c
c
      subroutine w_labels (isend, jcolor, kfill,
     +                     labels, panels, wordx, vectors)
c
c action: store colours, fill styles and labels for re-use in bar and pie charts
c author: w.g.bardsley, university of manchester, u.k.
c         27/10/2004 new version derived from w_symbols 
c         14/11/2004 extensive revision to allow defaults
c         02/02/2007 revised for w_clearwin.dll
c         10/12/2007 silenced advisory message when creating default version of w_labels.cfg
c         12/12/2007 added scale1 and scale2 to scale font sizes
c         06/11/2008 renamed the configuration file w_labels.cfg instead of w_simfit.lab
c         03/12/2010 added panels to argument list, increased dimension to 15, corrected
c                    the window_update@ code and now allows isend = 4 to supply values
c         23/04/2011 increased dimension to 20 and edited the window style
c         04/07/2011 added wordx and vectors
c         26/12/2012 altered winio call at c***** to agree with the 64-bit version
c
c         NOTE: the dimensions are assumed to be 20 for all arrays
c               Values are stored in w_labels.cfg which is created if missing.
c               nmax MUST be the same in the routine AND call back function
c               jcolor_2, kfill_2, and labels_2 are never changed by this
c               subroutine but are used as permanent reference values.
c
c         isend: (input/unchanged) as follows:
c                isend = 1, RETRIEVE, return with the current default values
c                isend = 2, EDIT/STORE/RETRIEVE,   ... write w_labels.cfg
c                isend = 3, INSTALL DEFAULT VALUES ... write w_labels.cfg          
c                isend = 4, STORE VALUES SUPPLIED  ... write w_labels.cfg
c        jcolor: (input/output) line/symbol colour 0 =< jcolor =< 71
c         kfill: (input/output) fill style 0 =< kfill =< 10
c        labels: (input/output) labels for pie charts, etc.
c        panels: (input/output) items for panels 
c         wordx: (input/output) x_tic mark labels
c       vectors: (input/output) vectors for labels, panels, x_tic 
c
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      integer,             intent (in)    :: isend 
      integer,             intent (inout) :: jcolor(20), kfill(20)
      character (len = *), intent (inout) :: labels(20), panels(20),
     +                                       wordx(20), vectors(60)
c
c locals
c
                                           
      integer    ntype
      parameter (ntype = 5)
      integer    n0, n1, n2, n3, n4, n10, n20, n60, n71
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n10 = 10,
     +           n20 = 20, n60 = 60, n71 = 71)
c
c nmax must equal nmax in call back function
c
      integer    nmax
      parameter (nmax = n20)
      integer    jcolor_1(nmax), kfill_1(nmax)
      integer    jcolor_2(nmax), kfill_2(nmax)
      integer    jcolor_sav(nmax), kfill_sav(nmax)
      integer    i, ios, itemp, j, nout
      integer    i_restore_labels_defaults
      integer    i_tell_about_labels_defaults
      integer    i_cancel_labels
      integer    i_edit_keys
      double precision scale1, scale2, size1, size2
      parameter (scale1 = 0.95d+00, scale2 = 0.95d+00)
      character  line*100, word6*6
      character  labels_1(nmax)*40, labels_2(nmax)*40
      character  labels_sav(nmax)*40
      character  panels_1(nmax)*40, panels_2(nmax)*40
      character  panels_sav(nmax)*40 
      character  wordx_1(nmax)*40, wordx_2(nmax)*40
      character  wordx_sav(nmax)*40 
      character  vectors_1(3*nmax)*40, zero40*40
      parameter (zero40 = '0000000000000000000000000000000000000000')
      character  x_pskeys*40
      character  ctype(19)*20, ftype(11)*20
      character  cfg_fname*12, pcent*1
      parameter (cfg_fname = 'w_labels.cfg', pcent = '%')
      character  fname*1024, x_sim256*1024
      logical    exist, first, ok, read_only
      logical    cancel_labels
      external   w_syspar, w_getnou, x_putfat, x_attrib, x_sim256,
     +           x_pskeys
      external   i_restore_labels_defaults
      external   i_tell_about_labels_defaults
      external   i_cancel_labels, i_edit_keys
      intrinsic  dble, index
      common     /colour_fill_defaults/ jcolor_1, kfill_1
      common     /label_defaults/ labels_1, panels_1, wordx_1, vectors_1
      common     /i_cancel_labels_changes/ cancel_labels
      save       first
      save       /colour_fill_defaults/, /label_defaults/
      save       jcolor_2, kfill_2
      save       labels_2
      data       first / .true. /
c
c next parameters must equal those in the call back function
c                                        
      data  jcolor_2 / 12, 10,  9, 14, 13, 11,  4,  2,  1,  3,  7,  5,
     +                  6,  0,  0,  0,  0,  0,  0,  0 /
      data   kfill_2 /  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  2,
     +                  3,  4,  5,  6,  7,  8,  9, 10 /
      data  labels_2 / 'label 1' , 'label 2' , 'label 3' , 'label 4' ,
     +                 'label 5' , 'label 6' , 'label 7' , 'label 8' ,
     +                 'label 9' , 'label 10', 'label 11', 'label 12',
     +                 'label 13', 'label 14', 'label 15', 'label 16',
     +                 'label 17', 'label 18', 'label 19', 'label 20' /
      data  panels_2 / 'panel 1' , 'panel 2' , 'panel 3' , 'panel 4' ,
     +                 'panel 5' , 'panel 6' , 'panel 7' , 'panel 8' ,
     +                 'panel 9' , 'panel 10', 'panel 11', 'panel 12',
     +                 'panel 13', 'panel 14', 'panel 15', 'panel 16',
     +                 'panel 17', 'panel 18', 'panel 19', 'panel 20' /
      data  wordx_2  / 'x_1' , 'x_2' , 'x_3' , 'x_4' ,
     +                 'x_5' , 'x_6' , 'x_7' , 'x_8' ,
     +                 'x_9' , 'x_10', 'x_11', 'x_12',
     +                 'x_13', 'x_14', 'x_15', 'x_16',
     +                 'x_17', 'x_18', 'x_19', 'x_20' /     
c
c check isend
c
      if (isend.lt.n1 .or. isend.gt.n4) then
         write (line,100)
         call x_putfat (line)
         return
      endif
c
c check if w_labels.cfg exists and is read-only
c
      fname = x_sim256(cfg_fname)
      call x_attrib (fname,
     +               exist, read_only)
c
c------------------------------------------------------------------------
c special actions required if w_labels.cfg is read-only or does not exist
c------------------------------------------------------------------------
c
      if (exist .and. read_only) then
c
c if w_labels.cfg is read_only then complain but return defaults
c

         do i = n1, n20
            jcolor(i) = jcolor_2(i)
            kfill(i) = kfill_2(i)
            labels(i) = labels_2(i)
            panels(i) = panels_2(i)
            wordx(i) = wordx_2(i)
         enddo
         do i = n1, n60
            vectors(i) = zero40
         enddo   
         if (first) then
            write (line,200)
            call x_putfat (line)
         endif
         return
      elseif (.not.exist) then
c
c if w_labels.cfg does not exist advise user and create a default
c suppressed 10/12/2007
c         write (line,300)
c         call x_putadv (line)
         do i = n1, n20
            jcolor_1(i) = jcolor_2(i)
            kfill_1(i) = kfill_2(i)
            labels_1(i) = labels_2(i)
            panels_1(i) = panels_2(i)
            wordx_1(i) = wordx_2(i)
            jcolor(i) = jcolor_2(i)
            kfill(i) = kfill_2(i)
            labels(i) = labels_2(i)
            panels(i) = panels_2(i)
            wordx(i) = wordx_1(i)
         enddo
         do i = n1, n60
            vectors(i) = zero40
         enddo   
         call w_getnou (nout)
         close (unit = nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.n0) then
            write (nout,400) pcent, ntype
            do i = n1, n20
               write (nout,'(i3)') kfill_2(i)
               write (nout,'(i3)') jcolor_2(i)
               write (nout,'(a)') labels_2(i)
               write (nout,'(a)') panels_2(i)
               write (nout,'(a)') wordx_2(i)
            enddo
         endif
         write (nout,500)
         do i = n1, n60
            write (nout,'(a)') zero40
         enddo   
         close (unit = nout)
      endif
c
c----------------------------------------------------------------
c special action required to set up the defaults first time round
c----------------------------------------------------------------
c
      if (first .and. isend.ne.n4) then
         first = .false.
c
c initialise then open the w_labels.cfg file and read in values
c
         do i = n1, nmax
            jcolor_1(i) = jcolor_2(i)
            kfill_1(i) = kfill_2(i)
            labels_1(i) = labels_2(i)
            panels_1(i) = panels_2(i)
            wordx_1(i) = wordx_2(i)
         enddo
         do i = n1, n60
            vectors_1(i) = zero40
         enddo   
         call w_getnou (nout)
         close (unit = nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
c
c check if it is a current type of w_labels.cfg file
c         
         if (ios.eq.n0) then
            ok = .true. 
            i = index(line, pcent)
            if (i.le.n0) then
               ok = .false.
            else 
               word6 = line(i + 1:i + 6)
               read (word6,*,iostat=ios) j
               if (ios.eq.n0) then
                  if (j.ne.ntype) ok = .false. 
               else 
                  ok = .false.
               endif
            endif   
         else
            ok = .false.
         endif 
         if (ok) then  
c
c read in (kfill, jcolor, labels, panels) values and check if satisfactory
c
         
            i = n0
            do while (ios.eq.n0 .and. i.lt.n20)
               i = i + n1
               if (ios.eq.n0) read (nout,*,iostat=ios) itemp
               if (ios.eq.n0) then
                  if (itemp.ge.n0.and.itemp.le.n10) kfill_1(i) = itemp
               endif
               if (ios.eq.n0) read (nout,*,iostat=ios) itemp
               if (ios.eq.n0) then
                  if (itemp.ge.n0.and.itemp.le.n71) jcolor_1(i) = itemp
               endif
               if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
               if (ios.eq.n0) labels_1(i) = line(1:40)
               if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
               if (ios.eq.n0) panels_1(i) = line(1:40)
               if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
               if (ios.eq.n0) wordx_1(i) = line(1:40)    
            enddo
            read (nout,'(a)',iostat=ios) line
            read (nout,'(a)',iostat=ios) line
            i = n0
            do while (ios.eq.n0 .and. i.lt.n60)
               i = i + n1
               if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
               if (ios.eq.n0) vectors_1(i) = x_pskeys(line)  
            enddo      
         endif   
         close (unit = nout)
      endif
c
c--------------------------------
c start of normal routine entries
c--------------------------------
c
      if (isend.eq.n1) then

c isend = 1: just return with the current default values
c ==========
c
         do i = n1, n20
            jcolor(i) = jcolor_1(i)
            kfill(i) = kfill_1(i)
            labels(i) = labels_1(i)
            panels(i) = panels_1(i)
            wordx(i) = wordx_1(i)
         enddo
         do i = 1, n60
            vectors(i) = vectors_1(i)
         enddo   
         return
      elseif (isend.eq.n2) then
c
c isend = 2: save data, scale the font sizes, use the control, them write to w_labels.cfg
c ==========
c                     
         cancel_labels = .false.     
         do i = 1, nmax
            jcolor_sav(i) = jcolor_1(i)
            kfill_sav(i) = kfill_1(i)
            labels_sav(i) = labels_1(i)
            panels_sav(i) = panels_1(i)
            wordx_sav(i) = wordx_1(i)
         enddo   
         write (ftype,1000)
         write (ctype,2000)
         call use_windows95_font@()
         call w_syspar (i, 'f')
         size1 = scale1*dble(i)/100.0d+00
         size2 = scale2*dble(i)/100.0d+00
         
         i = winio@('%`sf%ts&', size1)
         i = winio@(
     +'%ca[Simfit: fill-styles/colours/labels/panels/X_tics]&')
         i = winio@('%sy[no_sysmenu]&')
         i = winio@('%bg[grey]&')

         i = winio@('%ob[named_l,scored][Style]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%il&', n0, n10)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%2rd%cb&', kfill_1(i))
         enddo
         i = winio@('%cb&')

         j = winio@('%ob[named_l,scored][Options]&')
         do i = 1, 11
            j = winio@(ftype(i)//'&')
            j = winio@('%nl&')
         enddo   
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Colour]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%il&', n0, n71)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%2rd%cb&', jcolor_1(i))
         enddo
         i = winio@('%cb&')

         j = winio@('%ob[named_l,scored][Options]&')
         do i = 1, 19
            j = winio@(ctype(i)//'&')
            j = winio@('%nl&')
         enddo   
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Labels]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%15rs%cb&', labels_1(i))
         enddo
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Panel]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%15rs%cb&', panels_1(i))
         enddo
         i = winio@('%cb&')   

         i = winio@('%ob[named_l,scored][X_tics]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%15rs%cb&', wordx_1(i))
         enddo
         i = winio@('%cb&')         

         j = winio@('%`sf%ts&', size2)
c         
c         j = winio@('%^6bt[Apply]%nl %nl%^6bt[Cancel]%nl %nl%^6bt[Help]
c*****+%nl %nl%^6bt[Defaults], %nl %nl%^6bt[Keys]',
c     +   'EXIT',
c     +   i_cancel_labels,
c     +   i_tell_about_labels_defaults,
c     +   i_restore_labels_defaults,
c     +   i_edit_keys)
c     
         j=winio@('%^6bt[Apply]&', 'EXIT')
         j=winio@('%nl  %nl%^6bt[Cancel]&', i_cancel_labels)
         j=winio@('%nl  %nl%^6bt[Help]&', i_tell_about_labels_defaults)
         j=winio@('%nl  %nl%^6bt[Defaults]&', i_restore_labels_defaults)
         j=winio@('%nl  %nl%^6bt[Keys]', i_edit_keys)

c
c cancel editing if cancel_labels = .true.
c
         if (cancel_labels) then
            do i = 1, n20
               jcolor_1(i) = jcolor_sav(i)       
               kfill_1(i) = kfill_sav(i)       
               labels_1(i) = labels_sav(i)       
               panels_1(i) = panels_sav(i) 
               wordx_1(i) = wordx_sav(i)      
            enddo
         endif  
      elseif (isend.eq.n3) then
c
c isend = 3: over-ride using current default values then write w_labels.cfg
c ==========
c
         do i = n1, n20
            jcolor_1(i) = jcolor_2(i)
            kfill_1(i) = kfill_2(i)
            labels_1(i) = labels_2(i)
            panels_1(i) = panels_2(i)
            wordx_1(i) = wordx_2(i)
         enddo
         do i = n1, n60
            vectors_1(i) = zero40
         enddo   
      elseif (isend.eq.n4) then
c
c isend = 4: over-ride current values using data supplied then write w_labels.cfg
c ==========
c
         do i = n1, n20
            if (jcolor(i).ge.n0 .and. jcolor(i).le.n71)
     +          jcolor_1(i) = jcolor(i)
            if (kfill(i).ge.n0 .and. kfill(i).le.n10)
     +          kfill_1(i) = kfill(i)
            labels_1(i) = labels(i)
            panels_1(i) = panels(i)
            wordx_1(i) = wordx(i)
         enddo  
         do i = n1, n60
            vectors_1(i) = x_pskeys(vectors(i))
         enddo    
      endif
c
c---------------------------------------------------------
c special action required if w_labels.cfg is not read-only
c---------------------------------------------------------
c
      if (.not.read_only) then
         if (isend.ge.n2 .and. isend.le.n4) then
c
c check to make sure all are in range
c
            do i = n1, n20
               if (jcolor_1(i).lt.n0 .or. jcolor_1(i).gt.n71)
     +             jcolor_1(i) = n0
               if (kfill_1(i).lt.n0 .or. kfill_1(i).gt.n10)
     +             kfill_1(i) = n1
            enddo
c
c Create a new w_labels.cfg file
c
            call w_getnou (nout)
            open (unit = nout, file = fname, iostat = ios)
            if (ios.eq.n0) write (nout,400,iostat=ios) pcent, ntype
            do i = n1, n20
               if (ios.eq.n0) write (nout,'(i3)',iostat=ios) kfill_1(i)
               if (ios.eq.n0) write (nout,'(i3)',iostat=ios) jcolor_1(i)
               if (ios.eq.n0) write (nout,'(a)',iostat=ios) labels_1(i)
               if (ios.eq.n0) write (nout,'(a)',iostat=ios) panels_1(i)
               if (ios.eq.n0) write (nout,'(a)',iostat=ios) wordx_1(i)
            enddo
            if (ios.eq.0) write (nout,500,iostat=ios)
            do i = n1, n60
               if (ios.eq.0) write (nout,'(a40)',iostat=ios) 
     +                       x_pskeys(vectors_1(i)) 
            enddo      
            close (unit = nout)
         endif
      endif
      if (isend.eq.n2 .or. isend.eq.n3) then
c
c isend = 2 or 3: make sure sensible arguments are returned
c ==============
c
         do i = n1, n20
            jcolor(i) = jcolor_1(i)
            kfill(i) = kfill_1(i)
            labels(i) = labels_1(i)
            panels(i) = panels_1(i)
            wordx(i) = wordx_1(i)
         enddo
         do i = n1, n60
            vectors(i) = x_pskeys(vectors_1(i))
         enddo   
      endif
c
c format statements
c      
  100 format (
     +'ISEND out of range in call to W_LABELS')
  200 format (
     +'w_labels.cfg is read_only ... use attrib -r w_labels.cfg')
c  300 format (
c     +'Cannot find w_labels.cfg ... Simfit will create a default')
  400 format (
     +'Simfit fill-style/colour/label/panel file: type',2x,a1,i3)
  500 format (
     + 'Above are 20 fill-style/colour/label/panel/X_tic values'
     +/'Below are 60 keys for 20 Labels, 20 Panels, then 20 X_tics')  
 1000 format (
     + '0: none'
     +/'1: outline'
     +/'2: filled'
     +/'3: diagonal up'
     +/'4: diagonal down'
     +/'5: criss cross'
     +/'6: horizontal'
     +/'7: vertical'
     +/'8: dashes'
     +/'9: dots'
     +/'10: dot-dash')      
 2000 format (
     + '0: black'
     +/'1: blue',
     +/'2: green'
     +/'3: cyan'
     +/'4: red'
     +/'5: magenta'
     +/'6: brown'
     +/'7: light grey'
     +/'8: grey'
     +/'9: light blue'
     +/'10: light green'
     +/'11: light cyan'
     +/'12: light red'
     +/'13: light magenta'
     +/'14: yellow'
     +/'15: bright white'
     +/'16: etc.'
     +/'.........'
     +/'71: etc.' )     
      end
c
c
      recursive integer function i_restore_labels_defaults()
      implicit   none
      include   <windows.ins>
c
c nmax must equal nmax in main subroutine
c
      integer    nmax
      parameter (nmax = 20)
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 1, numdec = 1,
     +           numopt = 7, nstart = 3, ntext = numopt + 2)
      integer    numpos(numopt), numbld(ntext)      
      integer    jcolor_1(nmax), kfill_1(nmax)
      integer    jcolor_2(nmax), kfill_2(nmax)
      integer    jcolor_3(nmax), kfill_3(nmax)      
      integer    i
      character  labels_1(nmax)*40, labels_2(nmax)*40 
      character  panels_1(nmax)*40, panels_2(nmax)*40 
      character  wordx_1(nmax)*40, wordx_2(nmax)*40 
      character  vectors_1(3*nmax)*40 
      character  text(ntext)*100  
      logical    fixed, full, high
      parameter (fixed = .false., full = .false., high = .true.)      
      external   w_rbox01
      common    /colour_fill_defaults / jcolor_1, kfill_1
      common    /label_defaults / labels_1, panels_1, wordx_1, vectors_1
      save      /colour_fill_defaults/, /label_defaults /
      save       jcolor_2, kfill_2  
      save       jcolor_3, kfill_3
      save       numpos  
      data       numbld / 1, 0, -100, -100, -200, -200, 0, 0, 0 /
      data       numpos / 1, 0, 1, 0, 0, 0, 0 /      
      
c
c next parameters must equal those in main subroutine
c
      data  jcolor_2 / 12, 10,  9, 14, 13, 11,  4,  2,  1,  3,  7,  5,
     +                  6,  0,  0,  0,  0,  0,  0,  0 /
      data   kfill_2 /  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  2,
     +                  3,  4,  5,  6,  7,  8,  9, 10 /
      data  labels_2 / 'label 1' , 'label 2' , 'label 3' , 'label 4' ,
     +                 'label 5' , 'label 6' , 'label 7' , 'label 8' ,
     +                 'label 9' , 'label 10', 'label 11', 'label 12',
     +                 'label 13', 'label 14', 'label 15', 'label 16',
     +                 'label 17', 'label 18', 'label 19', 'label 20' /
      data  panels_2 / 'panel 1' , 'panel 2' , 'panel 3' , 'panel 4' ,
     +                 'panel 5' , 'panel 6' , 'panel 7' , 'panel 8' ,
     +                 'panel 9' , 'panel 10', 'panel 11', 'panel 12',
     +                 'panel 13', 'panel 14', 'panel 15', 'panel 16',
     +                 'panel 17', 'panel 18', 'panel 19', 'panel 20' /
      data  wordx_2  / 'x_1' , 'x_2' , 'x_3' , 'x_4' ,
     +                 'x_5' , 'x_6' , 'x_7' , 'x_8' ,
     +                 'x_9' , 'x_10', 'x_11', 'x_12',
     +                 'x_13', 'x_14', 'x_15', 'x_16',
     +                 'x_17', 'x_18', 'x_19', 'x_20' /  
     
c
c local defaults
c  
      data  jcolor_3 / 15,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,
     +                 15,  7,  0,  0,  0,  0,  0,  0  /
      data   kfill_3 /  1,  2,  2,  3,  4,  5,  6,  7,  8,  9, 10,  2,
     +                  1,  2,  2,  2,  2,  2,  2,  2  /

      i_restore_labels_defaults = 1
      write (text,100) 
      call w_rbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +               numpos, nstart, ntext,
     +               text,
     +               fixed, full, high)      
      do i = 1, nmax  
         if (numpos(1).eq.1) then
            jcolor_1(i) = jcolor_2(i)
         elseif (numpos(2).eq.1) then 
            jcolor_1(i) = jcolor_3(i)
         endif
         if (numpos(3).eq.1) then                          
            kfill_1(i) = kfill_2(i) 
         elseif (numpos(4).eq.1) then
            kfill_1(i) = kfill_3(i) 
         endif      
         if (numpos(5).eq.1) then
            labels_1(i) = labels_2(i)
         endif  
         if (numpos(6).eq.1) then
            panels_1(i) = panels_2(i)
         endif
         if (numpos(7).eq.1) then
            wordx_1(i) = wordx_2(i)
         endif        
      enddo  
      if (numpos(1).eq.1 .or. numpos(2).eq.1) then
         call window_update@(jcolor_1)
      endif   
      if (numpos(3).eq.1 .or. numpos(4).eq.1) then                          
         call window_update@(kfill_1)            
      endif      
      if (numpos(5).eq.1) then
         call window_update@(labels_1)
      endif  
      if (numpos(6).eq.1) then
         call window_update@(panels_1)
      endif 
      if (numpos(7).eq.1) then
         call window_update@(wordx_1)
      endif 
c
c format statement
c             
  100 format (
     + 'Tick to restore defaults required'
     +/'...'
     +/'Bars/segments in colour'
     +/'Bars/segments in monochrome'
     +/'Fill styles in colour'
     +/'Fill styles in monochrome'
     +/'Labels'
     +/'Panel'
     +/'X_tics')
      end
c
c
      recursive integer function i_tell_about_labels_defaults()
      implicit   none
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 22)
      integer    numbld(numtxt)
      character  text(numtxt)*100
      logical    border
      parameter (border = .false.)
      external   w_patch1
      data       numbld / numtxt*0 /
      write (text,100)
      numbld(1) = 1
      call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +               text,
     +               border)
      i_tell_about_labels_defaults = 2
c
c format statement
c      
  100 format (
     + 'The default fill-styles, colours, and labels.'
     +/
     +/'Each bar plotted in a bar chart, or segment plotted in a pie'
     +/'chart has an associated fill-style, colour, and label. With bar'
     +/'charts plotted from arbitrary matrices, and pie charts from'
     +/'arbitrary (positive) vectors, fill-styles, colours, and labels'
     +/'are set from w_labels.cfg. From the Simplot [Data] option then'
     +/'[Save As...] advanced files like barchart.tf?/piechart.tf? can'
     +/'be made with current values to over-ride the defaults. If you'
     +/'re-set the defaults, you can make bar and pie charts start with'
     +/'your own preferred values. However, note as follows.'
     +/'1)`Bar widths and segment displacements are not set this way.'
     +/'2)`Bar and segment line widths are not set in this way.'
     +/'3)`Deficient advanced bar and pie files (with insufficient'
     +/'  `appended labels) will use label defaults from w_labels.cfg.'
     +/'4)`Advanced bar and pie chart files should have labels appended'
     +/'  `for every bar or segment. However, bar charts usually have'
     +/'  `groups of bars (indicated by, e.g. m* for m bars per group'
     +/'  `in the last label appended to the advanced bar chart file).'
     +/'5)`If a bar chart has n bars in groups of size m, the first n/m'
     +/'  `fill-styles, colours, and labels will be used groupwise.'
     +/'6)`The [Defaults] option restores the Simfit defaults.')
      end
c
c
      recursive integer function i_cancel_labels()
      implicit none
      logical  cancel_labels
      common / i_cancel_labels_changes / cancel_labels
      cancel_labels = .true.
      i_cancel_labels = 0
      end
c
c      
      recursive integer function i_edit_keys()
      implicit none
      integer    i, icolor, k, nlines, numdec
      integer    numopt, nhigh, nwide
      parameter (numopt = 11, nhigh = 20, nwide = 40)
      character (len = nwide) labels_1(nhigh), panels_1(nhigh),
     +                        wordx_1(nhigh), vectors_1(3*nhigh)
      character (len = nwide) temp(nhigh)
      character (len = nwide) x_pskeys
      character (len = 100) line, text(30)
      character  blank*1
      parameter (blank = ' ')
      character (len = 40) zero40
      parameter (zero40 = '0000000000000000000000000000000000000000')
      logical   repeet
      common   /label_defaults / labels_1, panels_1, wordx_1, vectors_1
      external  x_listbx, w_table1, w_edittx, x_pskeys
      i_edit_keys = 2
      repeet = .true.
      do while (repeet)
         numdec = numopt 
         write (text,100)
         call x_listbx (numdec, numopt,
     +                 text)
         if (numdec.le.3) then
c
c display labels and keys
c           
             icolor = 15
             call w_table1 (icolor, 'OPEN')
             icolor = 4
             if (numdec.eq.1) then
                k = 0
                line = 'Labels and keys'
             elseif (numdec.eq.2) then   
                k = nhigh
                line = 'Panel items and keys'
             else   
                k = 2*nhigh
                line = 'X_tics and keys'
             endif
             call w_table1 (icolor, line)
             do i = 1, nhigh
                icolor = 1
                if (numdec.eq.1) then 
                   call w_table1 (icolor, labels_1(i))
                elseif (numdec.eq.2) then   
                   call w_table1 (icolor, panels_1(i))
                else   
                   call w_table1 (icolor, wordx_1(i))
                endif   
                icolor = 0
                call w_table1 (icolor, vectors_1(i + k))
                call w_table1 (icolor, blank)
             enddo   
             call w_table1 (icolor, 'CLOSE')   
         elseif (numdec.le.6) then
c
c edit keys
c         
            if (numdec.eq.4) then
               k = 0
            elseif (numdec.eq.5) then   
               k = nhigh
            else   
               k = 2*nhigh
            endif
            do i = 1, nhigh
               temp(i) = vectors_1(i + k)
            enddo
            call w_edittx (nhigh, nlines, nwide,
     +                     temp)
            do i = 1, nhigh
               vectors_1(i + k) = x_pskeys(temp(i))
            enddo   
         elseif (numdec.le.9) then 
c
c restore defaults
c          
            if (numdec.eq.6) then
               k = 0
            elseif (numdec.eq.7) then   
               k = nhigh
            else   
               k = 2*nhigh
            endif
            do i = 1, nhigh
               vectors_1(i + k) = zero40
            enddo
         elseif (numdec.eq.numopt - 1) then
c
c table of keys
c         
            write (text,200)
            icolor = 15
            call w_table1 (icolor, 'OPEN')
            icolor = 4
            call w_table1 (icolor, text(1))
            icolor = 0
            do i = 2, 23
               call w_table1 (icolor,text(i))
            enddo
            call w_table1 (icolor, 'CLOSE')                                             
         elseif (numdec.eq.numopt) then        
            repeet = .false.
         endif   
      enddo 
c
c format statements
c       
  100 format (
     + 'Display labels and keys'
     +/'Display panels and keys'
     +/'Display X_tics and keys'
     +/'Edit keys for labels' 
     +/'Edit keys for panels' 
     +/'Edit keys for X_tics'
     +/'Restore default keys for labels' 
     +/'Restore default keys for panels' 
     +/'Restore default keys for X_tics' 
     +/'Display a table of acceptable keys'
     +/'Exit ... Accept these edited values') 
  200 format (
     + 'Table of acceptable key values'
     +/'0: normal'
     +/'1: normal subscript'
     +/'2: normal superscript'
     +/'3: maths'
     +/'4: maths subscript'
     +/'5: maths superscript'
     +/'6: maths bold'
     +/'7: ZapfDingbats (PS), WingDings (Windows)'
     +/'8: Isolatin1Encoding'
     +/'9: special (PS), Webdings (Windows)'
     +/'A: grave'
     +/'B: acute'
     +/'C: hat (circumflex)',
     +/'D: tilde'
     +/'E: bar (macron/overline)'
     +/'F: dieresis'
     +/'G: maths-hat'
     +/'H: maths-bar'
     +/'I: maths-hat bold'
     +/'J: maths-bar bold'
     +/'K: Symbol'
     +/'L: Symbol bold')     
      end
c      
c
