c 
c
      subroutine w_lbfgsb (isend,
     +                     info, 
     +                     qnstop)
c
c action: display progress of optimisation
c author: w.g.bardsley, university of manchester, u.k., 19/07/2007
c     
      implicit none
      include <windows.ins>
c
c arguments
c          
      integer,             intent (in)    :: isend
      character (len = *), intent (in)    :: info(*)
      logical,             intent (inout) :: qnstop   
c
c locals
c     
      integer    i, ictrl, jctrl, kctrl
      integer    i_stop_qnfit2
      integer    ntab
      parameter (ntab = 22)
      double precision size1
      double precision f100
      parameter (f100 = 100.0d+00)
      character  info1*12, info2*12, info3*12, info4*12, info5*12,
     +           info6*12, info7*12 
      logical    stop_qnfit2
      external   w_syspar,w_reslib
      external   i_stop_qnfit2
      intrinsic  dble
      common    / control_qnfit2 / stop_qnfit2
      save       info1, info2, info3, info4, info5, info6, info7
      save       ictrl, jctrl, kctrl
      
      if (isend.eq.0) then
c
c Scale the font sizes and set up the control using info and qnstop
c Note: stop_qnfit2 and info must be initialised when isend = 0
c 
      
         jctrl = 1
         kctrl = 0 
         info1 = info(1)
         info2 = info(2)
         info3 = info(3)
         info4 = info(4)
         info5 = info(5)
         info6 = info(6)
         info7 = info(7)
         stop_qnfit2 = qnstop
         call use_windows95_font@()
         call w_syspar (i, 'f')
         size1 = dble(i)/f100
         call temporary_yield@()
         i = winio@('%sy[3d_thin]&')
         i = winio@('%1tl&', ntab)
         i = winio@('%cc&', i_stop_qnfit2)
         call w_reslib
         i = winio@('%mi[icon_1]&')
         i = winio@('%ww[no_minbox,topmost]&')
         i = winio@('%ca[Simfit: optimisation]&')
         i = winio@('%`sf%ts&', 1.0d+00*size1)
         i = winio@('%bf%tc[red]&')
         i = winio@(
     +'Method: Constrained quasi-Newton (L-BFGS-B/SETULB)&')
         i = winio@('%nl&')
         i = winio@('%nl&')
         i = winio@('%`sf%ts&', 1.0d+00*size1)
         i = winio@('%tc[blue]&')
         i = winio@(
     +'If the iterations are taking too long you can press Stop to&')
         i = winio@('%nl&')
         i = winio@(
     +'interrupt the unfinished optimisation after the current cycle&')
         i = winio@('%`sf%ts&', size1)
         i = winio@('%tc[black]%`it&')
         i = winio@('%nl &')
         i = winio@('%nl &')

         i = winio@('%ff%`bg[white]%`12rs&', info1)
         i = winio@('  starting objective function&')
         

         i = winio@('%ff%`bg[white]%`12rs&', info2)
         i = winio@('  current objective function&')
         

         i = winio@('%ff%`bg[white]%`12rs&', info3)
         i = winio@('  cpu seconds used so far&')
         

         i = winio@('%ff%`bg[white]%`12rs&', info4)
         i = winio@('  infinity norm of proj. grad.&')
         

         i = winio@('%ff%`bg[white]%`12rs&', info5)
         i = winio@('  number of iteration cycles&')
         

         i = winio@('%ff%`bg[white]%`12rs&', info6)
         i = winio@('  number of model evaluations&')
         

         i = winio@('%ff%`bg[white]%`12rs&', info7)
         i = winio@('  status of the optimisation&')
         
         
         i = winio@('%ff%nl%~^4bt[Stop]&', jctrl, i_stop_qnfit2)
         i = winio@('  %~^4bt[OK]&', kctrl, i_stop_qnfit2)
         i = winio@('%ff%nl&')
         i = winio@('%lw', ictrl)
      elseif (isend.eq.1) then
c
c isend = 1 to isend = 7: refresh using info(isend), qnstop is not referenced 
c      
         info1 = info(1)
         call window_update@(info1)
      elseif (isend.eq.2) then
         info2 = info(2)
         call window_update@(info2)
      elseif (isend.eq.3) then
         info3 = info(3)
         call window_update@(info3)
      elseif (isend.eq.4) then
         info4 = info(4)
         call window_update@(info4)
      elseif (isend.eq.5) then
         info5 = info(5)
         call window_update@(info5)
      elseif (isend.eq.6) then
         info6 = info(6)
         call window_update@(info6)
      elseif (isend.eq.7) then
         info7 = info(7)
         call window_update@(info7)
      elseif (isend.eq.8) then
c
c isend = 8: close down, no arguments are referenced
c      
         ictrl = 0
         call window_update@(ictrl)   
      elseif (isend.eq.9) then
c
c isend = 9: grey controls, no arguments are referenced
c      
         jctrl = 0
         call window_update@(jctrl)
         kctrl = 1   
         call window_update@(kctrl)
      elseif (isend.eq.10) then
c
c isend = 10: set stop_qnfit2, qnstop must be initialised, info is not referenced
c      
         qnstop = stop_qnfit2
      elseif (isend.eq.11) then
c
c isend = 11: retrieve stop_qnfit2, qnstop is returned, info is not referenced
c      
         stop_qnfit2 = qnstop      
      endif       
c
c********************************************************************************
c end of winio@ generated waiting window ... use temporary_yield@ in main program
c********************************************************************************
c
      end
c
c
      recursive integer function i_stop_qnfit2()
      logical stop_qnfit2
      common / control_qnfit2 / stop_qnfit2
      stop_qnfit2 = .true.
      i_stop_qnfit2 = 0
      end
c
c
