
c
c
      recursive subroutine w_lbox01 (icolor, ixl, iyl, lshade, numbld,
     +                               numdec, numopt, numpos, numsta,
     +                               numtxt,
     +                               text_in,
     +                               fixed, full, high)
c
c action : put out text plus menu with attributes onto a window
c          Testing the Stop menu:  This is the main simfit list box selection routine
c author : w.g.bardsley, university of manchester, u.k., 17/02/97
c          05/02/1997 padded menu with blanks and added button press
c          10/02/1997 added tabbing at the grave ` character
c          04/04/1997 added call to w_syspar to adjust font size
c          08/08/1997 extensive revision to limit colours in order to
c                     use %sy to set the windows95 list box style
c          12/11/1997 added facility to tab menu items into an extra %lb
c                     replaced Times by ms sans serif and used scored %ob
c          21/02/1998 made the second list box greyed out
c          09/09/1998 supressed features and made into standard windows
c                     dialogue control with no scoring or shading and introduced
c                     ndeep = max. depth, nmax = max. items. Also removed extra
c                     spaces either side of menu items.
c          01/11/1998 changed colour scheme and tidied up
c          12/04/1999 used %ww[no_sysmenu] to avoid ambiguities
c                     when closing from the closure cross and force exit
c                     by menu-choice
c          24/10/1999 added nblank and nblank2 to diminish the effect of
c                     multiple blanks used for padding to achieve tabbing
c          03/12/1999 restored topmost
c          10/01/2001 suppressed %ww, dimensioned the assumed size arrays,
c                     redefined factor depending on list box type and introduced
c                     tabber to control tab spacing when tabvar is defined
c          02/03/2001 added %sy[no_sysmenu] and mwtype and now treats menus
c                     with Cancel as a special case as follows:-
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     mwtype = 3: normal dialogue window
c                     mwtype = 4: treat 'Cancel' as a special case by
c                                 setting closure cross = 'Cancel'
c          21/10/2001 used msss font for list box when fixed = .true.
c          13/02/2002 XP version
c          22/02/2002 moved %tc so that it is not cancelled by %`sf
c          18/12/2002 added %sy[toolwindow]
c          07/04/2003 suppressed [toolwindow] as it causes problems with GSview 
c          27/04/2004 altered factor and iwide if header/trailer present  
c          16/02/2006 forced line 1 to be bold if numbld(1).ne.0 and nstart > 1 
c          17/11/2006 edited and added intents 
c          02/02/2007 edited for w_clearwin.dll
c          29/05/2007 added allocatable arrays, and calls to w_dbleup  
c          27/07/2007 introduced nbig to control the positioning as well as ixl, iyl 
c                     and nmax = numopt for allocatable dimension
c          28/11/2007 added [limit_height] with height = 0.6, and made all fonts identical size
c          10/12/2007 introduced x_len300 to estimate iwide more conservatively
c          22/05/2008 reintroduced x_len200 where x_len300 was used incorrectly and
c                     used x_trim80 for menu options
c          28/05/2011 deleted 3d_thin and concatenated a blank in front of text lines
c          12/01/2014 added an extra button if cancelling occurs from the last option 
c          13/08/2015 extended the number of cases leading to extra buttons
c          31/07/2017 added a Stop menu except for numtxt > 25 and where last option contains, e.g. 'Quit ... Exit program'
c          04/10/2017 checked for 'speedup' in text(1) when using add_stop_options and also added %mi
c          01/12/2017 added closure cross for all cases
c          10/12/2016 made it recursive
c          30/05/2019 replaced %bg[grey]&) by %bg&', rgb@(240,240,240)) 
c          09/12/2019 line 513 now %sy[no_border when ntext = numopt and line 825 onwards added %nl after buttons with extra spaces around buttons 
c          23/03/2020 added use_limit_height to prevent premature use of scroll bars when users choose large fonts.
c                     Note: graves in the items creates a second inactive list box for information only which was superceded by the %lv control. 
c          29/03/2020 now calls the new style list box w_lboxns for cases where numopt = numtxt and numopt =< 20   
c          25/05/2020 now calls the new style list box w_lboxnx for cases where numopt =< 18, when there is a short header but no trailer, and .not.fixed 
c          29/01/2021 now calls the new style list box w_lboxny for cases where numopt =< 20, when numtxt =< 50 but no trailer 
c          05/02/2021 now calls the new style list box w_lboxnz for cases where numopt =< 20, when numtxt =< 50 and a trailer is present
c          30/08/2023 ***added 4 blanks to left margin after using x_trim80 ... but see next item for extra code required
c          09/09/2023 ***added adjustl (line) to remove extra 4 blanks when checking for Quit, Exit, etc. at lines 445 and 477 
c
c  icolor: (input/unchanged) colour scheme (not used in this version)
c     ixl: (input/unchanged) x coordinate of top left hand corner, ignored if =< 0
c     iyl: (input/unchanged) y coordinate of top left hand corner, ignored if =< 0
c  lshade: (input/unchanged) shading (not used in this version)
c  numbld: (input/unchanged) font scheme line by line
c  numdec: (input/output) sets default on input then returns users choice
c  numopt: (input/unchanged) number of options available
c  numpos: (input/unchanged) position of hot key (not used in this version)
c  numsta: (input/unchanged) number of line of text where menu starts
c  numtxt: (input/unchanged) number of lines of text ntext >= numopt
c text_in: (input/unchanged) text array (text plus menus)
c   fixed: (input/unchanged) mono spaced font (Courier New)
c    full: (input/unchanged) not used in this version
c    high: (input/unchanged) not used in this version
c
c          this version creates the menu as a list box so it does not use
c          selection by special key and some parameters are disabled, e.g.
c          icolor ... is not used in this version 
c          lshade ... is not used in this version
c          numpos ... is not used in this version
c          full   ... is not used in this version
c          high   ... is not used in this version
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times .............. Now replaced by ms sans serif
c          2, 3       Times Italic                   "
c          4, 5       Times Bold                     "
c          6, 7       Times Bold Italic              "
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins>   
c
c arguments
c      
      integer,             intent (in)    :: numtxt, numopt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numsta  
      integer,             intent (inout) :: numdec
      integer,             intent (in)    :: numbld(numtxt),
     +                                       numpos(numopt)           
      character (len = *), intent (in)    :: text_in(numtxt) 
      logical,             intent (in)    :: fixed, full, high
c
c local allocatable arrays
c                        
      character (len = 129), allocatable :: text(:) 
      character (len = 80),  allocatable :: items1(:)
      character (len = 20),  allocatable :: items2(:)
c
c locals
c      
      integer    isend
      parameter (isend = 1)
      integer    i_quit, i_dots, i_exit
      integer    ntext, nstart, ntemp
      integer    i, ierr, j, k, l, m, nblank, nblank2, numdec_sav
      integer    x_len200, x_len300
      integer    i_check_lbox01, ideep, ipick, iwide, iwide2
      integer    i_button_lbox01, i_extra_button_lbox01, i_tell_which
      integer    iscale, n_cancel, nmax
      integer    ixyuse, ixy_use, mw_type, mwtype
      parameter (ixy_use = 1, mw_type = 4)
      integer    nbig, ndeep
      parameter (nbig = 25, ndeep = 40)
      integer    n0, n1, n2, n3, n4, n5, n6, n7, n8, n9, n20
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6,
     +           n7 = 7, n8 = 8, n9 = 9, n20 = 20)
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00,
     +           size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabber, tabvar
      parameter (percent = 100.0d+00, tabber = 1.00d+00)
      double precision height
      parameter (height = 0.65d+00)
      character (len = 129) line, w_dbleup*129
      character (len = 80 ) line1, x_trim80
      character (len = 9  ) word9
      character (len = 8  ) word8
      character (len = 6  ) word6
      character (len = 5  ) word5
      character (len = 4  ) word4, blank4
      parameter (blank4 = '    ')
      character (len = 3  ) word3
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    abort, cancel, extra, new_button, ok, use_limit_height
      logical    check1, check2
      external   x_len200, x_len300, x_chkmen, x_trim80
      external   w_syspar, x_putfat, w_dbleup
      external   i_check_lbox01, i_button_lbox01, i_extra_button_lbox01
      external   add_stop_option, w_reslib
      external   w_lboxns, w_lboxnx, w_lboxny, w_lboxnz
      intrinsic  adjustl 
      intrinsic  len, dble, index, max, min, nint
      common    / lbox01_info / i_tell_which  
c
c check
c      
      if (numopt.lt.n2) then
         numdec = n1
         return
      endif
      if (numdec.lt.n1) then
         numdec = n1
      elseif (numdec.gt.numopt) then
         numdec = numopt   
      endif   
      if (numopt.eq.numtxt .and. numopt.le.20 .and. .not.fixed) then
         abort = .false.
         call w_lboxns (numdec, numopt,
     +                  text_in,
     +                  abort)
         if (.not.abort) return
      endif   
      k = numopt + numsta - 1
      if (numtxt.eq.k .and. numtxt.le.22 .and. 
     +    .not.fixed .and. numopt.le.18) then
          abort = .false.
          call w_lboxnx (numbld, numdec, numopt, numsta, numtxt,
     +                   text_in,
     +                   abort) 
         if (.not.abort) return
      endif 
      if (numtxt.eq.k .and. numtxt.le.50 .and. 
     +    .not.fixed .and. numopt.le.20  .and.
     +    numsta + numopt - 1.eq.numtxt) then
          abort = .false.
          call w_lboxny (numbld, numdec, numopt, numsta, numtxt,
     +                   text_in,
     +                   abort) 
         if (.not.abort) return
      endif 
      if (numtxt.le.50 .and. .not.fixed .and. numopt.le.20) then
          abort = .false.
          call w_lboxnz (numbld, numdec, numopt, numsta, numtxt,
     +                   text_in,
     +                   abort) 
         if (.not.abort) return
      endif             
c
c initialise parameters used in case 'Cancel' is a list box item
c
      if (numopt.gt.10) then
         use_limit_height = .true.
      else
         use_limit_height = .false.
      endif       
      i_tell_which = n0
      n_cancel = numdec
      cancel = .false.  
      new_button = .false.  
      numdec_sav = numdec
c
c set position and control type
c
      if (numopt.le.nbig .or. ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif
      mwtype = mw_type         
c
c Scale the font sizes
c                   
      nstart = numsta   
      ntext = numtxt
      check1 = .false.
      check2 = .true.
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
c
c full check if required (not generally required for list boxes)
c
      if (check1) then
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                  'w_lbox01', text_in, 
     +                  abort)
         if (abort) return
      endif
c
c lesser check if required (generally required for list boxes)
c
      if (check2) then
         if (numopt.le.n1) then
            numdec = n1
            return
         endif
         ok = .true.
         if (ntext.lt.n2 .or. ntext.lt.numopt .or. 
     +       nstart.lt.n1 .or. nstart + numopt - n1.gt.ntext) 
     +       ok = .false.
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_lbox01')
            return
         endif
      endif    
c
c allocate
c         
      ierr = 0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(items1)) deallocate(items1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(items2)) deallocate(items2, stat = ierr)
      if (ierr.ne.0) return
      allocate(text(ntext), stat = ierr)
      if (ierr.ne.0) return
      nmax = numopt  
      allocate(items1(nmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(items2(nmax), stat = ierr)
      if (ierr.ne.0) return 
      j = nstart + numopt - n1    
      do i = n1, numtxt
         if (i.lt.nstart .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else
c
c concatenate blanks to space out the left hand margins
c           
            text(i) = blank4//x_trim80(text_in(i)(1:76))
         endif       
      enddo
c      
c use up dummy argument to stop ftn95 complaining
c leave them in the argument list for future developments
c
      i = icolor
      i = numpos(n1)
      i = lshade
      ok = full
      ok = high 
     
      if (ixyuse.eq.n1) then
c
c use ixl, iyl and parameter iscale to position the window
c
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c the next lines select the window type
c =====================================
c
      if (mwtype.eq.n1) then
c
c ww-type
c
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost]&')
            i = winio@('%ca[Simfit: options]&')
         endif
      elseif (mwtype.eq.n2) then
c
c dialogue type with no closure cross
c
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_sysmenu, no_border, 3d_thin]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[no_sysmenu, thin_border, 3d_thin]&')
            i = winio@('%ca[Simfit: options]&')
         endif
      elseif (mwtype.eq.n3) then
c
c dialogue type with closure cross
c
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_border, 3d_thin]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
            i = winio@('%ca[Simfit: options]&')
         endif
      elseif (mwtype.eq.n4) then
c
c check if 'Cancel' or 'Exit' or 'Quit', etc. is an item and, if so, make it
c the default. Here are Spanish equivalents.
c
c Apply = Aplicar
c Accept = Acceptar
c Done = Hecho
c OK = OK
c Exit = Salir
c Cancel = Abandonar
c
c Note: 1. The critical English words such as Quit, Stop, End, .etc are now case-sensitive
c       2. If the last option is not detected as a critical English word the previous items are scanned
c       3. If an itermediate item is flagged it is made the default but with no extra button
c       4. Only if a critical word is the last menu item is an extra button created
c       5. Spanish is only consulted if last menu item is not detected as a critical word 
c
         ntemp = nstart + numopt - n1
         line = text(ntemp)! **** this line and next 2 lines of code edited 09/09/2023 to compensate for extra 4 blanks
         line = adjustl (line)
         word6 = line(n1:n6)
         word5 = word6(n1:n5)
         word4 = word6(n1:n4)
         word3 = word6(n1:n3)
         if (word5.eq.'Apply' .or.
     +       word5.eq.'Close') then
            word6 = word5//blank
         elseif (word4.eq.'Quit' .or.
     +           word4.eq.'Exit' .or.
     +           word4.eq.'Done' .or.
     +           word4.eq.'Stop') then
            word6 = word4//blank//blank
         elseif (word3.eq.'End') then
            word6 = word3//blank//blank//blank
         endif
            
         new_button = .false.
         
         if (word6.eq.'Cancel' .or. word6.eq.'Apply ' .or.
     +       word6.eq.'Quit  ' .or. word6.eq.'Accept' .or.    
     +       word6.eq.'Exit  ' .or. word6.eq.'Finish' .or.
     +       word6.eq.'Done  ' .or. word6.eq.'End   ' .or.
     +       word6.eq.'Stop  ' .or. word6.eq.'Close ' ) then
            new_button = .true.    
            cancel = .true.
            n_cancel = ntemp  
         else       
            i = nstart - n1
            do while (i.lt.ntemp .and. .not.cancel)
               i = i + n1
               line = text(i)! **** this line and next 2 lines edited 09/09/2023 to compensate for extra 4 blanks
               line = adjustl (line)
               word9 = line(n1:n9)
               word8 = word9(n1:n8)
               word6 = word9(n1:n6)
               word5 = word9(n1:n5)
               word4 = word9(n1:n4)
               word3 = word9(n1:n3)
               if (word6.eq.'Cancel'    .or. word5.eq.'Apply'  .or.
     +             word4.eq.'Quit'      .or. word6.eq.'Accept' .or.    
     +             word4.eq.'Exit'      .or. word6.eq.'Finish' .or.
     +             word3.eq.'End'       .or. word4.eq.'Stop'   .or.
     +             word5.eq.'Close'     .or. word4.eq.'Done'   .or.
     +             word5.eq.'Hecho'     .or. word5.eq.'Salir'  .or.
     +             word9.eq.'Abandonar' .or. word8.eq.'Applicar') then
                  cancel = .true.
                  n_cancel = i - nstart + n1
               endif
            enddo
         endif
         
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_border]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[thin_border]&')
            i = winio@('%ca[Simfit: options]&')
         endif
         endif
c
c add the icon
c
      call w_reslib
      i = winio@('%mi[ICON_1]&')

c
c set the background colour
c
      k = winio@('%bg&', rgb@(240,240,240))
      
c
c add the stop menu as long as it is not of the form 'Quit ... Exit' or numtxt > 25 
c
      
      line = text(numsta + numopt - 1)
      i_quit = index(line,'Quit')
      i_dots = index(line,'...')
      i_exit = index(line,'Exit program')
      if (i_quit.eq.1 .and. i_dots.gt.4 .and.
     +    i_exit.gt.7 .or. numtxt.gt.25) then
         continue
      else  
         call add_stop_option (isend)
      endif   

c
c put out the text strings up to the menu
c
      do i = n1, nstart - n1

c
c now set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
c
c set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
            k = winio@(line, size_courier)
         else 
            if (i.eq.1 .and. numbld(1).ne.0) then 
               k = winio@('%`sf%bf&')
            elseif (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif
c
c set the text color depending on numbld(i)
c                                             
            if (i.eq.1 .and. numbld(1).ne.0) then 
               k = winio@('%tc[black]&')
            elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +              numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*tabber*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//'&'
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               k = winio@(line, size_roman)
            endif
         endif
c
c the next line causes a line feed
c
         k = winio@('%nl&')
      enddo
      
c
c create the menu items
c
      extra = .false.
      iwide = n1
      if (nstart.gt.n1) then
c
c increase iwide according to header text
c           
         do i = n1, nstart - n1
            l = x_len300(text(i))
            if (l.gt.iwide) iwide = l             
         enddo        
      endif
      ntemp = nstart + numopt - n1
      if (ntext.gt.ntemp) then
c
c increase iwide according to trailer text
c                         
         do i = ntemp, ntext
            l = x_len300(text(i))
            if (l.gt.iwide) iwide = l            
         enddo        
      endif                 
c
c initialise factor depending on header/trailer
c      
      if (iwide.gt.n1) then
         factor = 0.95d+00 
         iwide = nint(factor*dble(iwide))      
      else
         factor = 0.85d+00   
      endif   
      iwide2 = n1
      j = nstart - n1
      do i = n1, numopt
         j = j + n1
         l = x_len200(text(j))
         line1 = text(j)(n1:l)
c
c does the item contain a grave ` tabbing character ?
c
         nblank = n0
         nblank2 = n0
         k = index(line1, '`')
         if (k.ge.n1) then
            extra = .true.
            if (k.gt.n2) then
               do m = n2, k - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank = nblank + n1
               enddo
            endif
            if (l - k.gt.n2) then
               do m = k + n2, l - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank2 = nblank2 + n1
               enddo  
            endif
            items1(i) = line1(n1:k - n1)
            items2(i) = line1(k + n1:l)
            if (k - n1 - nblank.gt.iwide) iwide = k - n1 - nblank
            if (l - k - nblank2.gt.iwide2) iwide2 = l - k - nblank2
         else
            items1(i) = line1(n1:l)
            k = x_len300(line1)
            if (k.gt.iwide) iwide = k
            items2(i) = blank
         endif
      enddo
c
c define ideep and ipick
c
      ideep = min(ndeep,numopt)
      if (numdec.lt.n1) then
         ipick = n1
      elseif (numdec.gt.numopt) then
         ipick = numopt
      else
         ipick = numdec
      endif
c
c set up font then show list box (ms sans serif seems best here)
c
      if (fixed) then
c********k = winio@('%fn[Courier New]&')
         k = winio@('%`sf&')
         line = '%ts&'
c********k = winio@(line, size_courier)
         k = winio@(line, size_msss)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif
      k = winio@('%cn&')
      k = winio@('%`bg[white]%tc[black]&')
c
c adjust the list box width if necessary
c
      if (.not.fixed) then
         iwide = max(n20, nint(factor*dble(iwide)))
         if (extra) iwide2 = max(n1, nint(factor*dble(iwide2)))
      endif
      if (nstart + numopt - n1.eq.ntext) then
c
c code when there is no more text
c
         if (use_limit_height) then
             k = winio@('%*.*^ls[limit_height]&', iwide, ideep, items1,
     +                  numopt, ipick, height, i_check_lbox01)
         else
            k = winio@('%*.*^ls&', iwide, ideep, items1,
     +                  numopt, ipick, i_check_lbox01)
         endif 
         if (extra) then
c
c creates an information panel when graves are present in the items list but this second
c instance of %ls was to provide information only and was supercede by the %lv control.
c           
            i = n0
            j = n0
            k = winio@('%`bg[white]%tc[black]&')
            if (use_limit_height) then
               k = winio@('%~*.*^ls[limit_height]&', iwide2, ideep,
     +                    items2, numopt, i, j, height, i_check_lbox01)
            else
               k = winio@('%~*.*^ls&', iwide2, ideep,
     +                    items2, numopt, i, j, i_check_lbox01)
            endif
         endif
      else
c
c code when there is more text
c
         if (use_limit_height) then
            k = winio@('%*.*^ls[limit_height]&', iwide, ideep, items1,
     +                 numopt, ipick, height, i_check_lbox01)
         else
            k = winio@('%*.*^ls&', iwide, ideep, items1,
     +                 numopt, ipick, i_check_lbox01)
         endif
         if (extra) then
            i = n0
            j = n0
            k = winio@('%`bg[white]%tc[black]&')
            if (use_limit_height) then
               k = winio@('%~*.*^ls[limit_height]&', iwide2, ideep, 
     +                    items2, numopt, i, j, height, i_check_lbox01)
            else
               k = winio@('%~*.*^ls&', iwide2, ideep,
     +                    items2, numopt, i, j, i_check_lbox01)
            endif
         endif
         k = winio@('%ff&')
c
c put out the text strings after the end of the menu
c
         do i = nstart + numopt, ntext
c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif
c
c set the text color depending on numbld(i)
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[blue]&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
c
c set the text color depending on numbld(i)
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[blue]&')
               endif
c
c does the line contain a tabbing character ` grave accent
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  tabvar = correction*tabber*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
         enddo
         k = winio@(' &')
      endif
c
c close by button press
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%dy&', 0.5d+00)
      if (new_button) then
         k = winio@('%rj&')
         k = winio@('%ob[invisible]&')
         k = winio@('   %^`tt[&OK]&', i_button_lbox01)
         k = winio@(' %^tt@   &', word6, i_extra_button_lbox01) 
         k = winio@('%nl &') 
         k = winio@('%dy&', 0.5d+00)
         k = winio@('%cb')
      else  
         k = winio@('%cn&')
         k = winio@('%ob[invisible]&')
         k = winio@('   %^`tt[&OK]   &', i_button_lbox01)
         k = winio@('%nl &')
         k = winio@('%dy&', 0.5d+00)
         k = winio@('%cb')
      endif
c
c set numdec then check before returning
c
      if (cancel) then
         if (i_tell_which.eq.n0) then
c
c window closed from closure cross so return numdec = n_cancel
c
            numdec = n_cancel
         else
c
c window closed by button press or double clicking on a list box item
c
            numdec = ipick
         endif
      else
c
c window closed by closure cross, OK button or double click
c
         if (i_tell_which.eq.n0) then
            numdec = numdec_sav
         else   
            numdec = ipick
         endif   
      endif
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt 
c
c deallocate
c           
      deallocate(text, stat = ierr)  
      deallocate(items1, stat = ierr)
      deallocate(items2, stat = ierr)
      end
c
c --------------------------------------------------------------------
c call back function for call back from list box
c --------------------------------------------------------------------
c
      recursive integer function i_check_lbox01()
      implicit none
      include <windows.ins>
      integer (kind = 7) ibig
      integer  i, i_tell_which
      common / lbox01_info / i_tell_which
      ibig = clearwin_info@('LISTBOX_ITEM_SELECTED')
      i = ibig
      if (i.eq.1) then
c
c the list box item has been double clicked
c
         i_check_lbox01 = 0
         i_tell_which = 1
      else
c
c the list box item has been single clicked
c
         i_check_lbox01 = 1
         i_tell_which = 0
      endif
      end
c
c --------------------------------------------------------------------
c call back functions for call backs from button press
c --------------------------------------------------------------------
c
      recursive integer function i_button_lbox01()
c
c the OK button has been pressed
c
      implicit none
      integer  i_tell_which
      common / lbox01_info / i_tell_which
      i_button_lbox01 = 0
      i_tell_which = 2
      end
      
      recursive integer function i_extra_button_lbox01()
c
c the extra button has been pressed
c
      implicit none
      integer  i_tell_which
      common / lbox01_info / i_tell_which
      i_extra_button_lbox01 = 0
      i_tell_which = 0
      end      
c
c
      recursive integer function i_stop_this_program()
c
c action: call back function for the %mn Stop item using terminate_process
c author: w.g.bardsley, university of manchester, u.k., 01/08/2017
c      
      implicit none
      include <windows.ins>
      integer*2  error_code   
      integer    i, ios, j, k, l1, l2
      parameter (j = 0)
      character (len = 1024) fname, pname, x_sim256
      character (len = 100 ) line
      character (len = 22  ) caption
      parameter (caption = 'Simfit: Option to stop')
      logical    back
      parameter (back = .true.)
      logical    op
      c_external terminate_process 'terminate_process'
      external   x_sim256
      intrinsic  index
      call get_program_name@(pname)
      l2 = len_trim(pname)
      l1 = index (pname,'\', back) + 1
      write (line,100) pname(l1:l2) 
      k = MB_SYSTEMMODAL + MB_YESNO + MB_ICONEXCLAMATION + MB_DEFBUTTON2 
      i = messagebox (j, line, caption, k)
      if (i.eq.6) then
c
c stop has been selected so write to the results file on unit 4 then close
c        
         inquire (unit = 4, opened = op, iostat = ios)
         if (ios.eq.0 .and. op) then
            write (4,200)
            close (unit = 4)
         endif   
         fname = x_sim256('f$simfit.tmp')
         call erase@(fname, error_code)
         call terminate_process
         i_stop_this_program = 0
      else
         i_stop_this_program = 1
      endif      
c
c format statements
c      
  100 format ('Do you want to Quit ... Exit program',1x,a)  
  200 format ('*** Program closed using the Stop option')    
      end
c
c
      recursive subroutine add_stop_option (isend)
      implicit none
c
c action: add a stop option under the caption
c author: w.g.bardsley, university of manchester, u.k., 03/08/2017
c  
c isend = 1: Stop
c isend = 2: blueball
c isend = 3: big_cross
c
      integer, intent (in) :: isend  
      integer  i_stop_this_program
      integer  i_call_x_switch
      integer  k
      external w_reslib, x_putfat
      external i_call_x_switch, i_stop_this_program
      call w_reslib
      if (isend.eq.1) then 
         k = winio@ ('%mn[Stop]&', i_stop_this_program)
      elseif (isend.eq.2) then   
         k = winio@ ('%^ic[blueball]&', i_stop_this_program)
      elseif (isend.eq.3) then  
         k = winio@ ('%^ic[big_cross]&', i_stop_this_program)
      else
         call x_putfat ('ISEND out of range in call to ADD_STOP_OPTION') 
         return  
      endif  
      k = winio@('%mn[Speedup]&', i_call_x_switch) 
      k = winio@('%ff&')
      end   
c 
c







 





      
c













      



























 