c
c
      subroutine w_lboxm1 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text_in,
     +                     fixed, full, high)
c
c action : put out a text plus menu with attributes onto a window
c          this is the main simfit multi-selection list box routine
c author : w.g.bardsley, university of manchester, u.k.
c          developed from w_lbox01 19/02/2001
c          13/02/2002 XP version  
c          18/12/2002 added %sy[toolwindow] 
c          17/11/2006 suppressed toolwindow and added intents and no_sysmenu 
c          02/02/2007 edited for w_clearwin.dll 
c          29/05/2007 added allocatable arrays and call to w_dbleup
c          29/11/2007 added [limit_height] at 0.6 and made all fonts identical size
c          10/12/2007 added x_len300 to make iwide more conservative
c          22/05/2008 restored x_len200 where x_len300 used incorrectly and
c                     used x_trim80 for menu items 
c
c          this version uses: len200 = leng@ = len_trim, lcase1 = lcase@
c          to be compatible with ftn77 and ftn90
c
c          icolor ... colour scheme (not used in this version)
c          ixl    ... x coordinate of top left hand corner, ignored if =< 0
c          iyl    ... y coordinate of top left hand corner, ignored if =< 0
c          lshade ... shading (not used in this version)
c          numbld ... font scheme line by line
c          numdec ... not used but retained for future development
c          numopt ... number of options available
c          numpos ... 0 if unselected, 1 if selected on entry or return
c          numsta ... number of line of text where menu starts
c          numtxt ... number of lines of text ntext >= numopt
c          text_in... text array (text plus menus)
c          fixed  ... mono spaced font (Courier New)
c          full   ... not used in this version
c          high   ... not used in this version
c
c          this version creates the menu as a list box so it does not use
c          selection by special key and some parameters are disabled, e.g.
c          icolor ... is not used in this version
c          numdec ... is not used in this version
c          full   ... is not used in this version
c          high   ... is not used in this version
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times .............. Now replaced by ms sans serif
c          2, 3       Times Italic                   "
c          4, 5       Times Bold                     "
c          6, 7       Times Bold Italic              "
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: numtxt, numopt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numdec, numsta
      integer,             intent (in)    :: numbld(numtxt)
      integer,             intent (inout) :: numpos(numopt) 
      character (len = *), intent (in)    :: text_in(numtxt) 
      logical,             intent (in)    :: fixed, full, high
c
c allocatable array
c                  
      character (len = 129), allocatable :: text(:)
      character (len = 80), allocatable :: items(:)
      character (len = 20), allocatable :: items2(:)
c
c locals
c      
      integer    i, ierr, j, k, l, m, nblank, nblank2
      integer    x_len200, x_len300
      integer    ideep, iwide, iwide2, nstart, ntext
      integer    iscale
      integer    ndeep
      parameter (ndeep = 35)
      integer    n0, n1, n2, n4, n7, n20
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n7 = 7, n20 = 20) 
      integer    ixyuse, ixy_use
      parameter (ixy_use = 1)   
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00,
     +           size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabber, tabvar
      parameter (percent = 100.0d+00, tabber = 0.75d+00)
      double precision height
      parameter (height = 0.60d+00)
      character  line*129, line1*80, w_dbleup*129
      character  x_trim80*80
      character  blank*1
      parameter (blank = ' ')
      logical    extra, ok
      logical    check
      external   x_len200, x_len300, x_trim80
      external   w_syspar, x_putfat, w_dbleup
      intrinsic  len, dble, index, max, min, nint
c
c Scale the font sizes
c                   
      nstart = numsta
      ntext = numtxt
      check = .true.
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
c
c decide on position
c           
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif            
c
c lesser check if required (generally required for list boxes)
c

      if (check) then
         do i = n1, numopt
            if (numpos(i).lt.n0 .or. numpos(i).gt.n1) numpos(i) = n0
         enddo
         ok = .true.
         if (ntext.lt.n1 .or. ntext.lt.numopt .or. numopt.lt.n1 .or. 
     +       nstart.lt.n1 .or. nstart + numopt - n1.gt.ntext) 
     +       ok = .false.
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_lboxm1')
            return
         endif
      endif 
c
c allocate
c         
      ierr = 0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(items)) deallocate(items, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(items2)) deallocate(items2, stat = ierr)
      if (ierr.ne.0) return
      allocate(text(ntext), stat = ierr)
      if (ierr.ne.0) return 
      allocate(items(numopt), stat = ierr)
      if (ierr.ne.0) return
      allocate(items2(numopt), stat = ierr)
      if (ierr.ne.0) return   
      j = nstart + numopt - n1
      do i = n1, ntext 
         if (i.lt.nstart .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else
            text(i) = x_trim80(text_in(i))
         endif      
      enddo
c
c use up dummy arguments to stop ftn90 complaining
c leave them in the argument list for future developments
c
      i = icolor
      i = numdec
      i = lshade
      ok = full
      ok = high
      if (ixyuse.eq.n1) then   
c
c use ixl, iyl and parameter iscale to position the window
c
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c set the windows95 style and open a box if appropriate
c
      if (ntext.eq.numopt) then
         k = winio@('%sy[no_sysmenu, no_border, 3d_thin]&')
         i = winio@('%ca[Options]&')
      else
         k = winio@('%sy[no_sysmenu, thin_border, 3d_thin]&')
         i = winio@('%ca[Simfit: options]&')
      endif

c
c restore the next line if a %ww window is required rather than a dialogue one
c     k = winio@('%ww[no_sysmenu, topmost]&')
c

c
c set the background colour
c
      k = winio@('%bg[grey]&')
c
c put out the text strings up to the menu
c
      do i = n1, nstart - n1
c
c now set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
c
c and set the text color depending on numbld(i)
c
            if (numbld(i).eq.0) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif   
            line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'  
            k = winio@(line, size_courier)
         else    
            if (i.eq.1  .and. numbld(1).ne.0) then 
               k = winio@('%`sf%bf&')
            elseif (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif  
c
c and set the text color depending on numbld(i)
c               
            if (i.eq.1 .and. numbld(1).ne.0) then  
                k = winio@('%tc[black]&')
            elseif (numbld(i).eq.0) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif              
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*tabber*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//'&'
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               k = winio@(line, size_roman)
            endif
         endif
c
c the next calls must have %nl then %sf in that order
c
         k = winio@('%nl&')
         k = winio@('%sf&')
      enddo
      iwide = n1
      if (nstart.gt.n1) then
c
c increase iwide according to header text
c           
         do i = n1, nstart - n1
            l = x_len300(text(i))
            if (l.gt.iwide) iwide = l      
         enddo        
      endif
      if (ntext.gt.nstart + numopt - n1) then
c
c increase iwide according to trailer text
c                         
         do i = nstart + numopt - n1, ntext
            l = x_len300(text(i))
            if (l.gt.iwide) iwide = l                        
         enddo        
      endif                 
c
c initialise factor depending on header/trailer
c      
      if (iwide.gt.n1) then
         factor = 0.95d+00 
         iwide = nint(factor*dble(iwide))      
      else
         factor = 0.85d+00   
      endif               
c
c create the menu items
c
      extra = .false.
      iwide2 = n1
      j = nstart - n1
      do i = n1, numopt
         j = j + n1
         l = x_len200(text(j))
         line1 = text(j)(n1:l)
c
c does the item contain a grave ` tabbing character ?
c
         nblank = n0
         nblank2 = n0
         k = index(line1, '`')
         if (k.ge.n1) then
            extra = .true.
            if (k.gt.n2) then
               do m = n2, k - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank = nblank + n1
               enddo
            endif
            if (l - k.gt.n2) then
               do m = k + n2, l - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank2 = nblank2 + n1
               enddo
            endif
            items(i) = line1(n1:k - n1)
            items2(i) = line1(k + n1:l)
            if (k - n1 - nblank.gt.iwide) iwide = k - n1 - nblank
            if (l - k - nblank2.gt.iwide2) iwide2 = l - k - nblank2
         else
            items(i) = line1(n1:l)
            k = x_len300(line1)
            if (k.gt.iwide) iwide = k
            items2(i) = blank
         endif
      enddo
c
c define ideep
c
      ideep = min(ndeep,numopt)
c
c set up font then show list box (ms sans serif seems best here)
c
      if (fixed) then
         k = winio@('%fn[Courier New]&')
         line = '%ts&'
         k = winio@(line, size_courier)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif
      k = winio@('%cn&')
      k = winio@('%`bg[white]%tc[black]&')

c
c adjust the list box width if necessary
c
      if (.not.fixed) then
         iwide = max(n20, nint(factor*dble(iwide)))
         if (extra) iwide2 = max(n1, nint(factor*dble(iwide2)))
      endif
      if (nstart + numopt - n1.eq.ntext) then
c
c code when there is no more text
c
         k = winio@('%`*.*ms[limit_height]&', iwide, ideep, items,
     +              numopt, numpos, height)
         if (extra) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%`*.*ms[limit_height]&', iwide2, ideep, items2,
     +                 numopt, numpos, height)
         endif
      else
c
c code when there is more text
c
         k = winio@('%`*.*ms[limit_height]&', iwide, ideep, items,
     +              numopt, numpos, height)
         if (extra) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%`*.*ms[limit_height]&', iwide2, ideep, items2,
     +                 numopt, numpos, height)
         endif
         k = winio@('%ff&')
c
c put out the text strings after the end of the menu
c
         do i = nstart + numopt, ntext
            
c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif 
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                   k = winio@('%tc[black]&')
                else
                  k = winio@('%tc[blue]&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                   k = winio@('%tc[black]&')
                else
                  k = winio@('%tc[blue]&')
               endif
c
c does the line contain a tabbing character ` grave accent
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  tabvar = correction*tabber*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
            k = winio@('%sf&')
         enddo
         k = winio@(' &')
      endif
c
c close by button press
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%`tt[&OK]&')
      k = winio@('%nl &')
      k = winio@('%cb')
c
c check numpos before returning
c
      do i = n1, numopt
       if (numpos(i).lt.n0 .or. numpos(i).gt.n1) numpos(i) = n0
      enddo 
c
c deallocate
c           
      deallocate(text, stat = ierr)
      deallocate(items, stat = ierr)
      deallocate(items2, stat = ierr)
      end
c
c
 