c
c
      recursive subroutine w_lboxns (numdec, numopt,
     +                               text_in,
     +                               abort)  
c  
c action: new style list box restricted to the case numopt = #options = #text_in 
c author: w.g.bardsley, university of manchester, u.k. 30/03/2020
c         24/05/2020 replaced parameter ivert by calculated dvert
c         27/05/2020 added abort and removed hover
c         04/02/2021 restored abort, increased height to 0.8, replaced pnt05 by pnt025, and increased maximum dimension to 20
c   
c        dvert = fraction such that 1.0 = twice the font height
c       height = argument to limit_height (0 < height < 1 but I think 0.2 < height =< 0.75 in my experience with this option) 
c            n = number of items (input as numopt)
c            m = len_trim width of the largest item after padding with blanks - a correction factor depending on the padding
c     cur_item = (input/output as numdec)
c   
      implicit none
      include <windows.ins> 
c
c arguments
c     
      integer,             intent (in)    :: numopt
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: text_in(numopt)
      logical,             intent (out)   :: abort
c
c allocatable
c 
       character (len = 129), allocatable :: items(:)     
c
c locals
c
      integer    i, j, k, m, n
      integer    istop
      parameter (istop = 1)
      integer    cur_item
      integer    n_cancel
      integer    i_button_lboxns, i_extra_button_lboxns, i_exit_lboxns 
      double precision one, pnt025
      parameter (one = 1.0d+00, pnt025 = 0.025d+00)
      double precision dvert, height
      parameter (height = 0.8d+00)
      character (len = 129) line
      character (len = 10 ) blank10
      parameter (blank10 = '         ')
      character (len = 6  ) word6
      character (len = 5  ) word5
      character (len = 4  ) word4
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    add_cross, cancel, new_button, ok
      external   i_button_lboxns, i_extra_button_lboxns
      external   add_stop_option, x_lcase1, w_reslib 
      external   i_exit_lboxns
      intrinsic  len_trim, adjustl, dble
      common    / lboxns_info / cancel, ok
c
c check arguments supplied and take evasive action if required
c     
      abort = .true.
      if (numopt.lt.1 .or. numopt.gt.20)  return
      n = numopt
      allocate (items(n), stat = i)
      if (i.ne.0) then
         deallocate(items)
         return
      endif
      abort = .false.
      if (numdec.le.1) then
         numdec = 1
      elseif (numdec.ge.numopt) then
         numdec = numopt
      endif 
      line = blank
      do i = 1, n
         items(i) = blank
      enddo     
c
c initialise then define dvert and check if a closure cross is required
c
      if (numopt.le.12) then
         dvert = one
      else
         dvert = one - pnt025*dble(numopt - 10)
      endif      
      n_cancel = 0  
      add_cross = .false.
      new_button = .false.
      cancel = .false.
      ok = .false.             
      loop_to_add_cross: do i = numopt, 1, -1
         line = text_in(i)
         line = adjustl(line)
         word4 = line(1:4) 
         call x_lcase1 (word4)
         if (word4.eq.'quit' .or.
     +       word4.eq.'exit') then
            n_cancel = i
            word6 = line(1:4)
            add_cross = .true.
            new_button = .true.
            exit loop_to_add_cross
         endif 
         word5 = line(1:5)
         call x_lcase1 (word5)
         if (word5.eq.'apply') then
            n_cancel = i
            word6 = line(1:5)
            add_cross = .true.
            new_button = .true.
            exit loop_to_add_cross
         endif
         word6 = line(1:6)
         call x_lcase1 (word6)
         if (word6.eq.'accept' .or.
     +       word6.eq.'cancel') then
            n_cancel = i
            word6 = line(1:6) 
            add_cross = .true.
            new_button = .true.
            exit loop_to_add_cross
         endif 
      enddo loop_to_add_cross
c
c pad the text_in then copy and calculate m after padding for the call Clearwin
c     
      m = 0
      n = numopt
      do i = 1, n
         j = len_trim(text_in(i))
         items(i) = blank10//text_in(i)(1:j)
         j = len_trim(items(i))
         if (j.gt.m) m = j
      enddo 
c      m = m - 5
c
c call to Clearwin
c        
      cur_item = numdec
      if (add_cross) then
         call w_reslib
         i = winio@('%mi[ICON_1]&')
      else   
         i = winio@('%sy[no_sysmenu]&')
      endif   
      i = winio@('%ca[Simfit: Options]&')
      i = winio@('%bg[white]&')
      i = winio@('%tc[black]&')
      call add_stop_option (istop)
      if (numopt.le.10) then
c
c option without limit_height
c        
         i = winio@(
     +      '%cn%^*.*ls[vertical_fill=*,no_box,confirm]&',
     +       m, n, dvert, items, n, cur_item, i_exit_lboxns)
      else
c
c option with limit_height
c        
         i = winio@(
     +'%cn%^*.*ls[vertical_fill=*,no_box,confirm,limit_height]&',
     +m, n, dvert, items, n, cur_item, height, i_exit_lboxns)
      endif
      i = winio@('%ff%nl&')
c
c add buttons
c   
      if (new_button) then
         k = winio@('%rj&')
         k = winio@('%ob[invisible]&')
         k = winio@('   %^8bt[&OK]&', i_button_lboxns)
         k = winio@(' %^`8bt@   &', word6, i_extra_button_lboxns) 
         k = winio@('%nl &') 
         k = winio@('%dy&', 0.5d+00)
         k = winio@('%cb&')
      else  
         k = winio@('%cn&')
         k = winio@('%ob[invisible]&')
         k = winio@('   %^`8bt[&OK]   &', i_button_lboxns)
         k = winio@('%nl &')
         k = winio@('%dy&', 0.5d+00)
         k = winio@('%cb&')
      endif
      i = winio@('%ff%nl&')
      i = winio@(' ')
c
c retrieve the chosen item
c
      if (ok .or. n_cancel.le.0 .or. n_cancel.gt.numopt) then 
c
c either ok has been pressed or an item has been double-clicked
c        
         numdec = cur_item
      else
c
c either quit/exit/cancel etc. has been pressed or the closure-cross has been activated 
c        
         numdec = n_cancel
      endif 
      deallocate(items)     
      end
c
c
      recursive integer function i_button_lboxns()
c
c the OK button has been pressed so set OK = .true.
c      
      implicit none
      include <windows.ins>
      character (len = 250) clearwin_string@, reason
      logical    cancel, ok
      common    / lboxns_info / cancel, ok     
      reason = clearwin_string@('CALLBACK_REASON')
      if (reason.eq.'BUTTON_PRESS') then 
         ok = .true.
         cancel = .false.
         i_button_lboxns = 0
      else
         i_button_lboxns = 1
      endif      
      end
c
c
      recursive integer function i_extra_button_lboxns()
c
c the extra button cancel/quit/exit etc. hs been pressed so set cancel = .true. 
c      
      implicit none
      include <windows.ins>
      character (len = 250) clearwin_string@, reason
      logical    cancel, ok
      common    / lboxns_info / cancel, ok
      reason = clearwin_string@('CALLBACK_REASON')
      if (reason.eq.'BUTTON_PRESS') then 
         ok = .false.   
         cancel = .true.
         i_extra_button_lboxns = 0
      else
         i_extra_button_lboxns = 1
      endif      
      end  
c
c
      recursive integer function i_exit_lboxns()
c
c an item has been double clicked 
c      
      implicit none
      character (len = 250) clearwin_string@, reason
      logical    cancel, ok
      common    / lboxns_info / cancel, ok
      reason = clearwin_string@('CALLBACK_REASON')
      if (reason.eq.'ITEM_DOUBLE_CLICKED')  then
         i_exit_lboxns = 0
         ok = .true.
         cancel = .false.
      else
         i_exit_lboxns = 1   
      endif
      end               
c
c

     