c
c
      recursive subroutine w_lboxny (numbld, numdec, numopt, numsta,
     +                               numtxt,
     +                               text_in,
     +                               abort)  
c  
c action: new style list box developed from w_lboxns, 25/05/2020
c         29/05/2020 introduced text_copy and w_dbleup to trap % and &, etc. in the header 
c                    and added blank4 and blank5 to indent the header  
c         19/06/2020 commented out the line m = m - 5 as this can cause wide titles to hit the rhs margin
c         30/01/2021 introduced %ob and scaling factor for m in header
c         22/03/2021 added %`1tl which requires tabber, correction, percent, and call to w_syspar
c   
c        dvert = fraction such that 1.0 = twice the font height
c       height = argument to limit_height (0 < height < 1 but I think 0 < height =< 0.7 in my experience with this option) 
c            n = number of items (input as numopt)
c            m = len_trim width of the largest item after padding with blanks - a correction factor depending on the padding
c     cur_item = (input/output as numdec)
c   
c The idea is that this routine called from w_lbox01 so that, if abort is returned .true., then the the arguments are returned
c for further processing by w_lbox01.   
c
      implicit none
      include <windows.ins> 
c
c arguments
c     
      integer, intent (inout)         :: numdec
      integer, intent (in)            :: numopt, numsta, numtxt
      integer, intent (in)            :: numbld(numtxt)
      character (len = *), intent(in) :: text_in(numtxt)
      logical, intent (out)           :: abort
c
c allocatable
c 
       character (len = 129), allocatable :: header(:), items(:)     
c
c locals
c
      integer    i, j, k, m, n, numhdr
      integer    istop, max_grave
      parameter (istop = 1, max_grave = 1)
      integer    cur_item
      integer    n_cancel
      integer    i_button_lboxny, i_extra_button_lboxny, i_exit_lboxny 
      double precision correction, dvert, tabvar
      double precision one, percent, pnt025, tabber
      parameter (one = 1.0d+00, percent = 100.0d+00, pnt025 = 0.025d+00,
     +           tabber = 1.0d+00)
      double precision height
      parameter (height = 0.8d+00)
      character (len = 129) line, text_copy
      character (len = 129) w_dbleup
      character (len = 10 ) blank10
      parameter (blank10 = '         ')
      character (len = 6  ) word6
      character (len = 5  ) blank5, word5
      parameter (blank5 = '     ')  
      character (len = 4  ) blank4, word4
      parameter (blank4 = '    ')
      character (len = 1  ) blank, grave
      parameter (blank = ' ', grave = '`')
      logical    add_cross, cancel, new_button, ok
      external   i_button_lboxny, i_extra_button_lboxny
      external   i_exit_lboxny, add_stop_option, x_lcase1, w_reslib, 
     +           w_syspar, w_dbleup
      intrinsic  len_trim, adjustl
      common    / lboxny_info/ cancel, ok
c
c check arguments supplied and take evasive action if required
c      
      abort = .true.
      line = blank
      if (numtxt.gt.50 .or.
     +    numopt.gt.20 .or.   
     +    numtxt.lt.1  .or.           
     +    numopt + numsta - 1.ne.numtxt) then
          return
      else
         do i = 1, numsta - 1
            line = text_in(i)
            k = len_trim(line)
            m = 0
            do j = 1, k
               if (line(j:j).eq.grave) m = m + 1
               if (m.gt.max_grave) return  
            enddo
         enddo 
      endif  
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      if (numdec.le.1) then
         numdec = 1
      elseif (numdec.ge.numopt) then
         numdec = numopt
      endif 
      n = numopt
      allocate (items(n), stat = i)
      if (i.ne.0) then
         deallocate(items)
         return
      endif  
      do i = 1, n
         items(i) = blank
      enddo   
c
c prepare the header and items sections
c     
      abort = .false.  
      numhdr = numtxt - numopt
      n = numhdr
      allocate (header(n), stat = i)
      if (i.ne.0) then
         deallocate(header)
         abort = .true.
         return
      endif  
      do i = 1, numhdr
         header(i) = blank
         text_copy = blank
         text_copy = text_in(i)
         text_copy = w_dbleup(text_copy)
         j = index(text_copy,grave)
         if (j.le.0) then
            header(i) = text_copy
         else
            header(i)(1:j - 1) = text_copy(1:j - 1)
            k = len_trim(text_copy)
            header(i)(j:j + 4) = ' %ta '
            header(i)(j + 5:k + 4) = text_copy(j + 1:k)
         endif
      enddo
c
c initialise then check if a closure cross is required
c
      if (numopt.le.12) then
         dvert = one
      else
         dvert = one - pnt025*dble(numopt - 10)
      endif      
      n_cancel = 0  
      add_cross = .false.
      new_button = .false.
      cancel = .false.
      ok = .false. 
c
c note that it is necessary to subtract numhdr from the text line with the quit/exit/cancel/apply/accept to get n_cancel
c                  
      loop_to_add_cross: do i = numtxt, numsta, -1
         line = text_in(i)
         line = adjustl(line)
         word4 = line(1:4) 
         call x_lcase1 (word4)
         if (word4.eq.'quit' .or.
     +       word4.eq.'exit') then
            n_cancel = i - numhdr
            word6 = line(1:4)
            add_cross = .true.
            new_button = .true.
            exit loop_to_add_cross
         endif 
         word5 = line(1:5)
         call x_lcase1 (word5)
         if (word5.eq.'apply') then
            n_cancel = i - numhdr
            word6 = line(1:5)
            add_cross = .true.
            new_button = .true.
            exit loop_to_add_cross
         endif
         word6 = line(1:6)
         call x_lcase1 (word6)
         if (word6.eq.'accept' .or.
     +       word6.eq.'cancel') then
            n_cancel = i - numhdr
            word6 = line(1:6) 
            add_cross = .true.
            new_button = .true.
            exit loop_to_add_cross
         endif 
      enddo loop_to_add_cross
c
c pad the text_in then copy and calculate m after padding for the call Clearwin
c     
      m = 0
      n = numhdr
      do i = 1, n
         j = len_trim(header(i))
         if (j.gt.m) m = j
      enddo     
      n = numopt
      k = numhdr
      do i = 1, n
         k = k + 1
         j = len_trim(text_in(k))
         items(i) = blank10//text_in(k)(1:j)
         j = len_trim(items(i))
         if (j.gt.m) m = j
      enddo 
      m = nint(dble(m)*0.75d+00)!29/01/2021 Note: contraction factor may need adjusting
c
c call to Clearwin
c        
      cur_item = numdec
      if (add_cross) then
         i = winio@('%sy[thin_border]&')
         call w_reslib
         i = winio@('%mi[ICON_1]&')
      else   
         i = winio@('%sy[thin_border,no_sysmenu]&')
      endif
c
c set the caption and background colour then open the first box
c  
      i = winio@('%ca[Simfit: Options]&')
      call add_stop_option (istop)    
      k = winio@('%bg&', rgb@(240,240,240))
      i = winio@('%tc[black]&')
      
      k = winio@('%ob[invisible]&')

c
c display the header
c       
      do i = 1, numhdr
c
c define line then set the text_in color etc. depending on i and numbld(i)
c        
         k = winio@('%`sf&')
         
         j = index(header(i),'%ta')
         if (j.gt.0) then
            tabvar = correction*tabber*dble(j)
            k = winio@('%`1tl&', tabvar)
         endif  
         j = len_trim(header(i))        
         j = j + 5!29/01/2021 increase j to create a margin to the right of the text pane
         line = blank
         line(1:j + 1) = header(i)(1:j)//'&'
         if (i.eq.1) then
            k = winio@('%bf&')
            k = winio@('%tc[black]&')
            k = winio@('%ts&', 1.2d+00)
            k = winio@(blank4//line)
         else
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif 
            k = winio@('%ts&', 1.1d+00)
            k = winio@(blank5//line)
         endif
         k = winio@('%dy&', 0.25d+00)
         k = winio@('%nl&')
      enddo  

      k = winio@('%cb&')
      k = winio@('%ob[invisible]&')
c
c display the list box
c
      k = winio@('%ff%nl&') 
      k = winio@(' &') 
      k = winio@('%`sf&')
      i = winio@('%`bg[white]&')
      if (numopt.le.10) then
c
c option without limit_height
c        
         i = winio@(
     +      '%cn%^*.*ls[vertical_fill=*,confirm]&',
     +       m, n, dvert, items, n, cur_item, i_exit_lboxny)
      else
c
c option with limit_height
c        
         i = winio@(
     +'%cn%^*.*ls[vertical_fill=*,confirm,limit_height]&',
     + m, n, dvert, items, n, cur_item, height, i_exit_lboxny)
      endif
      i = winio@('%ff%nl&')
c
c add buttons
c   
      if (new_button) then
         k = winio@('%rj&')
         k = winio@('%ob[invisible]&')
         k = winio@('   %^8bt[&OK]&', i_button_lboxny)
         k = winio@(' %^`8bt@   &', word6, i_extra_button_lboxny) 
         k = winio@('%nl &') 
         k = winio@('%dy&', 0.5d+00)
         k = winio@('%cb&')
      else  
         k = winio@('%cn&')
         k = winio@('%ob[invisible]&')
         k = winio@('   %^`8bt[&OK]   &', i_button_lboxny)
         k = winio@('%nl &')
         k = winio@('%dy&', 0.5d+00)
         k = winio@('%cb&')
      endif
      i = winio@('%ff%nl&')
      i = winio@('%cb')
c      i = winio@(' ')
c
c retrieve the chosen item
c
      if (ok .or. n_cancel.le.0 .or. n_cancel.gt.numopt) then 
c
c either ok has been pressed or an item has been double-clicked
c        
         numdec = cur_item
      else
c
c either quit/exit/cancel etc. has been pressed or the closure-cross has been activated 
c        
         numdec = n_cancel
      endif 
      deallocate(items)   
      end
c
c
      recursive integer function i_button_lboxny()
c
c the OK button has been pressed so set OK = .true.
c      
      implicit none
      include <windows.ins>
      character (len = 250) clearwin_string@, reason
      logical    cancel, ok
      common    / lboxny_info/ cancel, ok     
      reason = clearwin_string@('CALLBACK_REASON')
      if (reason.eq.'BUTTON_PRESS') then 
         ok = .true.
         cancel = .false.
         i_button_lboxny = 0
      else
         i_button_lboxny = 1
      endif      
      end
c
c
      recursive integer function i_extra_button_lboxny()
c
c the extra button cancel/quit/exit etc. hs been pressed so set cancel = .true. 
c      
      implicit none
      include <windows.ins>
      character (len = 250) clearwin_string@, reason
      logical    cancel, ok
      common    / lboxny_info/ cancel, ok
      reason = clearwin_string@('CALLBACK_REASON')
      if (reason.eq.'BUTTON_PRESS') then 
         ok = .false.   
         cancel = .true.
         i_extra_button_lboxny = 0
      else
         i_extra_button_lboxny = 1
      endif      
      end  
c
c
      recursive integer function i_exit_lboxny()
c
c an item has been double clicked 
c      
      implicit none
      character (len = 250) clearwin_string@, reason
      logical    cancel, ok
      common    / lboxny_info/ cancel, ok
      reason = clearwin_string@('CALLBACK_REASON')
      if (reason.eq.'ITEM_DOUBLE_CLICKED')  then
         i_exit_lboxny = 0
         ok = .true.
         cancel = .false.
      else
         i_exit_lboxny = 1   
      endif
      end               