

c
c
      recursive subroutine w_lboxnz (numbld, numdec, numopt, numsta,
     +                               numtxt,
     +                               text_in,
     +                               abort)  
c  
c action: sets up new arguments then calls w_lboxny
c author: w.g.bardsley, university of manchester, uk, 03/02/2021
c         12/02/2021 editing to improve the code defining m and increase nxtra to 2 when itype = 2
c
      implicit none
c
c arguments
c     
      integer, intent (inout)         :: numdec
      integer, intent (in)            :: numopt, numsta, numtxt
      integer, intent (in)            :: numbld(numtxt)
      character (len = *), intent(in) :: text_in(numtxt)
      logical, intent (out)           :: abort
c
c locals
c
      integer    nmax
      parameter (nmax = 50) 
      integer    i, itype, j, k, m, new_numsta, new_numtxt,
     +           numhdr, numtrl, nxtra
      integer    new_numbld(nmax)
      double     precision factor
      parameter (factor = 0.85d+00)
      character (len = 129) new_text_in(nmax)
      character (len = 1  ) blank, uscore
      parameter (blank = ' ', uscore = '_')
      external   w_lboxns, w_lboxnx,w_lboxny
      intrinsic  nint, dble, len_trim
c
c initialise abort and check the arguments
c      
      abort = .true.  
      if (numopt.gt.20 .or. numopt.lt.1 .or. numsta.lt.1 .or. 
     +    numsta.gt.numtxt .or. numtxt.gt.50) return
c      
c numhdr (#header) and numtrl (#trailer) must be defined here and not changed subsequently
c      
      if (numopt.eq.numtxt .and. numopt.le.20) then
         call w_lboxns (numdec, numopt, 
     +                  text_in,
     +                  abort)
         return
      elseif (numopt.le.18.and.numtxt.le.22 .and. numsta.gt.1 
     +        .and. numopt + numsta - 1.eq.numtxt) then
         call w_lboxnx (numbld, numdec, numopt, numsta, numtxt,
     +                  text_in,
     +                  abort)  
         return
      elseif (numopt.le.20 .and. numsta + numopt - 1 .eq. numtxt) then
         call w_lboxny (numbld, numdec, numopt, numsta, numtxt,
     +                  text_in,
     +                  abort)  
         return
      endif 
c
c now there can now only be two possibilities: itype = 1 (numhdr > 0, numtrl > 0)
c                                              itype = 2 (numhdr = 0, numtrl > 0)
      numhdr = numsta - 1 
      numtrl = numtxt - (numopt + numhdr)
      if (numhdr.le.0 .and. numtrl.le.0) return
      if (numhdr.gt.0 .and. numtrl.gt.0) then
         itype = 1
         nxtra = 3
      elseif (numhdr.eq.0 .and. numtrl.gt.0) then
         itype = 2
         nxtra = 2
      endif       
c
c initialise the new arrays
c      
      do i = 1, nmax
         new_text_in(i) = blank
         new_numbld(i) = 0
      enddo 
c         
c calculate the scaled maximum width of header and/or trailer   
c
      m = 0
      if (numhdr.gt.0) then
         do i = 1, numhdr 
            k = len_trim(text_in(i))
            if (k.gt.m) m = k
         enddo
      endif  
      if (numtrl.gt.0) then
         do i = numsta + numopt, numtxt
            k = len_trim(text_in(i))
            if (k.gt.m) m = k
         enddo
      endif  
      m = nint(factor*dble(m))      
c
c add original header/trailer to new_text_in and define new_numbld 
c     
      if (itype.eq.1) then 
c
c itype = 1: header and trailer present 
c        
         do i = 1, numhdr
            new_text_in(i) = text_in(i)         
            new_numbld(i) = numbld(i)
         enddo
c
c add additional space between original header and original trailer
c     
         do i = 1, nxtra  
           new_numbld(numhdr + i) = 0
           new_text_in(numhdr + i) = blank
         enddo 
c
c add a line of underscores to separate the new header section from the trailer section 
c      
         
         j = numhdr + 2
         do i = 1, m
            new_text_in(j)(i:i) = uscore
         enddo
c
c now add the original trailer to the new header
c      
         j = numhdr + nxtra 
         k = numhdr + numopt 
         do i = 1, numtrl  
            j = j + 1 
            k = k + 1
            new_text_in(j) = text_in(k)
            new_numbld(j) = numbld(k)
         enddo
c
c finally add the original options to complete new_text_in
c
         j = numhdr + numtrl + nxtra
         k = numsta - 1
         do i = 1, numopt
            j = j + 1
            k = k + 1
            new_text_in(j) = text_in(k)
         enddo
         new_numtxt = numhdr + numtrl + numopt + nxtra
         new_numsta = numhdr + numtrl + nxtra + 1  
      elseif (itype.eq.2) then
c
c itype = 2: trailer but no header
c        
c
c new first lines
c      
         j = nxtra - 1
         do i = 1, m
           new_text_in(j)(i:i) = uscore
         enddo
         new_numbld(j) = 0
         j = nxtra
         new_text_in(j) = blank
         new_numbld(j) = 0   
         k = numopt
         do i = 1, numtrl  
            j = j + 1 
            k = k + 1
            new_text_in(j) = text_in(k)
            new_numbld(j) = numbld(k)
         enddo
c
c finally add the original options to complete new_text_in
c
         j = numtrl + nxtra
         k = numsta - 1
         do i = 1, numopt
            j = j + 1
            k = k + 1
            new_text_in(j) = text_in(k)
            new_numbld(j) = numbld(k)
         enddo
         new_numtxt = numtrl + numopt + nxtra
         new_numsta = numtrl + nxtra + 1  
      endif
c
c call w_lboxny 
c     
      call w_lboxny (new_numbld, numdec, numopt, new_numsta,
     +               new_numtxt,
     +               new_text_in,
     +               abort)   
      end   
c
c                  