c
c
      subroutine w_linein (icolor, ixl, iyl, nchar, numbld, numtxt,
     +                     line, text_in,
     +                     fixed)
c
c action : put out a patch of text with attributes onto a window
c          then return with a character string
c          nchar sets the width of the read box
c author : w.g.bardsley, university of manchester, u.k., 27/12/96
c
c          this version uses: len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c
c          10/02/1997 added tabbing
c          04/04/1997 added call to w_syspar to adjust font size
c          08/05/1997 extensive revision to allow %sy to create
c                     windows95 style. If icolor is 9 (as in the original
c                     dbos scheme) or 15 a white background is used but
c                     otherwise a windows95 style grey/white is used.
c          01/11/1998 changed colour and tidied up
c          14/11/1998 used [ms sans serif] explicitly instead of `sf
c          03/12/1999 restored topmost
c          21/01/2001 suppressed topmost and replced assumed size arrays
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure
c                     o/w normal dialogue window
c          13/02/2002 XP version
c          18/12/2002 added %sy[toolwindow]
c          15/11/2006 added ixyuse to suppress toolwindow and ignore ixl, iyl  
c          02/02/2007 edited for w_clearwin.dll 
c          29/05/2007 added allocatable text, w_dbleup, and roman
c          04/08/2017 added the subroutine add_stop_option
c
c          icolor    background   text     highlight-text
c          ======    ==========   ====     ==============
c          9 or 15   white        black    red
c          o/w       grey         black    blue
c
c          numbld(i)  font (Courier is used if fixed = .true.)
c          =========  ====
c          0, 1       Times
c          2, 3       Times Italic
c          4, 5       Times Bold
c          6, 7       Times Bold Italic
c
c          text size is set by the size parameters
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: icolor, ixl, iyl, nchar,
     +                                       numtxt
      integer,             intent (in)    :: numbld(numtxt) 
      character (len = *), intent (in)    :: text_in(numtxt)
      character (len = *), intent (inout) :: line
      logical,             intent (in)    :: fixed 
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
c
c locals
c      
      integer    isend
      parameter (isend = 1)
      integer    i, ierr, j, k, l  
      integer    x_len200
      integer    ixyuse, mwtype  
      integer    ixy_use, mw_type
      parameter (ixy_use = 2, mw_type = 2)
      integer    iscale, n1
      parameter (n1 = 1)
      double precision size1, size_courier, size_roman
      double precision size_courier_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00) 
      character  w_dbleup*129
      character  blank*1, line1*129, space*3
      parameter (blank = ' ', space = '   ') 
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200
      external   w_syspar, w_dbleup
      external   add_stop_option
      intrinsic  dble, index  
c
c check numtxt, allocate workspace, then copy text_in into text
c     
      if (numtxt.lt.1) return
      ierr = 0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return
      allocate (text(numtxt), stat = ierr)
      if (ierr.ne.0) return
      do i = 1, numtxt
         text(i) = w_dbleup(text_in(i))
      enddo       
c
c window type: recommend, ixyuse = 2 (ignore ixl and iyl and toolwindow)
c                         mwtype = 2 (dialogue window with no closure cross)
c            
      if (ixl.le.0 .or. iyl.le.0) then
         ixyuse = 2
      else   
         ixyuse = ixy_use
      endif   
      mwtype = mw_type  
c
c set the font type
c                  
      roman = roman_1
c
c Scale the font sizes
c                  
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent  
      size_courier = correction*size_courier_1 
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
     
     
c
c swap the next code to use ixl, iyl and parameter iscale to position the window
c ==============================================================================
c 
      if (ixyuse.eq.1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif
     
c
c swap the next code to use a normal window rather than a dialogue window
c =======================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
c
c restore the next lines to suppress the closure cross
c         
c      elseif (mwtype.eq.n2) then
c         i = winio@('%sy[no_sysmenu]&')
      endif
      
c
c now set the background colour depending on icolor
c
      if (icolor.eq.9 .or.icolor .eq.15) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg[grey]&')
         k = winio@('%sy[3d_thin]&')!causes grey to equal off-white
      endif

      i = winio@('%ca[Simfit: data required]&')
      if (numtxt.gt.1) call add_stop_option (isend)      
        
      do i = n1, numtxt
c
c now set the text font depending on numbld(i) and fixed
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif 
c
c and set the text color depending on numbld(i) and icolor
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               if (icolor.eq.9 .or. icolor.eq.15) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif            
            line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl%sf&'
            k = winio@(line1, size_courier)
         else 
            if (roman) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Times New Roman]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Times New Roman]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Times New Roman]%bf&')
               else
                  k = winio@('%fn[Times New Roman]%bf%it&')
               endif
            else       
               if (i.eq.1 .and.numbld(1).ne.0) then 
                  k = winio@('%`sf%bf&')
               elseif (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
            endif 
c
c and set the text color depending on numbld(i) and icolor
c                  
            if (.not.roman .and. i.eq.1 .and. numbld(1).ne.0) then 
                k = winio@('%tc[black]&')
            elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               if (icolor.eq.9 .or. icolor.eq.15) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif                 
            j = index(text(i), '`')
            if (j.lt.n1) then
               line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl%sf&'  
               k = winio@(line1, size_roman)
            else
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line1 = blank
               line1 = text(i)(n1:j - n1)//'&'
               k = winio@(line1(n1:j))
               line1 = blank
               line1 = '%ta'//text(i)(j + n1:l)//'%nl&'
               tab = correction*factor*dble(j)
               k = winio@('%`1tl&', tab)
               k = winio@(line1(n1:l - j + 7))
               k = winio@('%sf&')
            endif
         endif
      enddo
c
c text display is finished so end with request for a new line
c but first set the scale if nchar is large to reduce font size
c
      size1 = size_courier
      k = winio@('%nl%cn%`sf%tc[black]%ts&', size1)
      k = winio@('%`bg[white]&')
      if (nchar.le.10) then
         k = winio@('%10rs&',  line)
      elseif (nchar.le.20) then
         k = winio@('%15rs&',  line)
      elseif (nchar.le.30) then
         k = winio@('%20rs&',  line)
      elseif (nchar.le.45) then
         k = winio@('%30rs&',  line)
      elseif (nchar.le.130) then
         k = winio@('%45rs&',  line)
      else
         k = winio@('%60rs&', line)
      endif
      k = winio@(space//'%6`bt[OK]') 
c
c finally deallocate text
c      
      deallocate (text, stat = ierr)
      end
c
c
