c
c
      subroutine w_list01 (line)
c
c action : open a window for scrolling output
c author : w.g.bardsley, university of manchester, u.k.
c          06/06/2009 new version derived from w_list02 
c          16/06/2009 below = .true. for buttons below o/w at side
c          16/11/2009 added %ac[Ctrl+C}
c          16/01/2010 added an extra temporary_yield@ each time the subroutine 
c                     is called and deleted the calls to %ww, %mi, %ca, %cw%. 
c          02/03/2010 deleted sleep1@ and extra temporarily_yield@ but restored %ww
c          13/03/2010 restored sleep1@ and added CancelSelection, etc. as in Paul's WC7 
c          02/04/2010 added an edit button and deleted accelerator for copy
c          10/09/2010 added mwtype to swap window types 
c          07/03/2015 introduced kind = 7 
c          31/03/2017 increased time = 0.05 to time = 0.25
c
c          The argument line must be intent (inout) as it is used
c          for reverse communication when entry values are as follows
c
c          line = 'OPEN'   or line = 'open'   open window  ... line is unchanged
c          line = 'CLOSE'  or line = 'close'  close window ... line is returned as 'CLOSE'
c          line = 'STATUS' or line = 'status' line is returned overwritten by 'OPEN' or 'CLOSE'
c          line = 'NOPEN'  or line = 'nopen'  line is returned overwritten by integer nopen 
c          o/w just write line to the output window    
c
c Note: nopen = 0 ... unit is unopened 
c             = 1 ... unit is now connected for writing 
c        wait = .true.  ... [Pause] has been pressed so wait until [Continue] or [Cancel] is pressed	
c             = .false. ... write out the line
c
      implicit   none
      include   <windows.ins>  
      C_EXTERNAL CancelSelection "__cancel_selection"(VAL)
c
c argument
c                 
      character (len = *), intent (inout) :: line
c
c locals
c
      integer (kind = 7) hwnd, nh
      integer    i, ios, nlines
      integer    ictrl, nopen, nout
      integer    i_cancel_list01, i_continue_list01, i_pause_list01
      integer    i_copy_list01
      integer    i_grey_continue, i_grey_pause
      integer    mwtype, mw_type, nmax
      parameter (mw_type = 2, nmax = 100000)
      real       time
      double precision correction, percent, sizes, size1
      parameter (sizes = 1.0d+00, percent = 100.0d+00)
      character  temp*129, text(nmax)*129
      logical    op, first, wait
      logical    below, below_1, side, side_1
      parameter (below_1 = .false., side_1 = .false.)
      external   w_getnou, w_syspar, x_ucase1, x_triml1, w_reslib
      external   i_cancel_list01, i_continue_list01, i_pause_list01
      external   i_copy_list01
      intrinsic  dble
      common   / cancel_list01 / ictrl, nopen, nout
      common   / pause_list01 / wait
      common   / grey_list01 / i_grey_continue, i_grey_pause 
      common   / copy_list01 / nlines, text
      save       first, mwtype
      save       hwnd, nh
      data       first / .true. /
c
c First time initialise nopen and wait
c
      if (first) then
         mwtype = mw_type
         first = .false.
         wait = .false.
         i_grey_continue = 1
         i_grey_pause = 1
         nopen = 0
      endif
c
c Check that the window has not previously been opened or closed
c
      temp = line
      call x_triml1 (temp)
      call x_ucase1 (temp)
      if (temp.eq.'OPEN') then
c
c temp = 'OPEN': Simply return if called when already opened o/w set nopen = 1 and proceed
c      
         if (nopen.eq.1) then
c
c a window has already been opened
c           
            return
         else
            nopen = 1   
         endif
      elseif (temp.eq.'STATUS') then
c
c status has been requested
c      
         if (nopen.eq.1) then
            line = 'OPEN'
         else
            line = 'CLOSE'
         endif
         return
      elseif (temp.eq.'NOPEN') then
c
c value of nopen has been requested
c      
         write (line,'(i1)') nopen
         return            
      elseif (nopen.ne.1) then
c
c return if nopen not equal to 1
c      
         return   
      endif
c
c Either the window is being opened, used, or closure has been requested
c
      if (temp.eq.'OPEN') then
c
c open the main control
c        
         nlines = 0
         below = below_1
         side = side_1
         wait = .false.
         i_grey_continue = 1
         i_grey_pause = 1
         call w_syspar (i, 'f')
         correction = dble(i)/percent
         size1 = correction*sizes
         i = winio@('%fn[Courier New]&')
         i = winio@('%ts&', size1)
         i = winio@('%tc[black]&')
         call w_reslib
         i = winio@('%mi[icon_1]&') 
         i = winio@('%ca[Simfit: table]&')
         i = winio@('%mn[Copy]&', i_copy_list01)
         i = winio@('%mn[~Pause]&', i_grey_pause, i_pause_list01)
         i = winio@('%mn[~Continue]&', i_grey_continue,
     +                                 i_continue_list01)
         if (mwtype.eq.1) then
            i = winio@('%ww[topmost, thin_border, no_minbox]&')
         else
            i = winio@('%sy[thin_border]&')
         endif      
         i = winio@('%cc&', i_cancel_list01)
         call w_getnou (nout)
         i = winio@('%pv%90.40`cw[local_font, vscroll, hscroll]&', nout,
     +                                                             nh)
         i = winio@('%lc&', hwnd)
         i = winio@('%`sf&')
         i = winio@('%ts&', size1)

         if (below) then
c
c buttons below control
c           
            i = winio@('%ff&')
            i = winio@('%dy&', 0.5d+00)
            i = winio@(
     +'%cn%~^tt[Pause]  %~^tt[Continue]  %^tt[Cancel]&',
     +i_grey_pause, i_pause_list01, i_grey_continue, 
     +i_continue_list01, i_cancel_list01)
         elseif (side) then
c
c buttons at side of control
c           
            i = winio@('%1.3ob[invisible]&')
            i = winio@('  %~^6bt[Pause]%nl&', i_grey_pause,
     +                                        i_pause_list01)
            i = winio@('%cb%dy&', 0.5d+00)
            i = winio@('  %~^6bt[Resume]%nl&', i_grey_continue,
     +                                      i_continue_list01)
            i = winio@('%cb%dy&', 0.5d+00)
            i = winio@('  %^6bt[Cancel]&', i_cancel_list01)
            i = winio@('%cb&')
         endif
c
c finally add an accelerator if required then exit with %lw
c suppressed as copy does not work with %cw         
c         i = winio@('%ac[Ctrl+C]&', 'copy')
c
         i = winio@('%lw', ictrl)
         call set_max_lines@(nh, nmax)
      elseif (temp.eq.'CLOSE') then
c
c pause until the main control is closed using [Cancel]
c     
         i_grey_continue = 0
         i_grey_pause = 0
         call window_update@(i_grey_continue)
         call window_update@(i_grey_pause)
         time = 0.25
         do while (nopen.eq.1)
            call CancelSelection(hwnd)
            call temporary_yield@()
            call sleep1@(time)
            call temporary_yield@()
         enddo
      else
c
c pause if required then write out the line
c        
         if (nopen.eq.1) then
            time = 0.25
            do while (wait)
               call CancelSelection(hwnd)
               call temporary_yield@()
               call sleep1@(time)
               call temporary_yield@()
            enddo 
            call CancelSelection(hwnd)
            inquire (unit = nout, opened = op, iostat = ios)
            if (ios.eq.0 .and. op) then
               nopen = 1
               write (nout,'(a)') line
               if (nlines.lt.nmax) then
                  nlines = nlines + 1
                  text(nlines) = line
               endif   
            else
               nopen = 0
            endif
         endif   
      endif
      if (nopen.ne.1) line = 'CLOSE'
      end
c
c
      recursive integer function i_cancel_list01()
      implicit  none
      integer   ictrl, nopen, nout
      logical   wait
      common  / cancel_list01 / ictrl, nopen, nout
      common  / pause_list01 / wait
      i_cancel_list01 = 0
      wait = .false.
      nopen = 0
      close (unit = nout)
      ictrl = 0
      call window_update@(ictrl)
      end
c
c
      recursive integer function i_continue_list01()
      implicit  none
      integer   i_grey_continue, i_grey_pause      
      logical   wait
      common  / pause_list01 / wait
      common  / grey_list01 / i_grey_continue, i_grey_pause 
      i_continue_list01 = 1
      wait = .false.
      i_grey_continue = 1
      i_grey_pause = 1
      call window_update@(i_grey_continue)
      call window_update@(i_grey_pause)
      end
c
c
      recursive integer function i_pause_list01()
      implicit  none
      integer   i_grey_continue, i_grey_pause      
      logical   wait
      common  / pause_list01 / wait
      common  / grey_list01 / i_grey_continue, i_grey_pause 
      i_pause_list01 = 1
      wait = .true.
      i_grey_continue = 1
      i_grey_pause = 0  
      call window_update@(i_grey_continue)
      call window_update@(i_grey_pause)    
      end
c
c      
      recursive integer function i_copy_list01()
      implicit   none
      integer    nlines
      integer    i, nout
      integer    nmax
      parameter (nmax = 100000)
      character  text(nmax)*129
      character  fname*1024
      logical    askif, there
      external   w_gettmp, w_viewer, w_getnou, w_deleet
      common   / copy_list01 / nlines, text
      i_copy_list01 = 1
      call w_gettmp (i, 
     +               fname)
      call w_getnou (nout)
      open (unit = nout, file = fname)
      do i = 1, nlines
         write (nout,'(a)') text(i)
      enddo
      close (unit = nout)
      i = 1
      call w_viewer (i, fname, ' ', ' ')
      askif = .false.
      call w_deleet (fname,
     +               askif, there)
      end
c
c               