c
c
      subroutine w_list03 (line)
c
c action : open a window for output
c author : w.g.bardsley, university of manchester, u.k.
c          03/04/2010 derived from w_list02
c          07/03/2015 introduced kind = 7 
c          31/03/2017 increased time = 0.05 to time = 0.25
c
c          The argument line is unchanged so, if reverse communication is required, use w_list01. 
c          Special effects are produced when line is supplied with 'OPEN' or 'CLOSE' as follows:
c          line = 'OPEN'   or line = 'open'   then open a window
c          line = 'CLOSE'  or line = 'close'  then close the window
c          o/w write line to the window    
c
c Note: nopen = 0 ... unit is unopened 
c             = 1 ... unit is now connected for writing 
c        wait = .true.  ... [Pause] has been pressed so wait until [Continue] or [Cancel] is pressed	
c             = .false. ... write out the line
c
      implicit   none
      include   <windows.ins>  
      C_EXTERNAL CancelSelection "__cancel_selection"(VAL)      
c
c argument
c                 
      character (len = *), intent (in) :: line
c
c locals
c      
      integer (kind = 7) hwnd, nh
      integer    i, ios, nlines
      integer    ictrl, nopen, nout
      integer    i_cancel_list03, i_copy_list03
      integer    i_grey_continue, i_grey_pause
      integer    nmax
      parameter (nmax = 100000)
      real       time
      double precision correction, percent, sizes, size1
      parameter (sizes = 1.0d+00, percent = 100.0d+00)
      character  temp*129, text(nmax)*129
      logical    op, first
      external   w_getnou, w_syspar, x_ucase1, x_triml1, w_reslib
      external   i_cancel_list03,  i_copy_list03
      intrinsic  dble
      common   / cancel_list03 / ictrl, nopen, nout
      common   / copy_list03 / nlines, text 
      save       first
      save       hwnd, nh
      data       first / .true. /
c
c First time initialise nopen and wait
c
      if (first) then
         first = .false.
         nopen = 0
      endif
c
c Check that the window has not previously been opened or closed
c
      temp = line
      call x_triml1 (temp)
      call x_ucase1 (temp)
      if (temp.eq.'OPEN') then
c
c temp = 'OPEN': Simply return if called when already opened o/w set nopen = 1 and proceed
c      
     
         if (nopen.eq.1) then
c
c a window has already been opened
c           
            return
         else
            nopen = 1   
         endif
      elseif (nopen.ne.1) then
c
c return if nopen not equal to 1
c      
         return   
      endif
c
c Either the window is being opened, used, or closure has been requested
c
      if (temp.eq.'OPEN') then
c
c open the main control
c        
         nlines = 0
         i_grey_continue = 1
         i_grey_pause = 1
         call w_syspar (i, 'f')
         correction = dble(i)/percent
         size1 = correction*sizes
         i = winio@('%fn[Courier New]&')
         i = winio@('%tc[black]&')
         i = winio@('%ts&', size1)
         call w_reslib
         i = winio@('%mi[icon_1]&')
         i = winio@('%ca[Simfit: table]&')
         i = winio@('%mn[Copy]&', i_copy_list03)
         i = winio@('%ww[topmost, thin_border, no_minbox]&')
         i = winio@('%cc&', i_cancel_list03)
         call w_getnou (nout)
         i = winio@('%pv%`90.40cw[local_font, vscroll, hscroll]&', nout,
     +                                                             nh)
         i = winio@('%lc&', hwnd)
         i = winio@('%`sf&')
         i = winio@('%ts&', size1)
c
c finish window creation by adding %ac if required and %lw
c accelerator for copy suppressed as it does not work with %cw        
c 
c        i = winio@('%ac[Ctrl+C]&', 'copy')
         i = winio@('%lw', ictrl)
         call set_max_lines@(nh, nmax)
      elseif (temp.eq.'CLOSE') then
c
c pause until the main control is closed using [Cancel]
c     
         i_grey_continue = 0
         i_grey_pause = 0
         call window_update@(i_grey_continue)
         call window_update@(i_grey_pause)
         time = 0.25
         do while (nopen.eq.1)
            call CancelSelection(hwnd)
            call temporary_yield@()
            call sleep1@(time)
            call temporary_yield@()
         enddo
      else
c
c pause if required then write out the line
c        
         if (nopen.eq.1) then
            call CancelSelection(hwnd)
            inquire (unit = nout, opened = op, iostat = ios)
            if (ios.eq.0 .and. op) then
               nopen = 1
               write (nout,'(a)') line
               if (nlines.lt.nmax) then
                  nlines = nlines + 1
                  text(nlines) = line
               endif   
            else
               nopen = 0
            endif
         endif   
      endif
      end
c
c
      recursive integer function i_cancel_list03()
      implicit  none
      integer   ictrl, nopen, nout
      logical   wait
      common  / cancel_list03 / ictrl, nopen, nout
      common  / pause_list03 / wait
      i_cancel_list03 = 0
      wait = .false.
      nopen = 0
      close (unit = nout)
      ictrl = 0
      call window_update@(ictrl)
      end
c
c
      recursive integer function i_copy_list03()
      implicit   none
      integer    nlines
      integer    i, nout
      integer    nmax
      parameter (nmax = 100000)
      character  text(nmax)*129
      character  fname*1024
      logical    askif, there
      external   w_gettmp, w_viewer, w_getnou, w_deleet
      common   / copy_list03 / nlines, text
      i_copy_list03 = 1
      call w_gettmp (i, 
     +               fname)
      call w_getnou (nout)
      open (unit = nout, file = fname)
      do i = 1, nlines
         write (nout,'(a)') text(i)
      enddo
      close (unit = nout)
      i = 1
      call w_viewer (i, fname, ' ', ' ')
      askif = .false.
      call w_deleet (fname,
     +               askif, there)
      end
c
c               
