c
c
      subroutine w_lview1 (ixl, iyl, numdec, numopt, nstart, ntext,
     +                     text_in,
     +                     titles)
c
c action : put out a text plus menu with attributes onto a window
c          this is the main simfit list view selection routine
c          it creates a multicolumn list box based on %lv
c author : w.g.bardsley, university of manchester, u.k.
c          developed from w_lbox01 04/12/2000
c          21/01/2001 suppressed topmost
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     mwtype = 3: normal dialogue window
c                     mwtype = 4: depends on cancel = .true.
c          26/01/2002 increased the space for the control and increased the
c                     default text height/width for windows XP
c          13/02/2002 XP version
c          28/09/2002 improved nwide, nhigh and call back functions
c          18/12/2002 added %sy[toolwindow]
c          10/04/2003 removed %sy[toolwindow] to avoid problems with startp
c          28/04/2004 added user_font option, new calculation for %lv height
c                     and new option [full_row_select]
c          18/11/2006 added intents
c          08/02/2007 edited for w_clearwin.dll 
c          01/06/2007 added allocatable array and w_dbleup
c          23/07/2007 added nbig and autosize_last_column
c          01/12/2007 added tm_lead and tm_space to control pixel dimensions
c          07/04/2016 added lview1_extra
c          31/07/2017 added stop menu with call back function i_stop_this_program
c          25/11/2017 removed stop menu and added closure cross as follows:
C                     No Cancel, Quit, or Exit then exit with numdec = value supplied
c                     If Cancel, Quit, or Exit then exit with numdec = first item with Cancel, Quit, or Exit
c
c     ixl: (input/unchanged) x coordinate of top left hand corner, ignored if =< 0
c     iyl: (input/unchanged) y coordinate of top left hand corner, ignored if =< 0
c  numdec: (input/output) number of the initial decision then output as choice or
c                         with first item number with a Cancel, Quit, or Exit 
c  numopt: (input/unchanged) number of options available
c  nstart: (input/unchanged) number of the line of text where the menu starts
c          text(nstart - 1) MUST be the title line but this is
c          only displayed if titles = .true.
c   ntext: (input/unchanged) number of lines of text (ntext >= numopt + 1)
c text_in: (input/unchanged) text array (header, titles, menus and trailer)
c  titles: (input/unchanged).true. then use text(nstart - 1) as column headers
c                           .false. use text(nstart - 1) just to set column headers
c
c          text size is set by the parameters size_roman
c          menu size is set by size_msss
c          width of the control is set by the parameter wide
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      integer,             intent (in)    :: ixl, iyl, numopt, nstart,
     +                                       ntext
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: text_in(ntext)
      logical,             intent (in)    :: titles 
c
c local allocatable array
c          
      character (len = 129), allocatable :: text(:)
c
c locals
c
      integer    ih, iview, iw, ix, iy, nhigh, nwide, number, nxmax,
     +           nymax
      integer    i, ierr, iscale, j, k, l, nbar1, nbar2, n_cancel
      integer    x_len200, x_len300
      integer    ixyuse, ixy_use, mwtype, mw_type, nbig
      parameter (ixy_use = 1, mw_type = 4, nbig = 25)
      integer    nmax
      parameter (nmax = 500)!must be consistent with use by common block 
      integer    n0, n1, n2, n3, n4, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n7 = 7)
      integer    ipick, isel(nmax), nitems_sel, numdec_sel
      integer    i_press_w_lview1, i_select_w_lview1
      integer    nsav
      parameter (nsav = 40)
      integer    numbld(nsav)
      double precision size_msss, size_roman
      double precision size_msss_1, size_roman_1
      parameter (size_msss_1 = 1.0d+00, size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabvar
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      double precision three, four, tm_lead, tm_space
      parameter (three = 3.0d+00, four = 4.0d+00, tm_lead = 1.30d+00,
     +           tm_space = 0.90d+00)
      character  line*129, items(nmax + 1)*100, w_dbleup*129
      character  bar*1, grave*1
      parameter (bar = '|', grave = '`')
      logical    abort, cancel, store
      external   x_len200, x_len300, w_syspar, x_putfat, w_dbleup
      external   i_press_w_lview1, i_select_w_lview1, lview1_extra
      intrinsic  len, dble, index, max, min, nint
      common / w_lview1_variables / ipick, isel, nitems_sel, numdec_sel
c
c check
c      
      if (numopt.gt.nmax) then
         call x_putfat ('NUMOPT too large in call to W_LVIEW1')
         return
      endif    
c
c initialise variables in case a closure cross is necessary
c
      mwtype = mw_type
      ipick = n0
      n_cancel = n0
      numdec_sel = numdec
      cancel = .false.
c
c check the arguments supplied
c
      if (numopt.eq.n1) then
         numdec = n1
         return
      endif
      if (numopt.lt.n1 .or. numopt + n1.gt.ntext .or.
     +    nstart.lt.n2 .or. nstart + numopt - n1.gt.ntext) then
          call x_putfat (
     +       'nstart/numopt/ntext inconsistent in call to w_lview1')
          return
      endif
      abort = .false.
      nbar1 = n0
      nbar2 = n0
      do i = nstart - n1, nstart + numopt - n1
         if (.not.abort) then
            l = x_len200(text_in(i))
            nbar2 = n0
            do j = n1, l
               if (text_in(i)(j:j).eq.bar) nbar2 = nbar2 + n1
            enddo
            if (nbar2.lt.n1) abort = .true.
            if (.not.abort .and. i.ge.nstart) then
               if (nbar2.ne.nbar1) abort = .true.
            endif
            nbar1 = nbar2
         endif
      enddo
      if (abort) then
         call x_putfat (
     +      'Inconsistent no. of column separators in call to w_lview1')
         return
      endif
      if (numdec.lt.n1) numdec = n1
      if (numdec.gt.numopt) numdec = numopt
c
c allocate
c         
       ierr = n0
       if (allocated(text)) deallocate (text, stat = ierr)
       if (ierr.ne.0) return
       allocate(text(ntext), stat = ierr)
       if (ierr.ne.n0) return  
       j = nstart + numopt - n1
       if (titles) then
          k = nstart - 1
       else
          k = nstart
       endif      
       do i = n1, ntext  
          if (i.lt.k .or. i.gt.j) then
             text(i) = w_dbleup(text_in(i))
          else
             text(i) = text_in(i)     
          endif   
       enddo
c
c position
c         
       if (numopt.le.nbig .or. ixl.le.n0 .or. iyl.le.n0) then
          ixyuse = n2
       else
          ixyuse = ixy_use
       endif      
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
      if (ixyuse.eq.n1) then
c
c use ixl, iyl and parameter iscale to position the window
c
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c swap the next lines for a normal window instead of a dialogue window
c ====================================================================
c
      if (mwtype.eq.n1) then
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost, independent]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost, independent]&')
         endif
      elseif (mwtype.eq.n2) then
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, no_sysmenu, 3d_thin]&')
         else
            k = winio@('%sy[thin_border, no_sysmenu, 3d_thin]&')
         endif
      elseif (mwtype.eq.n3) then
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, 3d_thin]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
         endif
      elseif (mwtype.eq.n4) then
c
c check if 'Cancel' or 'Exit' or 'Quit' or 'Stop' is an item and, if so, make it the default
c
         i = nstart - n1
         do while (i.lt.nstart + numopt - n1 .and. .not.cancel)
            i = i + n1
            if (index(text(i),'Cancel').gt.n0 .or.
     +          index(text(i),'Exit').gt.n0 .or.
     +          index(text(i),'Quit').gt.n0 .or.
     +          index(text(i),'Stop').gt.n0 .or.
     +          index(text(i),'Abandonar').gt.n0 .or.
     +          index(text(i),'Salir').gt.n0) then
               cancel = .true.
               n_cancel = i - nstart + n1
            endif
         enddo
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, 3d_thin]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
         endif
      endif   
      k = winio@('%ca[Simfit: options]&')
c
c put out the text strings up to the menu minus header
c
      if (nstart.gt.n2) then
         store = .false.
         call lview1_extra (nsav, numbld,
     +                     store)        
         k = winio@('%`sf&')
         k = winio@('%ts&', size_roman)
         do i = n1, nstart - n2
            k = winio@('%sf%tc[black]&')
            if (numbld(i).ne.0) then 
               if (i.eq.1) then
                  k = winio@('%bf&')
               elseif (numbld(i).eq.1) then
                  k = winio@('%tc[blue]&')
               else
                  k = winio@('%tc[red]&')
               endif
            endif      
            j = index (text(i), grave)
            if (j.ge.n1) then
               l = x_len200(text(i))
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = '%ta'//text(i)(j + n1:l)//'&'
               k = winio@(line(n1:l - j + n4))
            else
               line = text(i)(n1:x_len200(text(i)))//'&'
               k = winio@(line)
            endif
            k = winio@('%nl&')
         enddo
         do i = 1, nsav
            numbld(i) = 0
         enddo
         store = .true.
         call lview1_extra (nsav, numbld,
     +                     store)       
      endif
c
c get the header and items
c
      do i = n1, numopt + n1
         items(i) = text(nstart + i - n2)(1:100)
      enddo
c
c make copies of numdec and numopt then initialise the selection
c
      nitems_sel = min(numopt, nmax)
      numdec_sel = min(numdec, nitems_sel)
      do i = n1, nitems_sel
         isel(i) = n0
      enddo
      isel(numdec_sel) = n1
      iview = n1
c
c get the screen dimensions and set upper limits for the dimensions
c
      call w_syspar (ix, 'x')
      nxmax = nint(three*dble(ix)/four)
      call w_syspar (iy, 'y')
      nymax = nint(three*dble(iy)/four)
c
c calculate nhigh using the font height but extra lines for scroll bars
c
      k = winio@('%`sf%ts&', size_msss)
      call w_syspar (ih, 'h')
      if (titles) then
         number = nitems_sel + n1
      else
         number = nitems_sel 
      endif
      if (ix.ge.639 .and. ix.le.641) then
         nhigh = 18 + 14*(number + n1)
      else
c
c allow extra space between lines
c
        ih = nint(correction*tm_lead*dble(ih))
        nhigh = ih*number
      endif
      if (nhigh.gt.nymax) nhigh = nymax
c
c calculate nwide, first the no. of characters
c
      number = n0
      do i = n1, ntext
         j = x_len300(text(i))
         if (j.gt.number) number = j
      enddo
c
c now scale up by the character width and check if within limits
c
      call w_syspar (iw, 'w')
      iw = nint(correction*tm_space*dble(iw))
      nwide = iw*number
      if (nwide.gt.nxmax) nwide = nxmax
c
c place the control centrally
c Note: the two categories below are for the no_scroll option if it is implemented
c
      i = winio@('%cn&')
      if (numopt.le.nbig) then
         if (titles) then
            i = winio@('%^lv[single_selection, show_selection_always,
     +                 no_border, user_font, full_row_select,
     +                 autosize_last_column]&',
     +                 nwide, nhigh, items, nitems_sel + 1, isel, iview,
     +                 i_select_w_lview1)
         else
            i = winio@('%^lv[single_selection, show_selection_always,
     +                 no_border, no_column_headers, user_font,
     +                 full_row_select,
     +                 autosize_last_column]&',
     +                 nwide, nhigh, items, nitems_sel + 1, isel, iview,
     +                 i_select_w_lview1)
         endif
      else
         if (titles) then
            i = winio@('%^lv[single_selection, show_selection_always,
     +                 no_border, user_font, full_row_select,
     +                 autosize_last_column]&',
     +                 nwide, nhigh, items, nitems_sel + 1, isel, iview,
     +                 i_select_w_lview1)
         else
            i = winio@('%^lv[single_selection, show_selection_always,
     +                 no_border, no_column_headers, user_font,
     +                 full_row_select,
     +                 autosize_last_column]&',
     +                 nwide, nhigh, items, nitems_sel + 1, isel, iview,
     +                 i_select_w_lview1)
         endif
      endif
c
c put out the text strings after the end of the menu
c
      if (ntext.gt.nstart + numopt - n1) then
         k = winio@('%ff&')
         k = winio@('%`sf&')
         k = winio@('%ts&', size_roman)
         do i = nstart + numopt, ntext
c
c does the line contain a tabbing character ` grave accent
c
            j = index(text(i), grave)
            if (j.ge.n1) then
               l = x_len200(text(i))
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = '%ta'//text(i)(j + n1:l)//'%nl&'
               k = winio@(line(n1:l - j + n7))
            else
               line = text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line)
            endif
         enddo
         k = winio@(' & ')
      endif
c
c close by button press
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%^`tt[&OK]&', i_press_w_lview1)
      k = winio@('%nl &')
      k = winio@('%cb')
c
c assign and check numdec depending on cancel
c
      if (cancel) then
         if (ipick.eq.n0) then
c
c window has been closed by closure cross so set numdec = n_cancel
c
            numdec = n_cancel
         else
c
c window has been closed by double click or button press
c
            numdec = numdec_sel
         endif
      else
c
c normal closure by button press or double click
c
         numdec = numdec_sel
      endif
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt    
c
c deallocate
c           
      deallocate (text, stat = ierr)
      end
c
c -------------------------------------------------------------------
c call back function for list view control
c -------------------------------------------------------------------
c
      integer function i_select_w_lview1()
c
c call back required for %lv
c
      implicit   none
      include <windows.ins>
      integer    nmax
      parameter (nmax = 500)
      integer    i
      integer    ipick, isel(nmax), nitems_sel, numdec_sel
      character (len = 256) line 
      character (len = 256) clearwin_string@!added  by w.g.b. 13/01/2020 
      common / w_lview1_variables / ipick, isel, nitems_sel, numdec_sel
      
      
      i_select_w_lview1 = 2
      ipick = 0

      call temporary_yield@
      line = clearwin_string@('CALL_BACK_REASON')
      call temporary_yield@

      if (line.eq.'MOUSE_DOUBLE_CLICK') THEN
         ipick = 1
         do i = 1, nitems_sel
            if (isel(i).eq.1) then
               numdec_sel = i
               i_select_w_lview1 = 0
               return
            endif
         enddo
      endif
      end
c
c
c -------------------------------------------------------------------
c call back function for button press
c -------------------------------------------------------------------
c
      integer function i_press_w_lview1()
c
c call back required for button press
c
      implicit   none
      integer    nmax
      parameter (nmax = 500)
      integer    i, ipick, isel(nmax), nitems_sel, numdec_sel
      common / w_lview1_variables / ipick, isel, nitems_sel, numdec_sel
      ipick = 0
      i_press_w_lview1 = 2
      do i = 1, nitems_sel
         if (isel(i).eq.1) then
            numdec_sel = i
            i_press_w_lview1 = 0
            ipick = 2
            return
         endif
      enddo
      end
c
c
      subroutine lview1_extra (n, numbld,
     +                         store)
      implicit none
c
c arguments
c      
      integer, intent (in)    :: n
      integer, intent (inout) :: numbld(n)
      logical, intent (in)    :: store
c
c locals
c      
      integer    i, ntemp
      integer    nsav
      parameter (nsav = 40)
      integer    numbld_sav(nsav)
      save       numbld_sav
      data       numbld_sav / nsav*0 /
      intrinsic  min
      ntemp = min(n,nsav)
      if (store) then
         do i = 1, ntemp
            numbld_sav(i) = numbld(i)
         enddo
      else
         do i = 1, ntemp
            numbld(i) = numbld_sav(i)
         enddo
      endif  
      end            
c
c      


c.........................................................................
c
c Salford documentation for %lv
c =============================
c
c209)   A new format, %lv, has been supplied to provide LISTVIEW controls.
c
c       winio@('%lv[options]',width,height,items,num_items,sel,view)
c       winio@('%`lv[options]',width,height,items,num_items,sel,view,icon_str)
c       character*(*) items(num_items+1)  (input/output)
c       integer num_items                 (input parameter)
c       integer sel(num_items)            (input/output)
c       integer width,height,view         (input)
c       character*(*) icon_str            (input)
c
c       Modifiers Grave accent (`)   Used to provide a list of icons.
c                 Caret (^)          A call-back function is provided.
c                 Question mark (?)  A help string is supplied.
c
c       DESCRIPTION
c       -----------
c       A list view control is a window that displays a collection of items, each
c       item consisting of an optional icon and a label. List view controls provide
c       several ways of arranging items and displaying individual items.  For example,
c       additional information about each item can be displayed in columns to the
c       right of the icon and label. This arrangement is called a report view.
c       Microsoft Explorer uses a list view control in order to display directory
c       information.
c
c       width and height provide the dimensions of the control in pixels.
c       num_items is an integer constant giving the number of rows in the report view.
c
c       Blank rows are not displayed in the control.
c       This means that the number of rows that are displayed can be changed under
c       program control.
c
c       items is an array of num_items+1 character strings the first describing the
c       column headers and widths, then one string describing each row in turn (see
c       the example below).
c
c       sel is an integer array whose elements are set to 1 if the item is selected
c       otherwise to zero.
c
c       view is an integer variable in the range 0..3 that represents the type of
c       view.  0=Icon view; 1=Report view; 2=Small icon view; 3=List view.  These
c       are available even when no icons are provided.
c
c       If a grave accent is provided, icon_str is a character string giving a list
c       of icon resources in the form 'icon1,icon2'.
c
c       %lv can take a pivot (%pv). Also the right mouse button can be used to trigger
c       a popup menu (%pm) defined in the parent window.
c
c       EXAMPLE
c       -------
c       CHARACTER*80 items(4)
c       INTEGER sel(3),view
c       items(1)='|Header_100|_50'
c       items(2)='|AItem1|Data1'
c       items(3)='|BItem2|Data2'
c       items(4)='|BItem3|Data3'
c       sel(1)=1;sel(2)=0;sel(3)=0;view=1
c       i=winio@('%`lv',300,200,items,3,sel,view,'icon1,icon2')
c
c       Here we have 3 rows with 2 columns. items(1) provides data for the column
c       headings and widths.  The first character defines the separator between the
c       data for each column.  In this example, the first column has the caption
c       "Header".
c       A trailing underscore followed by an integer provides the pixel width of the
c       column.  If this is ommitted then the length of the text defines the width.
c       In this example the second column header is blank and the second column width
c       is 50 pixels.  The number of characters (80 in this case) must be sufficient
c       to allow ClearWin+ to add the column width to each heading (4 characters per
c       column).
c
c       items(2) provides data for the first row of a report.  Again the first
c       character defines the separator.  The second character defines the icon as
c       an index (A,B,C...) into the list of icons 'icon1,icon2' (when a grave accent
c       is used).  Next comes the label and then the data for column two etc..
c
c       OPTIONS
c       -------
c       single_selection       Allows only one item at a time to be selected.
c                              By default Shift and Control keys can generate multiple selections.
c       edit_labels            Allows item text to be edited (first column in report view).
c       no_column_headers      Column headers are not displayed in report view
c                              (items(1) is still needed for column widths)
c       show_selection_always  Always show the selection, if any, even if the control does not
c                              have the focus.
c       no_border              Displays the control without a border.
c       no_label_wrap          Displays the item label on a single line in an icon view.
c       align_top              Items are top-aligned  in icon and small icon view.
c       align_left             Items are left-aligned in icon and small icon view.
c   edit_cells             Allows all columns in the report view to be edited (see below).
c
c       LABEL EDITING
c       -------------
c       edit_labels enables label editing and requires a call-back function that can test for
c       the call-back reasons 'BEGIN_EDIT', 'END_EDIT' and 'EDIT_KEY_DOWN'.
c       With BEGIN_EDIT you can get the index of the selected item by the call
c       clearwin_info@('ROW_NUMBER').  If the call-back function returns the value 4 then
c       editing of this item is prevented.
c
c   With EDIT_KEY_DOWN you can validate each character as it is typed.
c   Use clearwin_info@('KEYBOARD_KEY') to get the key and/or clearwin_string@('EDITED_TEXT')
c   to get the resulting string with the character inserted. If the call-back function
c   returns the value 4 then the character is not accepted. If you want to translate
c   the input key to another key then the call-back function must return the ASCII
c   character code (31<code<256) of the translated key.
c
c       With END_EDIT you can get the result of the edit by the call
c       clearwin_string@('EDITED_TEXT').  Having validated the label, you should then get the
c       index using clearwin_info@('ROW_NUMBER') and reconstuct the relevant row of the items
c       array by adding an icon identifier and extra column data as required (otherwise the
c       original data will be restored).  Creating a blank row in response to a label edit is
c       not recommended.
c
c       SELECTING A VIEW
c       ----------------
c       It is possible to create a menu item or a toolbar button that changes the view state
c       (Icon view, Report view, Small icon view, List view).  Here is some sample code for
c       the associated call-back function.
c
c       INTEGER FUNCTION change_view()
c         INTEGER view
c         COMMON view
c         view=view-1
c         IF(view < 0) view=3
c         CALL window_update@(view)
c         change_view=2
c       END
c
c       COLUMN WIDTHS
c       -------------
c       If the last column does not extend to the right of the control then ClearWin+ will
c       adjust the width of this column so that it fills the area.
c
c       If a column width is changed at run time then ClearWin+ stores the new width in row 1
c       of the data.  This means that the adjusted widths will be used when the control is
c       redrawn.  If you want to use the same widths when the program is re-used then you will
c       need to save and restore the modified data.
c
c       CELL EDITING
c   ------------
c       The option edit_cells is effective in a report view where it over-rides
c       edit_labels. By using edit_cells you can edit the data in any column. The
c       call-back function can be used to prevent the editing of any given cell
c       and to validate each input character and as well as the final result.
c       For this purpose edit_cells uses the call-back reasons BEGIN_EDIT,
c       EDIT_KEY_DOWN and END_EDIT etc. as in edit_labels. The only difference
c       is that unlike edit_lables, edit_cells initially responds to a single mouse click.
c       clearwin_info@('ROW_NUMBER') and clearwin_info@('COLUMN_NUMBER') identify
c       the cell that is being edited.
c
c       When editing cells, use the arrow keys to move vertically and CTRL with arrow
c       keys to move horizontally. This movement will step over any cells that are disabled.
c       The selection array (with one element for each row) contains the row number of
c       the current selection. However, when validating input it is simpler to use
c       clearwin_info@('COLUMN_NUMBER').
c
c       CALL-BACK REASONS
c       -----------------
c       BEGIN_EDIT              A label or cell is about to be edited (see above).
c       END_EDIT                A label or cell has been edited (see above).
c       SET_SELECTION           A item has been selected.
c                               clearwin_info@('ROW_NUMBER') provides the index.
c       COLUMN_CLICK            The user has clicked on a column header.
c                               clearwin_info@('COLUMN_NUMBER') provides the index.
c       MOUSE_DOUBLE_CLICK      The user has double-clicked using the left mouse button.
c                               clearwin_info@('ROW_NUMBER') provides the index.
c       KEY_DOWN                The user has pressed a keyboard key.
c                               clearwin_info@('KEYBOARD_KEY') provides the key code.
c       EDIT_KEY_DOWN           The user has pressed a keyboard key during a label or cell
c                           edit. clearwin_info@('KEYBOARD_KEY') provides the key code
c  (see above).
c
c       In reponse to a column click you might choose to sort the items using the given
c       column index.  Having reconstructed the data, you should then make a call to
c       window_update@(items) in order to view the new order.
c
c       NOTES FOR PROGRAMS WRITTEN IN C/C++:
c       ------------------------------------
c       a. num_items is not included in the list of arguments for %lv.
c       b. items should be an array of pointers to strings created using strdup.

C
C
