c
c
      subroutine w_mfiles (nfiles, nmax, 
     +                     files)
c
c action: return nfiles files by multiple file selection
c author: w.g.bardsley, university of manchester, u.k., 15/02/2001
c         04/02/2007 edited for w_clearwin.dll
c         26/06/2010 added call to x_infofl
c         22/12/2018 increased NFILT1 to 11 and NFILT3 to 16
c         17/01/2019 increased NFILT1 to 13 and NFILT3 to 18
c         07/02/2019 changed filt3 (len = 80) to filt3(len = 15)
c
c         nfiles set to 0 on entry
c         nfiles set to no. selected files on exit
c
c         This code is dependent on the w_filter.cfg file created by
c         w_ofiles. The definitions of NFILT1, NFILT3, etc. must be
c         consistent. If the structure of w_filter.cfg created by
c         w_ofiles is changed by editing w_ofiles, then this code
c         must be changed accordingly. It presumes that w_filter.cfg
c         looks like this:
c
c         title1
c         path1
c         nfilt1 pairs of type/wildcard (i.e. 2*nfilt1 lines)
c         title3
c         path3
c         nfilt3 pairs of type/wildcard (i.e. 2*nfilt3 lines)
c
c         i.e. making 2*(nfilt1 + nfilt3 + 2) lines in all
c
      implicit   none   
c
c arguments
c      
      integer,             intent (in)    :: nmax  
      integer,             intent (out)   :: nfiles  
      character (len = *), intent (inout) :: files(nmax)
c
c locals
c      
      integer    i, icount, ios, l1, l2, l3, nout
      integer    x_len200
      integer    nfilt1, nfilt3, ntotal
      parameter (nfilt1 = 13, nfilt3 = 18,
     +           ntotal = 2*(nfilt1 + nfilt3 + 2))
      integer    n0, n1, n2, n4, n6
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n6 = 6)
      character  filter*2048, fname*1024, path*1024 
      character  filt3(nfilt3)*15, type3(nfilt3)*45, temp(ntotal)*1024 
      character  x_sim256*1024
      character  blank*1, bslash*1, comma*1, w_filter_cfg*12, letter*1,
     +           w_in_tmp*8
      parameter (blank = ' ', bslash = '\', comma = ',',
     +           w_filter_cfg = 'w_filter.cfg', w_in_tmp = 'w_in.tmp')
      logical    exist, read_only
      external   w_getnou, x_len200, x_attrib, x_addstr, x_sim256,
     +           x_infofl
      external   w_mfile1
      intrinsic  char
      data path   / 'C:\Program Files\Simfit' /
      data type3  / 'All files',
     +              'Data files',
     +              'Vector files',
     +              'Matrix files',
     +              'Statistics files',
     +              'Curve fit files',
     +              'PostScript files',
     +              'EPS files',
     +              'SVG files',
     +              'Results files',
     +              'Temporary files',
     +              'SIMFIT test files',
     +              'SIMFIT library files',
     +              'Type 1 files',
     +              'Type 2 files',
     +              'Type 3 files',
     +              'TEX files', 
     +              'Metafiles' /
      data filt3 / '*.*',   '*.*', '*.*', '*.*', '*.*',
     +             '*.*', '*.ps',  '*.eps', '*.svg', '*.res', '*.tmp',
     +             '*.tf?', '*.tfl', '*.001', '*.002', '*.003', '*.tex', 
     +             '*.*' /
c
c Does w_filter.cfg exist
c                                            
      fname = x_sim256(w_filter_cfg)
      call x_attrib (fname,
     +               exist, read_only)
      if (exist) then
         if (read_only) call x_infofl (n6,
     +                                 fname)           
c
c If so then read the details
c
         call w_getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         icount = n1
         do while (ios.eq.0 .and. icount.le.ntotal)
            read (nout,'(a)',iostat=ios) temp(icount)
            icount = icount + n1
         enddo
         close (unit = nout)
         if (ios.eq.n0 .and. icount.ge.ntotal) then
c
c Define the path, types and wildcards
c
            icount = n2*nfilt1 + n4
            path = temp(icount)
            do i = n1, nfilt3
               icount = icount + n1
               type3(i) = temp(icount)(1:45)
               icount = icount + n1
               filt3(i) = temp(icount)(1:15)
            enddo
         endif
      endif
c
c Build up the filter of types and wildcards separated by null characters
c
      l1 = n1
      do i = n1, nfilt3
         l3 = x_len200(type3(i))
         l2 = l1 + l3 - n1
         filter(l1:l2) = type3(i)(n1:l3)
         l2 = l2 + n1
         filter(l2:l2) = comma
         l2 = l2 + n1
         filter(l2:l2) = blank
         l3 = x_len200(filt3(i))
         l1 = l2 + n1
         l2 = l1 + l3 - n1
         filter(l1:l2) = filt3(i)(n1:l3)
         l1 = l2 + n1
         filter(l1:l1) = char(n0)
         l1 = l1 + n1
         l2 = l1 + l3 - n1
         filter(l1:l2) = filt3(i)(n1:l3)
         l1 = l2 + n1
         filter(l1:l1) = char(n0)
         l1 = l1 + n1
      enddo
      filter(l1:l1) = char(n0)
c
c Set nfiles = 0 then call w_mfile1
c
      nfiles = 0
      call w_mfile1 (nfiles, nmax, 
     +               files, filter, path)
c
c Overwrite the path to opened files if files have been selected
c
      if (exist .and. .not.read_only .and. nfiles.gt.n0) then
         icount = x_len200(files(n1))
         letter = files(n1)(icount:icount)
         do while (icount.gt.n1 .and. letter.ne.bslash)
            icount = icount - n1
            letter = files(n1)(icount:icount)
         enddo
c
c Now set path = path to files(1)
c
         l1 = n2*nfilt1 + n4
         temp(l1) = blank
         temp(l1) = files(n1)(n1:icount - n1)
         call w_getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.0) then
            do i = n1, ntotal
               write (nout,'(a)') temp(i)
            enddo
         endif
         close (unit = nout)
      endif
c
c Add filenames to w_in.tmp
c
      if (nfiles.gt.n0) then 
         fname = x_sim256(w_in_tmp)
         call x_attrib (fname, 
     +                  exist, read_only)
         if (exist .and. .not.read_only) then
            do i = n1, nfiles
               call x_addstr (fname, files(i))
            enddo
         endif
      endif
      end
c
c
c---------------------------------------------------------
c
c
      subroutine w_mfile1 (nfiles, nmax,
     +                     files, filter, path)
c
c action: multiple file selection
c author: w.g.bardsley, university of manchester, u.k., 15/02/2001
c         04/02/2007 edited for w_clearwin.dll 
c         07/03/2015 introduced kind = 7 and increased maxfilename to 1024
c         22/02/2024 resored the c_external version
c
c         nfiles set to 0 on entry
c         nfiles set to number of selected files on exit
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)  :: nmax  
      integer,             intent (out) :: nfiles 
      character (len = *), intent (in)  :: filter, path 
      character (len = *), intent (out) :: files(nmax) 
c
c locals
c      
      integer (kind = 7) hwnd
      integer    maxfilename, n0, n1
      parameter (maxfilename = 1024, n0 = 0, n1 = 1)
      character  caption*31, newfilename*(maxfilename)
      parameter (caption = 'Simfit: multiple file selection')
      logical    l*4, next
      C_EXTERNAL GET_MULTIPLE_FILE_NAMES 'get_multiple_file_names'
     +(VAL,INSTRING,STRING,VAL,INSTRING,INSTRING,VAL):LOGICAL*4
      hwnd = n0
      nfiles = n0
      next = .false.
      l = .true.
      newfilename = '*.*'
      do while (l .and. nfiles.lt.nmax)
        l = get_multiple_file_names(hwnd, caption, newfilename,
     +                              maxfilename, filter, path, next)
        if (l .and. nfiles.lt.nmax) then
           next = .true.
           nfiles  = nfiles + n1
           files(nfiles) = newfilename
         endif
      enddo
      end
c
c
