c
c
      subroutine w_module (isend,
     +                     fname)
c
c action: store fname for re-use as in run5
c author: w.g.bardsley, university of manchester, u.k., 23/11/98
c         21/01/2001 edited defaults and removed do while/endwhile 
c         13/02/2002 XP version
c         04/02/2007 edited for w_clearwin.dll
c         12/12/2007 added scale0 and scale1 to scale font size
c         06/11/2008 rename w_simfit.use as w_module.cfg 
c
c         opens 'w_module.cfg' to store/retrieve filenames
c
c         isend = 0: check boxes to select on types
c                    fname = selected file on return
c         isend = 1: double edit box for types and executables
c                    fname = previously selected filename
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: isend 
      character (len = *), intent (inout) :: fname
c
c locals
c      
      integer    i, ios, j, nout, nsav, ntemp
      integer    nmax, n6
      parameter (nmax = 12, n6 = 6)
      integer    isav(nmax + 1)
      double precision scale0, scale1, size1
      parameter (scale0 = 1.0d+00, scale1 = 0.95d+00)
      character  types(nmax)*80, names(nmax)*1024
      character  type1(nmax)*80, name1(nmax)*1024
      character  line*80, fname1*1024, x_sim256*1024
      character  blank*1
      parameter (blank = ' ')
      logical    first, op, there, read_only
      external   w_syspar, w_getnou, x_sim256, x_infofl, x_attrib
      intrinsic  dble
      save       first, isav, nsav
      data       first / .true. /
c
c check
c      
      if (isend.lt.0 .or. isend.gt.1) return
      fname1 = x_sim256('w_module.cfg')
      call x_attrib (fname1,
     +               there, read_only)
      if (there .and. read_only) then
         call x_infofl (n6,
     +                  fname1)
         return
      endif                
c
c Initialise and scale the font sizes
c
  
      call use_windows95_font@()
      call w_syspar (i, 'f')
      if (isend.eq.0) then
         size1 = scale0*dble(i)/100.0d+00
      else 
         size1 = scale1*dble(i)/100.0d+00  
      endif   
c
c Set up the defaults first time round
c
      if (first) then
         first = .false.
         types(1) = 'Enzyme kinetics'
         types(2) = 'Ligand binding'
         types(3) = 'Growth/Survival'
         types(4) = 'Statistics'
         types(5) = 'Calibration'
         types(6) = 'Regression/GLIM'
         types(7) = 'Numerical Analysis'
         types(8) = 'Time series'
         types(9) = 'Pharmacokinetics'
         types(10) = 'Clinical trials'
         types(11) = 'Immunology'
         types(12) = 'Genetics'
         names(1) = 'C:\Program Files\Simfit\bin\module1.exe'
         names(2) = 'C:\Program Files\Simfit\bin\module2.exe'
         names(3) = 'C:\Program Files\Simfit\bin\module3.exe'
         names(4) = 'C:\Program Files\Simfit\bin\module4.exe'
         names(5) = 'C:\Program Files\Simfit\bin\module5.exe'
         names(6) = 'C:\Program Files\Simfit\bin\module6.exe'
         names(7) = 'C:\Program Files\Simfit\bin\module7.exe'
         names(8) = 'C:\Program Files\Simfit\bin\module8.exe'
         names(9) = 'C:\Program Files\Simfit\bin\module9.exe'
         names(10) = 'C:\Program Files\Simfit\bin\module10.exe'
         names(11) = 'C:\Program Files\Simfit\bin\module11.exe'
         names(12) = 'C:\Program files\simfit\module12.exe'
         do i = 1, nmax
            isav(i) = 0
         enddo
         nsav = nmax + 1
         isav(nsav) = 1
      endif
c
c Find an unopened unit
c                
      call w_getnou (nout)
c
c Open the module file and read in type1 and name1
c                                  
      inquire (unit = nout, opened = op, iostat = ios)
      if (ios.eq.0 .and. .not.op) then
         inquire (file = fname1, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            open (unit = nout, file = fname1, iostat = ios)
            if (ios.eq.0) read (nout,'(a)',iostat=ios) line
            ntemp = -1
            if (ios.eq.0) read (nout,*,iostat=ios) ntemp
            if (ntemp.lt.1 .or. ntemp.gt.nmax + 1) ios = -1
            i = 1
            do while (i.le.nmax .and. ios.eq.0)
               read (nout,'(a)',iostat=ios) type1(i)
               read (nout,'(a)',iostat=ios) name1(i)
               i = i + 1
            enddo
            if (i.eq.nmax + 1) then
               nsav = ntemp
               do i = 1, nmax + 1
                  isav(i) = 0
               enddo
               isav(nsav) = 1
               do i = 1, nmax
                  types(i) = type1(i)
                  names(i) = name1(i)
               enddo
            endif
            close (unit = nout)
         endif
      endif
c
c Now the radio box controls
c
      i = winio@('%`sf%ts&', size1)
      i = winio@('%ca[Simfit: modules]&')
      i = winio@('%sy[3d_thin]&')
      if (isend.eq.0) then
         do i = 1, nmax
            j = winio@('%`rb@&', types(i), isav(i))
            j = winio@('%nl&')
         enddo
         j = winio@('%`rb[Cancel]&', isav(nmax + 1))
         j = winio@('%13`ga&',  isav(1),   isav(2),  isav(3),  isav(4),
     +              isav(5),  isav(6),   isav(7),  isav(8),  isav(9),
     +              isav(10), isav(11), isav(12), isav(13))
      elseif (isend.eq.1) then
         i = winio@('%ob[named_l][Subjects]&')
         do i = 1, nmax
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%20rs&', types(i))
            j = winio@('%nl&')
         enddo
         i = winio@('%cb&')
         i = winio@('%ob[named_r][Programs]&')
         do i = 1, nmax
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%50rs&', names(i))
            j = winio@('%nl&')
         enddo
         i = winio@('%cb&')
      endif

      j = winio@('%`sf%ts&', size1)
      j = winio@('%ff%nl%cn%^tt[OK]', 'EXIT')
c
c Find out which check box has been selected
c
      if (isav(nmax + 1).eq.1) then
         nsav = nmax + 1
         fname = blank
      else
         i = 0
         nsav = 0
         do while(i.lt.nmax .and. nsav.eq.0)
            i = i + 1
            if (isav(i).eq.1) then
               nsav = i
               fname = names(nsav)
            endif
         enddo
      endif
c
c Create a new 'w_module.cfg' file
c
      if (nout.ge.11 .and. nout.le.100) then
         open (unit = nout, file = fname1, iostat = ios)
         if (ios.eq.0) write (nout,'(a)',iostat=ios)
     +'SIMFIT module function/name file %  1'
         if (ios.eq.0) write (nout,'(i3)',iostat=ios) nsav
         do i = 1, nmax
            if (ios.eq.0) write (nout,'(a)',iostat=ios) types(i)
            if (ios.eq.0) write (nout,'(a)',iostat=ios) names(i)
         enddo
         if (ios.eq.0) write (nout,'(a)',iostat=ios)
     +'line 1 = title, line 2 = name selected, then function/name pairs'
         close (unit = nout, iostat = ios)
      endif
      end
c
c
