c
c
      subroutine w_nbytes (nbytes, 
     +                     buffer, fname) 
c
c action: return nbytes in buffer from fname
c author: w.g.bardsley, university of manchester, u.k., 23/04/2008
c
      implicit none
c
c arguments
c          
      integer,             intent (out) :: nbytes
      character (len = *), intent (in)  :: fname 
      character (len = *), intent (out) :: buffer 
c
c locals
c       
      integer    nstart, nstop
      integer*2  error_code, handle     
      character  data*10000000
      character  blank*1
      parameter (blank = ' ')
      logical    there
      error_code = selected_int_kind(2)
      handle = selected_int_kind(2)
c
c initialise
c      
      nbytes = 0
      buffer = blank
      inquire (file = fname, exist = there)
      
      if (there) then
c
c how big is the file
c        
         call file_size@(fname, nbytes, error_code)
         if (error_code.ne.0 .or. nbytes.le.0) then
            nbytes = 0
            return
         endif   
c
c ok so try to open it
c           
         call openrw@(fname, handle, error_code)
         if (error_code.ne.0) then
            nbytes = 0
            return  
         endif   
c 
c ok so read successive lines
c      
         nstart = 1
         nstop = 0
         do while (error_code.eq.0 .and. nbytes.ge.0)
            call readfa@(data, handle, nbytes, error_code)
            if (error_code.eq.0 .and. nbytes.gt.0) then
               nstop = nstop + nbytes
               buffer(nstart:nstop) = data(1:nbytes)
               nstart = nstop + 1
            endif         
         enddo           
c
c close the file
c
         call closef@(handle, error_code)         
         if (error_code.ne.0) then
            nbytes = 0
            return
         endif   
      else
         return
      endif
c
c define nbytes for return
c      
      nbytes = nstop
      end
c
c           