c
c
      subroutine w_nlines (icolor, ixl, iyl, nchar, numbld, numlin, 
     +                     numtxt,
     +                     lines, text_in,
     +                     fixed, stack)
c
c action : put out a patch of text with attributes onto a window
c          then return with character strings
c          nchar sets the width of the read box
c author : w.g.bardsley, university of manchester, u.k.
c          10/04/2009 derived from w_linein
c          25/10/2010 removed grave default from %tt and %bt 
c          05/08/2017 added call to add_stop_option and deleted allocates
c
c          icolor    background   text     highlight-text
c          ======    ==========   ====     ==============
c          9 or 15   white        black    red
c          o/w       grey         black    blue
c
c          numbld(i)  font (Courier is used if fixed = .true.)
c          =========  ====
c          0, 1       Times
c          2, 3       Times Italic
c          4, 5       Times Bold
c          6, 7       Times Bold Italic
c
c          text size is set by the size parameters
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: icolor, ixl, iyl, nchar,
     +                                       numlin, numtxt
      integer,             intent (in)    :: numbld(*) 
      character (len = *), intent (in)    :: text_in(*)
      character (len = *), intent (inout) :: lines(numlin)
      logical,             intent (in)    :: fixed, stack 
c
c locals
c      
      integer    i, j, k, l  
      integer    x_len200
      integer    ixyuse, mwtype  
      integer    ixy_use, mw_type
      parameter (ixy_use = 2, mw_type = 2)
      integer    iscale, n1, n2, nmax
      parameter (n1 = 1, n2 = 2, nmax = 25)
      double precision size1, size_courier, size_roman
      double precision size_courier_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00) 
      character (len = 129) text(nmax), line1, w_dbleup
      character (len = 3  ) space
      character (len = 1  ) blank
      parameter (blank = ' ', space = '   ') 
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200
      external   w_syspar, w_dbleup
      external   add_stop_option
      intrinsic  dble, index  
c
c check numtxt, allocate workspace, then copy text_in into text
c     
      if (numlin.lt.1) return
      if (numtxt.gt.0) then  
         do i = 1, numtxt
            text(i) = w_dbleup(text_in(i))
         enddo       
      endif   
c
c window type: recommend, ixyuse = 2 (ignore ixl and iyl and toolwindow)
c                         mwtype = 2 (dialogue window with no closure cross)
c            
      if (ixl.le.0 .or. iyl.le.0) then
         ixyuse = 2
      else   
         ixyuse = ixy_use
      endif   
      mwtype = mw_type  
c
c set the font type
c                  
      roman = roman_1
c
c Scale the font sizes
c                  
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent  
      size_courier = correction*size_courier_1 
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
     
     
c
c swap the next code to use ixl, iyl and parameter iscale to position the window
c ==============================================================================
c 
      if (ixyuse.eq.1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif
    

c
c swap the next code to use a normal window rather than a dialogue window
c =======================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[no_sysmenu]&')
      endif
      i = winio@('%ca[Simfit: data required]&')
      if (numtxt.gt.1 .or. numlin.gt.1) call add_stop_option (n1)
c
c now set the background colour depending on icolor
c
      if (icolor.eq.9 .or. icolor.eq.15) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg[grey]&')
      endif

      if (numtxt.gt.0) then
         do i = n1, numtxt
c
c now set the text font depending on numbld(i) and fixed
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                  k = winio@('%fn[Courier New]%bf%it&')
               endif 
c
c and set the text color depending on numbld(i) and icolor
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  if (icolor.eq.9 .or. icolor.eq.15) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif            
               line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl%sf&'
               k = winio@(line1, size_courier)
            else 
               if (roman) then
                  if (numbld(i).le.1) then
                     k = winio@('%fn[Times New Roman]&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%fn[Times New Roman]%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%fn[Times New Roman]%bf&')
                  else
                     k = winio@('%fn[Times New Roman]%bf%it&')
                  endif
               else       
                  if (i.eq.1 .and.numbld(1).ne.0) then 
                     k = winio@('%`sf%bf&')
                  elseif (numbld(i).le.1) then
                     k = winio@('%`sf&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%`sf%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%`sf%bf&')
                  else
                     k = winio@('%`sf%bf%it&')
                  endif
               endif 
c
c and set the text color depending on numbld(i) and icolor
c                  
               if (.not.roman .and. i.eq.1 .and. numbld(1).ne.0) then 
                   k = winio@('%tc[black]&')
               elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  if (icolor.eq.9 .or. icolor.eq.15) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif                 
               j = index(text(i), '`')
               if (j.lt.n1) then
                 line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl%sf&'  
                  k = winio@(line1, size_roman)
               else
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line1 = blank
                  line1 = text(i)(n1:j - n1)//'&'
                  k = winio@(line1(n1:j))
                  line1 = blank
                  line1 = '%ta'//text(i)(j + n1:l)//'%nl&'
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  k = winio@(line1(n1:l - j + 7))
                  k = winio@('%sf&')
               endif
            endif
         enddo
      endif
c
c text display is finished so end with request for new lines
c but first set the scale if nchar is large to reduce font size
c
      size1 = size_courier
      k = winio@('%`sf%tc[black]%ts&', size1)
      if (numtxt.gt.0) k = winio@('%nl   &')
      if (stack .or. nchar*numlin.gt.80) then
         do i = n1, numlin
            k = winio@('%ff&')
            k = winio@('%`bg[white]&')
            if (nchar.le.12) then
               k = winio@('%10rs&', lines(i))
            elseif (nchar.le.20) then
               k = winio@('%15rs&', lines(i))
            elseif (nchar.le.30) then
               k = winio@('%20rs&', lines(i))
            elseif (nchar.le.45) then
               k = winio@('%30rs&', lines(i))
            elseif (nchar.le.130) then
               k = winio@('%45rs&', lines(i))
            else
               k = winio@('%60rs&', lines(i))
            endif
         enddo
         k = winio@('%ff%nl   &')
         k = winio@('%tt[OK]') 
      else
         do i = n1, numlin
            k = winio@('%`bg[white]&')
            if (nchar.le.12) then
               k = winio@('%10rs&', lines(i))
            elseif (nchar.le.20) then
               k = winio@('%15rs&', lines(i))
            elseif (nchar.le.30) then
               k = winio@('%20rs&', lines(i))
            elseif (nchar.le.45) then
               k = winio@('%30rs&', lines(i))
            elseif (nchar.le.130) then
               k = winio@('%45rs&', lines(i))
            else
               k = winio@('%60rs&', lines(i))
            endif
            if (i.eq.numlin) then
               k = winio@('%ff%nl   &')
               k = winio@('%tt[OK]') 
            else
               k = winio@(space//'&') 
            endif     
         enddo
      endif     
      end
c
c
