C
C
      INTEGER FUNCTION W_NUMRGB (ICOLOR)
C
C ACTION : Return rgb colours using rgb@
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/2/99
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
      INTEGER    ICOLOR
      INTEGER    N0, N1, N71, N72, N255
      PARAMETER (N0 = 0, N1 = 1, N71 = 71, N72 = 72, N255 = 255)
      INTEGER    IDEV, IVAL, NCOL, NFONT
      INTEGER    I, JCOLOR, NCOLOR(N0:N71)
      INTEGER    IRED, IGREEN, IBLUE
      DOUBLE PRECISION RED(N72), GREEN(N72), BLUE(N72)
      DOUBLE PRECISION THICK, SIZES, XINCH(N0:N1), YINCH(N0:N1),
     +                 ZSCALE(N0:N1)
      DOUBLE PRECISION F255
      PARAMETER (F255 = 255.0D+00)
      LOGICAL    FIRST
      EXTERNAL   X_WPSCFG
      INTRINSIC  NINT
      SAVE       FIRST, JCOLOR, NCOLOR
      DATA       FIRST / .TRUE. /
C
C First time or negative ICOLOR ... try to read the PostScript palette
C
      IF (FIRST .OR. ICOLOR.LT.N0) THEN
         FIRST = .FALSE.
         CALL X_WPSCFG (N0, N72,
     +                  IDEV, IVAL, THICK, SIZES, XINCH, YINCH, ZSCALE,
     +                  NFONT, NCOL, RED, GREEN, BLUE)
         DO I = N0, N71
            IRED = NINT(F255*RED(I + N1))
            IGREEN = NINT(F255*GREEN(I + N1))
            IBLUE = NINT(F255*BLUE(I + N1))
            IF (IRED.LT.N0) IRED = N0
            IF (IGREEN.LT.N0) IGREEN = N0
            IF (IBLUE.LT.N0) IBLUE = N0
            IF (IRED.GT.N255) IRED = N255
            IF (IGREEN.GT.N255) IGREEN = N255
            IF (IBLUE.GT.N255) IBLUE = N255
            NCOLOR(I) = rgb@(IRED, IGREEN, IBLUE)
         ENDDO
      ENDIF
C
C Make sure ICOLOR is in range
C
      IF (ICOLOR.LT.N0 .OR. ICOLOR.GT.N71) THEN
         JCOLOR = N0
      ELSE
         JCOLOR = ICOLOR
      ENDIF
C
C Assign a colour, i.e. value to NUMRGB$
C
      W_NUMRGB = NCOLOR(JCOLOR)
      END
C
C
