c
c w_ofiles ... extra routines set 1: the main windows menu and call backs
c ==================================
c
c w_ofile1             main window
c
c i_press_ofiles_1     main call back functions 1 to 15
c i_press_ofiles_2
c i_press_ofiles_3
c i_press_ofiles_4
c i_press_ofiles_5
c i_press_ofiles_6
c i_press_ofiles_7
c i_press_ofiles_8
c i_press_ofiles_9
c i_press_ofiles_10
c i_press_ofiles_11
c i_press_ofiles_12 new version 11/01/2005
c i_press_ofiles_13 ** suppressed 26/01/2002/restored 20/03/2002
c i_press_ofiles_14
c i_press_ofiles_15
c
c i_run_ofile1     two run routines ** suppressed 26/01/2002/restored 20/03/2002
c i_run_ofile2                      ** suppressed 26/01/2002/restored 20/03/2002
c
c i_view_ofiles_1  now just four view routines at 11/01/2005
c i_view_ofiles_2
c i_view_ofiles_3
c i_view_ofiles_4
c
c i_press_select   now three demonstration routines at 26/02/2005
c i_view_select
c i_nag_demo
c
c
      subroutine w_ofile1 (nfsav, numdec,
     +                     fname, fsav1, fsav3, cipher)
c
c action : open/save control for ofiles
c author: w.g.bardsley, university of manchester, u.k., 05/02/98
c         08/08/1998 extensively revised to add list box selection
c         26/08/1998 re-organised control to simplify list box selection
c         11/09/1998 increased nfiles to 50 (was 30)
c         28/09/1998 revised, added Swap Type button and set numdec = 5 unless
c                    1,2,3 or 4 selected to get cancel when closed by pressing
c                    the closure cross
c         16/10/1998 added w_clpbrd
c         01/02/1999 added menu
c         18/09/1999 added test file options and simplified the control
c         22/10/1999 added call to f$simfit.tmp to get current main program name
c                  this only works correctly with up to date versions of
c                  w_window and help
c         25/10/99 added the viewing routines
c         01/12/99 rearranged the control and added curdir@
c         10/02/2000 further rearangement, removed curdir@ and increased
c                    nfiles to 100
c         02/05/2001 added default to prevent a blank edit box
c         27/11/2000 renamed variables: size to fsize, open to open1 and
c                    program to progrm and suppressed a dummy continue
c                    statement to silence ftn95
c         26/01/2002 suppressed calls to w_help.exe which caused problems
c                    in windows XP, i.e i_press_ofiles_12, i_press_ofiles_13,
c                    i_run_ofile_1 and i_run_ofile_2, but left the code in
c                    (but commented out) for possible future development
c         13/02/2002 XP version
c         20/03/2002 introduced logical variable viewer as follows:-
c                    viewer = .true. then display w_readme.f4
c                    viewer = .false then call w_help.exe with command lines
c         17/11/2003 replaced start_process@
c         11/01/2005 extensive editing, for instance:
c                    deleted logical variable viewer, and obsolete viewer routines,
c                    simplified menus, and used vutext in [Help] call-back. New
c                    version of i_press_ofiles_12, new routine i_view_ofiles_2,
c                    and revised i_view_ofiles_1 by adding call-back to [OK] button
c         07/02/2005 added calls to DEMSAV in main and i_pres_ofiles_12
c         26/01/2005 added i_nag_demo  
c         16/02/2007 edited for w_clearwin.dll
c         03/01/2015 increased nfiles to 200 to agree with nfsav in ofiles
c         02/10/2017 added tool tip help to buttons 
c         19/10/2020 added call to x_keybrd to type in data from the console 
c                    also rearranged buttons and added further tool tips
c
      implicit   none
      include   <windows.ins> 
      
c
c arguments
c      
      integer,             intent (in)    :: nfsav
      integer,             intent (inout) :: numdec 
      character (len = *), intent (in)    :: cipher
      character (len = *), intent (inout) :: fname, fsav1(nfsav),
     +                                       fsav3(nfsav)
c
c locals
c     
      integer    nfiles, n1
      parameter (nfiles = 200, n1 = 1)
      integer    nsize
      integer    i, ios
      integer    i_grey_6, i_grey_7, i_grey_11, i_grey_13, i_grey_14,
     +           i_grey_15
      integer    i_grey_open, i_grey_save, i_grey_select
      integer    i_ofiles_count, i_ofiles_numdec
      integer    i_press_ofiles_1,  i_press_ofiles_2,  i_press_ofiles_3,
     +           i_press_ofiles_4,  i_press_ofiles_5,  i_press_ofiles_6,
     +           i_press_ofiles_7,  i_press_ofiles_8,  i_press_ofiles_9,
     +           i_press_ofiles_10, i_press_ofiles_11,
     +           i_press_ofiles_12, i_press_ofiles_13,
     +           i_press_ofiles_14, i_press_ofiles_15
      integer    i_press_select, i_view_select
      integer    i_view_ofiles_1,  i_view_ofiles_2, i_view_ofiles_3,
     +           i_view_ofiles_4
      integer    i_grey_clipboard, i_run_clipboard
      integer    ishow_formats
      integer    i_nag_demo
      integer    i_stop_this_program
      integer    i_call_keybrd
      double precision correction, percent, fsize, size_1
      parameter (percent = 100.0d+00, size_1 = 1.0d+00)
      character  word4*4 
      character  full_path*1024, x_sim256*1024
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  mode*8, pname*8, test_file*1024
      character  blank*1, simfit*12, stars*3, dfolt*11
      parameter (blank = ' ', simfit = 'f$simfit.tmp', stars = '*.*',
     +           dfolt = 'default.tmp')
      character (len = 37) hlp_analysed
      parameter (hlp_analysed = 'Select from recently analysed files') 
      character (len = 36) hlp_created
      parameter (hlp_created = 'Select from recently created files')    
      character (len = 38) hlp_paste
      parameter (hlp_paste = 'Paste numerical table from clipboard')       
      character (len = 41) hlp_demo
      parameter (hlp_demo = 'View/Open Simfit demonstration test files') 
      character (len = 32) hlp_nag
      parameter (hlp_nag = 'View/Open NAG library test files')
      character (len = 32) hlp_back
      parameter (hlp_back = 'Step backwards through file list')
      character (len = 31) hlp_next
      parameter (hlp_next = 'Step forwards through file list')
      character (len = 34) hlp_swap
      parameter (hlp_swap = 'Toggle Analysed/Created file types')
      character (len = 30) hlp_keybrd
      parameter (hlp_keybrd = 'Type data in from the keyboard')
      character (len = 29) hlp_browse
      parameter (hlp_browse = 'Select using Windows Explorer')
      character (len = 29) hlp_ok
      parameter (hlp_ok = 'Open the file in the edit box')
      
      logical    open1, there
      logical    demo, store
      parameter (demo = .false., store = .true.)
      external   i_press_ofiles_1,  i_press_ofiles_2,  i_press_ofiles_3,
     +           i_press_ofiles_4,  i_press_ofiles_5,  i_press_ofiles_6,
     +           i_press_ofiles_7,  i_press_ofiles_8,  i_press_ofiles_9,
     +           i_press_ofiles_10, i_press_ofiles_11,
     +           i_press_ofiles_12, i_press_ofiles_13,
     +           i_press_ofiles_14, i_press_ofiles_15
      external   i_press_select, i_view_select
      external   i_view_ofiles_1,  i_view_ofiles_2, i_view_ofiles_3,
     +           i_view_ofiles_4
      external   i_run_clipboard
      external   i_nag_demo
      external   ishow_formats
      external   i_stop_this_program
      external   x_lcase1, w_syspar, w_getnou, x_demsav, x_sim256,
     +           x_usrdir, w_reslib
      external   i_call_keybrd
      intrinsic  dble
      common   / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common   / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      common   / i_ofiles_grey / i_grey_6, i_grey_7
      common   / i_ofiles_name / pname, test_file
c
c Initialise then find the type and assign the stored filenames
c Note i_ofiles_numdec = 5 to get cancel if close cross is pressed
c
      call x_demsav (demo, store)
      i_ofiles_count = 1
      i_ofiles_numdec = 5
      i_grey_6 = 1
      i_grey_7 = 0
      i_grey_select = 0
      word4 = cipher(1:4)
      call x_lcase1 (word4)
      test_file = blank
c
c see if f$simfit.tmp exists, if so attempt to read pname
c
      pname = blank 
      full_path = x_sim256(simfit)
      inquire (file = full_path, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
         call w_getnou (i)
         open (unit = i, file = full_path, iostat = ios)
         if (ios.eq.0) read (i,'(a)',iostat=ios) pname
         if (ios.ne.0) pname = blank
         close (unit = i)
      endif
      if (pname.eq.blank) then
         i_grey_13 = 0
      else
         i_grey_13 = 1
      endif
c
c Different actions for Open and Save
c
      if (word4.eq.'open') then
c
c File opening for reading
c
         open1 = .true.
         i_grey_14 = 1
         if (pname.eq.blank) then
            i_grey_select = 0
         else
            i_grey_select = 1
         endif
         i_grey_15 = 1
         i_grey_open = 1
         i_grey_save = 0
         mode = 'analysed'
         nsize = sizeof_clipboard_text@()
         if (nsize.gt.6) then
            i_grey_11 = 1
            i_grey_clipboard = 1
         else
            i_grey_11 = 0
            i_grey_clipboard = 0
         endif
         do i = 1, nfiles
            if (i.le.nfsav) then
               fsav(i) = fsav3(i)
            else
               fsav(i) = stars
            endif
         enddo
      else
c
c File opening for saving a file
c
         open1 = .false.
         i_grey_14 = 0
         i_grey_select = 0
         i_grey_15 = 0
         i_grey_open = 0
         i_grey_save = 1
         mode = 'created'
         i_grey_11 = 0
         do i = 1, nfiles
            if (i.le.nfsav) then
               fsav(i) = fsav1(i)
            else
               fsav(i) = blank
            endif
         enddo
      endif
c
c Save the input/output lists
c
       do i = 1, nfiles
          if (i.le.nfsav) then
             gsav1(i) = fsav1(i)
             gsav3(i) = fsav3(i)
          endif
       enddo
c
c Put the filename supplied into temp unless it is blank
c
      if (fname.eq.blank) then
         call x_usrdir (i,
     +                  temp)
         if (i.gt.0) then
            temp = temp(1:i)//dfolt
         else
            temp = dfolt
         endif                         
      else
         temp = fname
      endif
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i,
     +              'f')
      correction = dble(i)/percent
      fsize = correction*size_1
      i = winio@('%sy[3d_thin,topmost]&')
c
c Include the icon
c
      call w_reslib
      i = winio@('%mi[icon_1]&')
c
c Define the accelerator, but only if there is clipboard data
c
      if (i_grey_11.eq.1) i = winio@('%ac[Ctrl+V]&', i_press_ofiles_11)
c
c Caption
c
      if (open1) then
         i = winio@('%ca[Simfit: Open]&')
      else
         i = winio@('%ca[Simfit: Save As ...]&')
      endif

      i = winio@('%th[ms_style]&', n1)
      
c
c Create the main control
c

      i = winio@('%mn[&File[~Open ...,|,
     +                      ~Open a Simfit test file,
     +                      ~Open a Simfit demonstration example,
     +                      ~Open a Simfit library file,|,
     +                      ~Save As ...,|,
     +                      Cancel]]&',
     +                      i_grey_open, i_press_ofiles_2,
     +                      i_grey_14, i_press_ofiles_14,
     +                      i_grey_select, i_press_select,
     +                      i_grey_15, i_press_ofiles_15,
     +                      i_grey_save, i_press_ofiles_2,
     +                      i_press_ofiles_5)

      i = winio@('%mn[&Edit[~Paste      Ctrl+V,|,
     +                      ~Check clipboard data,
     +                      Paths; types; filters]]&',
     +                      i_grey_11, i_press_ofiles_11,
     +                      i_grey_clipboard, i_run_clipboard,
     +                      i_press_ofiles_3)

      i = winio@('%mn[&View[Browse,|,
     +                      Simfit test files,
     +                      ~Simfit demonstration examples,
     +                      Analysed,
     +                      Created,|,
     +                      ~Clipboard]]&',
     +                      i_view_ofiles_2,
     +                      i_view_ofiles_1,
     +                      i_grey_select, i_view_select,
     +                      i_view_ofiles_3,
     +                      i_view_ofiles_4,
     +                      i_grey_clipboard, i_run_clipboard)


      i = winio@('%mn[&Help[Advice,|,
     +                      Simfit test files,
     +                      ~Simfit demonstration examples,
     +                      Simfit file formats]]&',
     +                      i_press_ofiles_4,
     +                      i_press_ofiles_12,
     +                      i_grey_13, i_press_ofiles_13,
     +                      ishow_formats)

      i = winio@('%mn[&Stop]&', i_stop_this_program)

      i = winio@('%`sf%ts&', fsize)
      i = winio@('%tc[red]&')
      if (open1) then
         i = winio@('  Open ...&')
      else
         i = winio@('  Save As ...&')
      endif
      i = winio@('%`sf%ts&', fsize)
      i = winio@('%tc[black]&')
      i = winio@('%ff%nl&')
      i = winio@('%75rs&', temp)

c
c Move down for OK/Browse
c

      i = winio@('%ff%nl&')
      i = winio@('  %`^10?bt[&OK]@%bh&',
     +           i_press_ofiles_1, hlp_ok, n1)
c
c Add the Browse, Keyboard, Paste, Demo, Nag buttons
c     
      if (open1) then
         i = winio@('%ff%nl&')
         i = winio@('  %^10?bt[&Browse]@%bh&', 
     +              i_press_ofiles_2, hlp_browse, n1)
         i = winio@('  %^10?bt[&Keyboard]@%bh&',
     +              i_call_keybrd, hlp_keybrd, n1)
         i = winio@('  %~^?10bt[&Paste]@%bh&', 
     +i_grey_11, i_press_ofiles_11, hlp_paste, n1)
         i = winio@('  %~^?10bt[&Demo]@%bh&',
     +i_grey_select, i_press_select, hlp_demo, n1)
         i = winio@('  %^?10bt[&NAG]@%bh&', i_nag_demo, hlp_nag, n1)
      endif    
c
c Add the Analysed/Created buttons
c
      
      if (open1) then
         i = winio@('%ff%nl&')
         i = winio@('  %^10?bt[&Analysed]@%bh&',
     +i_press_ofiles_8, hlp_analysed, n1)
         i = winio@('  %^10?bt[C&reated]@%bh&',
     +i_press_ofiles_9, hlp_created, n1)
      endif


c
c Move down for the subsidiary controls
c

      i = winio@('%ff%nl&')
      i = winio@('  %~^?10bt[Pre&vious <<]@%bh&',
     +i_grey_6, i_press_ofiles_6, hlp_back, n1)
      i = winio@('  %~^?10bt[Ne&xt >>]@%bh&', 
     +i_grey_7, i_press_ofiles_7, hlp_next, n1)
      i = winio@('  %^?10bt[Swap &Type]@%bh&',
     +i_press_ofiles_10, hlp_swap, n1)
      i = winio@('  Step from %`8rs&', mode)
      i = winio@('file list item%`3rd&', i_ofiles_count)

c
c Close the window control with a blank line
c

      i = winio@(' ')

c
c check if a suggested test file has been selected and this only
c happens when i_ofiles_numdec = - 1 and test_file is the name required
c
      if (i_ofiles_numdec.eq.-1) then
         i_ofiles_numdec = 1
         temp = test_file
      endif
c
c Assign the return arguments
c
      numdec = i_ofiles_numdec
      if (numdec.eq.1) then
c
c numdec = 1: a file has been selected
c
         fname = temp
      elseif (numdec.ne.2) then
c
c numdec not 1 or 2: help/configure/cancel/test-files/library-files
c
         fname = blank
      endif
      end
c
c
      recursive integer function i_press_ofiles_1()
c
c select the file in the box (in w_ofiles)
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 1
      i_press_ofiles_1 = 0
      end
c
c
      recursive integer function i_press_ofiles_2()
c
c use the windows file selection control (in w_ofiles)
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 2
      i_press_ofiles_2 = 0
      end
c
c
      recursive integer function i_press_ofiles_3()
c
c configure (in w_ofiles)
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 3
      i_press_ofiles_3 = 0
      end
c
c
      recursive integer function i_press_ofiles_4()
c
c help (in w_ofiles)
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 4
      i_press_ofiles_4 = 0
      end
c
c
      recursive integer function i_press_ofiles_5()
c
c cancel
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 5
      i_press_ofiles_5 = 0
      end
c
c
      recursive integer function i_press_ofiles_6()
c
c <<  step backwards
c
      implicit   none
      integer    nfiles
      parameter (nfiles = 200)
      integer    i_grey_6, i_grey_7
      integer    i_ofiles_count, i_ofiles_numdec
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  mode*8
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      common / i_ofiles_grey / i_grey_6, i_grey_7
      external window_update@
      i_ofiles_count = i_ofiles_count + 1
      if (i_ofiles_count.lt.1) i_ofiles_count = 1
      if (i_ofiles_count.gt.nfiles) i_ofiles_count = nfiles
      if (i_ofiles_count.eq.1) then
         i_grey_6 = 1
         i_grey_7 = 0
      elseif (i_ofiles_count.eq.nfiles) then
         i_grey_6 = 0
         i_grey_7 = 1
      else
         i_grey_6 = 1
         i_grey_7 = 1
      endif
      temp = fsav(i_ofiles_count)
      call window_update@(temp)
      call window_update@(i_ofiles_count)
      i_ofiles_numdec = 5
      i_press_ofiles_6 = 2
      end
c
c
      recursive integer function i_press_ofiles_7()
c
c >> step forwards
c
      implicit   none
      integer    nfiles
      parameter (nfiles = 200)
      integer    i_grey_6, i_grey_7
      integer    i_ofiles_count, i_ofiles_numdec
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  mode*8
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      common / i_ofiles_grey / i_grey_6, i_grey_7
      external window_update@
      i_ofiles_count = i_ofiles_count - 1
      if (i_ofiles_count.lt.1) i_ofiles_count = 1
      if (i_ofiles_count.gt.nfiles) i_ofiles_count = nfiles
      if (i_ofiles_count.eq.1) then
         i_grey_6 = 1
         i_grey_7 = 0
      elseif (i_ofiles_count.eq.nfiles) then
         i_grey_6 = 0
         i_grey_7 = 1
      else
         i_grey_6 = 1
         i_grey_7 = 1
      endif
      temp = fsav(i_ofiles_count)
      call window_update@(temp)
      call window_update@(i_ofiles_count)
      i_ofiles_numdec = 5
      i_press_ofiles_7 = 2
      end
c
c
      recursive integer function i_press_ofiles_8()
c
c list box for previously analysed files
c
      implicit   none
      integer    isend, nfiles, nfp1
      parameter (isend = 1, nfiles = 200, nfp1 = nfiles + 1)
      integer    i, numdec
      integer    i_ofiles_count, i_ofiles_numdec
      character  fsav(nfiles)*1024, temp*1024, x_trim80*80
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  files(nfp1)*80
      character  mode*8
      character  blank*1
      parameter (blank = ' ')
      logical    repeet, view
      logical    demo, store
      parameter (demo = .true., store = .true.)
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      external   x_vuopen, x_trim80, w_viewer, x_demsav
      external   window_update@
      files(1) = 'Cancel'
      do i = 1, nfiles
         files(i + 1) = x_trim80(gsav3(i))
      enddo
      view = .true.
      repeet = .true.
      numdec = 1
      do while (repeet)
         call x_vuopen (numdec, nfp1,
     +                  files,
     +                  view)
         if (numdec.gt.1) then
c
c a file has been selected
c
            if (view) then
               call w_viewer (isend,
     +                        gsav3(numdec - 1), blank, blank)
            else
               do i = 1, nfiles
                  fsav(i) = gsav3(i)
               enddo
               i_ofiles_count = numdec - 1
               call window_update@(i_ofiles_count)
               temp = gsav3(i_ofiles_count)
               call window_update@(temp)
               mode = 'opened'
               call window_update@(mode)
               call x_demsav (demo, store)
               i_press_ofiles_8 = 0
               i_ofiles_numdec = 1
               repeet = .false.
            endif
         else
c
c no action
c
            i_press_ofiles_8 = 2
            i_ofiles_numdec = 5
            repeet = .false.
         endif
      enddo
      end
c
c
      recursive integer function i_press_ofiles_9()
c
c list box for previously created/saved files
c
      implicit   none
      integer    isend, nfiles, nfp1
      parameter (isend = 1, nfiles = 200, nfp1 = nfiles + 1)
      integer    i, numdec
      integer    i_ofiles_count, i_ofiles_numdec
      character  fsav(nfiles)*1024, temp*1024, x_trim80*80
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  files(nfp1)*80
      character  mode*8
      character  blank*1
      parameter (blank = ' ')
      logical    repeet, view
      logical    demo, store
      parameter (demo = .true., store = .true.)
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      external   x_vuopen, x_trim80, w_viewer, x_demsav
      external   window_update@
      files(1) = 'Cancel'
      do i = 1, nfiles
         files(i + 1) = x_trim80(gsav1(i))
      enddo
      view = .true.
      repeet = .true.
      numdec = 1
      do while (repeet)
         call x_vuopen (numdec, nfp1,
     +                  files,
     +                  view)
         if (numdec.gt.1) then
c
c a file has been selected
c
            if (view) then
               call w_viewer (isend,
     +                        gsav1(numdec - 1), blank, blank)
            else
               do i = 1, nfiles
                  fsav(i) = gsav1(i)
               enddo
               i_ofiles_count = numdec - 1
               call window_update@(i_ofiles_count)
               temp = gsav1(i_ofiles_count)
               call window_update@(temp)
               mode = 'saved'
               call window_update@(mode)
               call x_demsav (demo, store)
               i_press_ofiles_9 = 0
               i_ofiles_numdec = 1
               repeet = .false.
            endif
         else
c
c no action
c
            i_press_ofiles_9 = 2
            i_ofiles_numdec = 5
            repeet = .false.
         endif
      enddo
      end
c
c
      recursive integer function i_press_ofiles_10()
c
c toggle between previously created/saved file types
c
      implicit   none
      integer    i, nfiles
      parameter (nfiles = 200)
      integer    i_ofiles_count, i_ofiles_numdec
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  mode*8
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      external window_update@
      if (mode.eq.'created') then
         mode = 'analysed'
         do i = 1, nfiles
            fsav(i) = gsav3(i)
         enddo
      else
         mode = 'created'
         do i = 1, nfiles
            fsav(i) = gsav1(i)
         enddo
      endif
      temp = fsav(i_ofiles_count)
      call window_update@(mode)
      call window_update@(temp)
      i_ofiles_numdec = 5
      i_press_ofiles_10 = 2
      end
c
c
      recursive integer function i_press_ofiles_11()
c
c select from the clipboard to create a temporary file
c
      implicit   none
      integer    isend, nout
      parameter (isend = 2)
      integer    nfiles
      parameter (nfiles = 200)
      character  fname*1024
      logical    abort
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  mode*8
      external   w_clpbrd, w_getnou
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      i_press_ofiles_11 = 2
      call w_getnou (nout)
      call w_clpbrd (isend, nout,
     +               fname, 
     +               abort)
      close (unit = nout)
      if (abort) then
         i_ofiles_numdec = 5
         i_press_ofiles_11 = 1
      else
         temp = fname
         i_ofiles_numdec = 1
         i_press_ofiles_11 = 0
      endif
      end
c
c
      recursive integer function i_press_ofiles_12()
c
c help about test files (alphabetical)
c
      implicit   none
      integer    i_ofiles_count, i_ofiles_numdec
      integer    numtxt
      parameter (numtxt = 21)
      integer    numbld(numtxt)
      character  text(30)*100
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      external  x_patch2
      data numbld /numtxt*0 /
      write (text,100)
      numbld(1) = 1
      call x_patch2 (numbld, numtxt,
     +               text)
      i_ofiles_numdec = 5
      i_press_ofiles_12 = 2
  100 format (
     + 'Simfit test files'
     +/
     +/'For each procedure in Simfit there is a set of data you can use'
     +/'to see how the procedure operates before trying with your own'
     +/'data. This will allow you to get the feel of what Simfit does'
     +/'with correctly formatted data but, more importantly, if Simfit'
     +/'analyses the test data but fails with your data, then obviously'
     +/'your data are not formatted correctly.'
     +/
     +/'Note that the Simfit reference manual contains a worked example'
     +/'using test data for every Simfit procedure, so you should read'
     +/'the appropriate section before trying to analyse your own data.'
     +/
     +/'You can view the test files to see the formatting details and,'
     +/'to facilitate selection of appropriate test files you can view'
     +/'test files grouped according to each program.'
     +/
     +/'Note that after using the [Help] menu item to read about test'
     +/'files that are consistent with the program you are using, and'
     +/'the [View] menu option to view them, you can use the [Demo]'
     +/'button to select an appropriate test file.')
      end
c
c
      recursive integer function i_press_ofiles_13()
c
c help about test files (program)
c
      implicit  none
      integer   i_ofiles_count, i_ofiles_numdec
      character pname*8, test_file*1024
      common  / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common  / i_ofiles_name / pname, test_file
      external  help_main
      call help_main (pname)
      i_ofiles_numdec = 5
      i_press_ofiles_13 = 2
      end
c
c
      recursive integer function i_press_ofiles_14()
c
c test files (in w_ofiles)
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 6
      i_press_ofiles_14 = 0
      end
c
c
      recursive integer function i_press_ofiles_15()
c
c library files (in w_ofiles)
c
      implicit none
      integer  i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      i_ofiles_numdec = 7
      i_press_ofiles_15 = 0
      end
c
c
      recursive integer function i_view_ofiles_1()
c
c view test files
c
      implicit   none
      integer    isend
      parameter (isend = 0)
      external   x_vutext
      i_view_ofiles_1 = 1
      call x_vutext (isend)
      end
c
c
      recursive integer function i_view_ofiles_2()
c
c view any file
c
      implicit   none
      include   <windows.ins>
      integer    isend, mode, nval(12)
      parameter (isend = 2, mode = 0)
      integer    k
      integer    i_hit_ofiles_ok
      double precision correction, pcent, fsize
      parameter (pcent = 100.0d+00)
      character (len = 1024) cval(12)
      character (len = 1024) fname, path, pattern
      character  blank*1
      parameter (blank = ' ')
      logical    ok
      external   w_config, w_viewer
      external   w_syspar
      external   i_hit_ofiles_ok
      intrinsic  dble
      common     / i_hit_ofiles_ok_button / ok
      save       fname, path, pattern
      data       fname, path, pattern / blank, '\Temp\', '*.*' /
      i_view_ofiles_2 = 1
      fname = blank
      ok = .false.
      call w_config (mode, nval, cval)
      call use_windows95_font@()
      call w_syspar (k,
     +               'f')
      correction = dble(k)/pcent
      fsize = correction
      k = winio@('%`sf%tc[black]%ts&', fsize)
      k = winio@('%sy[3d_thin]&')
      k = winio@('%bg[grey]%tc[black]&')
      k = winio@('%ob[bottom_exit, scored]&')
      k = winio@('%ca[Simfit: view a file]&')
      k = winio@('%co[full_check]&')
      k = winio@('%ff%`bg[white]%tc[black]&')
      k = winio@('%40rs&', path)
      k = winio@('Path (e.g. C:\Results\)&')
      k = winio@('%ff%`bg[white]%tc[black]&')
      k = winio@('%40rs&', pattern)
      k = winio@('Pattern (e.g.   *.*)&')
      k = winio@('%ff%nl%cn%^`6bt[OK]&', i_hit_ofiles_ok)
      k = winio@('%ff%nl&')
      k = winio@('%cb')
      if (ok) call w_viewer (isend, 
     +                       fname, path, pattern)
      end
c
c
      recursive integer function i_hit_ofiles_ok()
      implicit none
      logical ok
      common / i_hit_ofiles_ok_button / ok
      ok = .true.
      i_hit_ofiles_ok = 0
      end
c
c
      recursive integer function i_view_ofiles_3()
c
c list box for previously analysed files
c
      implicit   none
      integer    nfiles, nfp1
      parameter (nfiles = 200, nfp1 = nfiles + 1)
      integer    icolor, ixl, iyl
      parameter (icolor = 7, ixl = 4, iyl = 4)
      integer    isend
      parameter (isend = 1)
      integer    i, numdec, numpos(nfp1)
      character  fsav(nfiles)*1024, temp*1024, x_trim80*80
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  files(nfp1)*80
      character  mode*8
      character  blank*1
      parameter (blank = ' ')
      logical    repeet
      common   / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      external   x_lbox02, x_trim80, w_viewer
      data       numpos / nfp1*1 /
      files(1) = 'Cancel'
      do i = 1, nfiles
         files(i + 1) = x_trim80(gsav3(i))
      enddo
      numdec = 1
      repeet = .true.
      do while (repeet)
         call x_lbox02 (icolor, ixl, iyl, numdec, nfp1, numpos,
     +                  files)
         if (numdec.gt.1) then
c
c a file has been selected
c
            call w_viewer (isend,
     +                     gsav3(numdec - 1), blank, blank)
         else
            repeet = .false.
         endif
      enddo
      i_view_ofiles_3 = 1
      end
c
c
      recursive integer function i_view_ofiles_4()
c
c list box for previously created/saved files
c
      implicit   none
      integer    nfiles, nfp1
      parameter (nfiles = 200, nfp1 = nfiles + 1)
      integer    icolor, ixl, iyl
      parameter (icolor = 7, ixl = 4, iyl = 4)
      integer    isend
      parameter (isend = 1)
      integer    i, numdec, numpos(nfp1)
      character  fsav(nfiles)*1024, temp*1024, x_trim80*80
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  files(nfp1)*80
      character  mode*8
      character  blank*1
      parameter (blank = ' ')
      logical    repeet
      common   / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      external   x_lbox02, x_trim80, w_viewer
      data       numpos / nfp1*1 /
      files(1) = 'Cancel'
      do i = 1, nfiles
         files(i + 1) = x_trim80(gsav1(i))
      enddo
      numdec = 1
      repeet = .true.
      do while (repeet)
         call x_lbox02 (icolor, ixl, iyl, numdec, nfp1, numpos, 
     +                  files)
         if (numdec.gt.1) then
c
c a file has been selected
c
            call w_viewer (isend,
     +                     gsav1(numdec - 1), blank, blank)
         else
            repeet = .false.
         endif
      enddo
      i_view_ofiles_4 = 1
      end
c
c
      recursive integer function i_run_clipboard()
      implicit   none
      integer    isend
      parameter (isend = 1)
      external   w_vuclip
      call w_vuclip (isend)
      i_run_clipboard = 2
      end
c
c
      recursive integer function i_call_keybrd()
      implicit none
      integer    i_ofiles_count, i_ofiles_numdec
      integer    nfiles
      parameter (nfiles = 200)
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  fname*1024
      character  mode*8
      character  blank*1
      parameter (blank = ' ')
      logical    abort
      external   x_keybrd
      common   / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      common   / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      call x_keybrd (fname,
     +               abort)
      if (abort .or. fname.eq.blank) then
         i_call_keybrd = 2
      else
         fsav(1) = fname
         gsav1(1) = fname
         gsav3(1) = fname
         temp = fname
         i_ofiles_numdec = 1
         i_call_keybrd = 0
      endif
      end
c
c              


