c
c w_ofiles ... extra routines set 2: demonstration examples
c ==================================
c
c 27/11/2000 edited to suppress upper cases in filenames and
c            add filetype identifiers to the filenames
c 26/01/2002 replaced call to w_help.exe by call to w_viewer to
c            list test files, e.g. in w_readme.f4
c 20/03/2002 introduced viewer to control help type (see w_ofile1.for)
c 20/12/2002 added get_test_files and restored call to w_help.exe
c 14/01/2005 introduced vuopen
c 26/02/2005 added i_nag_demo
c 16/02/2007 edited for w_clearwin.dll
c 27/01/2010 edited to include grave accents for tabbing
c 18/01/2019 added SVG test files
c 04/07/2020 started to overhaul deqsol, qnfit, and simplot test files  
c 28/05/2022 introduced len_stub to increase the length = text and stub
c            This must be the same in i_press_select and i_view_select
c
c i_press_select ... open a demonstration example
c i_view_select  ... view a demonstration example
c get_test_files ... return filenames given program name
c
c
      recursive integer function i_press_select()
c
c select an example test file depending on the program name
c
      integer    isend, len_stub, nmax
      parameter (isend = 1, len_stub = 120, nmax = 100)
      integer    i_press_ofiles_13
      integer    i_ofiles_count, i_ofiles_numdec  
      integer    i, k, l
      integer    numdec, numopt, nstart, ntext
      character  x_sim256*1024
      character (len = len_stub) text(nmax), stub
      character  pname*8, test_file*1024
      character  blank*1, grave*1, help*11
      parameter (blank = ' ', grave = '`', help = 'w_readme.f4')
      logical    again, viewer, viewit
      logical    demo, store
      parameter (demo = .true., store = .true.)
      external   x_vuopen, w_viewer, x_demsav, x_sim256
      external   i_press_ofiles_13, get_test_files
      intrinsic  index
      common   / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common   / i_ofiles_name / pname, test_file
c
c initialise viewer = .false. for help or = .true. for w_readme.f4
c     
      l = 1
      i_press_select = l!to silence ftn95
      i_ofiles_numdec = 5
      viewer = .false.
      viewit = .true.
c
c assign nstart, ntext, numopt, numdec, text, etc. depending on pname
c
      call get_test_files (nmax, nstart, ntext, numdec, numopt,
     +                     pname, text, 
     +                     again, viewer)
      numdec = nstart + 1
      do while (again)
c
c choose
c
         call x_vuopen (numdec, ntext,
     +                  text,
     +                  viewit)
         if (numdec.eq.nstart) then
c
c Cancel with no choice
c
            test_file = blank
            i_press_select = 1
            again = .false.
         elseif (numdec.eq.nstart + 1) then
c
c Help (must define simfit each time o/w becomes undefined ?)
c
            if (viewer) then
               test_file = x_sim256(help)
               again = .true.
               call w_viewer (isend,
     +                        test_file, blank, blank)
            else
               l = i_press_ofiles_13()
            endif
            again = .true.
         else
c
c a displayed file has been selected so set i_ofiles_numdec = - 1
c must define simfit each time o/w it becomes undefined ?
c
            stub = text(nstart + numdec - 1)
            k = index(stub,grave)
            if (k.gt.0) then
               do i = k, len_stub
                  stub(i:i) = blank
               enddo   
            endif      
            test_file = x_sim256(stub)
            if (viewit) then
               call w_viewer (isend,
     +                        test_file, blank, blank)
            else
               call x_demsav (demo, store)
               i_ofiles_numdec = - 1
               i_press_select = 0
               again = .false.
            endif
         endif
      enddo
      end
c
c
      recursive integer function i_view_select()
c
c view an example test file depending on the program name
c
      integer    isend, len_stub, nmax
      parameter (isend = 1, len_stub = 120, nmax = 100)
      integer    i_press_ofiles_13
      integer    i, j, jmax, jmin, k, l, ngrave 
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 0)
      integer    numbld(nmax), numpos(nmax)
      character  x_sim256*1024
      character (len = len_stub) text(nmax), stub
      character  pname*8, path*1, pattern*1, test_file*1024
      character  blank*1, grave*1, help*11
      parameter (blank = ' ', grave = '`', help = 'w_readme.f4')
      logical    again, tabbing, viewer
      logical    titles
      parameter (titles = .false.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   w_lbox01, x_sim256, w_viewer, x_lview2
      external   i_press_ofiles_13, get_test_files
      intrinsic  index
      common   / i_ofiles_name / pname, test_file
      data       numbld / nmax*0 /
      data       numpos / nmax*1 /
c
c initialise viewer = .false. for help or = .true. for w_readme.f4
c         
      l = 1
      i_view_select = l
      viewer = .false.
c
c assign nstart, ntext, numopt, numdec, text, etc. depending on pname
c
      call get_test_files (nmax, nstart, ntext, numdec, numopt,
     +                     pname, text, 
     +                     again, viewer)
      jmax = 0
      jmin = 1000
      ngrave = 0
      do i = 1, numopt
         j = index(text(i),grave)
         if (j.lt.jmin) jmin = j
         if (j.gt.jmax) jmax = j
         if (j.gt.0) ngrave = ngrave + 1    
      enddo  
      if (ngrave.eq.numopt .and. jmax.eq.jmin) then
         tabbing = .true.
      else
         tabbing = .false.
      endif      
      numdec = nstart + 1
      do while (again)
c
c choose
c 
         if (tabbing) then
            call x_lview2 (ix, iy, numdec, numopt,
     +                     text,
     +                     titles)
         else           
            call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                     numopt, numpos, nstart, ntext,
     +                     text,
     +                     border, flash, high)
         endif
         if (numdec.eq.nstart) then
c
c Cancel with no choice
c
            test_file = blank
            again = .false.
         elseif (numdec.eq.nstart + 1) then
c
c Help (must define simfit each time o/w it becoms undefined ?)
c
            if (viewer) then
               test_file = x_sim256(help)
               again = .true.
               path = blank
               pattern = blank
               call w_viewer (isend,
     +                        test_file, path, pattern)
            else
               l = i_press_ofiles_13()
            endif
            again = .true.
         else
c
c a displayed file has been selected
c must define simfit each time o/w it becoms undefined
c
            stub = text(nstart + numdec - 1)
            k = index(stub,grave)
            if (k.gt.0) then
               do i = k, len_stub
                  stub(i:i) = blank
               enddo   
            endif      
            test_file = x_sim256(stub)
            again = .true.
            path = blank
            pattern = blank
            call w_viewer (isend, 
     +                     test_file, path, pattern)
         endif
      enddo
      end
c
c
      subroutine get_test_files (nmax, nstart, ntext, numdec, numopt,
     +                           pname, text, 
     +                           again, viewer)
      use module_clearwin, only : required
c
c action: return appropriate test files
c author: w.g.bardsley, university of manchester, u.k., 20/12/2002
c         27/01/2010 deleted text_copy and added graves for tabbing extra text
c         14/06/2010 expanded every menu to include graves 
c
      implicit  none  
c
c arguments
c             
      integer,             intent (in)  :: nmax
      integer,             intent (out) :: nstart, ntext, numdec, numopt 
      character (len = *), intent (in)  :: pname
      character (len = *), intent (out) :: text(nmax) 
      logical,             intent (in)  :: viewer
      logical,             intent (out) :: again 
c
c locals
c      
      integer    k
      character  grave*1
      parameter (grave = '`')
      intrinsic  index 
      nstart = 1
      ntext = nstart + 2
      again = .true.
      if (pname.eq.'adderr') then
c
c adderr
c
         text(ntext) = 'adderr.tf1`Function of 1 variable (y = 1)'
         ntext = ntext + 1
         text(ntext) = 'adderr.tf2`Function of 1 variable (y = 0)'
         ntext = ntext + 1
         text(ntext) = 'qnfit.tf2 `Function of 2 variables'
         ntext = ntext + 1
         text(ntext) = 'qnfit.tf3 `Function of 3 variables'
      elseif (pname.eq.'average') then
c
c average
c
         text(ntext) = 'average.tf1'
      elseif (pname.eq.'binomial') then
c
c binomial
c
         text(ntext) = 'binomial.tf1`Binomial sample with N=50, p=0.5'
         ntext = ntext + 1
         text(ntext) =
     +'binomial.tf2`Analysis of proportions: X,N (5 x 2)'
         ntext = ntext + 1
         text(ntext) = 
     +'binomial.tf3`Analysis of proportions, X,N,t (5 x 3)'
         ntext = ntext + 1
         text(ntext) = 
     +'binomial.tf4`Analysis of proportions, X,N,t (5 x 3)'
         ntext = ntext + 1
         text(ntext) = 
     +'binomial.tf5`Analysis of proportions, X,N,t (20 x 3)'
         ntext = ntext + 1
         text(ntext) = 'meta.tf1    `Meta Analysis data'
         ntext = ntext + 1
         text(ntext) = 'poisson.tf1 `Poisson sample'
         ntext = ntext + 1
         text(ntext) = 'trinom.tf1  `Trinomial sample'
         ntext = ntext + 1
         text(ntext) = 'trinom.tf2  `Trinomial sample'
      elseif (pname.eq.'calcurve') then
c
c calcurve
c
         text(ntext) = 'calcurve.tf1`Calibration curve in EXPERT mode'
         ntext = ntext + 1
         text(ntext) = 'calcurve.tf2`Calcurve.tf1 with no weights'
         ntext = ntext + 1
         text(ntext) = 'calcurve.tf3`Predict x=f(y) using calcurve.tf1'
      elseif (pname.eq.'chisqd') then
c
c chisqd
c
         text(ntext) = 'chisqd.tf1`Chi-square sample with DOF = 10'
         ntext = ntext + 1
         text(ntext) = 'chisqd.tf2`Observed values: use with chisqd.tf3'
         ntext = ntext + 1
         text(ntext) = 'chisqd.tf3`Expected values: use with chisqd.tf2'
         ntext = ntext + 1
         text(ntext) = 'chisqd.tf4`Fisher-exact contingency table'
         ntext = ntext + 1
         text(ntext) = 'chisqd.tf5`Chi-squared contingency table'
      elseif (pname.eq.'compare') then
c
c compare
c
         text(ntext) = 'compare.tf1`Compare with compare.tf2'
         ntext = ntext + 1
         text(ntext) = 'compare.tf2`Compare with compare.tf1'
      elseif (pname.eq.'csafit') then
c
c csafit
c
         text(ntext) = 'csafit.tf1`Geometric data: 15% stretch'
         ntext = ntext + 1
         text(ntext) = 'csafit.tf2`Arithmetic data: 5% translation'
         ntext = ntext + 1
         text(ntext) = 'csafit.tf3`Full linear stretch/translation data'
      elseif (pname.eq.'deqsol') then
c
c deqsol
c
         ntext = ntext - 1
         if (required(6)) then
            ntext = ntext + 1 
            text(ntext) = 
     +'usermodd_e.tf1`MODEL for 1 DE: First order kinetics'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod1_e.tf1 `MODEL for 1 DE: Irreversible MM S(t)'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod1_e.tf2 `MODEL for 1 DE: Irreversible MM P(t)'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod1_e.tf3 `MODEL for 1 DE: Generalised MM+D S(t)'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod1_e.tf4 `MODEL for 1 DE: Generalised MM+D P(t)'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod1_e.tf5 `MODEL for 1 DE: Membrane transport'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod1_e.tf6 `MODEL for 1 DE: Von Bertalannfy growth'
         endif

         if (required(6)) then
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod2_e.tf1 `MODEL for 2 DE: Coupled system'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod2_e.tf2 `MODEL for 2 DE: Lotka-Volterra'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod2_e.tf3 `MODEL for 2 DE: Competing species'
         endif

         if (required(6)) then
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod3_e.tf1 `MODEL for 3 DE: Epidemic with Jacobian'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod3_e.tf2 `MODEL for 3 DE: Epidemic with no Jacobian'
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod3_e.tf3 `MODEL for 3 DE: Recurrent Epidemic with Jacobian'
         endif
         
         if (required(6)) then
            ntext = ntext + 1
            text(ntext) = 
     +'deqmod4_e.tf1 `MODEL for 4 DE: Michaelis-Menten kinetics'
         endif
         
         if (required(1) .or. required(6)) then
            ntext = ntext + 1
            text(ntext) = 'qnfit_ode.tf1 `DATA for: MM irreverible S(t)'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_ode.tf2 `DATA for: Von Bertalannfy growth'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_ode.tf3 `DATA for: Up-down VB allometric DE'
         endif

         if (required(2) .or. required(6)) then
            ntext = ntext + 1
            text(ntext) = 
     +'deqsol.TFL    `DATA for: Lotka-Volterra (TFL type library file)'
         endif
            
         if (required(3) .or. required(6)) then 
            ntext = ntext + 1
            text(ntext) = 
     +'epidemic.TFL  `DATA for: Epidemic model (TFL type library file)'
            ntext = ntext + 1
            text(ntext) = 
     +'recurrent.TFL `DATA for: Recurrent Epidemic model (TFL type)'
         endif

         if (required(4) .or. required(6)) then 
            ntext = ntext + 1
            text(ntext) = 
     +'consec4.TFL   `DATA for: A=B=C=D (TFL type library file)'
         endif

         if (required(5) .or. required(6)) then
            ntext = ntext + 1
            text(ntext) = 
     +'consec5.TFL   `DATA for: A=B=C=D=E (TFL type library file)'
         endif


         
      elseif (pname.eq.'editfl') then
c
c editfl
c
         text(ntext) = 'editfl.tf1`Curve-fit data to check/edit'
         ntext = ntext + 1
         text(ntext) = 'editfl.tf2`Curve-fit data to check/edit'
         ntext = ntext + 1
         text(ntext) = 'editfl.tf3`Curve-fit data to check/edit'
         ntext = ntext + 1
         text(ntext) = 'editfl.tf4`Curve-fit data to check/edit'
      elseif (pname.eq.'editmt') then
c
c editmt
c
         text(ntext) = 'editmt.tf1`Matrix data to demonstrate editing'
         ntext = ntext + 1
         text(ntext) = 'editmt.tf2`Matrix data to demonstrate editing'
         ntext = ntext + 1
         text(ntext) = 'editmt.tf3`Data column to add to editmt.tf1'
      elseif (pname.eq.'editps') then
c
c editps
c
         text(ntext) = 'editps.TFL         `*.eps library file'
         ntext = ntext + 1
         text(ntext) = 'images.TFL         `*.eps library file'
         ntext = ntext + 1
         text(ntext) = 'simfig1.ps         `Figure for editps.tfl'
         ntext = ntext + 1
         text(ntext) = 'simfig2.ps         `Figure for editps.tfl'
         ntext = ntext + 1
         text(ntext) = 'simfig3.ps         `Figure for editps.tfl'
         ntext = ntext + 1
         text(ntext) = 'simfig4.ps         `Figure for editps.tfl'
         ntext = ntext + 1
         text(ntext) = 'waves.eps          `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'rosenbrock.eps     `Image for images.tfl' 
         ntext = ntext + 1
         text(ntext) = 'dendrogram.eps     `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'trinom.eps         `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'ukmap.eps          `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'diffusion.eps      `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'rose.eps           `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'gauss3.eps         `Image for images.tfl'
         ntext = ntext + 1
         text(ntext) = 'convolution.eps    `Image for images.tfl' 
c--------------------------------------------------------------------------SVG 
      elseif (pname.eq.'editsvg') then
c
c editsvg
c 
         text(ntext) =
     +'SVG_collage.TFL             `Simfit Library file for a collage' 
         ntext = ntext + 1
           
         text(ntext) =             
     +'exfit.svg                   `Figure 1 for SVG_collage.TFL'  
     
         ntext = ntext + 1
         text(ntext) =               
     +'exfit_logplot.svg           `Insert plot to make Figure 1'
     
         ntext = ntext + 1
         text(ntext) =
     +'exfit_normalplot.svg        `Main plot to make Figure 1'
     
         ntext = ntext + 1
         text(ntext) = 
     +'latex_chemistry.svg         `Figure 2 for SVG_collage.TFL' 
     
         ntext = ntext + 1
         text(ntext) = 
     +'latex_chemical_formula.svg  `Formula to make Figure 2'  
        
         ntext = ntext + 1
         text(ntext) =
     +'latex_chemical_plot.svg     `Main plot to make Figure 2'

         ntext = ntext + 1
         text(ntext) = 
     +'latex_maths.svg             `Figure 3 for SVG_collage.TFL'         
     
         ntext = ntext + 1
         text(ntext) =
     +'latex_maths_equation.svg    `Equation to make Figure 3'  
      
       ntext = ntext + 1
       text(ntext) =
     +'latex_maths_plot.svg        `Main plot to make Figure 3'
     
         ntext = ntext + 1
         text(ntext) = 
     +'lines.svg                   `Figure 4 for svg_collage.TFL'

         ntext = ntext + 1
         text(ntext) =
     +'fonts.svg                   `Figure 5 for SVG_collage.TFL'     

         ntext = ntext + 1
         text(ntext) = 
     +'new_lines.svg               `Figure 5 after editing'     
     
         ntext = ntext + 1
         text(ntext) =
     +'stack_plot.svg              `Figure 6 for svg_collage.TFL'
     
         ntext = ntext + 1
         text(ntext) =
     +'blank_plot.svg              `4x3 aspect ratio white background'

         ntext = ntext + 1
         text(ntext) = 
     +'binomial_poisson.tex        `Binomial/Poisson distributions' 

         ntext = ntext + 1
         text(ntext) = 
     +'chemical_formula1.tex       `Assorted chemical formulas' 

         ntext = ntext + 1
         text(ntext) = 
     +'latex_chemical_formula.tex  `Diamine Oxidase reagent oxidation'   

         ntext = ntext + 1
         text(ntext) = 
     +'latex_chemical_synthesis.tex`Diamine Oxidase reagent synthesis'   
     
         ntext = ntext + 1
         text(ntext) = 
     +'latex_maths_equation.tex    `Makes latex_maths_equation.svg'     
     
         
      elseif (pname.eq.'exfit') then
c
c exfit
c
         text(ntext) = 'exfit.tf1`Model 1: exact data (1 exponential)'
         ntext = ntext + 1
         text(ntext) = 'exfit.tf2`Model 1: exfit.tf1 with ADDERR error'
         ntext = ntext + 1
         text(ntext) = 'exfit.tf3`Model 1: exact data (2 exponentials)'
         ntext = ntext + 1
         text(ntext) = 'exfit.tf4`Model 1: exfit.tf3 with ADDERR error'
         ntext = ntext + 1
         text(ntext) = 
     +   'exfit.tf5`Model 5: exact UP-DOWN data (2 exponentials)'
         ntext = ntext + 1
         text(ntext) = 
     +   'exfit.tf6`Model 6: exact DOWN-UP data (2 exponentials)'
         ntext = ntext + 1
         text(ntext) = 
     +   'exfit.tf7`Model 3: exact MONOMOLECULAR data (2 exponentials)'
      elseif (pname.eq.'ftest') then
c
c ftest
c
         text(ntext) = 'anova1.tfl`Library file for 1-way ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova1.tfl`Matrix for 1-way ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova2.tf1`Matrix for 2-way ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova3.tf1`Matrix for 3-way ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova4.tf1`Matrix for groups/sub-groups ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova5.tf1`Matrix for 2-factor/1-block ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova6.tf1`Matrix for repeated measures ANOVA'
         ntext = ntext + 1
         text(ntext) = 'ftest.tf1 `F random sample with m = 2, n = 5'
      elseif (pname.eq.'gcfit') then
c
c gcfit
c
         text(ntext) = 'gcfit.tf1   `Exact data for mode 1 with model 3'
         ntext = ntext + 1
         text(ntext) = 'gcfit.tf2   `gcfit.tf1 with error using ADDERR'
         ntext = ntext + 1
         text(ntext) = 'weibull.tf1 `Weibull survival data for mode 2'
         ntext = ntext + 1
         text(ntext) = 'gompertz.tf1`Gompertz survival data for mode 2'
         ntext = ntext + 1
         text(ntext) = 'survive.tf1 `Survival data for mode 3'
         ntext = ntext + 1
         text(ntext) = 'survive.tf2 `Data to be paired with survive.tf1'
         ntext = ntext + 1
         text(ntext) = 'survive.tf3 `Survival data for mode 3'
         ntext = ntext + 1
         text(ntext) = 'survive.tf4 `Data to be paired with survive.tf3'
         ntext = ntext + 1
         text(ntext) = 'ld50.tf1    `LD50 dose-response data: y,N,x'
         ntext = ntext + 1
         text(ntext) = 'ld50.tf2    `LD50 dose-response data: x,y,N,s'
         ntext = ntext + 1
         text(ntext) = 'ld50.tf3    `LD50 dose-response data: x,N-y,N,s'
         ntext = ntext + 1
         text(ntext) = 'cox.tf1     `Cox proportional hazards data'
      elseif (pname.eq.'hlfit') then
c
c hlfit
c
         text(ntext) = 'hlfit.tf1  `Exact data for one site'
         ntext = ntext + 1
         text(ntext) = 'hlfit.tf2  `hlfit.tf1 with error using ADDERR'
         ntext = ntext + 1
         text(ntext) = 'hlfit.tf3  `Exact data for two sites'
         ntext = ntext + 1
         text(ntext) = 'hlfit.tf4  `hlfit.tf2 with error using ADDERR'
         ntext = ntext + 1
         text(ntext) = 'hotcold.tf1`Isotope displacement data'
      elseif (pname.eq.'inrate') then
c
c inrate
c
         text(ntext) = 'inrate.tf1`Data for models 1 and 2'
         ntext = ntext + 1
         text(ntext) = 'inrate.tf2`Data for model 3'
         ntext = ntext + 1
         text(ntext) = 'inrate.tf3`Data for model 4'
         ntext = ntext + 1
         text(ntext) = 'inrate.tf4`Data for model 5'
      elseif (pname.eq.'linfit') then
c
c linfit
c
         text(ntext) = 'line.tf1  `Straight line data'
         ntext = ntext + 1
         text(ntext) = 'linfit.tf1`Singular multilinear regression data'
         ntext = ntext + 1
         text(ntext) = 'linfit.tf2`Fullrank multilinear regression data'
         ntext = ntext + 1
         text(ntext) = 'glm.tf1   `Normal errors, reciprocal link'
         ntext = ntext + 1
         text(ntext) = 'glm.tf2   `Binomial errors, logistic link'
         ntext = ntext + 1
         text(ntext) = 'glm.tf3   `Poisson errors, log link'
         ntext = ntext + 1
         text(ntext) = 'glm.tf4   `Gamma errors, reciprocal link'
         ntext = ntext + 1
         text(ntext) = 'cox.tf1   `Cox proportional hazards data'
      elseif (pname.eq.'makdat') then
c
c makdat
c
         text(ntext) = 'usermod1.tf1`Function of one variable'
         ntext = ntext + 1
         text(ntext) = 'usermod2.tf1`Function of two variables'
         ntext = ntext + 1
         text(ntext) = 'usermod3.tf1`Function of three variables'
         ntext = ntext + 1
         text(ntext) = 'usermodd.tf1`Differential equation'
         ntext = ntext + 1
         text(ntext) = 'rose.mod    `Parametric r(theta)'
         ntext = ntext + 1
         text(ntext) = 'ellipse.mod `Parametric x(t), y(t)'
         ntext = ntext + 1
         text(ntext) = 'helix.mod   `Parametric x(t), y(t), z(t)'
      elseif (pname.eq.'maksim') then
c
c maksim
c
          text(ntext) = 
     +'maksim.tf1   `Data table in text format'
         ntext = ntext + 1
         text(ntext) = 
     +'maksim.tf2   `Data table in CSV format (no row or column labels)'
         ntext = ntext + 1
         text(ntext) = 
     +'maksim.tf3   `Data table in CSV format (row and column labels)'
         ntext = ntext + 1
         text(ntext) = 
     +'maksim_1.html`W3C compliant HTML file containing a data table'
         ntext = ntext + 1
         text(ntext) = 
     +'maksim_2.html`Simple HTML data table with all closure tags'
         ntext = ntext + 1
         text(ntext) = 
     +'maksim_3.html`Minimalist HTML data table with no closure tabs'     
      elseif (pname.eq.'mmfit') then
c
c mmfit
c
         text(ntext) = 'mmfit.tf1  `Exact data for one isoenzyme'
         ntext = ntext + 1
         text(ntext) = 'mmfit.tf2  `mmfit.tf1 with error using ADDERR'
         ntext = ntext + 1
         text(ntext) = 'mmfit.tf3  `Exact data for two isoenzymes'
         ntext = ntext + 1
         text(ntext) = 'mmfit.tf4  `mmfit.tf3 with error using ADDERR'
         ntext = ntext + 1
         text(ntext) = 'hotcold.tf1`Isotope displacement data'
      elseif (pname.eq.'normal') then
c
c normal
c
         text(ntext) = 'normal.tf1`Normal sample with mean 0 variance 1'
      elseif (pname.eq.'polnom') then
c
c polnom
c
         text(ntext) = 'polnom.tf1`Quadratic calibration data'
         ntext = ntext + 1
         text(ntext) = 'polnom.tf2`Predict x = f(y) using polnom.tf1'
         ntext = ntext + 1
         text(ntext) = 'polnom.tf3`Evaluate y = g(x) using polnom.tf1'
      elseif (pname.eq.'qnfit') then
c
c qnfit
c
         ntext = ntext - 1
c
c one function of one variable
c         
         if (required(1)) then
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_data.tf1    `DATA for tutorial example 1: quadratic f(x)'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_model.tf1   `MODEL for tutorial example 1: quadratic f(x)'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf4    `DATA for tutorial example 4: sum of 2'//
     +'Michaelis-Menten functions' 
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_model.tf4   `MODEL for tutorial example 4: sum of 2'//
     +' Michaelis-Mention functions'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf5    `DATA for tutorial example 5: B in A-->B-->C'   
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_model.tf5   `MODEL for tutorial example 5: B in A->B->C'//
     +' not allowing k_1=k_2'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf6    `DATA for tutorial example 6:'//
     +' Two normal pdfs'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_model.tf6   `MODEL for tutorial example 6: Two normal pdfs'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf7    `DATA for tutorial example 7:'//
     +' Two normal cdfs'   
            ntext = ntext + 1        
            text(ntext) =
     +'qnfit_model.tf7   `MODEL for tutorial example 7: Two normal cdfs'   
            ntext = ntext + 1
            text(ntext) = 
     +'pdfb.tf1          `DATA for a beta distribution pdf'
            ntext = ntext + 1
            text(ntext) = 
     +'pdfb.mod          `MODEL for a beta distribution pdf'
            ntext = ntext + 1
            text(ntext) =
     +'cdfb.tf1          `DATA for a beta distribution cdf'
            ntext = ntext + 1
            text(ntext) = 
     +'cdfb.mod          `MODEL for a beta distribution cdf'
     
ccccccccc     +'qnfit.TFL         `Library file to set-up Parameter Limits files'
            ntext = ntext + 1
            text(ntext) = 
     +'gauss3.tf1        `DATA for f(x) = sum of 3 Gaussian pdfs'
            ntext = ntext + 1
            text(ntext) = 
     +'gauss3_e.mod      `MODEL for f(x) = sum of three Gaussian pdfs'         
c            ntext = ntext + 1
c           text(ntext) = 
c     +'mmfit.tf4         `DATA for f(x) = sum of 2 Michaelis-Menten'//
c     +' functions'
c            ntext = ntext + 1
c            text(ntext) = 
c     +'exfit.tf4         `DATA for f(x) = sum of 2 exponentials'//
c     +' functions'
c            ntext = ntext + 1
c            text(ntext) = 
c     +'beta32_pdf.tf1    `DATA for f(x) = beta distribution pdf'
c            ntext = ntext + 1
c            text(ntext) =
c     +'beta32_cdf.tf1    `DATA for f(x) = beta distribution cdf'
         endif
c
c one function of two variables
c         
         if (required(2)) then
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_data.tf2    `DATA  for tutorial example 2: linear g(x,y)'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_model.tf2   `MODEL for tutorial example 2: linear g(x,y)'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit.tf2         `DATA for g(x,y) = Reversible Michaelis-'//
     +'Menten equation'     
         endif
c
c one function of three variables
c         
         if (required(3)) then
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf3    `DATA for tutorial example 3: linear h(x,y,z)'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_model.tf3   `MODEL for tutorial example 3: linear h(x,y,z)'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit.tf3         `DATA for h(x,y,z) = a plane in 3D space'
            ntext = ntext + 1
            text(ntext) =
     +'e04fyf.tf1        `DATA for h(x,y,z) = E04FYF model'
         endif
c
c one differential equation 
c
         if (required(4)) then
            ntext = ntext + 1        
            text(ntext) =
     +'deqn_data.tf1     `DATA for irreversible substrate depletion' 
            ntext = ntext + 1        
            text(ntext) =
     +'deqn_model.tf1    `MODEL for irreversible substrate depletion'      
            ntext = ntext + 1        
            text(ntext) =
     +'deqn_data.tf2     `DATA for von Bertalanffy model'
            ntext = ntext + 1        
            text(ntext) =
     +'deqn_model.tf2    `MODEL for von Bertalanffy equation'      
            ntext = ntext + 1        
            text(ntext) =
     +'deqn_data.tf3     `DATA for modified von Bertalanffy model' 
            ntext = ntext + 1        
            text(ntext) =
     +'deqn_model.tf3    `MODEL for modified von Bertalanffy equation' 
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_ode.tf1     `DATA for Irreversible Michaelis-Menten'//
     +' S(t) ODE'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_ode.tf2     `DATA for Von Bertalannfy ODE'
            ntext = ntext + 1
            text(ntext) = 
     +'qnfit_ode.tf3     `DATA for Allometric up-down ODE'
         endif
c
c n functions of one variable
c     
         if (required(5)) then
            ntext = ntext + 1
            text(ntext) =
     +'line3.TFL         `DATA Library file for line3.mod'
            ntext = ntext + 1
            text(ntext) =
     +'line3.mod         `MODEL for 3 unlinked lines'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf8    `DATA Library file for tutorial example 8:'//
     +'  A->B->C'
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_model.tf8   `MODEL for tutorial example 8:  A->B->C'//
     +' allowing k_1=k_2'               
            ntext = ntext + 1
            text(ntext) =
     +'qnfit_data.tf9    `DATA Library file for tutorial example 9:'//
     +' convolution f*g'  
            ntext = ntext + 1        
            text(ntext) =
     +'qnfit_model.tf9   `MODEL for tutorial example 9: convolution f*g'  
                ntext = ntext + 1
            text(ntext) = 
     +'consec3.TFL       `DATA Library file for consec3.mod: A->B->C'           
            ntext = ntext + 1
            text(ntext) =
     +'consec3.mod       `MODEL for B in A->B->C allowing for k_1 = k_2'
            ntext = ntext + 1
            text(ntext) = 
     +'convolv3.TFL      `DATA Library file for convolv3.mod'
            ntext = ntext + 1
            text(ntext) =
     +'convolv3_e.mod    `MODEL for convolution f, g, and f*g'
         endif
         

      elseif (pname.eq.'rffit') then
c
c rffit
c
         text(ntext) = 'rffit.tf1`Exact 2:2, f(0)=0, f(infinity)=2'
         ntext = ntext + 1
         text(ntext) = 'rffit.tf2`Exact 1:2, f(0)=0, f(infinity)=0'
         ntext = ntext + 1
         text(ntext) = 'rffit.tf3`Exact 2:2, f(0)=1 , f(infinity)=3/5'
         ntext = ntext + 1
         text(ntext) = 'rffit.tf4`Exact 2:3, f(0)=1, f(infinity)=0'
         ntext = ntext + 1
         text(ntext) = 'rffit.tf5`Exact 4:4, with two turning points'
      elseif (pname.eq.'rstest') then
c
c rstest
c
         text(ntext) = 'anova1.tfl  `Library file for 1-way ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova2.tf1  `Data for 2-way ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova3.tf1  `Data for Latin square ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova4.tf1  `Data for groups-subgroups ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova5.tf1  `Data for factorial ANOVA'
         ntext = ntext + 1
         text(ntext) = 'anova6.tf1  `Data for repeat measures ANOVA'
         ntext = ntext + 1
         text(ntext) = 'cochranq.tf1`Data for Cochran Q test'
         ntext = ntext + 1
         text(ntext) = 'g08daf.tf1  `Kendall coefficient of concordance'
         ntext = ntext + 1
         text(ntext) = 'normal.tf1  `Data for KS 1-sample test'
         ntext = ntext + 1
         text(ntext) = 'npcorr.tfl  `Data for nonparametric correlation'
         ntext = ntext + 1
         text(ntext) = 'rstest.tf1  `Signed residuals for run test'
         ntext = ntext + 1
         text(ntext) = 'ttest.tf2   `MW-U or KS-2 with ttest.tf3'
         ntext = ntext + 1
         text(ntext) = 'ttest.tf3   `MW-U or KS-2 with ttest.tf2'
      elseif (pname.eq.'sffit') then
c
c sffit
c
         text(ntext) = 'sffit.tf1`Exact data for one binding site'
         ntext = ntext + 1
         text(ntext) = 'sffit.tf2`sffit.tf1 with error using ADDERR'
         ntext = ntext + 1
         text(ntext) = 'sffit.tf3`Exact data for two binding sites'
         ntext = ntext + 1
         text(ntext) = 'sffit.tf4`sffit.tf3 with error using ADDERR'
      elseif (pname.eq.'simdem') then
c
c simdem
c
         text(ntext) = 'metafile.tf1`Multiple plots'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf2`Double plot metafile'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf3`Barchart metafile'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf4`Piechart metafile'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf5`Labels metafile'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf6`Vector Field metafile'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf7`Biplot metafile'
         ntext = ntext + 1
         text(ntext) = 'metafile.tf8`Dendrogram metafile'        
      elseif (pname.eq.'simplot') then
c
c simplot
c
         ntext = ntext - 1!since ntext has to be 2 not 3 at this stage2 
         if (required(1) .or. required(5)) then
            ntext = ntext + 1
            text(ntext) =
     +'vector.tf1   `Arbitrary 5 row vector file'
            ntext = ntext + 1
            text(ntext) =
     +'vector.tf2   `Arbitrary 7 row vector file'
         endif
         if (required(1) .or. required(4) .or. required(7)) then
            ntext = ntext + 1
            text(ntext) = 
     +'matrix.tf1   `Arbitrary 5 row  by 5 column matrix'
            ntext = ntext + 1
            text(ntext) = 
     +'matrix.tf2   `Arbitrary 7 row by 5 column matrix'
         endif
         
         if (required(2)) then
            ntext = ntext + 1
            text(ntext) = 'simfig1.TFL  `Library file for 3 plots'
            ntext = ntext + 1
            text(ntext) = 
     +'simplot.tf1  `Data with error bars plotted by simfig.tfL'
            ntext = ntext + 1
            text(ntext) =
     +'simplot.tf2  `Best fit curve for model 1 plotted by simfig.tfL'
            ntext = ntext + 1
            text(ntext) = 
     +'simplot.tf3  `Best fit curve for model 2 plotted by simfig.tfL' 
            ntext = ntext + 1
            text(ntext) = 'w_simfig1.cfg`Config. file for simfig1.tfL'  
         endif
         
         if (required(3)) then    
            ntext = ntext + 1
            text(ntext) = 'plot2.tf1    `Data for double plot LHS'
            ntext = ntext + 1
            text(ntext) = 'plot2.tf2    `Data for double plot RHS'
            ntext = ntext + 1
            text(ntext) = 'plot2.tf3    `Data for double plot RHS'    
         endif  
          
         if (required(2)) then      
            ntext = ntext + 1
            text(ntext) = 'errorbar.tf1 `Data for vertical error bars'
            ntext = ntext + 1
            text(ntext) = 'errorbar.tf2 `Data for slanting error bars'
         endif

         if (required(4)) then
            ntext = ntext + 1
            text(ntext) = 
     +'barchart.tf1 `Barchart demo 1: box and whisker'
            ntext = ntext + 1
            text(ntext) =
     +'barchart.tf2 `Barchart demo 2: fill styles'
            ntext = ntext + 1
            text(ntext) =
     +'barchart.tf3 `Barchart demo 3: adjacent groups'
            ntext = ntext + 1
            text(ntext) = 
     +'barchart.tf4 `Barchart demo 4: stacked groups'
            ntext = ntext + 1
            text(ntext) = 
     +'barchart.tf5 `Barchart demo 5: overlayed groups'
            ntext = ntext + 1
            text(ntext) = 
     +'barchart.tf6 `Barchart demo 6: up and down bars'
            ntext = ntext + 1
            text(ntext) = 
     +'barchart.tf7 `Curve to overlay on barchart.tf6'
         endif
         
         if (required(5)) then
            ntext = ntext + 1
            text(ntext) = 'piechart.tf1 `Piechart demo 1: fill styles'
            ntext = ntext + 1
            text(ntext) = 'piechart.tf2 `Piechart demo 2: displacements'
            ntext = ntext + 1
            text(ntext) = 'piechart.tf3 `Piechart demo 3: features'
         endif

         if (required(7)) then
            ntext = ntext + 1
            text(ntext) = 'surface.tf1  `3D surface demo 1: four spikes'
            ntext = ntext + 1
            text(ntext) = 'surface.tf2  `3D surface demo 2: smooth peak'
            ntext = ntext + 1
            text(ntext) = 'surface.tf3  `3D surface demo 3: folds'
            ntext = ntext + 1
            text(ntext) = 'surface.tf4  `3D surface demo 4: waves'  
            ntext = ntext + 1
            text(ntext) = 'surface.tf5  `3D surface demo 5: z = x^2-y^2'        
         endif
         
         if (required(8)) then
            ntext = ntext + 1
            text(ntext) = 'spiral.TFL   `Library file for 3D spirals'
            ntext = ntext + 1
            text(ntext) = 'spiral.tf1   `File referenced by spiral.TFL'
            ntext = ntext + 1
            text(ntext) = 'spiral.tf2   `File referenced by spiral.TFL'
         endif

         if (required(6)) then
            ntext = ntext + 1
            text(ntext) = 
     +'vfield.tf1   `Differental equation Vector Field data'
             ntext = ntext + 1
            text(ntext) = 
     +'vfield.tf2   `Arbitrary Vector Field data'
         endif

         if (required(2)) then
            ntext = ntext + 1
            text(ntext) = 'orbit.TFL    `Library file for ODE orbits'
         endif

         if (required(9)) then
            ntext = ntext + 1
            text(ntext) = 'rose.mod     `Model: parameteric r(theta)'
            ntext = ntext + 1
            text(ntext) = 'ellipse.mod  `Model: parametric x(t),y(t)'
            ntext = ntext + 1
            text(ntext) = 
     +'helix.mod    `Model: parametric x(t),y(t),z(t)'
         endif
         
         if (required(10)) then
            ntext = ntext + 1
            text(ntext) = 'metafile.tf1 `simfig1.TFL plus w_simfig1.cfg'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf2 `Double plot metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf3 `Barchart metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf4 `Piechart metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf5 `Labels metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf6 `Vector Field metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf7 `Biplot metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf8 `Dendrogram metafile'
            ntext = ntext + 1
            text(ntext) = 'metafile.tf9 `Forest Plot'
         endif

      elseif (pname.eq.'simstat') then
c
c simstat
c
         ntext = ntext - 1

         if (required(1)) then!Data Exploration
            ntext = ntext + 1
            text(ntext) = 'anova1.TFL    `Library file of vectors'
            ntext = ntext + 1
            text(ntext) = 'cluster.tf1   `Matrix with no missing values'
            ntext = ntext + 1
            text(ntext) = 'incomplete.tf1`Matrix with missing values'
            ntext = ntext + 1
            text(ntext) = 'normal.tf1    `50 Normal(0,1) random numbers' 
            ntext = ntext + 1
            text(ntext) = 'ttest.tf2     `Paired t test with ttest.tf3'
            ntext = ntext + 1
            text(ntext) = 'ttest.tf3     `Paired t test with ttest.tf2'
            ntext = ntext + 1
            text(ntext) = 
     +'ttest.tf6     `Multiple t tests with indicator flags'
            ntext = ntext + 1
            text(ntext) = 'matrix.tf1    `Arbitrary 5 by 5 data set'  
            ntext = ntext + 1
            text(ntext) = 'matrix.tf2    `Arbitrary 7 by 5 data set'
            ntext = ntext + 1
            text(ntext) = 'vector.tf1    `Arbitrary 5 by 1 data set'
            ntext = ntext + 1
            text(ntext) = 'vector.tf2    `Arbitrary 7 by 1 data set'  
            ntext = ntext + 1
            text(ntext) = 'vector.tf3    `Arbitrary 4 by 1 data set'  
         endif 

         if (required(2)) then!Standard Tests
            ntext = ntext + 1
            text(ntext) = 'chisqd.tf2  `Observed chi-square frequencies'
            ntext = ntext + 1
            text(ntext) = 'chisqd.tf3  `Expected chi-square frequencies'
            ntext = ntext + 1
            text(ntext) = 'chisqd.tf4  `Fisher exact text'
            ntext = ntext + 1
            text(ntext) = 'cochranq.tf1`Cochran Q test'
            ntext = ntext + 1
            text(ntext) = 
     +'g08agf.tf1  `Wilcoxon signed rank test with g08agf.tf2'
            ntext = ntext + 1
            text(ntext) =
     +'g08agf.tf1  `Wilcoxon signed rank test with g08agf.tf1'
            ntext = ntext + 1
            text(ntext) =
     +'g08ahf.tf1  `Mann-Whitney U test with g08ahf.tf2'  
            ntext = ntext + 1
            text(ntext) =
     +'g08ahf.tf2  `Mann-Whitney U test with g08ahf.tf1'
            ntext = ntext + 1
            text(ntext) =
     +'g08cbf.tf1  `Kolmogorov-Smirnov 1-sample test'
            ntext = ntext + 1
            text(ntext) = 'mcnemar.tf1 `McNemar test'
            ntext = ntext + 1
            text(ntext) = 'normal.tf1  `50 Normal(0,1) random numbers' 
            ntext = ntext + 1
            text(ntext) = 'poisson.tf1 `40 Poisson numbers'
            ntext = ntext + 1
            text(ntext) = 'ttest.tf2   `t test paired with ttest.tf3'
            ntext = ntext + 1
            text(ntext) = 'ttest.tf3   `t test paired with ttest.tf2'
            ntext = ntext + 1
            text(ntext) = 'matrix.tf1  `Arbitrary 5 by 5 data set'  
            ntext = ntext + 1
            text(ntext) = 'matrix.tf2  `Arbitrary 7 by 5 data set'
            ntext = ntext + 1
            text(ntext) = 'vector.tf1  `Arbitrary 5 by 1 data set'
            ntext = ntext + 1
            text(ntext) = 'vector.tf2  `Arbitrary 7 by 1 data set'
            ntext = ntext + 1
            text(ntext) = 'vector.tf3  `Arbitrary 4 by 1 data set'  
         endif
         
         if (required(3)) then!ANOVA
            text(ntext) = 'anova1.tfl    `Library file for 1-way ANOVA'
            ntext = ntext + 1
            text(ntext) = 'anova1.tf1    `1-way ANOVA'
            ntext = ntext + 1
            text(ntext) = 'anova2.tf1    `2-way ANOVA (Friedman)'
            ntext = ntext + 1
            text(ntext) = 'anova2.tf2    `2-way ANOVA'
            ntext = ntext + 1
            text(ntext) = 'anova3.tf1    `Latin Square ANOVA'
            ntext = ntext + 1
            text(ntext) = 'anova4.tf1    `Groups-subgroups ANOVA'
            ntext = ntext + 1
            text(ntext) =
     +'anova5.tf1    `Factorial ANOVA: 2 factors, no blocking'
            ntext = ntext + 1
            text(ntext) =
     +'anova5.tf2    `Factorial ANOVA: 2 factors, 3 blocks'
            ntext = ntext + 1
            text(ntext) =
     +'anova5.tf3    `Factorial ANOVA: 3 factors, no blocking'
            ntext = ntext + 1
            text(ntext) =
     +'anova5.tf4    `Factorial ANOVA: 3 factors, 3 blocks'
            ntext = ntext + 1
            text(ntext) = 'anova6.tf1    `Repeated measures ANOVA'
            ntext = ntext + 1
            text(ntext) = 'incomplete.tf1`incomplete matrix' 
         endif
         
         if (required(4)) then!Analysis of Proportions
            ntext = ntext + 1
            text(ntext) = 'binomial.tf1`50 binomial numbers N=10, p=0.5'
            ntext = ntext + 1
            text(ntext) = 
     +'binomial.tf2`Analysis of proportions (2 columns Y, N) size 5'
            ntext = ntext + 1
            text(ntext) =
     +'binomial.tf3`Analysis of proportions (3 columns Y, N, x) size 5'
            ntext = ntext + 1
            text(ntext) =
     +'binomial.tf4`Analysis of proportions (3 columns Y, N, x) size 5'
            ntext = ntext + 1
            text(ntext) =
     +'binomial.tf5`Analysis of proportions (3 columns Y, N, x) size 20'
            ntext = ntext + 1
            text(ntext) = 'meta.tf1    `Cochran-Mantel-Haenzel'
            ntext = ntext + 1
            text(ntext) = 
     +'trinom.tf1  `Trinomial contour plotting (with trinom.tf2)'
            ntext = ntext + 1
            text(ntext) = 
     +'trinom.tf2  `Trinomial contour plotting (with trinom.tf1)'
         endif

         if (required(5)) then!Multivariate         
            ntext = ntext + 1
            text(ntext) = 
     +'cluster.tf1 `Cluster analysis (dendrogram, PCA)'
            ntext = ntext + 1
            text(ntext) = 
     +'g02baf.tf1  `Pearson product moment correlation' 
            ntext = ntext + 1
            text(ntext) = 
     +'g02bnf.tf1  `Spearman-Kendal-tau nonparametric correlation'  
            ntext = ntext + 1
            text(ntext) = 
     +'g02byf.tf1  `Partial correlation (2 subgroups)' 
            ntext = ntext + 1
            text(ntext) = 
     +'g02laf.tf1  `Partial least squares X-predictor data'
            ntext = ntext + 1
            text(ntext) = 
     +'g02laf.tf2  `Partial least squares Y-response data' 
            ntext = ntext + 1
            text(ntext) = 
     +'g03aaf.tf1  `Principal components'                      
            ntext = ntext + 1
            text(ntext) = 
     +'g03adf.tf1  `Canonical correlation (2 subroups)'  
            ntext = ntext + 1
            text(ntext) = 
     +'g03baf.tf1  `Orthogonal rotation (Varimax/Quartimax)'         
            ntext = ntext + 1
            text(ntext) = 
     +'g03bcf.tf1  `Procrustes rotation (with g03bcf.tf2)' 
            ntext = ntext + 1
            text(ntext) = 
     +'g03bcf.tf2  `Procrustes rotation (with g03bcf.tf1)'                 
            ntext = ntext + 1
            text(ntext) =
     +'g03caf.tf1  `Factor analysis data'
            ntext = ntext + 1
            text(ntext) = 
     +'g03ecf.tf1  `Clustering and dendrograms'
            ntext = ntext + 1
            text(ntext) = 
     +'g03eff.tf1  `K-means clustering'  
            ntext = ntext + 1
            text(ntext) = 
     +'g03faf.tf1  `Distance matrix scaling'              
            ntext = ntext + 1
            text(ntext) = 
     +'houses.tf1  `Biplot data'
            ntext = ntext + 1
            text(ntext) = 
     +'kmeans.tf1  `K-means clustering'
            ntext = ntext + 1
            text(ntext) =
     +'kmeans.tf2  `Starting estimates for kmeans.tf1'
            ntext = ntext + 1
            text(ntext) =
     +'manova1.tf1 `MANOVA (2 groups,5 variables)'
            ntext = ntext + 1
            text(ntext) = 
     +'matrix_a.tf1`Directed correlation with matrix_b.tf1'
            ntext = ntext + 1
            text(ntext) =
     +'matrix_b.tf1`Directed correlation with matrix_a.tf1'
            ntext = ntext + 1
            text(ntext) =
     +'npcorr.TFL  `Library file for Nonparametric correlation'
         endif
         
         if (required(6)) then!Regression
            ntext = ntext + 1
            text(ntext) = 'line.tf1    `A straight line'
            ntext = ntext + 1
            text(ntext) =
     +'linfit.tf1  `Multi-linear regression (rank deficient)'
            ntext = ntext + 1
            text(ntext) = 
     +'linfit.tf2  `Multi-linear regression (full rank)'
            ntext = ntext + 1
            text(ntext) = 'logistic.tf1`Binary logistic regression'
            ntext = ntext + 1
            text(ntext) = 'polnom.tf1  `Quadratic for curve-fitting'
            ntext =  ntext + 1
            text(ntext) = 
     +'g08raf.tf1  `Regression on ranks (uncensored)'
            ntext =  ntext + 1
            text(ntext) = 
     +'g08rbf.tf1  `Regression on ranks (censored)'
         endif

         if (required(7)) then!GLM
            ntext = ntext + 1
            text(ntext) =
     +'cox.tf1     `Cox proportional hazards'
            ntext = ntext + 1
            text(ntext) = 
     +'cox.tf2     `Cox proportional hazards (g12baf)'
            ntext = ntext + 1
            text(ntext) = 
     +'cox.tf3     `Cox proportional hazards)'
            ntext = ntext + 1
            text(ntext) = 
     +'cox.tf4     `Cox proportional hazards'
            ntext = ntext + 1
            text(ntext) = 
     +'glm.tf1     `GLM normal/reciprocal-link (g02caf)'
            ntext = ntext + 1
            text(ntext) = 
     +'glm.tf2     `GLM binomial/logistic-link (g02cbf)'
            ntext = ntext + 1
            text(ntext) = 
     +'glm.tf3     `GLM Poisson/log-link (g02gcf)'
            ntext = ntext + 1
            text(ntext) =
     +'glm.tf4     `GLM gamma/reciprocal-link (g02gdf)'
            ntext = ntext + 1
            text(ntext) =
     +'ld50.tf1    `Dose-response GLM/LD50 (format 1)'
            ntext = ntext + 1
            text(ntext) =
     +'ld50.tf2    `Dose-response GLM/LD50 (format 2)'
            ntext = ntext + 1
            text(ntext) =
     +'logistic.tf1`Binary logistic regression'
            ntext = ntext + 1
            text(ntext) =
     +'strata.tf1  `Stratified binomial logistic (g11caf)'
         endif
         
         if (required(8)) then!Smoothing/Time-Series/survival
            ntext = ntext + 1
            text(ntext) = 'cox.tf4     `Cox regression' 
            ntext = ntext + 1
            text(ntext) = 'g10caf.tf1  `T4253H twice smoother'
            ntext = ntext + 1
            text(ntext) = 
     +'j06caf.tf1  `Smooth interpolation for y = f(x)'
            ntext = ntext + 1
            text(ntext) = 
     +'j06ccf.tf1  `Smooth interpolation for x(t), y(t)'
            ntext = ntext + 1
            text(ntext) = 'g10caf.tf1  `T4253H twice smoother'
            ntext = ntext + 1
            text(ntext) = 'g13dmf.tf1  `Auto and Cross-Correlation'
            ntext = ntext + 1
            text(ntext) = 
     +'survive.tf2 `Kaplan-Meier 1-sample and Weibull curve (g07bef)'
            ntext = ntext + 1
            text(ntext) =
     +'survive.tf3 `Kaplan-Meier 2-sample Survival data'
            ntext = ntext + 1
            text(ntext) = 
     +'survive.tf4 `Kaplan-Meier placebo data for survive.tf3'
            ntext = ntext + 1
            text(ntext) =
     +'times.tf1   `ARIMA plus forecasts for time series analysis '
         endif

         if (required(9)) then!statistical calculations
            ntext = ntext + 1
            text(ntext) = 
     +'fdr_bh.tf1  `Data for BH false detection rates'
            ntext = ntext + 1
            text(ntext) =
     +'matrix_p.tf1`p(i,j) values values for false detection rates'
            ntext = ntext + 1           
            text(ntext) = 'normal.tf1  `50 normal pseudo random nombers'
            ntext = ntext + 1
            text(ntext) = 'ttest.tf2   `Sample paired with ttest.tf3'
            ntext = ntext + 1 
            text(ntext) = 'ttest.tf3   `Sample paired with ttest.tf2' 
         endif  
           
        
         if (required(10)) then!Numerical
            ntext = ntext + 1
            text(ntext) = 'c02agf.tf1  `Polynomial coefficients'
            ntext = ntext + 1
            text(ntext) = 'f01blf.tf1  `Pseudo inverse and rank'
            ntext = ntext + 1
            text(ntext) = 'f08kff.tf1  `Singular value decomposition' 
            ntext = ntext + 1
            text(ntext) = 'g03baf.tf1  `Orthogonal rotation' 
            ntext = ntext + 1
            text(ntext) = 
     +'g03bcf.tf1  `X-matrix for Procrustes rotation'
            ntext = ntext + 1
            text(ntext) = 
     +'g03bcf.tf2  `Y-matrix for Procrustes rotation'
            ntext = ntext + 1
            text(ntext) = 'matrix.tf1  `5 by 5 arbitrary matrix'
            ntext = ntext + 1
            text(ntext) = 'matrix.tf2  `7 by 5 arbitrary matrix'
            ntext = ntext + 1
            text(ntext) =
     +'matrix.tf3  `4 by 4 positive definite symmetric matrix'      
            ntext = ntext + 1
            text(ntext) = 'matrix.tf4  `4 by 4 symmetric matrix'  
            ntext = ntext + 1
            text(ntext) = 'vector.tf1  `5-vector paired with matrix.tf1'
            ntext = ntext + 1
            text(ntext) = 'vector.tf2  `7-vector paired with matrix.tf2'
            ntext = ntext + 1
            text(ntext) = 'vector.tf3  `4-vector paired with matrix.tf3'      
         endif       
      elseif (pname.eq.'spline') then
c
c spline
c
         text(ntext) = 'spline.tf1 `Spline file from e02baf.tf1'
         ntext = ntext + 1
         text(ntext) = 'spline.tf2 `Spline file from compare.tf1'
         ntext = ntext + 1
         text(ntext) = 'spline.tf3 `Spline file from compare.tf2'
         ntext = ntext + 1
         text(ntext) = 'compare.tf1`Data to compare with compare.tf2'
         ntext = ntext + 1
         text(ntext) = 'compare.tf2`Data to compare with compare.tf1'
         ntext = ntext + 1
         text(ntext) = 'e02baf.tf1 `Data for NAG example e02baf'
         ntext = ntext + 1
         text(ntext) = 'e02baf.tf2 `Starter knot set for e02baf.tf1'
      elseif (pname.eq.'ttest') then
c
c ttest
c
         text(ntext) = 'ttest.tf1`Fifty numbers from t with NDOF = 10'
         ntext = ntext + 1
         text(ntext) = 'ttest.tf2`For paired t test with ttest.tf3'
         ntext = ntext + 1
         text(ntext) = 'ttest.tf3`For paired t test with ttest.tf2'
         ntext = ntext + 1
         text(ntext) = 'ttest.tf4`For unpaired t test with ttest.tf5'
         ntext = ntext + 1
         text(ntext) = 'ttest.tf5`For unpaired t test with ttest.tf4'
      elseif (pname.eq.'usermod') then
c
c usermod
c
      text(ntext) =
     +'usermod1_e.tf1 `Function of 1 variable: a line                  '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf2 `Function of 1 variable: a quadratic             '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf3 `Function of 1 variable: a cubic                 '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf4 `Function of 1 variable: a 2:2 rational function '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf5 `Function of 1 variable: one exponential         '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf6 `Function of 1 variable: two exponentials        '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf7 `Function of 1 variable: normal integral         '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf8 `Function of 1 variable: capillary diffusion     '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1_e.tf9 `Function of 1 variable: damped SHM              '
       ntext = ntext + 1
       text(ntext) =
     +'usermod2_e.tf1 `Function of 2 variables: linear                 '
       ntext = ntext + 1
       text(ntext) =
     +'usermod3_e.tf1 `Function of 3 variables: linear                 '
       ntext = ntext + 1
       text(ntext) =
     +'usermod4_e.tf1 `Function of 4 variables: integrand for D01FCF   '
       ntext = ntext + 1
       text(ntext) =
     +'usermodd_e.tf1 `Differential equation                           '
       ntext = ntext + 1
       text(ntext) =
     +'usermods_e.tf1 `Special functions with 1 argument               '
       ntext = ntext + 1
       text(ntext) =
     +'usermods_e.tf2 `Special functions with 2 arguments              '
       ntext = ntext + 1
       text(ntext) =
     +'usermods_e.tf3 `Special functions with 3 arguments              '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn_e.tf1 `Four functions of 1 variable for USERMOD        '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn_e.tf2 `Two functions of 2 variables for USERMOD        '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn_e.tf3 `Three functions of 3 variables for USERMOD      '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn_e.tf4 `Nine functions of 9 variables for USERMOD       '
       ntext = ntext + 1
       text(ntext) =
     +'camalot_e.mod  `Logarithmic spiral as used by Camalots          '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod2_e.tf2  `Model for 2 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'ellipse_e.mod  `Parameteric ellipse equation                    '
       ntext = ntext + 1
       text(ntext) =
     +'helix_e.mod    `Parameteric helix equation                      '
       ntext = ntext + 1
       text(ntext) =
     +'line3_e.mod    `Model for fitting 3 lines                       '
       ntext = ntext + 1
       text(ntext) =
     +'optimum_e.mod  `Model for optimizing Rosenbruck test function   '
       ntext = ntext + 1
       text(ntext) =
     +'rose_e.mod     `Parameteric rose equation                       '
       ntext = ntext + 1
       text(ntext) =
     +'c05adf_e.mod   `(NAG) 1 function  of 1 variable                 '
       ntext = ntext + 1
       text(ntext) =
     +'c05nbf_e.mod   `(NAG) 9 functions of 9 variables                '
       ntext = ntext + 1
       text(ntext) =
     +'d01ajf_e.mod   `(NAG)1 function  of 1 variable                  '
       ntext = ntext + 1
       text(ntext) =
     +'d01eaf_e.mod   `(NAG) 10 functions of 4 variables               '
       ntext = ntext + 1
       text(ntext) =
     +'d01fcf_e.mod   `(NAG) 1 function  of 4 variables                '
       ntext = ntext + 1
       text(ntext) =
     +'e04fyf_e.mod   `(NAG) 1 function  of 3 variables                '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod1.tf1    `Model for 1 differential equation               '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod1.tf2    `Model for 1 differential equation               '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod1.tf3    `Model for 1 differential equation               '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod1.tf4    `Model for 1 differential equation               '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod1.tf5    `Model for 1 differential equation               '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod1.tf6    `Model for 1 differential equation               '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod2.tf1    `Model for 2 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod2.tf2    `Model for 2 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod2.tf3    `Model for 2 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod3.tf1    `Model for 3 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod3.tf2    `Model for 3 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'deqmod4.tf1    `Model for 4 differential equations              '
       ntext = ntext + 1
       text(ntext) =
     +'ellipse.mod    `Parameteric ellipse equation                    '
       ntext = ntext + 1
       text(ntext) =
     +'family2D.mod   `2-D family of diffusion curves                  '
       ntext = ntext + 1
       text(ntext) =
     +'family3D.mod   `3-D family of diffusion curves                  '
       ntext = ntext + 1
       text(ntext) =
     +'helix.mod      `Parameteric helix equation                      '
       ntext = ntext + 1
       text(ntext) =
     +'if.mod         `Illustrates how to use logical commands         '
       ntext = ntext + 1
       text(ntext) =
     +'impulse.mod    `Model illustrating 5 single impulse functions   '
       ntext = ntext + 1
       text(ntext) =
     +'line3.mod      `Model for fitting 3 lines                       '
       ntext = ntext + 1
       text(ntext) =
     +'optimum.mod    `Model for optimizing Rosenbruck test function   '
       ntext = ntext + 1
       text(ntext) =
     +'periodic.mod   `Model illustrating 7 periodic impulse functions '
       ntext = ntext + 1
       text(ntext) =
     +'rose.mod       `Parameteric rose equation                       '
       ntext = ntext + 1
       text(ntext) =
     +'tangent.mod    `Tangent to logarithmic spiral in camalot.mod    '
       ntext = ntext + 1
       text(ntext) =
     +'twister.mod    `Model for 3D projections onto 2D planes         '
       ntext = ntext + 1
       text(ntext) =
     +'updown.mod     `Model with a cross-over point at 1 critical x   '
       ntext = ntext + 1
       text(ntext) =
     +'updownup.mod   `Model with a cross-over point at 2 critical x   '
       ntext = ntext + 1
       text(ntext) =
     +'user1.mod      `Illustrates how to use arbitrary models         '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf1   `Function of 1 variable: a line                  '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf2   `Function of 1 variable: a quadratic             '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf3   `Function of 1 variable: a cubic                 '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf4   `Function of 1 variable: a 2:2 rational function '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf5   `Function of 1 variable: one exponential         '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf6   `Function of 1 variable: two exponentials        '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf7   `Function of 1 variable: normal integral         '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf8   `Function of 1 variable: capillary diffusion     '
       ntext = ntext + 1
       text(ntext) =
     +'usermod1.tf9   `Function of 1 variable: damped SHM              '
       ntext = ntext + 1
       text(ntext) =
     +'usermod2.tf1   `Function of 2 variables: linear                 '
       ntext = ntext + 1
       text(ntext) =
     +'usermod3.tf1   `Function of 3 variables: linear                 '
       ntext = ntext + 1
       text(ntext) =
     +'usermod4.tf1   `Function of 4 variables: integrand for D01FCF   '
       ntext = ntext + 1
       text(ntext) =
     +'usermodd.tf1   `Differential equation                           '
       ntext = ntext + 1
       text(ntext) =
     +'usermods.tf1   `Special functions with 1 argument               '
       ntext = ntext + 1
       text(ntext) =
     +'usermods.tf2   `Special functions with 2 arguments              '
       ntext = ntext + 1
       text(ntext) =
     +'usermods.tf3   `Special functions with 3 arguments              '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn.tf1   `Four functions of 1 variable for USERMOD        '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn.tf2   `Two functions of 2 variables for USERMOD        '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn.tf3   `Three functions of 3 variables for USERMOD      '
       ntext = ntext + 1
       text(ntext) =
     +'usermodn.tf4   `Nine functions of 9 variables for USERMOD       '
       ntext = ntext + 1
       text(ntext) =
     +'usermodx.tf1   `Extra sub-model for evaluation                  '
       ntext = ntext + 1
       text(ntext) =
     +'usermodx.tf2   `Extra sub-model for quadrature                  '
       ntext = ntext + 1
       text(ntext) =
     +'usermodx.tf3   `Extra sub-model for root finding                '
       ntext = ntext + 1
       text(ntext) =
     +'usermodx.tf4   `Extra sub-models for roots involving quadrature '
       ntext = ntext + 1
       text(ntext) =
     +'usermodx.tf5   `Extra sub-model for multidimensional quadrature '
       ntext = ntext + 1
       text(ntext) =
     +'camalot.mod    `Logarithmic spiral as used by Camalots          '
       ntext = ntext + 1
       text(ntext) =
     +'cheby.mod      `Model illustrating Chebyshev expansion          '
       ntext = ntext + 1
       text(ntext) =
     +'consec3.mod    `Irreversible chemical reaction A --> B --> C    '
       ntext = ntext + 1
       text(ntext) =
     +'convolve.mod   `Model for a convolution integral                '
       ntext = ntext + 1
       text(ntext) =
     +'convolv3.mod   `Convolution integral for all components         '
       ntext = ntext + 1
       text(ntext) =
     +'dble_exp.mod   `Chemical kinetic double exponential model       '
       ntext = ntext + 1
       text(ntext) =
     +'c05adf.mod     `(NAG) 1 function  of 1 variable                 '
       ntext = ntext + 1
       text(ntext) =
     +'c05nbf.mod     `(NAG) 9 functions of 9 variables                '
       ntext = ntext + 1
       text(ntext) =
     +'d01ajf.mod     `(NAG) 1 function  of 1 variable                 '
       ntext = ntext + 1
       text(ntext) =
     +'d01eaf.mod     `(NAG) 10 functions of 4 variables               '
       ntext = ntext + 1
       text(ntext) =
     +'d01fcf.mod     `(NAG) 1 function  of 4 variables                '
       text(ntext) =
     +'e04fyf.mod     `(NAG) 1 function  of 3 variables                '
      else
c
c not called from a simfit program
c
         again = .false.
      endif
c
c make the first two menu items Cancel and Help/Test files
c
      if (again) then
         numopt = ntext - nstart + 1
         numdec = nstart
         text(numdec) = 'Cancel'
         if (viewer) then
            text(numdec + 1) = 'Files'
         else
            text(numdec + 1) = 'Help'
         endif
         k = index(text(3),grave)
         if (k.ge.5) then
c
c add graves to text(1) and text(2)
c           
            text(1)(k:k) = grave
            text(2)(k:k) = grave
         endif   
      endif
      end
c
c
      recursive integer function i_nag_demo()
c
c list box for nag examples
c
      implicit   none
      integer    isend, nfiles
      parameter (isend = 2, nfiles = 200)
      integer    i_ofiles_count, i_ofiles_numdec
      character  fsav(nfiles)*1024, temp*1024
      character  gsav1(nfiles)*1024, gsav3(nfiles)*1024
      character  mode*8
      character  blank*1, fname*1024
      parameter (blank = ' ')
      logical    there
      logical    demo, store
      parameter (demo = .true., store = .true.)
      common / i_ofiles_info / i_ofiles_count, i_ofiles_numdec
      common / i_ofiles_sav  / fsav, gsav1, gsav3, mode, temp
      external   x_demsav, x_nagdem
      external   window_update@
      call x_nagdem (isend,
     +               fname)
      if (fname.eq.blank) then
         there = .false.
      else
         inquire (file = fname, exist = there)
      endif
      if (there) then
c
c a file has been selected
c
         temp = fname
         call window_update@(temp)
         mode = 'opened'
         call window_update@(mode)
         call x_demsav (demo, store)
         i_nag_demo = 0
         i_ofiles_numdec = 1
      else
c
c no action
c
         i_nag_demo = 2
         i_ofiles_numdec = 5
      endif
      end
