c
c


c
c
      subroutine w_palett (icolor, mode)
c
c action: choose from a colour palette
c author: w.g.bardsley, university of manchester, u.k., 29/11/2000
c
c         02/03/2002 rearranged colours as follows:
c                     0-60 = rainbow
c                    60-71 = grey scale
c         16/01/2003 added numbering and call backs for rgb and help
c         12/08/2003 replaced old dbos routines draw_line@, draw_text@, fill_rectangle@
c                    by draw_line_between@, draw_characters@, draw_filled_rectangle@
c         16/01/2004 added code to initialise mouse
c         21/07/2004 added call to numrgb$ in rgb_save/rgb_restore to redefine colours
c         18/11/2006 suppressed toolwindow and added intents
c         04/02/2007 edited for w_clearwin.dll 
c         07/03/2015 introduced kind = 7 and k_mouse
c                                                           
c icolor: (input/output) sets default on entry then returns the selected colour
c   mode: (input/unchanged)
c         mode is intended to control the options available but is disabled
c         in this version except that the subroutine berhaves as follows:
c         mode = 0: fully active
c         mode = 1: any other value = no action in this version
c
c         set check = .true. to check that keys are uniquely defined,
c         and all colours are available then set to .false. when all is well
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer, intent (inout) :: icolor
      integer, intent (in)    :: mode
c
c locals
c      
      integer (kind = 7) k_mouse
      integer    w_numrgb
      integer    rgb_mouse_position, rgb_colours, rgb_editing, rgb_help
      integer    numcol, numrow, n0, n1, n2, n3, n8, n10, n255
      parameter (numcol = 12, numrow = 6, n0 = 0, n1 = 1, n2 = 2,
     +           n3 = 3, n8 = 8, n10 = 10, n255 = 255)
      integer    jcolor(numrow,numcol)
      integer    igrey(48:59), irain(0:47), ixtra(60:71), key(0:71)
      integer    icheck(0:71)
      integer    i, iadd, iadd2, iadd3, iadd8, icount, j, jcount, k,
     +           kcolor, lcolor, ncol, npixel, nrow
      integer    ix1, ix2, iy1, iy2
      integer    jx1, jx2, jy1, jy2
      integer    ix_mouse, iy_mouse
      integer    handle1, mainx1(0:71), mainx2(0:71), mainy1(0:71),
     +           mainy2(0:71)
      double precision factor, fifty, reference, size_msss
      parameter (fifty = 50.0d+00, reference = 1024.0d+00)
      character  word3*3
      logical    check, check1
      parameter (check1 = .false.)
      external   w_numrgb, rgb_mouse_position, rgb_colours, rgb_editing,
     +           rgb_help, w_syspar
      intrinsic  dble, nint
      common
     +/rgb_main/ handle1, mainx1, mainx2, mainy1, mainy2
     +/rgb_mouse/ ix_mouse, iy_mouse

      data irain / 36, 12, 28, 58, 24,  4,  6, 39, 30, 14, 38, 34,
     +             56, 46, 10, 26, 45, 52,  2, 43, 53, 31, 50, 40,
     +              3, 54, 27, 11, 35, 57, 55, 44,  9, 25, 49, 42,
     +             48, 32,  1, 51, 41, 59, 33, 37, 13, 29,  5, 47 /

      data igrey / 15, 23, 22, 21, 20,  7, 19, 18, 17, 16,  8,  0 /

      data ixtra / 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71 /
c
c initialise the mouse
c
      ix_mouse = 0
      iy_mouse = 0
      k_mouse = 0
      call set_mouse_cursor_position@(k_mouse, ix_mouse, iy_mouse)

c
c initialise key(0) to key(71) on each call using irain and igrey
c
      check = check1
      do i = 0, 47
         key(i) = irain(i)
      enddo
      do i = 48, 59
          key(i) = igrey(i)
      enddo
      do i = 60, 71
         key(i) = ixtra(i)
      enddo
      if (check) then
c
c check that all colours are included
c
         do i = 0, 71
            icheck(i) = 0
         enddo
         do i = 0, 71
            do j = 0, 71
               if (key(j).eq.i) icheck(i) = icheck(i) + 1
            enddo
         enddo
         do i = 0, 71
            if (icheck(i).eq.0) then
              print*, i, icheck(i)
            elseif (icheck(i).gt.1) then
               print*, i, icheck(i)
            endif
         enddo
      endif
c
c highlight the existing key colour
c
      icount = - n1
      jcount = - n1
      do while (jcount.lt.0 .and. icount.lt.71)
         icount = icount + n1
         if (icolor.eq.key(icount)) jcount = icount
      enddo
      if (mode.eq.n0) then
C
C initialise
C
         call w_syspar (i, 'f')
         size_msss = dble(i)/100.0d+00
         ix_mouse = n0
         iy_mouse = n0
         call w_syspar (i, 'x')
         factor = dble(i)*fifty/reference
         i = nint(factor)/n10
         npixel = n10*i
         iadd = i + n1
         iadd2 = n2*iadd
         iadd3 = n3*iadd
         iadd8 = n8*iadd
         kcolor = rgb@(n255, n255, n255)
         lcolor = rgb@(n0, n0, n0)
c
c define the colours using jcolor and key
c
         icount = - n1
         do i = n1, numrow
            do j = n1, numcol
               icount = icount + n1
               jcolor(i,j) = w_numrgb(key(icount))
            enddo
         enddo
c
c create the window using handle1
c
         handle1 = 1
         ncol = npixel*numcol + iadd2
         nrow = npixel*numrow + iadd8
         i = winio@('%ca[Simfit: colour palette]&')
         i = winio@('%sy[no_border, 3d_thin]&')
         i = winio@('%`^gr[grey, rgb_colours]&', ncol, nrow, handle1,
     +              '+', rgb_mouse_position, 'exit')
c
c colour the rectangles and write the colours underneath
c
         call select_font@('Arial')
         call size_in_pixels@(iadd2, iadd)
         iy1 = - npixel
         iy2 = n0
         icount = - n1
         do i = n1, numrow
            iy1 = iy1 + npixel + iadd
            iy2 = iy2 + npixel + iadd
            ix1 = iadd - npixel
            ix2 = iadd
            do j = n1, numcol
               icount = icount + n1
               ix1 = ix1 + npixel
               ix2 = ix2 + npixel
               jx1 = ix1 + iadd
               jx2 = ix2 - iadd
               jy1 = iy1 + iadd
               jy2 = iy2 - iadd
               call draw_filled_rectangle@(jx1, jy1, jx2, jy2,
     +                                     jcolor(i,j))
c
c store coordinates to refresh if save or restore is used
c
               k = key(icount)
               mainx1(k) = jx1
               mainx2(k) = jx2
               mainy1(k) = jy1
               mainy2(k) = jy2
               if (icount.eq.jcount) then
c
c draw 2 sets of lines to highlight the currently selected colour
c
                  jx1 = jx1 - n3
                  jx2 = jx2 + n3
                  jy1 = jy1 - n3
                  jy2 = jy2 + n3
                  call draw_line_between@(jx1, jy1, jx1, jy2, kcolor)
                  call draw_line_between@(jx1, jy2, jx2, jy2, kcolor)
                  call draw_line_between@(jx2, jy2, jx2, jy1, kcolor)
                  call draw_line_between@(jx2, jy1, jx1, jy1, kcolor)
                  jx1 = jx1 - n1
                  jx2 = jx2 + n1
                  jy1 = jy1 - n1
                  jy2 = jy2 + n1
                  call draw_line_between@(jx1, jy1, jx1, jy2, kcolor)
                  call draw_line_between@(jx1, jy2, jx2, jy2, kcolor)
                  call draw_line_between@(jx2, jy2, jx2, jy1, kcolor)
                  call draw_line_between@(jx2, jy1, jx1, jy1, kcolor)
               endif
               write (word3,'(i3)') key(icount)
               jx1 = ix1 + iadd3
               jy1 = iy2 + iadd + n3
               call draw_characters@(word3, jx1, jy1, lcolor)
            enddo
         enddo
c
c close the control with a status bar
c
         i = winio@('%ff&')
         i = winio@('`%sf%ts&', size_msss)
         i = winio@('%ob[status,thin_panelled]&')
         i = winio@('%^tt[rgb]   %^tt[Edit]   %^tt[Help]&',
     +              rgb_colours, rgb_editing, rgb_help)
         i = winio@('%cb')

         if (ix_mouse.ge.n1 .and. ix_mouse.le.ncol .and.
     +       iy_mouse.ge.n1 .and. iy_mouse.le.nrow) then
c
c retrieve the mouse coordinates then define icolor before returning
c
            nrow = (iy_mouse - iadd)/(npixel + iadd) + n1
            ncol = (ix_mouse - iadd)/npixel + n1
            icolor = (nrow - n1)*numcol + ncol - n1
            if (icolor.lt.n0) then
                icolor = 0
            elseif (icolor.gt.numcol*numrow - n1) then
              icolor = numcol*numrow - n1
            endif
c
c re-set icolor on exit using key
c
            icolor = key(icolor)
         endif
      endif
      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_mouse_position()
c
c get the mouse coordinates ... call back for main window
c
      implicit  none
      integer   iflags
      integer   ix_mouse, iy_mouse
      external  get_mouse_info@
      common
     +/rgb_mouse/ ix_mouse, iy_mouse
      rgb_mouse_position = 0
      call get_mouse_info@(ix_mouse, iy_mouse, iflags)

      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_colours()
c
c display the current and default rgb values ... call back for [rgb] button
c
      implicit   none
      integer    i, icolor
      integer    j, j_d, k, k_d, l, l_d
      integer    isend, nmax, idev, ival, nfont, ncolor
      parameter (nmax = 72)
      double precision thick, size1, xinch(0:1), yinch(0:1),
     +                 zscale(0:1)
      double precision red(nmax), green(nmax), blue(nmax)
      double precision red_d(nmax), green_d(nmax), blue_d(nmax)
      double precision f255
      parameter (f255 = 255.0d+00)
      character  cipher*3, line*100
      character  blank3*3, stars*3
      parameter (blank3 = '   ', stars = ' **')
      external   x_wpscfg, x_table1
      intrinsic  nint
      common
     +/rgb_data/ idev, ival, thick, size1, xinch, yinch, zscale, nfont,
     +ncolor, red, green, blue, red_d, green_d, blue_d
      rgb_colours = 2
c
c get the current parameters
c
      isend = 2
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red, green, blue)
c
c get the defaults
c
      isend = 3
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red_d, green_d, blue_d)
      write (line,100)
      icolor = 15
      call x_table1 (icolor, 'OPEN')
      icolor = 4
      call x_table1 (icolor, line)
      icolor = 0
      do i = 1, nmax
         j = nint(f255*red(i))
         k = nint(f255*green(i))
         l = nint(f255*blue(i))
         j_d = nint(f255*red_d(i))
         k_d = nint(f255*green_d(i))
         l_d = nint(f255*blue_d(i))
         if (j.eq.j_d .and. l.eq.l_d .and. k.eq.k_d) then
            cipher = blank3
         else
            cipher = stars
         endif
         write (line,200) i - 1, red(i), green(i), blue(i),
     +                    j, k, l, j_d, k_d, l_d, cipher
          call x_table1 (icolor, line)
      enddo
      call x_table1 (icolor, 'CLOSE')
  100 format ('No.     Red   Green    Blue',20x,'Defaults')
  200 format (i3,1x,f7.4,',',f7.4,',',f7.4,2x,
     +'(',i3,',',i3,',',i3,')',2x,
     +'(',i3,',',i3,',',i3,')',a)
      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_help()
c
c display the help screen ... call back for [Help] button on main control
c
      implicit   none
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 22)
      integer    numbld(numtxt)
      character  text(numtxt)*100
      logical    border
      parameter (border = .false.)
      external   w_patch1
      data       numbld / numtxt*0 /
      rgb_help = 2
      write (text,100)
      numbld(1) = 1
      numbld(numtxt) = 1
      call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +               text,
     +               border)
  100 format (
     + 'Editing Simfit colours to design a customised palette'
     +/
     +/'The Simfit colour scheme uses primary colours (red, green and'
     +/'blue) mixed in defined proportions, and the current palette'
     +/'uses the 72 triples stored in your PostScript configuration'
     +/'file, w_ps.cfg. So the range of PostScript colours is set by'
     +/'numbers on (0,1) which, when printing or displaying using 24-'
     +/'bit colour, are mapped onto integers in (0,255).'
     +/
     +/'Clearly, you can set up any scheme at all for your own use, by'
     +/'simply editing the file w_ps.cfg. However you should not edit'
     +/'the standard VGA colours (0 to 15) too much, as they are used'
     +/'as defaults by Simfit graphics. It is probably best to leave'
     +/'colours 0 to 59 alone, so you would have a basic palette of 60'
     +/'default colours plus 12 colours you can customise.'
     +/
     +/'To make a customised palette, or fine graded grey scale, for'
     +/'colours 60 to 71, use the [Edit] control to ceate the colour,'
     +/'then the [Save] button to over-ride the current settings. The'
     +/'[Restore] button restores the default for the selected colour.'
     +/
     +/'If you delete w_ps.cfg, Simfit will create a default version.')
      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_editing()
c
c edit a colour ... call back from [Edit] button on main window
c
      implicit   none
      include   <windows.ins>
      integer    i, jcolor, kcolor, ncol, nrow
      integer    ired, igreen, iblue
      integer    rgb_refresh, rgb_restore, rgb_save
      integer    handle2, lx1, lx2, ly1, ly2, kcolor1
      double precision size_msss
      double precision red, green, blue
      double precision red1, green1, blue1
      double precision zero, one, f255, step
      parameter (zero = 0.0d+00, one = 1.0d+00, f255 = 255.0d+00,
     +           step = 0.01d+00)
      common
     +/rgb_rgb/ red1, green1, blue1
     +/rgb_user/ handle2, lx1, lx2, ly1, ly2, kcolor1
      external rgb_refresh, rgb_restore, rgb_save, w_syspar
      intrinsic nint, dble
      save kcolor
      save red, green, blue
      data red, green, blue / 0.5D+00, 0.5d+00, 0.5d+00 /
      data kcolor / 60 /
      rgb_editing = 2
c
c create the window using graphics on handle2
c
      call w_syspar (i,
     +               'f')
      size_msss = dble(i)/100.0d+00
      call w_syspar (i,
     +               'x')
      handle2 = 2
      ncol = i/3
      nrow = i/10
      lx1 = 1
      lx2 = ncol
      ly1 = 1
      ly2 = nrow
      i = winio@('%sy[no_border, 3d_thin, independent]&')
      i = winio@('%ca[Simfit: user defined colour]&')
      i = winio@('%`gr[grey, rgb_colours]&',
     +           ncol, nrow, handle2)
c
c set red1, green1 and blue1 using the stored values
c
      red1 = red
      green1 = green
      blue1 = blue
      ired = nint(f255*red)
      igreen = nint(f255*green)
      iblue = nint(f255*blue)
      jcolor = rgb@(ired, igreen, iblue)
      kcolor1 = kcolor
      call draw_filled_rectangle@(lx1, ly1, lx2, ly2, jcolor)
c
c now the sliders, edit boxes and spin wheels
c
      i = winio@('%`sf%ts&', size_msss)
      i = winio@('%fl&', zero, one)
      i = winio@('%ff&')
      i = winio@('%^20sl&', red1, zero, one, rgb_refresh)
      i = winio@('%df%^rf red&', step, red1, rgb_refresh)
      i = winio@('%ff&')
      i = winio@('%^20sl&', green1, zero, one, rgb_refresh)
      i = winio@('%df%^rf green&', step, green1, rgb_refresh)
      i = winio@('%ff&')
      i = winio@('%^20sl&', blue1, zero, one, rgb_refresh)
      i = winio@('%df%^rf blue&', step, blue1, rgb_refresh)
      i = winio@('%ff&')
      i = winio@('%il&', 60, 71)
      i = winio@('%dd&', 1)
      i = winio@('%rd colour to save (replace) or restore (default)&',
     +           kcolor1)
      i = winio@('%ob[status,thin_panelled]&')
      i = winio@('%tt[Cancel]  %^tt[Save]  %^tt[Restore]&',
     +           rgb_save, rgb_restore)
      i = winio@('%cb')
c
c store the edited values
c
      red = red1
      green = green1
      blue = blue1
      kcolor = kcolor1
      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_refresh()
c
c refresh the colour that is being edited ... call back from sliders in edit window
c
      implicit   none
      include   <windows.ins>
      integer    ired, igreen, iblue, jcolor
      integer    handle2, lx1, lx2, ly1, ly2, kcolor1
      double precision red1, green1, blue1
      double precision f255
      parameter (f255 = 255.0d+00)
      intrinsic  nint
      common
     +/rgb_rgb/ red1, green1, blue1
     +/rgb_user/ handle2, lx1, lx2, ly1, ly2, kcolor1
      rgb_refresh = 2
      call select_graphics_object@(handle2)
      ired = nint(f255*red1)
      igreen = nint(f255*green1)
      iblue = nint(f255*blue1)
      jcolor = rgb@(ired, igreen, iblue)
      call draw_filled_rectangle@(lx1, ly1, lx2, ly2, jcolor)
      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_save()
c
c overwrite using the edited colour ... call back from [Save] button in edit window
c 21/07/2004 added call to numrgb$ with negative colour to redefine palette  
c 11/06/2007 replaced numrgb$ by w_numrgb
c
      implicit   none
      include   <windows.ins>
      integer    isave, itemp, ix1, ix2, iy1, iy2
      integer    handle2, lx1, lx2, ly1, ly2, kcolor1
      integer    isend, nmax, idev, ival, nfont, ncolor
      parameter (nmax = 72)
      integer    ired, igreen, iblue, jcolor
      integer    handle1, mainx1(0:71), mainy1(0:71), mainx2(0:71),
     +           mainy2(0:71)
      integer    w_numrgb
      double precision red1 , green1, blue1
      double precision f255
      parameter (f255 = 255.0d+00)
      double precision thick, size1, xinch(0:1), yinch(0:1), zscale(0:1)
      double precision red(nmax), green(nmax), blue(nmax),
     +                 red_d(nmax), green_d(nmax), blue_d(nmax)
      external   x_wpscfg, w_numrgb
      intrinsic  nint
      common
     +/rgb_main/ handle1, mainx1, mainx2, mainy1, mainy2
     +/rgb_data/ idev, ival, thick, size1, xinch, yinch, zscale, nfont,
     +ncolor, red, green, blue, red_d, green_d, blue_d
     +/rgb_rgb/ red1, green1, blue1
     +/rgb_user/ handle2, lx1, lx2, ly1, ly2, kcolor1
      rgb_save = 0
c
c get the current defaults
c
      isend = 2
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red, green, blue)
      isave = kcolor1 + 1
      red(isave) = red1
      green(isave) = green1
      blue(isave) = blue1
c
c store the edited colours to the configuration file
c
      isend = 1
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red, green, blue)
c
c call w_numrgb with negative colour to redefine colours
c
      itemp = -1
      isend = w_numrgb(itemp)
c
c refresh the main window
c
      ired = nint(f255*red1)
      igreen = nint(f255*green1)
      iblue = nint(f255*blue1)
      jcolor = rgb@(ired, igreen, iblue)
      ix1 = mainx1(kcolor1)
      ix2 = mainx2(kcolor1)
      iy1 = mainy1(kcolor1)
      iy2 = mainy2(kcolor1)
      call select_graphics_object@(handle1)
      call draw_filled_rectangle@(ix1, iy1, ix2, iy2, jcolor)
      end
c
c----------------------------------------------------------------------
c
      recursive integer function rgb_restore()
c
c restore the default colour ... call back for [Restore] button in edit window
c 21/07/2004 added call to numrgb$ with negative colour to redefine palette
c 11/06/2007 replaced call to numrgb$ by w_numrgb
c
      implicit   none
      include   <windows.ins>
      integer    isave, ired, igreen, iblue, ix1, ix2, iy1, iy2, jcolor
      integer    handle2, jx1, jx2, jy1, jy2, kcolor1
      integer    isend, itemp, nmax, idev, ival, nfont, ncolor
      parameter (nmax = 72)
      integer    handle1, mainx1(0:71), mainx2(0:71), mainy1(0:71),
     +           mainy2(0:71)
      integer    w_numrgb
      double precision f255
      parameter (f255 = 255.0d+00)
      double precision red1, green1, blue1
      double precision thick, size1, xinch(0:1), yinch(0:1), zscale(0:1)
      double precision red(nmax), green(nmax), blue(nmax),
     +                 red_d(nmax), green_d(nmax), blue_d(nmax)
      external    x_wpscfg, w_numrgb
      intrinsic   nint
      common
     +/rgb_main/ handle1, mainx1, mainx2, mainy1, mainy2
     +/rgb_data/ idev, ival, thick, size1, xinch, yinch, zscale, nfont,
     +ncolor, red, green, blue, red_d, green_d, blue_d
     +/rgb_rgb/ red1, green1, blue1
     +/rgb_user/ handle2, jx1, jx2, jy1, jy2, kcolor1
      rgb_restore = 0
c
c get the current values
c
      isend = 2
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red, green, blue)
c
c get the defaults
c
      isend = 3
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red_d, green_d, blue_d)
      isave = kcolor1 + 1
      red1 = red_d(isave)
      green1 = green_d(isave)
      blue1 = blue_d(isave)
      red(isave) = red1
      green(isave) = green1
      blue(isave) = blue1
      red(isave) = red1
      green(isave) = green1
      blue(isave) = blue1
c
c overwrite the values stored on w_ps.cfg
c
      isend = 1
      call x_wpscfg (isend, nmax,
     +               idev, ival, thick, size1, xinch, yinch,
     +               zscale, nfont, ncolor, red, green, blue)
c
c call w_numrgb with negative colour to redefine colours
c
      itemp = -1
      isend = w_numrgb(itemp)
c
c refresh the main window
c
      ired = nint(f255*red1)
      igreen = nint(f255*green1)
      iblue = nint(f255*blue1)
      jcolor = rgb@(ired, igreen, iblue)
      ix1 = mainx1(kcolor1)
      ix2 = mainx2(kcolor1)
      iy1 = mainy1(kcolor1)
      iy2 = mainy2(kcolor1)
      call select_graphics_object@(handle1)
      call draw_filled_rectangle@(ix1, iy1, ix2, iy2, jcolor)
      end
c
c


