c
c
      subroutine w_patch1 (icolor, ixl, iyl, lshade, numbld, numtxt,
     +                     text_in,
     +                     fixed)
c
c action : put out a patch of text with attributes onto a window
c author : w.g.bardsley, university of manchester, u.k., 14/12/96 
c          10/02/1997 added tabbing
c          04/04/1997 added call to w_syspar to size fonts
c          13/10/1998 changed grey highlight from red to blue
c          14/11/1998 re-introduced Times New Roman for buttons (scales better)
c          14/04/1999 went back to ms sans serif for buttons but at two sizes
c          03/09/1999 re-introduced %ww[no_sysmenu]
c          03/12/1999 restored topmost
c          16/12/2000 now calls the Windows MessageBox function for 1-liners
c          21/01/2001 suppressed topmost
c          13/02/2002 XP version
c          18/12/2002 added %sy[toolwindow] and 1-line options controlled by mode
c          13/03/2003 added w_dbleup for one liners 
c          18/11/2006 suppressed toolwindow, edited captions, and added intents 
c          04/02/2007 edited for w_clearwin.dll
c          30/05/2007 added allocatable array, ixyuse, roman, and w_dbleup for all text
c          03/04/2009 added extra lines in one-line messages to free-up the icon
c          03/04/2010 added call back for Copy/Print/Save As ...
c          04/08/2017 added stop and call back i_stop_this_program
c          11/12/2017 suppressed %mn items when numtxt =< 1 
c          03/05/2022 introduced jcolor for background colour and changed icons for 1-liners
c          27/12/2022 new color and icon scheme for 1-liners
c
c          this version uses: len200 = leng@ = len_trim, lcase1 = lcase@
c          to be compatible with ftn77 and ftn90
c
c          Note that tabbing occurs at the grave character and this routine is
c          usually called from patch1 which includes a call to w_dbleup to filter
c          out characters that could confuse cw+. Users calling w_patch1 directly
c          must take steps to filter out problem character strings.
c          This version takes special action when called with FATAL, etc. so it
c          can be called directly by putfat, etc. for special one line messages.
c          fixed = .true. causes the use of courier
c
c          Note: this version deals with one liners as special cases only if they
c          are: ADVICE, CAUTION, WARNING or FATAL messages
c                                       
c  icolor: (input/unchanged) as follows:
c           icolor background   text     highlight-text
c           ====== ==========   ====     ==============
c           0      black        grey     yellow

c           1      blue         grey     yellow
c           4      red          grey     yellow
c           9      white        black    red
c           o/w    grey         black    blue
c     ixl: (input/unchanged) x-coordinate, ignored if =< 0
c     iyl: (input/unchanged) y-coordinate, ignored if =< 0
c  lshade: (input/unchanged) shade...disabled in this version
c  numbld: (input/unchanged) asa follows: 
c           numbld(i)  font (Courier is used if fixed = .true.)
c           =========  ====
c           0, 1       Times
c           2, 3       Times Italic
c           4, 5       Times Bold
c           6, 7       Times Bold Italic 
c  numtxt: (input/unchanged) no. of text lines
c text_in: (input/unchanged) the message
c   fixed: (input/unchanged) if .true. then fixed font (Courier)
c                            if .false. then Times New Roman
c
c          text size is set by the parameters size_*
c
      implicit   none
      include   <windows.ins>  
c
c arguments
c      
      integer,             intent (in) :: icolor, ixl, iyl, lshade,
     +                                    numtxt
      integer,             intent (in) :: numbld(numtxt)
      character (len = *), intent (in) :: text_in(numtxt) 
      logical,             intent (in) :: fixed  
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
c
c locals
c      
      integer    i_call_x_switch, i_stop_this_program
      integer    i, ierr, ios, j, k, l, nout
      integer    jcolor, nstart
      integer    x_len200
      integer    mode
      integer    n0, n1, n2, n4, n5, n6, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n5 = 5, n6 = 6, n7 = 7)
      integer    i_copy_patch1, iscale 
      integer    ixyuse, ixy_use
      parameter (ixy_use = 2)
      double precision size_roman, size_courier, size_msss
      double precision size_roman_1, size_courier_1, size_msss_1
      parameter (size_roman_1 = 1.0d+00, size_courier_1 = 1.0d+00,
     +           size_msss_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  caption*80, line*129, symbol5*5, symbol6*6, symbol7*7
      character  w_dbleup*129, wrd129*129
      character  blank*1
      parameter (blank = ' ')
      logical    advice, caution, fatal, one_line, warning 
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_lcase1, x_len200, w_getnou, w_reslib
      external   w_syspar, w_dbleup
      external   i_copy_patch1
      external   i_call_x_switch, i_stop_this_program
      intrinsic  index, dble, len
      common    / patch1 / nout 
      i = lshade!to silence ftn95 as lshade is not going to be used
      mode = n1 
      roman = roman_1 
      if (ixl.lt.n0 .or. iyl.lt.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif      
c
c special action taken if numtxt = 1 to check if it is a 1 line warning
c
      if (numtxt.eq.n1 .and. len(text_in(1)).ge.n7) then
         symbol5 = text_in(1)(n1:n5)
         call x_lcase1 (symbol5)
         symbol6 = text_in(1)(n1:n6)
         call x_lcase1 (symbol6)
         symbol7 = text_in(1)(n1:n7)
         call x_lcase1 (symbol7)
         advice = .false.
         caution = .false.
         warning = .false.
         fatal = .false.
         one_line = .true.
         if (symbol6.eq.'advice' .or. symbol7.eq.'*advice') then
            advice = .true.
            jcolor = rgb@(250,250,250)
         elseif (symbol7.eq.'caution') then
            caution = .true.
            jcolor = rgb@(230,230,230)
         elseif (symbol7.eq.'warning') then
            warning = .true.
            jcolor = rgb@(230,230,230) 
         elseif (symbol5.eq.'fatal' .or. symbol6.eq.'*fatal') then
            jcolor = rgb@(230,230,230)
            fatal = .true.
         else
            one_line = .false.
         endif
      else
         one_line = .false.
      endif
c
c special action required for 1 line warning messages as follows:
c
c mode = 1: use Clearwin+
c
c o/w use Windows MessageBox function as in i = MessageBox (j, line, caption, k)
c j = 0 implies null handle, icon type as follows:-
C k = MB_ICONHAND = 16 (fatal, x icon),
c k = MB_ICONEXCLAMATION = 48 (warning, ! icon)
c k = MB_ICONINFORMATION = 64 (information, i icon)
c k = k + SYSTEMMODAL + MB_OK makes the window a top-level window with 1 button
c
      if (one_line) then
         if (mode.eq.1) then   
            call w_syspar (i, 'f')
            correction = dble(i)/percent
            size_msss = correction*size_msss_1 
            if (advice) then 
               k = winio@('%ca[Simfit: advisory message]&')
            elseif (caution) then 
               k = winio@('%ca[Simfit: cautionary message]&')
            elseif (warning) then
               k = winio@('%ca[Simfit: warning message]&')
            elseif (fatal) then
               k = winio@('%ca[Simfit: error message]&')
            endif       
            k = winio@('%sy[topmost]&')
            k = winio@('%`sf&')
            k = winio@('%ts&', size_msss)
            
            k = winio@('%nl   &')
            
            if (advice) then 
               k = winio@('%si*%bg&', jcolor)
               k = winio@('%tc[black]&')
            elseif (caution) then 
               k = winio@('%si?%bg&', jcolor)
               k = winio@('%tc[black]&')
            elseif (warning) then
               k = winio@('%si!%bg&', jcolor)
               k = winio@('%tc[black]&')
            elseif (fatal) then
               k = winio@('%si#%bg&', jcolor)
               k = winio@('%tc[black]&')
            endif
            
            line = text_in(1) 
            l = x_len200(line) 
            nstart = index(line,':') + 1  
            wrd129 = w_dbleup(line(nstart:l))
            l = x_len200(wrd129)
            line = wrd129(1:l)//'&'
            k = winio@(line)
            
            k = winio@('%ff&')
            k = winio@('%nl   &')
            k = winio@('%nl   &')
            k = winio@('%cn%`8bt[OK]&')
            k = winio@('%nl   ')
            
         else                
            line = text_in(1) 
            j = 0 
            caption = 'Simfit: information'
            if (advice) then
               k = MB_ICONINFORMATION
            elseif (caution) then
               k = MB_ICONEXCLAMATION
            elseif (warning) then
               k = MB_ICONEXCLAMATION
            elseif (fatal) then
               k = MB_ICONHAND
            endif
            k = k + MB_SYSTEMMODAL + MB_OK
            i = messagebox (j, line, caption, k)
         endif
c
c else the general case
c
      else  
c
c allocate
c         
         ierr = n0
         if (allocated(text)) deallocate(text, stat = ierr)
         if (ierr.ne.n0) return
         allocate(text(numtxt), stat = ierr)
         if (ierr.ne.n0) return
         do i = n1, numtxt  
            text(i) = w_dbleup(text_in(i))
         enddo         
c
c Scale the font sizes
c
         call use_windows95_font@()
         call w_syspar (i, 'f')
         correction = dble(i)/percent
         size_courier = correction*size_courier_1
         size_msss = correction*size_msss_1 
         if (roman) then
            size_roman = correction*size_roman_1
         else   
            size_roman = size_courier 
         endif
         if (ixyuse.eq.n1) then
c
c use ixl, iyl and parameter iscale to position the window
c
            call w_syspar (iscale, 'i')
            i = winio@('%sp&', iscale*ixl, iscale*iyl)
         endif   

c
c uncomment the next line for a normal window instead of a dialogue window
c ========================================================================
c********i = winio@('%ww[no_sysmenu, topmost]&')
c

         k = winio@('%ca[Simfit: information]&')
         call w_reslib
         k = winio@('%mi[icon_1]&')
         if (numtxt.gt.1) then
            k = winio@('%mn[Copy]&', i_copy_patch1)
            k = winio@('%mn[Stop]&', i_stop_this_program)
            k = winio@('%mn[Speedup]&', i_call_x_switch)
         endif   
         call w_getnou (nout)
         open (unit = nout, status = 'SCRATCH', iostat = ios)
         do i = 1, numtxt
            line = text_in(i)
            j = index(line,'`')
            do while (j.gt.0)
               line(j:j) = blank
               j = index (line,'`')
            enddo   
            write (nout,'(a)',iostat=ios) line
         enddo   
       
c
c now set the background colour depending on icolor
c
         if (icolor.eq.0) then
            k = winio@('%bg[black]&')
         elseif (icolor.eq.1) then
            k = winio@('%bg[blue]&')
         elseif (icolor.eq.4) then
            k = winio@('%bg[red]&')
         elseif (icolor.eq.9) then
            k = winio@('%bg[white]&')
         else
            k = winio@('%bg[grey]&')
         endif

         do i = n1, numtxt
c
c now set the text font depending on numbld(i) and fixed
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                  k = winio@('%fn[Courier New]%bf%it&')
               endif
               if (i.eq.numtxt) then
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               endif 
c
c and set the text color depending on numbld(i) and icolor
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  if (icolor.eq.0) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[grey]&')
                  else
                     k = winio@('%tc[black]&')
                  endif
               else
                  if (icolor.eq.0) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.9) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif
               k = winio@(line, size_courier)
            else     
               if (roman) then
                  if (numbld(i).le.1) then
                     k = winio@('%fn[Times New Roman]&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%fn[Times New Roman]%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%fn[Times New Roman]%bf&')
                  else
                     k = winio@('%fn[Times New Roman]%bf%it&')
                  endif
               else 
                  if (numbld(i).le.1) then
                     k = winio@('%`sf&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%`sf%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%`sf%bf&')
                  else
                     k = winio@('%`sf%bf%it&')
                  endif
               endif 
c
c and set the text color depending on numbld(i) and icolor
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  if (icolor.eq.0) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[grey]&')
                  else
                     k = winio@('%tc[black]&')
                  endif
               else
                  if (icolor.eq.0) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.9) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif  
c
c search for the tabbing character (i.e. grave accent `) then tab if present
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  line = blank
                  if (i.eq.numtxt) then
                     line = '%ta'//text(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//text(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.numtxt) then
                     line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
                  else
                     line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  endif
                  k = winio@(line, size_roman)
               endif
            endif
            k = winio@('%sf&')
         enddo
         k = winio@('%ff&')
c
c text display is finished so end with a button press
c
         if (fixed) then
            k = winio@('%fn[Courier New]&')
         else
            k = winio@('%`sf&')
         endif
         k = winio@('%ts&',size_msss)
         k = winio@('%nl%cn%`8bt[OK]')
         deallocate(text, stat = ierr)
         close (unit = nout)
      endif
      end
c
c
      recursive integer  function i_copy_patch1()
      implicit none
      integer  nout
      external w_revpro
      common / patch1 / nout 
      i_copy_patch1 = 1
      call w_revpro (nout)
      end
c
c      