c
c
      subroutine w_patch3 (ibot, icolor, imid, itop, ixl, iyl, lshade,
     +                     numbld, numtxt,
     +                     quest, text_in,
     +                     fixed)
c
c action : put out a patch of text with attributes onto a window followed by a %ls or %rd
c author : w.g.bardsley, university of manchester, u.k.
c          14/09/2017 developed from w_patch1 
c          06/04/2019 the drop list is limited to imax = 20 items o/w a %rd is used 
c                     also made the ls box 7 characters, etc, to agree with w_get00x 
c          17/02/2020 increased ls box characters from 6 to 7 and added a closure button
c
c          Note that tabbing occurs at the grave character and this routine is
c          usually called from patch1 which includes a call to w_dbleup to filter
c          out characters that could confuse cw+. Users calling w_patch3 directly
c          must take steps to filter out problem character strings.
c          fixed = .true. causes the use of courier
c
c                                       
c  icolor: (input/unchanged) as follows:
c           icolor background   text     highlight-text
c           ====== ==========   ====     ==============
c           0      black        grey     yellow
c           1      blue         grey     yellow
c           4      red          grey     yellow
c           9      white        black    red
c           o/w    grey         black    blue
c     ixl: (input/unchanged) x-coordinate, ignored if =< 0
c     iyl: (input/unchanged) y-coordinate, ignored if =< 0
c  lshade: (input/unchanged) shade...disabled in this version
c  numbld: (input/unchanged) as follows: 
c           numbld(i)  font (Courier is used if fixed = .true.)
c           =========  ====
c           0, 1       Times
c           2, 3       Times Italic
c           4, 5       Times Bold
c           6, 7       Times Bold Italic 
c  numtxt: (input/unchanged) no. of text lines
c text_in: (input/unchanged) the message
c   fixed: (input/unchanged) if .true. then fixed font (Courier)
c                            if .false. then Times New Roman
c
c          text size is set by the parameters size_*
c
      implicit   none
      include   <windows.ins>  
c
c arguments
c      
      integer,             intent (in)    :: ibot, icolor, itop, ixl,
     +                                       iyl, lshade, numtxt
      integer,             intent (inout) :: imid
      integer,             intent (in)    :: numbld(numtxt)
      character (len = *), intent (in)    :: quest, text_in(numtxt) 
      logical,             intent (in)    :: fixed  
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
c
c locals
c      
      integer    i_call_x_switch, i_stop_this_program
      integer    i, ierr, ios, imax, j, k, l, m, n, nout, ntemp
      integer    cur_item, num_items
      integer    x_len200
      integer    n0, n1, n2, n4, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n7 = 7)
      integer    i_copy_patch1, iscale 
      integer    ixyuse, ixy_use
      parameter (ixy_use = 2)
      double precision size_roman, size_courier, size_msss
      double precision size_roman_1, size_courier_1, size_msss_1
      parameter (size_roman_1 = 1.0d+00, size_courier_1 = 1.0d+00,
     +           size_msss_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character (len = 129) line, w_dbleup
      character (len = 7  ) items(50)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200, w_getnou, w_reslib, x_putfat
      external   w_syspar, w_dbleup
      external   i_call_x_switch, i_copy_patch1
      external   i_stop_this_program
      intrinsic  index, dble, abs, max, len_trim
      common    / patch1 / nout 
c
c check
c      
      if (numtxt.lt.1 .or. numtxt.gt.50) then
         call x_putfat ('NUMTXT < 1 or NUMTXT > 50 in call to W_PATCH3')
         return
      elseif (ibot.gt.itop) then
         call x_putfat ('IBOT > ITOP in call to W_PATCH3')   
      elseif (imid.lt.ibot .or. imid.gt.itop) then
         call x_putfat (
     +   'IMID < IBOT or IMID > ITOP in call to W_PATCH3')
         return
      endif   
      i = lshade!to silence ftn95 as lshade is not going to be used
      roman = roman_1 
      if (ixl.lt.n0 .or. iyl.lt.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif      
      if (ibot.eq.itop) then
         imid = ibot
         return 
      else  
c
c allocate
c         
         ierr = n0
         if (allocated(text)) deallocate(text, stat = ierr)
         if (ierr.ne.n0) return
         allocate(text(numtxt), stat = ierr)
         if (ierr.ne.n0) return
         do i = n1, numtxt  
            text(i) = w_dbleup(text_in(i))
         enddo         
c
c Scale the font sizes
c
         call use_windows95_font@()
         call w_syspar (i, 'f')
         correction = dble(i)/percent
         size_courier = correction*size_courier_1
         size_msss = correction*size_msss_1 
         if (roman) then
            size_roman = correction*size_roman_1
         else   
            size_roman = size_courier 
         endif
         if (ixyuse.eq.n1) then
c
c use ixl, iyl and parameter iscale to position the window
c
            call w_syspar (iscale, 'i')
            i = winio@('%sp&', iscale*ixl, iscale*iyl)
         endif   

c
c uncomment the next line for a normal window instead of a dialogue window
c ========================================================================
c********i = winio@('%ww[no_sysmenu, topmost]&')
c

         k = winio@('%ca[Simfit: input an integer]&')
         call w_reslib
         k = winio@('%mi[icon_1]&')
         k = winio@('%mn[Copy]&', i_copy_patch1)
         k = winio@('%mn[Stop]&', i_stop_this_program)
         k = winio@('%mn[Speedup]&', i_call_x_switch)
         call w_getnou (nout)
         open (unit = nout, status = 'SCRATCH', iostat = ios)
         do i = 1, numtxt
            line = text_in(i)
            j = index(line,'`')
            do while (j.gt.0)
               line(j:j) = blank
               j = index (line,'`')
            enddo   
            write (nout,'(a)',iostat=ios) line
         enddo   
c
c now set the background colour depending on icolor
c
         if (icolor.eq.0) then
            k = winio@('%bg[black]&')
         elseif (icolor.eq.1) then
            k = winio@('%bg[blue]&')
         elseif (icolor.eq.4) then
            k = winio@('%bg[red]&')
         elseif (icolor.eq.9) then
            k = winio@('%bg[white]&')
         else
            k = winio@('%bg&',rgb@(225,225,225))
         endif

         do i = n1, numtxt
c
c now set the text font depending on numbld(i) and fixed
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                  k = winio@('%fn[Courier New]%bf%it&')
               endif
               if (i.eq.numtxt) then
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               endif 
c
c and set the text color depending on numbld(i) and icolor
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  if (icolor.eq.0) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[grey]&')
                  else
                     k = winio@('%tc[black]&')
                  endif
               else
                  if (icolor.eq.0) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.9) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif
               k = winio@(line, size_courier)
            else     
               if (roman) then
                  if (numbld(i).le.1) then
                     k = winio@('%fn[Times New Roman]&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%fn[Times New Roman]%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%fn[Times New Roman]%bf&')
                  else
                     k = winio@('%fn[Times New Roman]%bf%it&')
                  endif
               else 
                  if (numbld(i).le.1) then
                     k = winio@('%`sf&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%`sf%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%`sf%bf&')
                  else
                     k = winio@('%`sf%bf%it&')
                  endif
               endif 
c
c and set the text color depending on numbld(i) and icolor
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  if (icolor.eq.0) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[grey]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[grey]&')
                  else
                     k = winio@('%tc[black]&')
                  endif
               else
                  if (icolor.eq.0) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.1) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.4) then
                     k = winio@('%tc[yellow]&')
                  elseif (icolor.eq.9) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif  
c
c search for the tabbing character (i.e. grave accent `) then tab if present
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  line = blank
                  if (i.eq.numtxt) then
                     line = '%ta'//text(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//text(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.numtxt) then
                     line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
                  else
                     line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  endif
                  k = winio@(line, size_roman)
               endif
            endif
            k = winio@('%sf&')
         enddo
         k = winio@('%ff&')
c
c text display is finished so end with a %rd
c
         if (fixed) then
            k = winio@('%fn[Courier New]&')
         else
            k = winio@('%`sf&')
         endif
         k = winio@('%ts&',size_msss)
         ntemp = imid
         k = winio@('%il&', ibot, itop)
         k = winio@('%co[data_border,check_on_focus_loss]&')
         k = winio@('%`bg[white]&')
         imax = itop - ibot + 1
         if (imax.le.20) then
             cur_item = 0
             num_items = 0
             k = 0
             do i = ibot, itop
               k = k + 1 
               if (i.eq.imid) cur_item = k
               num_items = num_items + 1
               write (items(num_items),'(i3,4x)') i
             enddo  
             n = 7
             m = num_items 
             ntemp = winio@('%nl &')
             ntemp = winio@('%`*.*ls&',
     +                      n, m, items, num_items, cur_item)
         elseif (imax .lt. 1000) then   
            k = winio@('%nl%4rd&', ntemp)
         else   
            k = winio@('%nl%8rd&', ntemp)
         endif 
         k = winio@('%sf&')  
         k = winio@('%tc[blue]&')
         k = winio@('%ts&',size_roman)
         i = len_trim(quest)
         k = winio@(blank//blank//quest(1:i)//'&')
         k = winio@('%ff%sf&')
         k = winio@('%ts&',size_msss)
         k = winio@('%nl%`8tt[OK]')
         close (unit = nout)
      endif
      
      deallocate(text, stat = ierr)
      if (imax.le.20) then
         read (items(cur_item),*) imid
      else   
         imid = ntemp
      endif   
      end
c
c
      