c
c
      subroutine w_pathto (path, pname_in,
     +                     there)
c
c action: confirm or try to find a path to a named file
c author: w.g.bardsley, university of manchester, u.u., 23/02/2002
c         30/07/2002 edited to call w_system for system files and call lbox01 
c         12/02/2005 extensive editing to prevent non-sense searches 
c         22/11/2006 edited, added intents, and stopped .exe being mandatory 
c         04/01/2007 extensive editing to avoid recursive calls to w_config
c                    when this routine is called from w_config  
c         08/02/2007 edited for w_clearwin.dll
c         18/07/2007 added curdir@ for redpr.exe
c         15/01/2009 added C: to \ to make searching C drive the priority
c         07/07/2010 added call to w_getenv and option to search from the root
c         28/09/2010 now forces a search even with a blank string or if undefined
c         25/01/2011 added call to w_v7path
c         01/05/2011 added call to w_fpath2 
c         24/12/2012 replaced x_getany by x_getstr and added checks for w_simfit.exe and simdem.exe
c         29/07/2015 added 64-bit options and function w_pathid = PathIsDirectory
c         13/05/2017 added gsview.exe and sumatraPDF.exe and replaced x_len200 by len_trim
c         28/05/2017 used x_okcval to prevent searching for ghostscript if the DLL is located
c         15/07/2017 removed x_okcval and used logical function use_gsdll() instead  
c         28/07/2017 added acrobat.exe to the options
c         20/02/2010 added the case to avoid searching depending on the value of parameter silent1
c         06/11/2022 added pdfrdr and epsrdr
c                         
c          path: (input/output) 
c                on entry should be a fully qualified path/filename like
c                \windows\notepad.exe and this may or may not exist.
c                This subroutine confirms the path supplied or tries to
c                return an existing fully qualified path/filename
c      pname_in: (input/unchanged)
c                 default filename, e.g. notepad.exe
c                 pname_in is never altered by this routine
c         there: (output)
c                 if true then path exists o/w path was not found
c
      implicit   none 
c
c arguments
c      
      character (len = *), intent (in)    :: pname_in
      character (len = *), intent (inout) :: path      
      logical,             intent (out)   :: there
c
c locals
c      
      integer    i, ios, k, l_pf32, l_pf64
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart,
     +           ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1,
     +           numopt = 7, nstart = 14)   
      integer    numbld(30), numpos(numopt)
      character (len = 1024) dir, full_pname, full_path, temp
      character (len = 1024) new_dir, new_pname, new_path
      character (len = 1024) svalue
      character (len = 1024) pf32, pf64, w_fpath2
      character (len = 100 ) line, text(30)
      character (len = 100 ) word100(3), query, x_trim100
      character (len = 20  ) pname
      character (len = 14  ) word14
      character (len = 12  ) undef, word12
      character (len = 10  ) word10
      character (len = 9   ) word9
      character (len = 7   ) word7 
      character (len = 6   ) word6
      character (len = 4   ) word4
      character (len = 2   ) root 
      character (len = 1   ) blank, bslash
      parameter (undef = '***Undefined') 
      parameter (blank = ' ', bslash = '\') 
      logical    ok, w_pathid
      logical    extra, linux_program, x_linux3, repeet
      logical    fixed, full, high
      parameter (fixed = .false., full = .false., high = .false.)
      logical    silent, silent1
      parameter (silent1 = .true.) 
      logical    first
      external   w_findfl, x_lcase1, w_lbox01, 
     +           x_putadv, x_trim100, w_patch1, w_system, 
     +           x_linux3, x_getstr, w_v7path, w_fpath2,
     +           w_pathid, pdfrdr, epsrdr
      intrinsic  len_trim, adjustl, index
      save       first, pf32, l_pf32, pf64, l_pf64, root
      data       first / .true. /
      data       numbld / 30*0 /
      data       numpos /numopt*1 /
      pname = blank
      k = len_trim(pname_in)
      pname(1:k) = pname_in(1:k)
      if (first) then
c
c first time round get the program files environment variable and root
c        
         first = .false.
         call w_v7path (l_pf32,
     +                  'p32', pf32)  
         if (l_pf32.gt.1) then
            if (pf32(l_pf32:l_pf32).ne.bslash) then
               l_pf32 = l_pf32 + 1
               pf32(l_pf32:l_pf32) = bslash
            endif
         endif 
         call w_v7path (l_pf64,
     +                  'p64', pf64) 
         if (l_pf64.gt.1) then
            if (pf64(l_pf64:l_pf64).ne.bslash) then
               l_pf64 = l_pf64 + 1
               pf64(l_pf64:l_pf64) = bslash
            endif
         endif 
         root = pf32(1:2) 
      endif
c
c check the data supplied 
c         
      extra = .false.          
      there = .false.  
      path = adjustl(path)   
      k = len_trim(path)
      if (k.lt.3 .or. path.eq.undef) then 
c
c cannot have number of characters < 3 or be undefined
c      
         extra = .true.
         write (line,100)
         if (path.eq.blank) then
            call x_putadv ('blank'//line)
         else   
            call x_putadv (path(1:k)//line)
         endif 
         path = pname 
         k = len_trim(path) 
      endif 
c
c define linux_program
c      
      linux_program = x_linux3(path)   
      if (.not.linux_program .and. k.lt.5) then
         word4 = path 
         write (line,100)
         call x_putadv (word4//line) 
         there = .false.
      endif   
      word4 = path(k - 3:k)
      call x_lcase1 (word4)
      if (.not.linux_program) then
          if (word4.ne.'.exe' .and. word4.ne.'.dll') then
            write (line,200)
            call x_putadv (line)
         endif   
      endif   
c                        
c try the path supplied and if it is there then return
c
      inquire (file = path, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
         temp = w_fpath2(path)
         path = temp
         return
      endif 
c                        
c try the pname supplied and if it is there then return
c
      inquire (file = pname, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
         temp = w_fpath2(pname)
         path = temp
         return
      endif          
c
c make local copies of pname and path then check for system files
c
      full_pname = pname
      full_path = path  
      full_pname = adjustl(full_pname)
      full_path = adjustl(full_path)
      word12 = full_pname(1:12)
      call x_lcase1 (word12)
      if (word12.eq.'gswin32c.exe' .or. word12.eq.'gswin64c.exe') then
         call epsrdr (path)
         there = .true.
         return
      endif       
      if (word12.eq.'notepad.exe ' .or. 
     +    word12.eq.'explorer.exe' .or. word12.eq.'calc.exe    ') then 
c
c try the other possible paths (defined in w_system) for system files
c
         call w_system (full_path, full_pname,
     +                  there)
         if (there) then
            path = w_fpath2(full_path)
            if (extra) then
               write (line,400)
               call x_putadv (line)
            endif   
            return
         endif
      endif   
      word6 = full_pname(1:6)
      word7 = full_pname(1:7)
      call x_lcase1 (word7)
      word9 = full_pname(1:9)
      call x_lcase1 (word9)
      word10 = full_pname(1:10)
      call x_lcase1 (word14)
      if (word6.eq.'acrord' .or.
     +    word7.eq.'acrobat' .or.
     +    word9.eq.'pdfreader' .or.  
     +    word10.eq.'sumatrapdf') then
          call pdfrdr (path)
          there = .true.
          return
      endif    
      word6 = full_pname(1:6)
      call x_lcase1(word6)
      if (word6.eq.'gsview') then
         call epsrdr (path)
         there = .true.
         return
      endif   
      
c
c
      silent = silent1
      if (.not.silent) then
c
c put out a message except for gsview then return 
c
         if (index(pname,'gsview').le.0) then
            write (text,900) 
            ntext = 22
            numbld(1) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                     text, fixed)
            numbld(1) = 0
         endif
         return
      endif   
c
c now try to guess the search path
c      
      full_path = path
      if (word14.eq.'acrobat.exe   ') then  
         dir = pf32(1:l_pf32)//'Adobe'                     
      elseif (word14.eq.'acrord32.exe  ') then
         dir = pf32(1:l_pf32)//'Adobe'
      elseif (word14.eq.'acrord64.exe  ') then   
         dir = pf64(1:l_pf64)//'Adobe'
      elseif (word14.eq.'gswin32c.exe  ') then
         dir = pf32(1:l_pf32)//'gs'
      elseif (word14.eq.'gswin64c.exe  ') then 
         dir = pf64(1:l_pf64)//'gs' 
      elseif (word14.eq.'gsview.exe    ') then
         dir = pf32(1:l_pf32)//'Artifex Software'
         ok = w_pathid (dir)
         if (.not.ok) dir = pf64(1:l_pf64)//'Artifex Software'     
      elseif (word14.eq.'gsview32.exe  ') then
         dir = pf32(1:l_pf32)//'Ghostgum\Gsview'
      elseif (word14.eq.'gsview64.exe  ') then 
         dir = pf64(1:l_pf64)//'Ghostgum\Gsview'  
      elseif (word14.eq.'w_simfit.exe  ') then   
         dir = pf32(1:l_pf32)//'Simfit\bin'
      elseif (word14.eq.'x64_simfit.exe') then   
         dir = pf64(1:l_pf64)//'Simfit\bin'   
      elseif (word14.eq.'simdem.exe    ') then   
         dir = pf32   
      elseif (word14.eq.'x64_simdem.exe') then   
         dir = pf32    
      else
         dir = pf32
      endif 
      numdec = numopt - 3           
      repeet = .true.
      do while (repeet)
         word100(1) = x_trim100(full_path)
         word100(2) = x_trim100(full_pname)
         ok = w_pathid (dir)
         if (ok) then
            word100(3) = x_trim100(dir)
         else
            dir = undef
            word100(3) = dir(1:80)
         endif      
         write (text,300) (word100(i), i = 1, 3), root
         numbld(1) = 1
         numbld(6) = 1
         numbld(9) = 1
         numbld(12) = 1
         ntext = nstart + numopt - 1
         call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                  numpos, nstart, ntext,
     +                  text,
     +                  fixed, full, high)
         numbld(1) = 0
         numbld(6) = 0
         numbld(9) = 0
         numbld(12) = 0
         if (numdec.eq.1) then
c
c try a full path/file_name
c                          
            query =
     +'Fully qualified path\filename for the program required'
            new_path = full_path 
            svalue = new_path
            call x_getstr (query, svalue) 
            new_path = svalue
            new_path = adjustl(new_path)
            k = len_trim(new_path)
            if (k.lt.4) k = 4
            word4 = new_path(k - 3:k)
            call x_lcase1 (word4)
            if (word4.ne.'.exe' .and. word4.ne.'.dll') then 
               linux_program = x_linux3(new_path)
               if (.not.linux_program) then  
                  write (line,200)
                  call x_putadv (line)     
               endif   
            endif   
            full_path = new_path
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then  
               write (line,400)
               call x_putadv (line)
               path = w_fpath2(full_path)
               repeet = .false.
            else
               full_path = path
               write (line,500)
               call x_putadv (line)
            endif
            numdec = numopt - 3 
         elseif (numdec.eq.2) then
c
c try a new file name
c         
            query = 
     +'Full file name (with extension) for the program required' 
            new_pname = full_pname
            svalue = new_pname
            call x_getstr (query, svalue)
            new_pname = svalue
            new_pname = adjustl(new_pname)
            full_pname = new_pname
            numdec = numopt - 3
         elseif (numdec.eq.3) then 
c
c try a new search path
c         
            query =
     +'Full drive\path to search for the program required'
            new_dir = dir   
            svalue = new_dir
            call x_getstr (query, svalue)
            new_dir = svalue              
            new_dir = adjustl(new_dir)
            k = len_trim(new_dir)
            if (k.le.1) then
               write (line,600)
               call x_putadv (line)
               numdec = numopt - 1
            else 
               ok = w_pathid (new_dir)
               if (ok) then
                  dir = new_dir
                  numdec = numopt - 3
               else
                  write (line,800)
                  call x_putadv (line)
                  numdec = numopt - 1
               endif      
            endif   
         elseif (numdec.eq.4) then 
c
c search for the missing file
c           
            ok = w_pathid (dir)
            if (ok) then
               temp = blank
               call w_findfl (dir, full_pname, temp, 
     +                        there)
               if (there) then
                  write (line,400)
                  call x_putadv (line)
                  path = w_fpath2(temp)
                  repeet = .false.
               else              
                  write (line,500)
                  call x_putadv (line)
               endif
            else
               write (line,800)
               call x_putadv (line)
            endif    
            numdec = numopt - 1  
         elseif (numdec.eq.5) then 
c
c search the root for the missing file
c         
            temp = blank
            call w_findfl (root, full_pname, temp, 
     +                     there)
            if (there) then
               write (line,400)
               call x_putadv (line)
               path = w_fpath2(temp)
               repeet = .false.
            else              
               write (line,500)
               call x_putadv (line)
               numdec = numopt - 1
            endif   
         elseif (numdec.eq.numopt - 1) then
c
c help
c         
            write (text,700) root
            ntext = 22
            numbld(1) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                      text, fixed)
            numbld(1) = 0
            numdec = numopt - 3
         elseif (numdec.eq.numopt) then
c
c cancel search
c         
            repeet = .false.
         endif
      enddo
c
c format statements
c      
  100 format (1x,'is not a path/filename ... will try searching')      
  200 format (
     +'Windows programs must have extension .exe (not Linux programs)')    
  300 format (
     + 'Simfit cannot locate a specified auxiliary file'
     +/
     +/'You can search now for the correct file or proceed'
     +/
     +/'Incorrect drive\path\filename supplied is:'
     +/A  
     +/
     +/'Correct drive\path\ is required for the file:'
     +/A 
     +/
     +/'Current drive\path to be searched is:'
     +/A
     +/
     +/'Input new drive\path\filename'
     +/'Input new filename for searching'
     +/'Input new drive\path to be searched'
     +/'Search from current drive\path'
     +/'Search from the root',1x,a
     +/'Help'
     +/'Cancel')
  400 format (
     +'SUCCESS ... file located. Use [Apply] to update w_simfit.cfg')     
  500 format ('FAILURE ... missing file was not found')  
  600 format ('Path must have more than one character, e.g. D:')  
  700 format (
     + 'Locating incorrectly specified Simfit auxiliary programs'
     +/
     +/'Simfit uses several auxiliary programs. Some of these, such as'
     +/'Notepad.exe, are distributed as part of the Windows OS while'
     +/'others, e.g. Acrobat reader, are public domain programs.'
     +/'You can specify your own text editor, disc explorer, or'
     +/'calculator.'
     +/'If you do not want to use the Simfit defaults, you can switch'
     +/'off flagging for missing non-essential auxiliaries.'
     +/
     +/'Simfit stores the paths to such files in w_simfit.cfg in your'
     +/'...ProgramData\Simfit\user\cfg folder, where Simfit looks in'
     +/'order to use an auxiliary program. If you press the [Configure]'
     +/'button you will be able to specify which auxiliary programs you'
     +/'want Simfit to use. Pressing the [Check] button followed by the'
     +/'[Apply] button will install your chosen programs.'
     +/
     +/'If Simfit cannot find a specified program, you can input a full'
     +/'drive\path\filename, a new filename, or else a drive\path to be'
     +/'searched for the missing file.'
     +/
     +/'If you do not know a search path, then search from the root (',
     +a,')')
  800 format ('Path does not exist')
  900 format (
     + 'Setting specified Simfit auxiliary programs'
     +/
     +/'Simfit uses several auxiliary programs. Some of these, such as'
     +/'Notepad.exe are part of the Windows OS while, e.g. SumatraPDF,'
     +/'or Acrobat reader must be defined as Windows defaults.'
     +/'You can specify your text editor, disc explorer, or calculator.'
     +/
     +/'if you do not want to use the Simfit defaults you can switch'
     +/'off checking for missing non-essential auxiliaries.'
     +/
     +/'Simfit stores path-filenames in the file w_simfit.cfg in your'
     +/'...ProgramData\Simfit\user\cfg folder.'
     +/
     +/'Change in configuration from Version 8.0.6'
     +/'EPS view/transform needs Ghostscript DLL in .... \bin folder'
     +/'PDF view uses the Windows default PDF viewer'
     +/
     +/'You may wish to specify your own auxiliaries and this is easy'
     +/'to do by one of two methods. First open the configuration page'
     +/'then fill in the appropriate edit box by either:'
     +/'1) Typing in the full path-filename directly, or'
     +/'2) Copying and Pasting the full path-filename from Explorer.')
      end
c
c








      

