c
c
      subroutine w_ploteb (n,
     +                     x, y_bot, y_mid, y_top)
c
c action: simple error bar plot              
c author: w.g.bardsley, university of manchester, u.k., 20/09/2011
c
      implicit none
      include <windows.ins>
c
c arguments
c      
      integer,          intent (in) :: n
      double precision, intent (in) :: x(n), 
     +                                 y_bot(n), y_mid(n), y_top(n)
c
c allocatable
c     
      double precision, allocatable :: x1(:), y1(:), y2(:), y3(:)
      integer,          allocatable :: ix(:), iy(:) 
c
c locals
c      
      integer    i, icol, ierr, ixwide, iyhigh, n1
      integer    ia, ib, ix1, ix2, iy1, iy2
      integer    iadd
      parameter (iadd = 10)
      double precision xdiff, xmax, xmin, xwide,
     +                 ydiff, yhigh, ymax, ymin
      double precision zero, one, factor, fraction
      parameter (zero = 0.0d+00, one = 1.0d+00, factor = 200.0d+00, 
     +           fraction = 0.67d+00)
      intrinsic  max, min, nint, dble
c
c check then allocate and initialise 
c     
      if (n.lt.1) then
        return
      else  
        n1 = n 
      endif   
      ierr = 0
      allocate (x1(n1), stat = ierr)
      if (ierr.ne.0) return 
      allocate (y1(n1), stat = ierr)
      if (ierr.ne.0) return
      allocate (y2(n1), stat = ierr)
      if (ierr.ne.0) return
      allocate (y3(n1), stat = ierr)
      if (ierr.ne.0) return  
      allocate (ix(n1), stat = ierr)
      if (ierr.ne.0) return
      allocate (iy(n1), stat = ierr)
      if (ierr.ne.0) return    
      xmax = x(1)
      xmin = x(1)
      ymax = max(y_bot(1), y_mid(1), y_top(1))
      ymin = min(y_bot(1), y_mid(1), y_top(1))
      do i = 2, n
         if (x(i).lt.xmin) xmin = x(i)
         if (x(i).gt.xmax) xmax = x(i)  
         if (y_bot(i).lt.ymin) ymin = y_bot(i)
         if (y_bot(i).gt.ymax) ymax = y_bot(i)
         if (y_mid(i).lt.ymin) ymin = y_mid(i)
         if (y_mid(i).gt.ymax) ymax = y_mid(i)
         if (y_top(i).lt.ymin) ymin = y_top(i)
         if (y_top(i).gt.ymax) ymax = y_top(i) 
      enddo
c
c get screen dimensions and map onto (0,1)
c      
      xwide = fraction*dble(clearwin_info@('SCREEN_WIDTH'))
      yhigh = fraction*dble(clearwin_info@('SCREEN_DEPTH'))
      xdiff = xmax - xmin
      if (xdiff.le.zero) return
      ydiff = ymax - ymin
      if (ydiff.le.zero) return  
      do i = 1, n1
         x1(i) = xwide*(x(i) - xmin)/xdiff
         y1(i) = yhigh*(one - (y_bot(i) - ymin)/ydiff)
         y2(i) = yhigh*(one - (y_mid(i) - ymin)/ydiff)
         y3(i) = yhigh*(one - (y_top(i) - ymin)/ydiff)
      enddo
c
c increase slightly to avoid cropping plotting symbols
c      
      do i = 1, n1
         ix(i) = nint(x1(i)) + iadd
         iy(i) = nint(y2(i)) + iadd
      enddo 
      ixwide = nint(xwide) + 2*iadd
      iyhigh = nint(yhigh) + 2*iadd 
c
c create the plot
c      
      i = winio@('%ca[Simfit: simple error bar plot]&')   
      i = winio@('%gr[white,rgb_colours]&', ixwide, iyhigh)	
      icol = rgb@(250,0,0)
      call draw_polyline@(ix, iy, n1, icol)
      icol = rgb@(0,0,250)
      ia = nint(xwide/factor)
      ib = ia
      do i = 1, n1
         ix1 = ix(i)
         ix2 = ix(i)
         iy1 = nint(y1(i)) + iadd
         iy2 = nint(y3(i)) + iadd
         call draw_line_between@(ix1, iy1, ix2, iy2, icol)
         call draw_filled_ellipse@(ix(i), iy(i), ia, ib, icol)
      enddo  
      i = winio@(' ')
c
c deallocate
c      
      deallocate(x1,stat = ierr)
      deallocate(y1,stat = ierr)
      deallocate(y2,stat = ierr)
      deallocate(y3,stat = ierr)
      end
c
c      
