C
C
      SUBROUTINE W_PLOTSQ (NFILES,
     +                     BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE)
C
C ACTION: Plot PS file BoundingBoxes
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 1/2/98
C         3/8/98 saved KFILE between calls
C         08/08/2003 extensive editing to clip icon movement
C         20/07/2007 edited for w_clearwin.dll 
C         08/01/2009 added call to use_resource_library@
C         30/10/2016 replaced resource_library@ by call to w_reslib
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NFILES
      DOUBLE PRECISION, INTENT (IN)    :: BBOXX(2,NFILES), 
     +                                    BBOXY(2,NFILES)
      DOUBLE PRECISION, INTENT (INOUT) :: XTRANS(NFILES),
     +                                    YTRANS(NFILES),
     +                                    ZSCALE(NFILES)
C
C Locals
C     
      INTEGER (KIND = 7) ICON
      INTEGER    N0, N1, N2, N200, N255, NUMTXT
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N200 = 200, N255 = 255,
     +           NUMTXT = 20)
      INTEGER    I, ICOLOR
      INTEGER    IXRES, IX1, IX2, IYRES, IY1, IY2, JSIZE
      INTEGER    XRES, YRES
      INTEGER    IPRESS, ISIZE, IX_HIGH, IX_LOW, IX_MOUSE,
     +           IY_HIGH, IY_LOW, IY_MOUSE, KFILE
      INTEGER    I_END_IT_ALL, I_MAGNIFY, I_MOVE_BOX, I_REDUCE,
     +           I_SCALE_DOWN, I_SCALE_UP, I_SELECT_BOX,
     +           I_SHIFT_DOWN, I_SHIFT_UP, I_TELL_ALL, I_XYMOUSE
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION AMOUNT, F72, SCALE_DOWN, SCALE_UP,
     +                 SHIFT_DOWN, SHIFT_UP
      PARAMETER (AMOUNT = 0.85D+00, F72 = 72.0D+00,
     +           SCALE_DOWN = 0.9D+00, SCALE_UP = 1.0D+00/SCALE_DOWN,
     +           SHIFT_DOWN = 0.75D+00, SHIFT_UP = 1.0D+00/SHIFT_DOWN)
      DOUBLE PRECISION DISIZE, FACTOR
      CHARACTER  TEXT(NUMTXT)*100, WORD2*2
      LOGICAL    FRAME, NEXT, UPDOWN
      PARAMETER (FRAME = .FALSE., UPDOWN = .FALSE.)
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      EXTERNAL  W_SYSPAR, X_GETJM1, X_PUTADV, W_TUTORS, W_RESLIB
      EXTERNAL  I_END_IT_ALL, I_MAGNIFY, I_MOVE_BOX, I_REDUCE,
     +          I_SCALE_DOWN, I_SCALE_UP, I_SELECT_BOX,
     +          I_SHIFT_DOWN, I_SHIFT_UP, I_TELL_ALL, I_XYMOUSE
      INTRINSIC DBLE, NINT
      SAVE      ISIZE, KFILE, XRES, YRES
      DATA      NUMBLD / NUMTXT*0 /
      DATA      KFILE / 1 /
C
C Initialise
C
      call w_reslib
      IPRESS = 0
      ISIZE = 36
      IX_MOUSE = 1
      IY_MOUSE = 1
      IF (KFILE.GT.NFILES) KFILE = 1
      CALL W_SYSPAR (XRES, 'x')
      XRES = NINT(AMOUNT*DBLE(XRES))
      IXRES = XRES
      CALL W_SYSPAR (YRES, 'y')
      YRES = NINT(AMOUNT*DBLE(YRES))
      IYRES = YRES
      IX_LOW = N1
      IX_HIGH = XRES - N1
      IY_LOW = N1
      IY_HIGH = YRES - N1
C
C Main branch point for repeated editing
C
   20 CONTINUE

C
C Check IPRESS on return from the display
C
      IF (IPRESS.EQ.1) THEN
C...magnify
         ISIZE = 2*ISIZE
         IF (ISIZE.GT.288) ISIZE = 288
      ELSEIF (IPRESS.EQ.2) THEN
C...reduce
         ISIZE = ISIZE/2
         IF (ISIZE.LT.9) ISIZE = 9
      ELSEIF (IPRESS.EQ.3) THEN
C...Big increase
         ZSCALE(KFILE) = SHIFT_UP*ZSCALE(KFILE)
      ELSEIF (IPRESS.EQ.4) THEN
C...Small increase
         ZSCALE(KFILE) = SCALE_UP*ZSCALE(KFILE)
      ELSEIF (IPRESS.EQ.5) THEN
C...Small decrease
         ZSCALE(KFILE) = SCALE_DOWN*ZSCALE(KFILE)
      ELSEIF (IPRESS.EQ.6) THEN
C...Big decrease
         ZSCALE(KFILE) = SHIFT_DOWN*ZSCALE(KFILE)
      ELSEIF (IPRESS.EQ.7) THEN
C...Move
         DISIZE = DBLE(ISIZE)
         FACTOR = DISIZE/F72
         XTRANS(KFILE) = (DBLE(IX_MOUSE) - BBOXX(1,KFILE)*FACTOR)/DISIZE
         YTRANS(KFILE) = (DBLE(IYRES) - DBLE(IY_MOUSE) -
     +                    BBOXY(1,KFILE)*FACTOR)/DISIZE
      ELSEIF (IPRESS.EQ.8) THEN
C...Select
         IF (NFILES.EQ.1) THEN
            CALL X_PUTADV ('There is only one file in this set')
         ELSE
            IF (KFILE.LT.N1 .OR. KFILE.GT.NFILES) KFILE = N1
            CALL X_GETJM1 (N1, KFILE, NFILES,
     +     'Number of the PS file to become the current object')
         ENDIF
         CALL WINDOW_UPDATE@(KFILE)
      ELSEIF (IPRESS.EQ.9) THEN
C...Help
         WRITE (TEXT,100)
         NUMBLD(1) = 1
         ICOLOR = 9
         NEXT = .TRUE.
         CALL W_TUTORS (ICOLOR, NUMBLD, NUMTXT, 
     +                  TEXT, 
     +                  FRAME, NEXT, UPDOWN)
      ENDIF
C
C Open the window
C
      I = WINIO@('%sy[3d_thin]&')
      I = WINIO@('%hw&', ICON(1))
      I = WINIO@('%ca[Simfit: EPS transformations, grid = inches]&')
      I = WINIO@('%^gr[white]%ww[no_sysmenu, maximise,
     +            no_maxminbox]&', XRES, YRES, I_XYMOUSE)
      I = WINIO@('%LC&', ICON(2))
      I = USE_RGB_COLOURS@(N0, N1)

C
C Draw the grid
C
      CALL SET_LINE_WIDTH@(N1)
      ICOLOR = RGB@(N200, N200, N200)
      IX1 = 0
      IY1 = 0
      IY2 = IYRES
      JSIZE = ISIZE
      DO I = 1, 100
         IX1 = IX1 + JSIZE
         IF (IX1.LT.IXRES) THEN
            IX2 = IX1
            CALL DRAW_LINE_BETWEEN@(IX1, IY1, IX2, IY2, ICOLOR)
         ENDIF
      ENDDO
      IX1 = 0
      IX2 = IXRES
      IY1 = IYRES
      DO I = 1, 100
         IY1 = IY1 - JSIZE
         IF (IY1.GT.0) THEN
            IY2 = IY1
            CALL DRAW_LINE_BETWEEN@(IX1, IY1, IX2, IY2, ICOLOR)
         ENDIF
      ENDDO
C
C Draw A4 paper
C
      IX1 = 0
      IX2 = 8*JSIZE
      IY1 = IYRES
      IY2 = IYRES - 12*JSIZE
      CALL SET_LINE_WIDTH@(N2)
      ICOLOR = RGB@(  N0,  N0,  N0)
      CALL DRAW_RECTANGLE@(IX1, IY1, IX2, IY2, ICOLOR)
C
C Draw the boxes
C
      CALL SET_LINE_WIDTH@(N1)
      DISIZE = DBLE(ISIZE)
      FACTOR = DISIZE/F72
      DO I = 1, NFILES
         IF (I.EQ.2 .OR. I.EQ.6 .OR. I.EQ.10 .OR. I.EQ.14) THEN
            ICOLOR = RGB@( N255,   N0,   N0)
         ELSEIF (I.EQ.3 .OR. I.EQ.7 .OR. I.EQ.11 .OR. I.EQ.15) THEN
            ICOLOR = RGB@(   N0, N255,   N0)
         ELSEIF (I.EQ.4 .OR. I.EQ.8 .OR. I.EQ. 12 .OR. I.EQ.16) THEN
            ICOLOR = RGB@(   N0,   N0, N255)
         ELSE
            ICOLOR = RGB@(  N0,   N0,   N0)
         ENDIF
         IX1 = NINT(DISIZE*XTRANS(I)) +
     +         NINT(BBOXX(1,I)*FACTOR)
         IX2 = IX1 +
     +         NINT((BBOXX(2,I) - BBOXX(1,I))*FACTOR*ZSCALE(I))
         IY1 = IYRES - NINT(DISIZE*YTRANS(I)) -
     +         NINT(BBOXY(1,I)*FACTOR)
         IY2 = IYRES - NINT(DISIZE*YTRANS(I)) -
     +         NINT(BBOXY(1,I)*FACTOR) -
     +         NINT((BBOXY(2,I) - BBOXY(1,I))*FACTOR*ZSCALE(I))
         CALL DRAW_FILLED_RECTANGLE@(IX1, IY1, IX2, IY2, ICOLOR)
         ICOLOR = RGB@(   N0,   N0,   N0)
         CALL DRAW_RECTANGLE@(IX1, IY1, IX2, IY2, ICOLOR)
         ICOLOR = RGB@( N255, N255, N255)
         WRITE (WORD2,'(I2)') I
         CALL SELECT_FONT@('Modern')
         CALL DRAW_CHARACTERS@(WORD2, IX1, IY1, ICOLOR)
      ENDDO

C
C Close the window
C
      I = WINIO@('%1.11ob[invisible]&')
      I = WINIO@('%nl%^4bt[Magnify]%cb%nl&', i_magnify)
      I = WINIO@('%^4bt[Reduce]%cb%nl&',     i_reduce)
      I = WINIO@('%^4bt[+33%]%cb%nl&',       i_shift_up)
      I = WINIO@('%^4bt[+11%]%cb%nl&',       i_scale_up)
      I = WINIO@('%^4bt[-10%]%cb%nl&',       i_scale_down)
      I = WINIO@('%^4bt[-25%]%cb%nl&',       i_shift_down)
      I = WINIO@('%^4bt[Move]%cb%nl&',       i_move_box)
      I = WINIO@('%`2rd%cb%nl&', kfile)
      I = WINIO@('%^4bt[Select]%cb%nl&',     i_select_box)
      I = WINIO@('%^4bt[Help]%cb%nl&',       i_tell_all)
      ICON(3) = ADD_GRAPHICS_ICON@('icon_arr',
     +                             IX_MOUSE, IY_MOUSE, N0, N0)
      I = I_XYMOUSE()
      I = WINIO@('%^4bt[Apply]%cb',          i_end_it_all)

C
C Is a return requested
C
      IF (IPRESS.GE.1 .AND. IPRESS.LE.9) THEN
         GOTO 20
      ELSE
         RETURN
      ENDIF
  100 FORMAT ('Rearranging and re-sizing eps files'
     +/'This utility accepts a set of .eps files and allows you to move'
     +/'them about and re-scale them to create a collage or overlay. It'
     +/'is important that the files have accurate BoundingBoxes, since'
     +/'what you will see with this utility is a set of rectangles in'
     +/'different colours representing the extent of the BoundingBoxes.'
     +/'Simfit creates BoundingBoxes equal to the clipping rectangle,'
     +/'which is advantageous if you want axes to have standard sizes.'
     +/'Some other packages calculate BoundingBoxes incorrectly so you'
     +/'may have to use GSview/Ghostscript to transform ps into eps.'
     +/'1)`Select each file (i.e. figure) in sequence and drag it to'
     +/'  `the position you want it to occupy (using the arrow icon).'
     +/'2)`Always move the bottom left hand corner to the new position'
     +/'  `set by the icon, noting that each grid position corresponds'
     +/'  `to 72 points (1 inch). A4 (shown) is about 8 by 12 inches.'
     +/'3)`Magnifying and reducing only alters display surface size but'
     +/'  `% scaling alters the actual size of the figure selected.'
     +/'4)`If you want more precise control over rearranging or want'
     +/'  `rotating or differential scaling use the other menu options.'
     +/'5)`Use GSview/Ghostscript to check visually before printing.')
      END
C
C
      recursive integer function I_MAGNIFY()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 1
      I_MAGNIFY = 0
      END
C
C
      recursive integer function I_REDUCE()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 2
      I_REDUCE = 0
      END
C
C
      recursive integer function I_SHIFT_UP()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE, IY_LOW,
     +                      IY_HIGH, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 3
      I_SHIFT_UP = 0
      END
C
C
      recursive integer function I_SCALE_UP()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE, IY_LOW,
     +                      IY_HIGH, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 4
      I_SCALE_UP = 0
      END
C
C
      recursive integer function I_SCALE_DOWN()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 5
      I_SCALE_DOWN = 0
      END
C
C
      recursive integer function I_SHIFT_DOWN()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON      
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 6
      I_SHIFT_DOWN = 0
      END
C
C
      recursive integer function I_MOVE_BOX()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 7
      I_MOVE_BOX = 0
      END
C
C
      recursive integer function I_SELECT_BOX()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 8
      I_SELECT_BOX = 0
      END
C
C
      recursive integer function I_TELL_ALL()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 9
      I_TELL_ALL = 0
      END
C
C
      recursive integer function I_END_IT_ALL()
      IMPLICIT NONE
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
      IPRESS = 10
      I_END_IT_ALL = 0
      END
C
C
      recursive integer function I_XYMOUSE()
      IMPLICIT NONE
      INCLUDE <WINDOWS.INS>
      INTEGER (KIND = 7) ICON
      INTEGER  IPRESS, IX_HIGH, IX_LOW, IX_MOUSE,
     +                      IY_HIGH, IY_LOW, IY_MOUSE
      COMMON   /EDITPS_DATA/ ICON(4), IPRESS,
     +                       IX_HIGH, IX_LOW, IX_MOUSE,
     +                       IY_HIGH, IY_LOW, IY_MOUSE
c
c save the screen coordinates using savexy$ when the icon is dragged
c this subroutine is called after every mouse controlled icon drag
c
c 12/08/2003 derived from i_track_mouse in w_graphics.dll
c
      integer    h0, w0, rc(4), x0, y0
      integer    x1, x2, y1, y2
      integer   (kind = 7) i0
      parameter (i0 = 0)
      logical    l
      intrinsic  dble, nint, core4
      l = .true.!to silence ftn95
      icon(4) = clearwin_info@('dropped_icon')
c*****icon(4) = clearwin_info@('dragged_icon')
      if (l .and. icon(3).eq.icon(4)) then
         call get_window_location@(icon(1), x1, y1, w0, h0)
         call get_window_location@(icon(2), x2, y2, w0, h0)
         x0 = x1 + x2
         y0 = y1 + y2
         rc(1) = x0 + ix_low
         rc(2) = y0 + iy_low
         rc(3) = x0 + ix_high
         rc(4) = y0 + iy_high
         l = clipcursor(rc)
      else
        l = clipcursor(core4(i0))
      endif
      if (ix_mouse.lt.ix_low) then
         ix_mouse = ix_low
      elseif (ix_mouse.gt.ix_high) then
         ix_mouse = ix_high
      endif
      if (iy_mouse.lt.iy_low) then
         iy_mouse = iy_low
      elseif (iy_mouse.gt.iy_high) then
         iy_mouse = iy_high
      endif
      I_XYMOUSE = 2
      END
C
C