c
c This file contains:
c w_putall: the message box for simple messages with an icon 
c x_putdbl: interface for simple messages with double precision value and no icon
c x_putint: interface for simple messages with integer value and no icon
c x_putlgl: interface for simple messages with logical value and no icon
c x_puttxt: interface for simple text messages without an icon
c
      subroutine w_putall (isend,
     +                     strng)
c
c action: put one line messages out in a graphics environment
c author: w.g.bardsley, university of manchester, u.k., 15/11/2004
c         20/03/2007 edited for w_clearwin.dll
c         05/12/2017 added the case isend = 5 for a simple text string
c         20/04/2022 removed the prefixes ADVICE, CAUTION, WARNING and FATAL
c   
c         isend: (input/unchanged) action as follows:
c                isend = 1: advice
c                isend = 2: caution
c                isend = 3: warning
c                isend = 4: fatal
c                isend = 5: text  
c         strng: (input/unchanged) string
c
      implicit none
      include <windows.ins>
c
c arguments
c
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: strng
c
c locals
c
      integer    i, j, k
      character (len = 256) caption, line
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    advice, caution, fatal, text, warning
c
c check
c
      if (isend.lt.1 .or. isend.gt.5 .or. strng.eq.blank) return
c
c initialise
c
      advice = .false.
      caution = .false.
      warning = .false.
      fatal = .false.
      text = .false.
      line = strng
      if (isend.eq.1) then
         advice = .true.
      elseif (isend.eq.2) then
         caution = .true.
      elseif (isend.eq.3) then
         warning = .true.
      elseif (isend.eq.4) then
         fatal = .true.
      elseif (isend.eq.5) then 
         text = .true.
      endif

c
c use Windows MessageBox function as in i = MessageBox (j, line, caption, k)
c j = 0 implies null handle, icon type as follows:-
C k = MB_ICONHAND = 16 (fatal, x icon),
c k = MB_ICONEXCLAMATION = 48 (warning, ! icon)
c k = MB_ICONINFORMATION = 64 (information, i icon)
c k = k + SYSTEMMODAL + MB_OK makes the window a top-level window with 1 button
c


      j = 0
      if (advice) then
         caption = 'Simfit: advisory message'
         k = MB_ICONINFORMATION
      elseif (caution) then
         caption = 'Simfit: cautionary message'
         k = MB_ICONEXCLAMATION
      elseif (warning) then
        caption = 'Simfit: warning message'
         k = MB_ICONEXCLAMATION
      elseif (fatal) then
         caption = 'Simfit: fatal error message'
         k = MB_ICONHAND
      elseif (text) then  
         caption = 'Simfit: information'
         k = 0 
      endif
      k = k + MB_SYSTEMMODAL + MB_OK
      i = messagebox (j, line, caption, k)
      k = i!to silence ftn95
      end
c
c
      subroutine x_puttxt (strng)
c
c action: display a simple string with no icon using the message box
c author: w.g.bardsley, university of manchester, u.k., 06/12/2017
c      
      implicit   none
      character (len = *), intent (in) :: strng
      integer    isend
      parameter (isend = 5) 
      external   w_putall
      call w_putall (isend,
     +               strng)
      end
c
c    
      subroutine x_putdbl (x,
     +                     strng)
c
c action: display a string and double precision value using the message box
c author: w.g.bardsley, university of manchester, u.k., 06/12/2017
c         Note: the argument order follows the SIMFIT convention of integers > doubles > characters > logical
c     
      implicit none
      double precision,    intent (in) :: x
      character (len = *), intent (in) :: strng
      integer    k 
      character (len = 256) line
      character (len = 25 ) word25, x_form25
      character (len = 1  ) blank
      parameter (blank = ' ')
      external   x_puttxt, x_form25 
      intrinsic  len_trim
      k = len_trim(strng)
      word25 = x_form25 (x)
      line = strng(1:k)//blank//word25
      call x_puttxt (line)
      end
c
c      
      subroutine x_putint (i,
     +                     strng)
c
c action: display a string and integer value using the message box
c author: w.g.bardsley, university of manchester, u.k., 06/12/2017
c         Note: the argument order follows the SIMFIT convention of integers > doubles > characters > logical
c     
      implicit none
      integer,             intent (in) :: i
      character (len = *), intent (in) :: strng
      integer    k 
      character (len = 256) line
      character (len = 12 ) word12, x_form12
      character (len = 1  ) blank
      parameter (blank = ' ')
      external   x_puttxt, x_form12 
      intrinsic  len_trim
      k = len_trim(strng)
      word12 = x_form12 (i)
      line = strng(1:k)//blank//word12
      call x_puttxt (line)
      end
c
c      
      subroutine x_putlgl (strng,
     +                     l)
c
c action: display a string and logical value using the message box
c author: w.g.bardsley, university of manchester, u.k., 06/12/2017
c         Note: the argument order follows the SIMFIT convention of integers > doubles > characters > logical
c     
      implicit none
      logical,             intent (in) :: l
      character (len = *), intent (in) :: strng
      integer    k 
      character (len = 256) line
      external   x_puttxt 
      intrinsic  len_trim
      k = len_trim(strng)
      if (l) then
         line = strng(1:k)//' .true.'
      else   
         line = strng(1:k)//' .false.'
      endif   
      call x_puttxt (line)
      end               
c
c      