c
c
      subroutine w_rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text_in,
     +                     fixed, full, high)
c
c action : put out a text plus radio buttons with attributes onto a window
c author : w.g.bardsley, university of manchester
c          derived from w_lbox01 on 28/08/97 
c          09/09/1998 made into a normal dialogue window
c          01/11/1998 changed colour and tidied up
c          12/04/1999 suppressed closure from caption cross to avoid ambiguity
c                     Note: this control should really have a cancel button to
c                           restore the defaults, i.e. entry values
c          04/12/1999 restored topmost
c          21/01/2001 suppressed topmost
c          13/02/2002 XP version
c          21/02/2002 moved colour definition until after %`sf which resets everything
c          18/12/2002 added %sy[toolwindow] and putfat for error reporting  
c          18/11/2006 suppressed toolwindow and sys_menu and and added intents
c          05/02/2007 edited for w_clearwin.dll 
c          30/05/2007 added allocatable array and calls to w_dbleup
c          12/04/2015 increased ganging to 10 of either type  
c          31/07/2017 added a Stop menu with call back function i_stop_this_program
c          18/08/2016 changed %ff for %nl to display blank lines and suppressed the %bg background
c          29/11/2017 removed %sy[3d_thin, no_sysmenu], and restored %bg
c          30/05/2019 re-set background colour to rgb@(240,240,240)
c          30/03/2020 now uses radio buttons instead of check boxes for ganged sets  
c          19/02/2021 introduced kmax, xtra, and insert to add blank lines between radio buttons and text where:
c                     kmax = upper limit for introducig spacing depending on numopt
c                     xtra = argument to winio@ to create blank lines
c                     insert = .true. if numopt =< kmax   
c
c          this version uses: len200 = leng@ = len_trim, lcase1 = lcase@
c          to be compatible with ftn77 and ftn90
c
c          This version creates the menu as radio buttons but
c          some parameters are disabled or have altered meanings
c  icolor: (input/unchanged) not used in this version  
c     ixl: (input/unchanged) x-coordinate
c     iyl: (input/unchanged) y-coordinate
c  lshade: (input/unchanged) shading ... not used in this version
c  numbld: (input/unchanged) has special meaning within a menu sub-group
c  numdec: (input/unchanged) is <= 0 for radio o/w check boxes
c  numopt: (input/unchanged) no. of options
c  numpos: (input/output) is 0,1 for false/true
c  numsta: (input/unchanged) starting line for menu items
c  numtxt: (input/unchanged) no. of text lines
c text_in: (input/unchanged) header plus embedded menu items
c   fixed: (input/unchanged) use fixed or proportional fonts
c    full: (input/unchanged) not used in this version
c    high: (input/unchanged) not used in this version
c
c          note how ganging is achieved as follows:-
c          =========================================
c          The idea is that positive hundreds for numbld form ganged
c          groups where at least one must be switched on, but negative
c          hundreds form ganged groups where they can all be switched
c          off. At most one can be switched on in any ganged group.
c          for example-
c          set corresponding numbld = 100 leads to a 100-type group
c          set corresponding numbld = - 100 leads to a -100-type group
c          set corresponding numbld = 200 leads to a 200-type group
c          set corresponding numbld =  -200 leads to a -200-type group
c          set corresponding numbld = 300 leads to a 300-type group
c          set corresponding numbld =  -300 leads to a -300-type group
c          the significance of this is as follows:
c          =======================================
c          if numbld(i) < 0 then the controls in a group can be all off
c          if numbld(i) > 0 then one control in a group must be switched on
c          only one of the numpos can be switched on (i.e. 1) in any group
c          it is necessary to edit if large groups > 10 are required
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times           ... changed to ms sans serif
c          2, 3       Times Italic
c          4, 5       Times Bold
c          6, 7       Times Bold Italic
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numdec, numopt, numsta,
     +                                       numtxt
      integer,             intent (in)    :: numbld(numtxt)
      integer,             intent (inout) :: numpos(numopt) 
      character (len = *), intent (in)    :: text_in(numtxt) 
      logical,             intent (in)    :: fixed, full, high 
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
c
c locals
c      
      integer    isend
      parameter (isend = 1)
      integer    i, iabs, ierr, j, k, l, m, m0, m1, nstart, ntext
      integer    x_len200
      integer    iscale
      integer    kmax, nmax
      parameter (kmax = 15, nmax = 20)
      integer    n0, n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12,
     +           n13, n14, n15, n16, n17, n18, n19, n20,
     +           n30, n100, n200, n300, n400, n500, n600, n700, n800,
     +           n900, n1000      
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6,
     +           n7 = 7, n8 = 8, n9 = 9, n10 = 10, n11 = 11, n12 = 12,
     +           n13 = 13, n14 = 14, n15 = 15, n16 = 16, n17 = 17,
     +           n18 = 18, n19 = 19, n20 = 20,
     +           n30 = 30, n100 = 100, n200 = 200, n300 = 300,
     +           n400 = 400, n500 = 500, n600 = 600, n700 = 700,
     +           n800 = 800, n900 = 900, n1000 = 1000)
      integer    mgang, ngang(n30)
      integer    ixyuse, ixy_use
      parameter (ixy_use = 1)
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00)
      double precision correction, factor, percent, tabvar
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character (len = 129) line, w_dbleam, w_dbleup
      character (len = 6  ) xtra
      parameter (xtra = '%nl  &')
      character (len = 2  ) space
      character (len = 1  ) blank
      parameter (blank = ' ', space = '  ')
      logical    ok, insert
      logical    check1
      external   x_len200, x_putfat
      external   w_syspar, w_dbleup, w_dbleam
      external   add_stop_option
      intrinsic  len, dble, index, abs
c
c Scale the font sizes
c                   
      nstart = numsta
      ntext = numtxt
      check1 = .true.
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_roman = size_courier
      size_msss = correction*size_msss_1
c
c lesser check if required (generally required for check boxes)
c
      if (check1) then
         ok = .true.
         if (ntext.lt.n2 .or. ntext.lt.numopt .or. numopt.lt.n2 .or.
     +       nstart.lt.n1 .or. nstart + numopt - n1.gt.ntext .or.
     +       numopt.gt.n30) ok = .false.
          do i = n1, numopt
            j = numpos(i)
            if (j.lt.n0 .or. j.gt.n1) ok = .false.
         enddo
         k = len(line)
         do i = n1, ntext
            l = len(text(i))
            if (l.gt.k) ok = .false.
         enddo
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_rbox01')
            return
         endif
      endif    
c
c position
c         
       if (ixl.le.n0 .or. iyl.le.n0) then
          ixyuse = n2
       else
          ixyuse = ixy_use
       endif      
c
c allocate
c         
      ierr = n0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.n0) return
      allocate(text(ntext), stat = ierr)
      if (ierr.ne.n0) return  
      j = nstart + numopt - n1
      do i = n1, ntext   
         if (i.lt.nstart .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else
            text(i) = w_dbleam(text_in(i))
         endif       
      enddo
c
c use up dummy arguments to stop ftn95 complaining
c
      i = icolor
      i = lshade
      ok = full
      ok = high
      if (ixyuse.eq.n1) then
c
c use ixl, iyl and parameter iscale to position the window
c
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)  
      endif   
      i = winio@('%ca[Simfit: check list]&')
c
c uncomment the next line for a normal window rather than a dialogue window
c =========================================================================
c*****i = winio@('%ww[no_sysmenu, topmost]&')
c

c
c set the background colour (fixed to light grey)
c
      k = winio@('%bg&',rgb@(240,240,240))     
c
c define insert
c 
      if (numopt.le.kmax) then
         insert = .true.
      else
         insert = .false.
      endif            
c
c add the Stop menu
c
      if (numtxt.le.nmax) call add_stop_option (isend)
c
c put out the text strings up to the menu
c
      do i = n1, nstart - n1
c
c now set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
c
c set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
            k = winio@(line, size_courier)
         else               
            if (i.eq.1 .and. numbld(1).ne.0) then 
                k = winio@('%`sf%bf&')
            elseif (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif
c
c set the text color depending on numbld(i)
c                                       
            if (i.eq.1 .and. numbld(1).ne.0) then  
                k = winio@('%tc[black]&')
            elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//'&'
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               k = winio@(line, size_roman)
            endif
         endif
c
c the next call creates a line feed
c
         k = winio@('%nl&')
      enddo
c
c check for ganging where numbld = 100 or numbld = 200 or numbld = 300
c generating adjacent groups where one must be swtiched on
c
      do l = n1, n20
         m0 = n0
         m1 = n0
         if (l.eq.n1) then
            m = -n1000
         elseif (l.eq.n2) then
            m = - n900
         elseif (l.eq.n3) then
            m = - n800   
         elseif (l.eq.n4) then
            m = - n700
         elseif (l.eq.n5) then
            m = - n600
         elseif (l.eq.n6) then
            m = - n500
         elseif (l.eq.n7) then
            m = - n400
         elseif (l.eq.n8) then
            m = - n300
         elseif (l.eq.n9) then
            m = - n200
         elseif (l.eq.n10) then
            m = - n100
         elseif (l.eq.n11) then
            m = n100
         elseif (l.eq.n12) then
            m = n200   
         elseif (l.eq.n13) then
            m = n300
         elseif (l.eq.n14) then
            m = n400
         elseif (l.eq.n15) then
            m = n500
         elseif (l.eq.n16) then
            m = n600
         elseif (l.eq.n17) then
            m = n700
         elseif (l.eq.n18) then
            m = n800
         elseif (l.eq.n19) then
            m = n900
         elseif (l.eq.n20) then
            m = n1000      
         endif
         mgang = n0
         j = n0
         do i = nstart, nstart + numopt - n1
            j = j + n1
            if (numbld(i).eq.m) then
               mgang = mgang + n1
               ngang(mgang) = j
               if (numpos(j).eq.n0) then
                  m0 = m0 + n1
               else
                  m1 = m1 + n1
               endif
            endif
         enddo
c
c check mgang, m0, m1 and numpos for consistency
c
         if (mgang.eq.n1) then
            call x_putfat (
     +'ganging error: there cannot be a gang size of 1 in w_rbox01&')
         elseif (mgang.ne.n0) then
            if ((m.gt.n0 .and. m1.ne.1) .or.
     +          (m.lt.n0 .and. m1.gt.n1)) then
               call x_putfat (
     +'ganging error: numbld/numpos inconsistent in call to w_rbox01&')
            endif
         endif
         if (m.gt.n0) then
            if (mgang.eq.2) then
               k = winio@('%2`ga&', numpos(ngang(1)), numpos(ngang(2)))
            elseif (mgang.eq.3) then
               k = winio@('%3`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)))
            elseif (mgang.eq.4) then
               k = winio@('%4`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)))
            elseif (mgang.eq.5) then
               k = winio@('%5`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)),
     +                              numpos(ngang(5)))
            elseif (mgang.eq.6) then
               k = winio@('%6`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)),
     +                              numpos(ngang(5)), numpos(ngang(6)))
            elseif (mgang.eq.7) then
               k = winio@('%7`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)),
     +                              numpos(ngang(5)), numpos(ngang(6)),
     +                              numpos(ngang(7)))
            elseif (mgang.eq.8) then
               k = winio@('%8`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)),
     +                              numpos(ngang(5)), numpos(ngang(6)),
     +                              numpos(ngang(7)), numpos(ngang(8)))
            elseif (mgang.eq.9) then
               k = winio@('%9`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)),
     +                              numpos(ngang(5)), numpos(ngang(6)),
     +                              numpos(ngang(7)), numpos(ngang(8)),
     +                              numpos(ngang(9)))
            elseif (mgang.eq.10) then
               k = winio@('%10`ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                               numpos(ngang(3)), numpos(ngang(4)),
     +                               numpos(ngang(5)), numpos(ngang(6)),
     +                               numpos(ngang(7)), numpos(ngang(8)),
     +                               numpos(ngang(9)),numpos(ngang(10)))
            endif
         else
            if (mgang.eq.2) then
               k = winio@('%2ga&', numpos(ngang(1)), numpos(ngang(2)))
            elseif (mgang.eq.3) then
               k = winio@('%3ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)))
            elseif (mgang.eq.4) then
               k = winio@('%4ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)), numpos(ngang(4)))
            elseif (mgang.eq.5) then
               k = winio@('%5ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)), numpos(ngang(4)),
     +                             numpos(ngang(5)))
            elseif (mgang.eq.6) then
               k = winio@('%6ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)), numpos(ngang(4)),
     +                             numpos(ngang(5)), numpos(ngang(6)))
            elseif (mgang.eq.7) then
               k = winio@('%7ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)), numpos(ngang(4)),
     +                             numpos(ngang(5)), numpos(ngang(6)),
     +                             numpos(ngang(7)))
            elseif (mgang.eq.8) then
               k = winio@('%8ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)), numpos(ngang(4)),
     +                             numpos(ngang(5)), numpos(ngang(6)),
     +                             numpos(ngang(7)), numpos(ngang(8)))
            elseif (mgang.eq.9) then
               k = winio@('%9ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                             numpos(ngang(3)), numpos(ngang(4)),
     +                             numpos(ngang(5)), numpos(ngang(6)),
     +                             numpos(ngang(7)), numpos(ngang(8)),
     +                             numpos(ngang(9)))
            elseif (mgang.eq.10) then
               k = winio@('%10ga&', numpos(ngang(1)), numpos(ngang(2)),
     +                              numpos(ngang(3)), numpos(ngang(4)),
     +                              numpos(ngang(5)), numpos(ngang(6)),
     +                              numpos(ngang(7)), numpos(ngang(8)),
     +                              numpos(ngang(9)), numpos(ngang(10)))
            endif
         endif
      enddo
c
c set up font then show radio box
c
      if (fixed) then
         k = winio@('%fn[Courier New]&')
         line = '%ts&'
         k = winio@(line, size_courier)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif
      
      if (numopt.eq.ntext) then
c
c no header and no trailer so text(i) = option(i) 
c        
         do i = n1, numopt
            line = space//text(i)
            if (numdec.le.n0) then
               k = winio@('  %rb@&', line, numpos(i))
               if (insert) k = winio@(xtra)
            else
               iabs = abs(numbld(i)/n100)
               if (iabs.ge.n1 .and. iabs.le.n10) then
                  k = winio@('  %rb@&', line, numpos(i))
                  if (insert) k = winio@(xtra)
               else   
                  k = winio@('  %`rb@&', line, numpos(i))
                  if (insert) k = winio@(xtra)
              endif   
            endif
            if (i.lt.numopt) k = winio@('%ff&')
         enddo
      else
c
c header and/or trailer is present so start with j = nstart - 1
c        
         j = nstart - n1  
         do i = n1, numopt
            j = j + 1
            line = space//text(j)
            if (numdec.le.n0) then
               k = winio@('  %rb@&', line, numpos(i))
               if (insert) k = winio@(xtra)
            else
               iabs = abs(numbld(j)/n100)
               if (iabs.ge.n1 .and. iabs.le.n10) then
                  k = winio@('  %rb@&', line, numpos(i))
                  if (insert) k = winio@(xtra)
              else   
                  k = winio@('  %`rb@&', line, numpos(i)) 
                  if (insert) k = winio@(xtra)
               endif   
            endif
            k = winio@('%ff&')
         enddo
c
c put out the text strings after the end of the menu
c
         do i = nstart + numopt, ntext

c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif
c
c set the text color depending on numbld(i)
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                   k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[blue]&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%ff&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
c
c set the text color depending on numbld(i)
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                   k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[blue]&')
               endif
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  tabvar = factor*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
         enddo
      endif
c
c close the window by button press
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%nl%cn%`6bt[&OK]')
      end
c
c

      





























      