c
c
c***********************************************************************
c start of the simfit multi radio boxes module
c***********************************************************************
c
c 07/03/2015 introduced kind = 7
c nboxwide and nboxhigh are dimensions for the control which limit the
c maximum size of the displayed control
c ndatawide and ndatahigh are maximum dimensions for data which limit
c the maximum size of the logical matrix that can be edited
c
c ictrl           counter for each displayed check box
c ihcurmaxbox     current horizontal scroller position
c iholdcurmaxbox  previous horizontal scroller position
c ivcurmaxbox,    current vertical scroller position
c ivoldcurmaxbox  previous vertical scroller position
c jmax            maximum value for ivcurboxmax
c kmax            maximum value for ihcurboxmax 
c ncol2           the actual number of check boxes across
c nhigh           vertical height of control
c nrow2           the actual number of check boxes down
c nwide           horizontal width of the control
c jctrl           buffer to carry data between ictrl, jctrl, and irb
c word20          character array to carry data between text, word20, and char20
c max_val_h       maximum value for horizontal scroll bar
c max_val_v       maximum value for vertical scroll bar
c page_step_h     for horizontal scrolling
c page_step_v     for vertical scrolling
c 
c Details about this version
c -------------------------- 
c This code has been developed from the rp_editor code and there is
c some redundancy as described in the headers for the w_rp_editor.
c However this version allocates jctrl and char20 to the same 
c dimensions as the nrows by ncols matrix required by n_across and n_down. 
c Hence the following identities (mostly just duplicates) are used.

c      nrow1 = nrow2 = ndatahigh = nrows
c      ncol1 = ncol2 = ndatawide = ncols
c      allocate (jctrl(ndatahigh,ndatawide), stat = ierr)
c      allocate (char20(ndatahigh,ndatawide), stat = ierr)
c      nwide = min(nboxwide, ncol2)
c      nhigh = min(nboxhigh, nrow2)
c      jmax = ndatahigh - nhigh
c      kmax = ndatawide - nwide
c
c The redundant definitions are maintained for now just in case future 
c versions are developed with different allocations to jctrl and char20.  
c 
                 
      module     rboxes_module
      implicit   none 
c
c declared variables
c      
      integer (kind = 7) main_hwnd
      integer    nboxhigh_default, nboxwide_default
      parameter (nboxhigh_default = 15, nboxwide_default = 20)  
      integer    max_nboxhigh, max_nboxwide,
     +           min_nboxhigh, min_nboxwide
      parameter (max_nboxhigh = 30,
     +           max_nboxwide = 20,
     +           min_nboxhigh = 10,
     +           min_nboxwide = 1)  
      integer    nboxhigh, nboxwide, ndatahigh, ndatawide,
     +           page_step_h, page_step_v
      integer    ihcurmaxbox, iholdcurmaxbox, 
     +           ivcurmaxbox, ivoldcurmaxbox,
     +           max_val_h, max_val_v,
     +           ncol2, nhigh, nrow2, nwide 
      integer    ictrl(max_nboxhigh,max_nboxwide)
      integer    jmax, kmax
      character (len = 20) :: word20(max_nboxhigh)
      logical    discard_editing
c
c allocatable arrays
c      
      integer,              allocatable :: jctrl(:,:)
      character (len = 20), allocatable :: char20(:)
      end module rboxes_module
c     
c***********************************************************************
c end of the simfit rboxes_module      
c***********************************************************************
c

c
c
      subroutine w_rboxes (irb, n_across, n_down, n_header,
     +                     header, text)
c
c action: multi radio boxes control
c author: w.g.bardsley, university of manchester, u.k., 23/11/2010
c         07/12/2010 added grave accents to ganging control %ga
c         08/10/2017 replaced %ff by %nl in header 
c
c   irb(i): on entry ... number of the horizontal check box to be switched on at row i
c           on exit  ... number of the horizontal check box switched on at row i
c                        otherwise unchanged if [Cancel] is selected not [Apply] 
c           Note that irb(i) must be > 0 and =< n_across i.e. a box must be on in each row 
c n_across: number of radio check boxes across (> 0)
c   n_down: number of radio check boxes down (> 0)
c n_header: number of header rows (can be 0)
c   header: titles to place as the control headers
c     text: caption for each row
c
c Note: ganged must be set to .true. to obtain ganging across rows     
c
      use        rboxes_module, only : ictrl, 
     +                                 ihcurmaxbox,  
     +                                 iholdcurmaxbox, 
     +                                 ivcurmaxbox, ivoldcurmaxbox,
     +                                 main_hwnd,
     +                                 jmax, jctrl, kmax,
     +                                 max_val_h, max_val_v,
     +                                 max_nboxhigh, max_nboxwide,
     +                                 min_nboxhigh, min_nboxwide, 
     +                                 nboxhigh_default,
     +                                 nboxwide_default,
     +                                 nboxhigh, nboxwide, 
     +                                 ncol2, 
     +                                 ndatahigh, ndatawide,
     +                                 nhigh, nrow2, nwide, 
     +                                 page_step_h, page_step_v,
     +                                 char20, word20, 
     +                                 discard_editing   
     
      implicit   none 
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: n_across, n_down, n_header
      integer,             intent (inout) :: irb(n_down) 
      character (len = *), intent (in)    :: header(n_header),
     +                                       text(n_down)  
c
c locals
c     
      integer    n0, n1, n5, n34
      parameter (n0 = 0, n1 = 1, n5 = 5, n34 = 34)
      integer    x_len200
      integer    i, ierr, j, k, ncols, ncol1, nmax, nrows, nrow1
      integer    iscroll_rboxes, rboxes_scroll_fix
      integer    iapply_rboxes, idiscard_rboxes
      integer    x_nklcfg
      double precision correction, sizes
      double precision size_1, size_2, percent
      parameter (size_1 = 1.0d+00,
     +           size_2 = 0.8d+00, percent = 100.0d+00) 
      character  blank*1
      parameter (blank = ' ')
      character  word80*80
      logical    vga
      logical    add_scroll_bars, ganging
      logical    dialogue, label, label_at_top
      external   iscroll_rboxes, rboxes_scroll_fix
      external   iapply_rboxes, idiscard_rboxes
      external   w_syspar, x_len200, x_putfat, x_nklcfg
      intrinsic  dble, min, nint
c
c Set the window style as follows:
c --------------------------------
c dialogue = .true. create a dialogue window o/w a %ww type window
c ganging = .true. sets up horizontal ganging
c label_at_top = .true. use header(1) in %ca o/w as strings above control
c      
      dialogue = .true.
      ganging = .true.
      label_at_top = .false.
      discard_editing = .false.
c
c Check the input parameters
c
      if (n_across.lt.n1 .or. n_down.lt.n1) then
         call x_putfat (
     +'n_across < 1, or n_down < 1 in call to W_RBOXES')
         return
      endif
      if (n_across.gt.20) then
         call x_putfat (
     +'n_across is greater than 20 in call to W_RBOXES')
         return
      endif  
      do i = n1, n_down
         if (irb(i).lt.n1 .or. irb(i).gt.n_across) then
            call x_putfat (
     +'irb < 1 or irb > n_across in call to W_RBOXES')
            return
         endif   
      enddo 
      if (n_header.ge.n1) then
         label = .true.
         if (n_header.ge.max_nboxhigh - n5) then
            call x_putfat (
     +'Too many headers in call to W_RBOXES')            
            return
         endif   
      else
         label = .false.
      endif                 
c
c Set the number of boxes across and down
c      
      nboxhigh = nboxhigh_default
      nboxwide = nboxwide_default
      i = min(max_nboxhigh,x_nklcfg (n34))
      if (i.ge.min_nboxhigh) nboxhigh = i
      nmax = max_nboxhigh - n_header - n5  
      if (nboxhigh.gt.nmax) nboxhigh = nmax  
      page_step_h = nboxwide
      page_step_v = nboxhigh
c
c allocate internal workspace arrays
c                  
      ierr = n0
      if (allocated(jctrl)) deallocate(jctrl, stat = ierr)
      if (ierr.ne.n0) return
      if (allocated(char20)) deallocate(char20, stat = ierr)
      if (ierr.ne.n0) return  
      ncols = n_across
      nrows = n_down  
c
c Note: in this version we set ndatahigh = nrows and ndatawide = ncols
c      
      ndatahigh = nrows
      ndatawide = ncols
      allocate (jctrl(ndatahigh,ndatawide), stat = ierr)
      if (ierr.ne.n0) return
      allocate (char20(ndatahigh), stat = ierr)
      if (ierr.ne.n0) return  
c
c Copy ncols, nrows, etc. to local variables
c Note: in this version we set ncol1 = ncol2 = ncols and nrow1 = nrow2 = nrows
c
      ncol1 = ncols  
      ncol2 = ncol1
      nrow1 = nrows
      nrow2 = nrow1
c
c Initialise ictrl, jctrl, and word20
c
      do j = n1, nrows
         do k = n1, ncols
            jctrl(j,k) = n0
         enddo  
         jctrl(j,irb(j)) = n1
         char20(j) = text(j)
      enddo  
      do k = n1, nboxwide
         do j = n1, nboxhigh
            if (j.le.nrows .and. k.le.ncols) then
               ictrl(j,k) = jctrl(j,k)
            else
               ictrl(j,k) = n0
            endif      
         enddo
      enddo
      do j = n1, nboxhigh
         if (j.le.nrows) then
            word20(j) = text(j)
         else
            word20(j) = blank
         endif      
      enddo   
c
c Define nwide, nhigh, jmax and kmax, then initialise the viewable data
c
      nwide = min(nboxwide, ncol2)
      nhigh = min(nboxhigh, nrow2)
      jmax = ndatahigh - nhigh
      kmax = ndatawide - nwide
c
c Initialise the cursor positions
c
      ivcurmaxbox = n0
      ivoldcurmaxbox = n0
      ihcurmaxbox = n0
      iholdcurmaxbox = n0

c See if VGA is in use then scale the font sizes
c
      call w_syspar (i, 'x')
      call w_syspar (j, 'y')
      if (i.gt.635 .and. i.lt.645 .and.
     +    j.gt.475 .and. j.lt.485) then
         vga = .true.
      else
         vga = .false.
      endif
      call use_windows95_font@()
      call w_syspar (i, 
     +               'f')
      correction = dble(i)/percent
      if (vga .or. ncol1.le.5) then
         sizes = correction*size_1
      else
         sizes = correction*size_2
      endif

c*********************
c start of winio@ code
c*********************
      
c
c Show the check-boxes window ..........................................
c      
      if (dialogue) then 
         i = winio@('%sy[no_sysmenu, thin_border]&')
      else   
         i = winio@('%ww[no_sysmenu, thin_border, topmost]&')
      endif
c
c uncomment the next lines and add a %cc if closure by cross is allowed
c
c      call w_reslib
c      i = winio@('%mi[icon_1]&')
c
c define the caption
c      
      if (label .and. label_at_top) then
         word80 = header(1)
         k = x_len200(word80)
         i = winio@('%`ca@&', word80(1:k))
      else
         i = winio@('%ca[Simfit: multi check box control]&')
      endif   
c
c Put some scroll bars on if required.
c
c Note the following details.
c Horizontal scrolling is disabled in this version.
c If scroll_fix is used then max_val_h and max_val_v have to be increased
c and, to prevent overflow, jmax and kmax must be used to confine the
c upper limits for ihcurmaxbox and ivcurmaxbox in iscroll_boxes
c If scroll bars are not required, then define add_scroll_bars = .false. 
c to prevent the use of the scroll_fix call back.
c Horizontal scrolling has been inhibited by only allowing n_across =< 20
c
      
      add_scroll_bars = .false.
      
      max_val_h = n0
      max_val_v = n0
      if (ncol2.gt.nboxwide .or. nrow2.gt.nboxhigh) then
         add_scroll_bars = .true. 
c********max_val_h = min(ncol2, ndatawide) - nboxwide + n1
         max_val_h = ncol2

         i = winio@('%`^hs&', page_step_h, max_val_h, ihcurmaxbox,
     +                        iscroll_rboxes)
c********max_val_v = min(nrow2, ndatahigh) - nboxhigh + n1
         max_val_v = nrow2 
         i = winio@('%`^vs&', page_step_v, max_val_v, ivcurmaxbox,
     +                        iscroll_rboxes)
      endif 
             
c
c Show the headers if required
c     
      if (label .and. .not.label_at_top) then
         sizes = correction*size_1
         i = winio@('%`sf&')
         i = winio@('%ts&', sizes)
         do i = n1, n_header
            k = x_len200(header(i))
            if (k.gt.80) k = 80
            if (k.le.0) then
               j = winio@(' &')
            else
               word80 = header(i)(1:k)
               j = winio@(word80(1:k)//'&')
            endif        
            j = winio@('%nl&')
         enddo   
         i = winio@('%nl%ff&')
      endif
      
c
c Draw the boxes as a nwide by nhigh array
c     

      i = winio@('%`bg[white]&')
      i = winio@('%tc[black]&')
      i = winio@('%ff&')
      i = winio@('%ob[invisible]&')
      do k = n1, nhigh
         if (ganging) then
            if (n_across.eq.2) then
               i = winio@('%`2ga&', ictrl(k,1), ictrl(k,2))
            elseif (n_across.eq.3) then 
               i = winio@('%`3ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3)) 
            elseif (n_across.eq.4) then 
               i = winio@('%`4ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                              ictrl(k,4))  
            elseif (n_across.eq.5) then 
               i = winio@('%`5ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                              ictrl(k,4), ictrl(k,5))     
            elseif (n_across.eq.6) then 
               i = winio@('%`6ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                              ictrl(k,4), ictrl(k,5), ictrl(k,6)) 
            elseif (n_across.eq.7) then 
               i = winio@('%`7ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                              ictrl(k,4), ictrl(k,5), ictrl(k,6),
     +                              ictrl(k,7)) 
            elseif (n_across.eq.8) then 
               i = winio@('%`8ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                              ictrl(k,4), ictrl(k,5), ictrl(k,6),
     +                              ictrl(k,7), ictrl(k,8))  
            elseif (n_across.eq.9) then 
               i = winio@('%`9ga&', ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                              ictrl(k,4), ictrl(k,5), ictrl(k,6),
     +                              ictrl(k,7), ictrl(k,8), ictrl(k,9)) 
            elseif (n_across.eq.10) then 
               i = winio@('%`10ga&', 
     +                            ictrl(k,1), ictrl(k,2), ictrl(k,3),
     +                            ictrl(k,4), ictrl(k,5), ictrl(k,6),
     +                            ictrl(k,7), ictrl(k,8), ictrl(k,9),
     +                            ictrl(k,10))
            elseif (n_across.eq.11) then 
               i = winio@('%`11ga&', 
     +                            ictrl(k,1),  ictrl(k,2), ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5), ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8), ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11)) 
            elseif (n_across.eq.12) then 
               i = winio@('%`12ga&', 
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12)) 
            elseif (n_across.eq.13) then 
               i = winio@('%`13ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13)) 
            elseif (n_across.eq.14) then 
               i = winio@('%`14ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14))  
            elseif (n_across.eq.15) then 
               i = winio@('%`15ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14), ictrl(k,15)) 
            elseif (n_across.eq.16) then 
               i = winio@('%`16ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14), ictrl(k,15),
     +                            ictrl(k,16))
            elseif (n_across.eq.17) then 
               i = winio@('%`17ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14), ictrl(k,15),
     +                            ictrl(k,16), ictrl(k,17)) 
            elseif (n_across.eq.18) then 
               i = winio@('%`18ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14), ictrl(k,15),
     +                            ictrl(k,16), ictrl(k,17), ictrl(k,18))   
            elseif (n_across.eq.19) then 
               i = winio@('%`19ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14), ictrl(k,15),
     +                            ictrl(k,16), ictrl(k,17), ictrl(k,18),
     +                            ictrl(k,19)) 
            elseif (n_across.eq.20) then 
               i = winio@('%`20ga&',
     +                            ictrl(k,1),  ictrl(k,2),  ictrl(k,3),
     +                            ictrl(k,4),  ictrl(k,5),  ictrl(k,6),
     +                            ictrl(k,7),  ictrl(k,8),  ictrl(k,9),
     +                            ictrl(k,10), ictrl(k,11), ictrl(k,12),
     +                            ictrl(k,13), ictrl(k,14), ictrl(k,15),
     +                            ictrl(k,16), ictrl(k,17), ictrl(k,18),
     +                            ictrl(k,19), ictrl(k,20))                                                                                   
            endif
         endif
            
         do j = n1, nwide
            i = winio@('%`rb[ ] &', ictrl(k,j))
         enddo  
         i = winio@('%`15rs&', word20(k))
         i = winio@('%nl&')
      enddo
      i = winio@('%cb&')
      i = winio@('%ff&')
      
c
c Display the buttons 
c
      
      sizes = correction*size_2
      i = winio@('%`sf&')
      i = winio@('%ts&', sizes)
      i = winio@('%^tt[&Apply]&', iapply_rboxes)
      i = winio@('  %^tt[&Cancel]&', idiscard_rboxes)
c
c Define main_hwnd to stop ftn95 complaining then close the window
c     
      main_hwnd = n1
      if (add_scroll_bars) then
        i = winio@('%hw%sc', main_hwnd, rboxes_scroll_fix)
      else  
        i = winio@('%hw', main_hwnd)
      endif  

c*******************
c end of winio@ code
c*******************      

c
c Note that the next code is only executed when the window is closed
c
      if (.not.discard_editing) then
         i = iscroll_rboxes()
         do j = n1, nrow2
            if (ncol2.eq.n1) then
               irb(j) = jctrl(j,n1)
            else    
               do k = n1, ncol2
                  if (jctrl(j,k).ne.0) then
                     irb(j) = k
                     exit
                  endif 
               enddo
            endif
         enddo
      endif   
c
c Deallocate
c               
      deallocate(jctrl, stat = ierr)
      deallocate(char20, stat = ierr)
      end
c 
c *********************************************************
c * iscroll_rboxes                                        *
c *********************************************************
c
      recursive integer function iscroll_rboxes() 
      use        rboxes_module, only : ictrl, 
     +                                 ihcurmaxbox, iholdcurmaxbox, 
     +                                 ivcurmaxbox, ivoldcurmaxbox,
     +                                 jctrl, jmax, kmax,
     +                                 ndatahigh, ndatawide, 
     +                                 nhigh, nwide,
     +                                 char20, word20
      implicit   none
      include   <windows.ins>
      integer    j, k
      integer    n1
      parameter (n1 = 1)
c
c now check cursor value to prevent overflow
c        
      if (ivcurmaxbox.gt.jmax) ivcurmaxbox = jmax
      if (ihcurmaxbox.gt.kmax) ihcurmaxbox = kmax  
c        
c Update the data
c
      do k = n1, nwide
         do j = n1, nhigh
            jctrl(j + ivoldcurmaxbox,k + iholdcurmaxbox) = ictrl(j,k)
         enddo
      enddo
c
c Update the boxes contents
c
      do k = n1, nwide
         do j = n1, nhigh
            ictrl(j,k) = jctrl(j + ivcurmaxbox,k + ihcurmaxbox)
         enddo
      enddo
      
      call window_update@(ictrl)
      
      do j = n1, nhigh
         word20(j) = char20(j + ivcurmaxbox)
      enddo
      
      call window_update@(word20)
      
      ivoldcurmaxbox = ivcurmaxbox
      iholdcurmaxbox = ihcurmaxbox
      iscroll_rboxes = n1
      end
c
c 23/11/2010 modification of the scroll_fix call back supplied by David Bailey
c
      recursive integer function rboxes_scroll_fix()
      use rboxes_module, only : main_hwnd, nboxhigh, nboxwide 
      C_External scroll_kludge 'scroll_kludge' (val, val, val)
      call scroll_kludge (main_hwnd, nboxwide, nboxhigh)
      rboxes_scroll_fix = 1
      end   
c
c
      recursive integer function iapply_rboxes()
      use rboxes_module, only : discard_editing
      implicit none
      discard_editing = .false.
      iapply_rboxes = 0
      end 
c
c
      recursive integer function idiscard_rboxes()
      use rboxes_module, only : discard_editing
      implicit   none
      integer    icolor, ix, iy
      parameter (icolor = 7, ix = 0, iy = 0) 
      external   x_yesno2
      discard_editing = .false.
      call x_yesno2 (icolor, ix, iy,
     +               'Are you sure you want to discard current editing',
     +               discard_editing)
      if (discard_editing) then
         idiscard_rboxes = 0
      else
         idiscard_rboxes = 1
      endif      
      end
