c
c-----------------------------------------------------------------
c
      module module_rdvals
c
c store internal variables for w_rdvals
c      
      implicit   none
      integer    imax, imin, nmax
      parameter (imax = 2**30 - 1, imin = -imax, nmax = 50)
      integer   (kind = 7) ihan(nmax)
      integer    itype(nmax), i_data(nmax), l_lim(nmax), u_lim(nmax)
      integer    n_cases
      character (len = 100) labels(nmax) 
      character (len = 40 ) comment  
      character (len = 1  ) blank
      parameter (blank = ' ')
      data       comment / blank /    
      end module module_rdvals 
c
c------------------------------------------------------------------
c
      subroutine w_rdvals (n, nbot, nmid, ntop,
     +                     text, 
     +                     abort, supply)
c
c action: return users choice of integer(s)
c author: w.g.bardsley, university of manchester, u.k. in collaboration with David Bailey, 16/12/2017
c         21/03/2019 extensively revised  
c 
c      n: dimension
c   nbot: lower limit        
c   nmid: users value
c   ntop: upper limit
c   text: labels for the %rd boxes
c  abort: indicates success or failure
c supply: .true. if data are initialised
c         .false then set to the mid-range  
c
      use module_rdvals 
      implicit none 
c
c arguments
c      
      integer,             intent (in)    :: n
      integer,             intent (in)    :: nbot(n), ntop(n)
      integer,             intent (inout) :: nmid(n) 
      character (len = *), intent (in)    :: text(n)
      logical,             intent (out)   :: abort 
      logical,             intent (in)    :: supply
c
c locals
c      
      integer    i, icase, k, j1, j2, j3
      character (len = 12) l1, l2, max12, min12, x_form12
      character (len = 80) line, title
      logical    lower, repeet, upper 
      external   db_callback, x_form12, x_putfat
c
c initialise abort and check the input
c      
      abort = .true. 
      n_cases = n
      if (n.lt.1 .or. n.gt.nmax) then
         call x_putfat ('W_RDVALS called with N < 1 or N > NMAX')
         return
      endif   
      do i = 1, n
         if (nbot(i).gt.ntop(i)) then
            call x_putfat ('W_RDVALS called with NBOT > NTOP')
            return
         endif   
         if (supply .and. nbot(i).gt.nmid(i)) then
            call x_putfat ('W_RDVALS called with NBOT > NMID') 
            return
         endif   
         if (supply .and. nmid(i).gt.ntop(i)) then
            call x_putfat ('W_RDVALS called with NMID > NTOP') 
            return
         endif   
      enddo
      do i = 1, n
         lower = .false.
         upper = .false.
         if (nbot(i).gt.imin) lower = .true.
         if (ntop(i).lt.imax) upper = .true.
         if (lower .and. upper) then
            itype(i) = 1 !upper and lower limits
         elseif (lower) then
            itype(i) = 2 !just lower limit
         elseif (upper) then
            itype(i) = 3 !just upper limit
         else
            itype(i) = 0 !no limits  
         endif 
      enddo              
c
c copy the data supplied
c      
      do i = 1, n
         if (supply) then
            i_data(i) = nmid(i)
         else
            if (itype(i).eq.0) then
               nmid(i) = 0
            elseif (itype(i).eq.1) then   
               nmid(i) = (nbot(i) + ntop(i))/2
            elseif (itype(i).eq.2) then
               nmid(i) = nbot(i)
            elseif (itype(i).eq.3) then
               nmid(i) = ntop(i)
            endif         
         endif      
         l_lim(i) = nbot(i)
         u_lim(i) = ntop(i)
         labels(i) = text(i)(1:60)
      enddo
c
c define labels
c     
      if (n.gt.1) then  
         do i = 1, n
            if (itype(i).gt.0) then
               min12 = x_form12(nbot(i))
               max12 = x_form12(ntop(i))
               j1 = len_trim(min12)  
               j2 = len_trim(max12)
               j3 = min(60,len_trim(text(i)))
               if (itype(i).eq.1) then 
                  labels(i) =
     +text(i)(1:j3)//' [Range '//min12(1:j1)//' to '//max12(1:j2)//']'    
               elseif (itype(i).eq.2) then
                  labels(i) =
     +text(i)(1:j3)//' [Minimum '//min12(1:j1)//']'
               elseif (itype(i).eq.3) then
                  labels(i) =
     +text(i)(1:j3)//' [Maximum '//max12(1:j2)//']'               
               endif          
            endif
         enddo  
      endif   
c
c loop until success
c      
      repeet = .true.
      do while (repeet)
         k = winio@('%bg[grey]&')
         
         if (n.eq.1) then
c
c special case when n = 1 with label above the %rd
c
            if (itype(1).eq.0) then
               k = winio@('%ca[Simfit: get an unconstrained integer]&')
               line = blank//'&'
            elseif (itype(1).eq.1) then   
               k = winio@('%ca[Simfit: get a constrained integer]&')
               l1 = x_form12(nbot(1))
               l2 = x_form12(ntop(1))
               write (line,'(a,a12,a,a12,a1)')
     +               'Minimum = ',l1,'Maximum = ',l2,'&'
            elseif (itype(1).eq.2) then   
               k = winio@('%ca[Simfit: get an integer > lower limit]&')
               l1 = x_form12(nbot(1))
               write (line,'(a,a12,a1)') 'Mininum = ',l1,'&' 
            else   
               k = winio@('%ca[Simfit: get an integer < upper limit]&')
               l2 = x_form12(ntop(1))
               write (line,'(a,a12,a1)') 'Maximum = ',l2,'&'
            endif   
            title = 'INPUT: '//text(1)
            k = winio@('%`rs%nl&', trim(title))
            if (itype(1).gt.0) then
               k = winio@('%nl&')
               k = winio@(line)
            endif   
            k = winio@('%nl&')
         else   
c
c when n > 1 labels at RHS of %rd
c           
            k = winio@('%ca[Simfit: get integers]&')
         endif
         
         comment = blank
         if (supply) then
c
c the case supply = .true.
c           
            if (n_cases.eq.1) then
              icase = 1 
              i_data(icase) = nmid(icase)
              if (itype(icase).eq.0) then
                 k = winio@("%nl%`bg[white]%^8rd%lc&",
     +           i_data(icase), db_callback, ihan(icase))
               elseif (itype(icase).eq.1) then
                  k = winio@("%nl%`bg[white]%^8rd%lc&",
     +            i_data(icase), db_callback, ihan(icase))
               elseif (itype(icase).eq.2) then
                  k = winio@("%nl%`bg[white]%^8rd%lc&",
     +            i_data(icase), db_callback, ihan(icase))
               elseif (itype(icase).eq.3) then
                  k = winio@("%nl%`bg[white]%^8rd%lc&",
     +            i_data(icase), db_callback, ihan(icase))
               endif
            else  
               do icase = 1, n_cases
                  i_data(icase) = nmid(icase)
                  if (itype(icase).eq.0) then
                     k = winio@("%nl%`bg[white]%^8rd%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                  elseif (itype(icase).eq.1) then
                     k = winio@("%nl%`bg[white]%^8rd%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                  elseif (itype(icase).eq.2) then
                 k = winio@("%nl%`bg[white]%^8rd%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                  elseif (itype(icase).eq.3) then
                 k = winio@("%nl%`bg[white]%^8rd%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                  endif
                  k = winio@('%`rs&', trim(labels(icase)))
               enddo
            endif
         else  
c
c the case supply = .false.
c         
            if (n_cases.eq.1) then
               icase = 1  
               i_data(icase) = nmid(icase)
               if (itype(icase).eq.0) then
                  k = winio@(
     +           "%nl%`bg[white]%^8rd[initially_blank]%lc&",
     +            i_data(icase), db_callback, ihan(icase))
                elseif (itype(icase).eq.1) then
                  k = winio@(
     +           "%nl%`bg[white]%^8rd[initially_blank]%lc&",
     +            i_data(icase), db_callback, ihan(icase))
                elseif (itype(icase).eq.2) then
                  k = winio@(
     +           "%nl%`bg[white]%^8rd[initially_blank]%lc&",
     +            i_data(icase), db_callback, ihan(icase))
                elseif (itype(icase).eq.3) then
                  k = winio@(
     +           "%nl%`bg[white]%^8rd[initially_blank]%lc&",
     +            i_data(icase), db_callback, ihan(icase))
               endif 
            else  
               do icase = 1, n_cases
                  i_data(icase) = nmid(icase)
                  if (itype(icase).eq.0) then
                     k = winio@(
     +             "%nl%`bg[white]%^8rd[initially_blank]%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                   elseif (itype(icase).eq.1) then
                     k = winio@(
     +               "%nl%`bg[white]%^8rd[initially_blank]%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                   elseif (itype(icase).eq.2) then
                     k = winio@(
     +               "%nl%`bg[white]%^8rd[initially_blank]%lc &",
     +               i_data(icase), db_callback, ihan(icase))
                   elseif (itype(icase).eq.3) then
                     k = winio@(
     +               "%nl%`bg[white]%^8rd[initially_blank]%lc &",
     +               i_data(icase), db_callback, ihan(icase))
               endif
               k = winio@('%`rs&', trim(labels(icase)))
            enddo
            endif
         endif    
         if (n_cases.eq.1) then
            k = winio@("%nl%nl%`6tt[OK]%nl%nl%tc[red]%`rs", comment)
         else   
            k = winio@("%nl%nl%6tt[OK]%nl%nl%tc[red]%`rs", comment)  
         endif   
         repeet = .false.     
         do i = 1, n_cases
            if (i_data(i).lt.l_lim(i) .or.
     +          i_data(i).gt.u_lim(i)) repeet = .true.
         enddo 
      enddo  
c
c define nmid and set abort = .false.
c      
      do i = 1, n_cases
         nmid(i) = i_data(i)
      enddo   
      abort = .false.            
      end
c
c
      integer function db_callback()
      use module_rdvals
      implicit none
      include <windows.ins>
c      
c Data transfered from winio@ caller
c This would be 8 for real*8 data
c
      integer, parameter:: data_size = 4
      integer icase
c      
c This gets the address if the data array element being used
c and converts extracts icase (integers are 4 bytes long
c
      icase = 
     +(clearwin_info@("LATEST_VARIABLE") - loc(i_data))/data_size + 1
      if(i_data(icase).le.u_lim(icase) .and.
     +   i_data(icase).ge.l_lim(icase)) then
         comment = blank
         call set_control_text_colour@(ihan(icase), 0)
      else
         if(i_data(icase).lt.l_lim(icase)) comment = "Value too small"
         if(i_data(icase).gt.u_lim(icase)) comment = "Value too big"
         call set_control_text_colour@(ihan(icase), 255)
      endif
      call update_window@(comment)
      db_callback = 1
      end
c
c