c
c
      subroutine w_revpro (nout)
c
c action : review progress so far by viewing results file on nout
c author : w.g.bardsley, university of manchester, u.k.
c          18/02/2007 derived from revpro to be used by w_ routines
c
      implicit   none 
c
c argument
c      
      integer, intent (in) :: nout
c
c locals
c      
      integer    ifail, ios, isend, ndummy
      parameter (isend = 1)
      character  dummy1*1, dummy2*1, fname*1024, line*1024
      parameter (dummy1 = ' ', dummy2 = ' ')
      logical    askif, there
      parameter (askif = .false.)
      external   w_deleet, w_getnou, w_gettmp, x_putfat, w_viewer
c
c Make sure the unit is opened
c
      inquire (unit = nout, opened = there, iostat = ios)
      if (ios.ne.0 .or. .not.there) then
         call x_putfat ('Results file has not yet been opened')
         return
      endif
c
c open a temporary file
c
      call w_getnou (ndummy)
      if (ndummy.le.11) return
      call w_gettmp (ifail,
     +               fname)
      if (ifail.ne.0) return
      open (unit = ndummy, file = fname, iostat = ios)
      if (ios.eq.0) then
c
c rewind the log file then copy it into the temporary file
c
         rewind (unit = nout, err = 20, iostat = ios) 
         do while (ios.eq.0) 
             read (nout,'(a)',end=20,err=20,iostat=ios) line
             if (ios.eq.0) write (ndummy,'(a)') line
         enddo
      endif   
c
c close the temporary unit and backspace the log file
c
   20 continue
      close (unit = ndummy)
      backspace (unit = nout, iostat = ios)
c
c view the temporary file then erase it
c
      if (ios.eq.0) call w_viewer (isend, 
     +                             fname, dummy1, dummy2)
      call w_deleet (fname,
     +               askif, there)
      end

c
c
