c
c-----------------------------------------------------------------
c
      module module_rfvals
c
c store internal variables for w_rfvals
c      
      implicit   none
      integer    nmax
      parameter (nmax = 50)
      integer   (kind = 7) ihan(nmax)
      integer    itype(nmax)
      integer    n_cases
      double precision xmax, xmin
      parameter (xmax = 1.0d+300 - 1.0d+00, xmin = - xmax)
      double precision x_data(nmax), l_lim(nmax), u_lim(nmax)
      character (len = 100) labels(nmax) 
      character (len = 40 ) comment  
      character (len = 15 ) lower(nmax), upper(nmax)
      character (len = 1  ) blank
      logical    getdg2, getdg3, ok
      parameter (blank = ' ')
      data       comment / blank /    
      end module module_rfvals 
c
c------------------------------------------------------------------
c
      subroutine w_rfvals (n,
     +                     xbot, xmid, xtop,
     +                     text, 
     +                     abort, supply)
c
c action: return users choice of double(s)
c author: w.g.bardsley, university of manchester, u.k. in collaboration with David Bailey, 22/12/2017
c         21/03/2019 extensive revision
c         12 /12/2021 replaced 'Maximum =' by '  Maximum =' to improve readability
c 
c      n: dimension
c   xbot: lower limit        
c   xmid: users value
c   xtop: upper limit
c   text: labels for the %rf boxes
c  abort: indicates success or failure
c supply: .true. if data are initialised
c         .false then set to the mid-range  
c
      use module_rfvals 
      implicit none 
      include <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: n
      double precision,    intent (in)    :: xbot(n), xtop(n)
      double precision,    intent (inout) :: xmid(n) 
      character (len = *), intent (in)    :: text(n)
      logical,             intent (out)   :: abort 
      logical,             intent (in)    :: supply
c
c locals
c      
      integer    i, icase, k, len1, len2, len3  
      character (len = 15) l1, l2, x_form15
      character (len = 80) line, title
      logical    high, low, repeet 
      logical    getr02, getd02
      logical    getr03, getd03
      external   rf_callback, x_form15, x_putfat
      intrinsic  len_trim
c
c initialise abort and check the input to define itype
c      
      abort = .true. 
      n_cases = n
      if (n.lt.1 .or. n.gt.nmax) then
         call x_putfat ('W_RFVALS called with N < 1 or N > NMAX')
         return
      endif   
      do i = 1, n
         if (xbot(i).gt.xtop(i)) then
            call x_putfat ('W_RFVALS called with XBOT > XTOP')
            return
         endif   
         if (supply .and. xbot(i).gt.xmid(i)) then
            call x_putfat ('W_RFVALS called with XBOT > XMID') 
            return
         endif   
         if (supply .and. xmid(i).gt.xtop(i)) then
            call x_putfat ('W_RFVALS called with XMID > XTOP') 
            return
         endif   
      enddo
      do i = 1, n
         low = .false.
         high = .false.
         lower(i) = blank
         upper(i) = blank
         if (xbot(i).gt.xmin) low = .true.
         if (xtop(i).lt.xmax) high = .true.
         if (low .and. high) then
            itype(i) = 1 !upper and lower limits
         elseif (low) then
            itype(i) = 2 !just lower limit
         elseif(high) then
            itype(i) = 3 ! just upper limit   
         else
            itype(i) = 0 !no limits  
         endif 
      enddo            
c
c check the special cases for n = 2 or n = 3 
c        
      getr02 = .false.
      getd02 = .false.
      getdg2 = .false.
      getr03 = .false.
      getd03 = .false.
      getdg3 = .false.
      if (n.eq.2) then
         if (text(2).eq.'getr02') then
            getr02 = .true.
         elseif (text(2).eq.'getd02') then
            getd02 = .true.  
         elseif (text(2).eq.'getdg2') then    
            getdg2 = .true.
         endif
      elseif (n.eq.3) then
         if (text(2).eq.'getr03') then
            getr03 = .true.
         elseif (text(2).eq.'getd03') then
            getd03 = .true.  
         elseif (text(2).eq.'getdg3') then
            getdg3 = .true.    
         endif
      endif             
c
c copy the data supplied and define labels
c      
      do i = 1, n
         if (supply) then
            x_data(i) = xmid(i)
         else
            if (itype(i).eq.0) then
               xmid(i) = 0.0d+00
            elseif (itype(i).eq.1) then   
               xmid(i) = (xbot(i) + xtop(i))/2.0d+00
            elseif (itype(i).eq.2) then
               xmid(i) = xbot(i)
            elseif (itype(i).eq.3) then
               xmid(i) = xtop(i)
            endif  
            x_data(i) = xmid(i)       
         endif
         len3 = min(50,len_trim(text(i)))  
         labels(i) = blank 
         if (n.gt.1) then
            if (itype(i).eq.0) then
               labels(i)(1:len3 + 1) = blank//text(i)(1:len3)
            elseif (itype(i).eq.1) then
               lower(i) = x_form15(xbot(i))
               upper(i) = x_form15(xtop(i))
               len1 = len_trim(lower(i))
               len2 = len_trim(upper(i))
               labels(i) = blank//text(i)(1:len3)//' [Range '//
     +         lower(i)(1:len1)//' to '//upper(i)(1:len2)//']'
            elseif (itype(i).eq.2) then
               lower(i) = x_form15(xbot(i))
               len1 = len_trim(lower(i))
               labels(i) = 
     +blank//text(i)(1:len3)//' [Minimum '//lower(i)(1:len1)//']'              
            else
               upper(i) = x_form15(xtop(i))
               len2 = len_trim(upper(i))
               labels(i) =
     +blank//text(i)(1:len3)//' [Maximum '//upper(i)(1:len2)//']'  
            endif         
         endif  
         l_lim(i) = xbot(i)
         u_lim(i) = xtop(i)
      enddo  
c
c loop until success
c      
      repeet = .true.
      do while (repeet)
         k = winio@('%bg[grey]&')
         if (n.eq.1) then
c
c special case when n = 1 with label above the %rd
c
            if (itype(1).eq.0) then
               k = winio@('%ca[Simfit: get an unconstrained number]&')
               line = blank//'&'
            elseif (itype(1).eq.1) then   
               k = winio@('%ca[Simfit: get a constrained number]&')
               l1 = x_form15(xbot(1))
               l2 = x_form15(xtop(1))
               write (line,'(a,a15,a,a15,a1)')
     +               'Minimum = ',l1,'  Maximum = ',l2,'&'
            elseif (itype(1).eq.2) then   
               k = winio@('%ca[Simfit: get a number > lower limit]&')
               l1 = x_form15(xbot(1))
               write (line,'(a,a15,a1)') 'Minimum = ',l1,'&' 
            else   
               k = winio@('%ca[Simfit: get a number < upper limit]&')
               l2 = x_form15(xtop(1))
               write (line,'(a,a15,a1)') '  Maximum = ',l2,'&'
            endif   
            title = 'INPUT: '//text(1)
            k = winio@('%`rs%nl&', trim(title))
            if (itype(1).gt.0) then
               k = winio@('%nl&')
               k = winio@(line)
            endif   
            k = winio@('%nl&')
         elseif (getr02 .or. getd02 .or. getdg2) then
            k = winio@('%ca[Simfit: get X and Y]&')
            if (getdg2) then
               line = 'Limits: X =< Y&'
            else   
               line = 'Limits: None&'
            endif   
            title = 'INPUT: '//text(1)
            k = winio@('%`rs%nl&', trim(title))
            k = winio@('%nl&')
            k = winio@(line)
            k = winio@('%nl&')
            labels(1) = '  X'
            labels(2) = '  Y'
         elseif (getr03 .or. getd03 .or. getdg3) then   
            k = winio@('%ca[Simfit: get X, Y and Z]&')
            if (getdg3) then
               line = 'Limits: X =< Y =< Z&'
            else   
               line = 'Limits: None&'
            endif   
            title = 'INPUT: '//text(1)
            k = winio@('%`rs%nl&', trim(title))
            k = winio@('%nl&')
            k = winio@(line)
            k = winio@('%nl&')
            labels(1) = '  X'
            labels(2) = '  Y'
            labels(3) = '  Z'
         else   
c
c when n > 1 labels at RHS of %rd
c           
            k = winio@(
     +'%ca[Simfit: get double precision numbers]&')
         endif
         comment = blank
         if (supply) then
c
c the case supply = .true.
c           
            if (n_cases.eq.1) then
               icase = 1 
               x_data(icase) = xmid(icase)
               if (itype(icase).eq.0) then
                  k = winio@("%nl%`bg[white]%^15rf%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
               elseif (itype(icase).eq.1) then
                  k = winio@("%nl%`bg[white]%^15rf%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
               elseif (itype(icase).eq.2) then
                  k = winio@("%nl%`bg[white]%^15rf%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
               elseif (itype(icase).eq.3) then
                  k = winio@("%nl%`bg[white]%^15rf%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
               endif
            else  
               do icase = 1, n_cases
                  x_data(icase) = xmid(icase)
                  if (itype(icase).eq.0) then
                     k = winio@("%nl%`bg[white]%^15rf%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                  elseif (itype(icase).eq.1) then
                     k = winio@("%nl%`bg[white]%^15rf%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                  elseif (itype(icase).eq.2) then
                     k = winio@("%nl%`bg[white]%^15rf%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                  elseif (itype(icase).eq.3) then
                     k = winio@("%nl%`bg[white]%^15rf%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                  endif
                  k = winio@('%`rs&', trim(labels(icase)))
            enddo
            endif
         else  
c
c the case supply = .false.
c         
            if (n_cases.eq.1) then
               icase = 1  
               x_data(icase) = xmid(icase)
               if (itype(icase).eq.0) then
                  k = winio@(
     +            "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
                elseif (itype(icase).eq.1) then
                  k = winio@(
     +            "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
                elseif (itype(icase).eq.2) then
                  k = winio@(
     +            "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
                elseif (itype(icase).eq.3) then
                  k = winio@(
     +            "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +            x_data(icase), rf_callback, ihan(icase))
               endif 
            else  
               do icase = 1, n_cases
                  x_data(icase) = xmid(icase)
                  if (itype(icase).eq.0) then
                     k = winio@(
     +               "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                   elseif (itype(icase).eq.1) then
                     k = winio@(
     +               "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                   elseif (itype(icase).eq.2) then
                     k = winio@(
     +               "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
                   elseif (itype(icase).eq.3) then
                     k = winio@(
     +               "%nl%`bg[white]%^15rf[initially_blank]%lc&",
     +               x_data(icase), rf_callback, ihan(icase))
               endif
               k = winio@('%`rs&', trim(labels(icase)))
            enddo
            endif
         endif    
         ok = .true.
         if (n_cases.eq.1) then
            k = winio@("%nl%nl%`6tt[OK]%nl%nl%tc[red]%`rs", comment)
         else   
            k = winio@("%nl%nl%6tt[OK]%nl%nl%tc[red]%`rs", comment)  
         endif   
         if (getdg2) then
            if (x_data(1).gt.x_data(2)) then
               ok = .false.
               comment = 'Must have X =< Y'
               call update_window@(comment)
            endif
         elseif (getdg3) then
            if (x_data(1).gt.x_data(2) .or.
     +          x_data(2).gt.x_data(3)) then      
               ok = .false.
               comment = 'Must have X =< Y =< Z'
               call update_window@(comment)
            endif
         endif  
         if (ok) then 
            repeet = .false.  
            do i = 1, n_cases
               if (x_data(i).lt.l_lim(i) .or.
     +             x_data(i).gt.u_lim(i)) repeet = .true.
            enddo 
         else
            repeet = .true.  
         endif
      enddo  
c
c define nmid and set abort = .false.
c      
      do i = 1, n_cases
         xmid(i) = x_data(i)
      enddo   
      abort = .false.            
      end
c
c
      integer function rf_callback()
      use module_rfvals
      implicit none
      include <windows.ins>
c      
c Data transfered from winio@ caller
c This would be 8 for real*8 data
c
      integer, parameter:: data_size = 8
      integer icase
c      
c This gets the address if the data array element being used
c and converts extracts icase (integers are 4 bytes long
c
      ok = .true.
      icase = 
     +(clearwin_info@("LATEST_VARIABLE") - loc(x_data))/data_size + 1
      if (getdg2 .and. x_data(1).gt.x_data(2)) then
            comment = 'Must have X =< Y'
            call set_control_text_colour@(ihan(icase), 255)
            ok = .false.
      elseif (getdg3 .and. x_data(1).gt.x_data(2) .or. 
     +        getdg3 .and. x_data(2).gt.x_data(3)) then
            comment = 'Must have X =< Y =< Z'
            call set_control_text_colour@(ihan(icase), 255)
            ok = .false.           
      elseif (x_data(icase).le.u_lim(icase) .and.
     +   x_data(icase).ge.l_lim(icase)) then
         comment = blank
         call set_control_text_colour@(ihan(icase), 0)
      else
         if(x_data(icase).lt.l_lim(icase)) comment = "Value too small"
         if(x_data(icase).gt.u_lim(icase)) comment = "Value too big"
         call set_control_text_colour@(ihan(icase), 255)
         ok = .false.
      endif
      call update_window@(comment)
      rf_callback = 1
      end
c
c