c
c--------------------------------------------------------------------------- 
c w_salfgr.for: salford graphics and printing routines
c
c 11/12/2013 Added GDI+ routines and set_dash_array, trapped
C            rotate_font when abs(theta) < 1, and edited set_line_style.
C 24/02/2017 Added ISIT64  
c--------------------------------------------------------------------------- 

c
c bold_font  
c close_printer 
c create_graphics_region 
c delete_graphics_region
c draw_characters 
c draw_filled_polygon 
c draw_filled_rectangle  
c draw_hershey ... dummy subroutine
c draw_line_between   
c draw_line_between_d   
c draw_polyline 
c draw_polyline_d 
c draw_rectangle 
c draw_ellipse
c draw_filled_ellipse
c draw_bezier
c get_file_attributes
c get_filtered_file
c get_program_name
c get_text_size
c isit64
c italic_font 
c read_tabs
c rotate_font
c scale_font (= scale_font1@)
c select_font 
c set_dash_array
c set_end_cap
c set_line_join
c set_line_style
c set_line_width
c set_line_width_D
c set_text_attribute ... dummy subroutine
c temporary_yield
c use_url
c
  
c
c
      subroutine bold_font (active)
      implicit none
      include <windows.ins>
      integer active
      call bold_font@(active)
      end
c
c
      integer function close_printer (handle)
      implicit none 
      include <windows.ins>
      integer  handle
      close_printer = close_printer@(handle)
      end 
c
c
      integer function create_graphics_region (handle, width, height)
      implicit none
      include <windows.ins>
      integer handle, width, height
      create_graphics_region = create_graphics_region@(handle, width,
     +                                                 height)
      end 
c
c
      integer function delete_graphics_region (handle)
      implicit none
      include <windows.ins>            
      integer handle
      delete_graphics_region = delete_graphics_region@(handle)
      end
c      
c  
      subroutine draw_characters (str, ih, iv, icol)
      implicit none
      include <windows.ins>
      integer  icol, ih, iv 
      character str*(*)
      call draw_characters@(str, ih, iv, icol)
      end 
c
c
      subroutine draw_filled_polygon (ix, iy, n, icol)
      implicit none
      include <windows.ins>
      integer  icol, n
      integer  ix(n), iy(n)
      call draw_filled_polygon@(ix, iy, n, icol)
      end 
c
c
      subroutine draw_filled_rectangle (ix1, iy1, ix2, iy2, icol)
      implicit none
      include <windows.ins>
      integer  icol, ix1, ix2, iy1, iy2
      call draw_filled_rectangle@(ix1, iy1, ix2, iy2, icol)
      end  
c
c
      subroutine draw_ellipse (ixc, iyc, ia, ib, icol)      
      implicit none
      include <windows.ins>
      integer ixc, iyc, ia, ib, icol
      call draw_ellipse@(ixc, iyc, ia, ib, icol)
      end 
c
c
      subroutine draw_filled_ellipse (ixc, iyc, ia, ib, icol)      
      implicit none
      include <windows.ins>
      integer ixc, iyc, ia, ib, icol
      call draw_filled_ellipse@(ixc, iyc, ia, ib, icol)
      end       
c
c
      subroutine draw_bezier (x, y, n, colour)      
      implicit none
      include <windows.ins>
      integer n
      integer colour, x(n), y(n)
      call draw_bezier@(x, y, n, colour)
      end       
c
c
      options (silent)
      subroutine draw_hershey (ihersh, ih, iv, icol, ih_end, iv_end)
      implicit none
      integer (selected_int_kind(4))ihersh, ih, iv, icol, ih_end, iv_end
      return
      end                   
c
c      
      subroutine draw_line_between (ix1, iy1, ix2, iy2, icol)
      implicit none 
      include <windows.ins>
      integer  icol, ix1, ix2, iy1, iy2      
      call draw_line_between@(ix1, iy1, ix2, iy2, icol)
      end
c
c      
      subroutine draw_line_between_d (x1, y1, x2, y2, icol)
      implicit none 
      include <windows.ins>
      integer  icol 
      double precision x1, x2, y1, y2
      call draw_line_betweend@(x1, y1, x2, y2, icol)
      end      
c
c      
      subroutine draw_polyline (ix, iy, n, icol)
      implicit none
      include <windows.ins>
      integer  icol, n 
      integer  ix(n), iy(n)
      call draw_polyline@(ix, iy, n, icol)
      end
c
c      
      subroutine draw_polyline_d (x, y, n, icol)
c
c 04/08/2015 split large arrays into sections if n > nmax
c      
      implicit none
      include <windows.ins>
c
c arguments
c      
      integer,          intent (in) :: icol, n 
      double precision, intent (in) :: x(n), y(n)
c
c locals
c     
      integer    i, ndiv, nrem, nstart, nstop, nmax
      parameter (nmax = 6000)
      
      if (n.le.nmax) then 
c
c normal call
c        
         call draw_polylined@(x, y, n, icol)
      else
c
c split into sections 
c        
         ndiv = (n - 1)/(nmax - 1)
         nstop = 1
         do i = 1, ndiv
            nstart = nstop
            nstop = nstart + nmax - 1
            call draw_polylined@(x(nstart), y(nstart), nmax, icol)            
         enddo
         nstart = nstop
         nrem = n - nstart + 1
         call draw_polylined@(x(nstart), y(nstart), nrem, icol)
      endif
 
      end      
c
c       
      subroutine draw_rectangle (ix1, iy1, ix2, iy2, icol)
      implicit none
      include <windows.ins>
      integer  icol, ix1, ix2, iy1, iy2
      call draw_rectangle@(ix1, iy1, ix2, iy2, icol)
      end
c
c
      integer function get_file_attributes (fname)
      implicit none
      include <windows.ins>
      integer k
      character (len = *) fname
      k = getfileattributes (fname)
      get_file_attributes = k
      end    
c
c
      subroutine get_filtered_file (title, file, path, filternames, 
     +                              filterspecs, nfilters, mustexist)
c
c Information: about the argument to clearwin_option
c Use alt_open_save for the indirect method or -alt_open_save for the direct method
c Using neither should call the related control i.e. 32bit or 64bit 
c However this routine is very problematical
c 16/01/2016 now always uses alt-open-save 
c     
      implicit none
      include <windows.ins>
      integer    mustexist, nfilters
      character (len = *) title, file, path, filternames(nfilters),
     +                    filterspecs(nfilters)
      call clearwin_option@("alt_open_save")
      call get_filtered_file@(title, file, path, filternames, 
     +                        filterspecs, nfilters, mustexist) 
      end    
c
c
      subroutine get_program_name (pname)
      implicit none
      character (len = *), intent (out) :: pname
      call get_program_name@(pname)
      end
c      
c
      subroutine get_text_size (str, width, depth)
c      use module_defngks, only : svg
c
c Note: with SVG width was originally width/1.35 for single characters and
c       width/1.55 for strings but with depth unchanged.
c       01/07/2019 this was replaced by a scheme altering depth but not width
c                  using depth = depth*factor where factor = 1.55d+00 
c       08/09/2019 set factor = 1.0 until a new scheme has been developed 
c       12/03/2020 suppressed the svg correction factor treated blanks as a special case  
c
      
      implicit none
      include <windows.ins>
      integer    width, depth
      integer    l
      character (len = *) str
      
c      double precision factor
c      parameter (factor = 1.0d+00)

       l = len(str)
       call get_text_size@(str(1:l)//char(0), width, depth)
      
c      if (svg) width = nint(dble(width)*factor) 
      end 
c
c
      logical function isit64()
      implicit none
      integer k
      logical isit64
      isit64 = .false.
      k = kind(1_7)
      if (k.eq.4) isit64 = .true.
      end  
c
c      
      subroutine italic_font (ital)
      implicit none
      include <windows.ins> 
      integer ital
      call italic_font@(ital)
      end    
c
c
      subroutine read_tabs (nunit)
      implicit none
      include <windows.ins>
      integer nunit
      call read_tabs@(nunit)
      end      
c
c
      subroutine rotate_font (rot)
      implicit none
      include <windows.ins>
      double precision rot
      call rotate_font@(rot)
      end        
c
c      
      subroutine scale_font (size1)
      use module_defngks, only : current_font, svg
c     01/04/2018 replaced scale_font@ by scale_font1@
c     05/08/2019 added call to unscale_font@
c     10/08/2019 added factor for re-scaling in svg unlesss symbol font is in use
c                this presumes that clearwin svg divides allL font sizes by 0.88
      implicit none
      include <windows.ins>
      double precision size1
      double precision factor1, factor2, size_copy
      parameter (factor1 = 1.125d+00, factor2 = 1.25d+00)
      size_copy = size1
      if (svg) then
         if (current_font.eq.'symbol') then
             size_copy = factor1*size1
          else   
             size_copy = factor2*size1
          endif   
      endif      
      call unscale_font@()
      call scale_font1@(size_copy)
      end
c
c        
      subroutine select_font (fontname)
      use module_defngks, only : current_font
      implicit none
      include <windows.ins>
      character fontname*(*)
      external x_lcase1 
      current_font = fontname
      call x_lcase1 (current_font)
      call select_font@(fontname)
      end
c
c
      subroutine set_dash_array (arr, nsize)
      implicit none
      include <windows.ins>
      integer  nsize
      double precision arr(*)
      call set_dash_array@(arr, nsize)
      end  
c
c
      subroutine set_end_cap (itype,
     +                        store)
c
c subroutine to set or retrieve gdi+ endcap styles
c settings must agree with PostScript in subroutines gksbox$ and gksplt$
c itype = 0 ... flat
c       = 1 ... round
c       = 2 ... square 
c     
      implicit none
      integer, intent (inout) :: itype
      logical, intent (in)    :: store
      integer  itype_sav
      save     itype_sav
      data     itype_sav / 0 /
      if (store) then
         if(itype.ge.0 .and. itype.le.2) itype_sav = itype
      else
         itype = itype_sav
      endif
      end                  
c
c
      subroutine set_line_join (itype,
     +                          store)
c
c subroutine to set or retrieve gdi+ linejoin styles
c settings must agree with PostScript in subroutine psjoin$
c itype = 0 ... miter
c       = 1 ... round
c       = 2 ... bezel 
c     
      implicit none
      integer, intent (inout) :: itype
      logical, intent (in)    :: store
      integer  itype_sav
      save     itype_sav
      data     itype_sav / 1 /
      if (store) then
         if (itype.ge.0 .and. itype.le.2) itype_sav = itype
      else
         itype = itype_sav
      endif
      end        
c
c      
      subroutine set_line_style (value)
      use module_defngks, only : svg
c
c call set_line_style@ with appropriate parameters
c      
      implicit none
      include <windows.ins>
      integer value
      integer i, join_type, mycap_type, nsize
      double precision dash_size, dot_size, space_size
      parameter (dash_size = 6.0d+00,
     +            dot_size = 2.0d+00,
     +          space_size = 4.0d+00)
      double precision arr(4)
      double precision dash_width
      logical    store
      parameter (store = .false.)
      external   savelw$, set_end_cap, set_line_join
      intrinsic  dble
c
c retrieve the current endcap style
c
      call set_end_cap (mycap_type,
     +                  store)
      if (mycap_type.eq.0) then
         mycap_type = ps_endcap_flat
      elseif (mycap_type.eq.1) then
         mycap_type = ps_endcap_round
      else
         mycap_type = ps_endcap_square
      endif
c
c retrieve the current line_join type
c      
      call set_line_join (join_type,
     +                    store)
      if (join_type.eq.0) then
         join_type = ps_join_miter
      elseif (join_type.eq.1) then
         join_type = ps_join_round
      else
         join_type = ps_join_bevel
      endif
c
c proceed to call set_line_type@
c      
      if (value.gt.1 .and. value.le.4) then  
        
         call savelw$(dash_width,
     +                'z')     
         if (svg) then
            dash_width = dash_width/3.0d+00
         else
            dash_width = dash_width/2.0d+00
         endif      
            
         if (value.eq.2) then  
c
c dashed line
c            
             arr(1) = dash_size
             arr(2) = space_size
             nsize = 2
         elseif (value.eq.3) then  
c
c dotted line
c         
             arr(1) = dot_size
             arr(2) = space_size
             nsize = 2 
         elseif (value.eq.4) then  
c
c dash-dotted line
c          
             arr(1) = dash_size
             arr(2) = space_size
             arr(3) = dot_size
             arr(4) = space_size
             nsize = 4
         endif
         
         do i = 1, nsize
            arr(i) = arr(i)/dash_width
         enddo   
         call set_dash_array@(arr, nsize) 
         call set_line_style@(ps_geometric + ps_userstyle + 
     +                        mycap_type + join_type)
      else
         call set_line_style@(ps_geometric + mycap_type +
     +                        join_type)
      endif  
      end
c
c
      subroutine set_line_width (value)
      implicit  none
      include <windows.ins>
      integer   value
      double precision dvalue
      external  savelw$
      intrinsic dble
      call set_line_width@(value)
      dvalue = dble(value)
      call savelw$(dvalue,
     +             'w')     
      end     
c
c
      subroutine set_line_width_D (dvalue)
      implicit  none
      include <windows.ins>
      double precision dvalue
      external  savelw$
      call set_line_widthD@(dvalue)
      call savelw$(dvalue,
     +             'w')     
      end            
c
c
      options (silent)  
      subroutine set_text_attribute (font, size1, rotation, italic)
      implicit none
      integer (selected_int_kind(4)) font
      real (selected_real_kind(6,37)) size1, italic, rotation
      return
      end
c
c      
      subroutine temporary_yield()
      include <windows.ins>
      call temporary_yield@()
      end
c
c
      subroutine current_dir (dir)
      implicit none
      character (len = *), intent (out) :: dir
      character (len = 1024) curdir@
      dir = curdir@()
      end
      
      subroutine use_url (strng)
      implicit none
      include <windows.ins>
      character (len = *) strng
      call use_url@(strng)
      end     
c      
c   
         
           