c
c This version has separate copies of startp for distinct programs
c 18/02/2005 edited format 100 for more meaningful error messages
c            when start_process_and_wait@ fails in all subroutines
c            with specific executables 
c 29/11/2006 derived from startp 
c 09/02/2007 edited for w_clearwin.dll
c 01/10/2010 added both warnings (formats 100, and 200) for some operations
c 07/05/2017 added w_shellx
c 19/02/2020 startp_acrobat now calls w_shellx if the default pdf reader cannot be found
c            
c
c w_shellx
c w_startp
c startp_acrobat
c startp_calculator
c startp_clipboard
c startp_editor
c startp_explorer
c startp_gsview
c startp_program
c startp_win32
c startp_printer
c
c
      subroutine w_shellx (fname)
c
c action: use ShellExecute to open a file for editing/viewing
c author: w.g.bardsley, university of manchester, u.k., 07/05/2017
c         19/02/2020 added extra advisory messages and more extensions for editing
c
      implicit   none
      include   <windows.ins>
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c
      integer    i
      integer    l  
      character (len = 100) line
      character (len = 4  ) ext
      logical    iwarnu, there
      external   x_lcase1, x_putadv
      intrinsic  index
      data       iwarnu / .true. /
      inquire (file = fname, exist = there, iostat = l)
      if (l.eq.0 .and. .not.there) then
         write (line,100)
         call x_putadv (line)
         return
      endif   
      l = len_trim(fname) 
      if (l.le.3) then
         write (line,200)
         call x_putadv (line)
         return
      elseif (l.gt.4) then
         ext = fname(l - 3:l)
         call x_lcase1 (ext)
      else
         ext = '    '     
      endif
      call temporary_yield@()
      if (ext.eq.'.txt') then
        i = shellexecute(0, "edit", FNAME, "", "", SW_SHOWMAXIMIZED)
C        i = shellexecute(0, "edit", FNAME, "", "", SW_SHOWNORMAL)
      else  
        i = shellexecute(0, "open", FNAME, "", "", SW_SHOWMAXIMIZED)
C        i = shellexecute(0, "open", FNAME, "", "", SW_SHOWNORMAL)
      endif  
      if (i.le.32 .and. iwarnu) then
         write (line,300) i
         call x_putadv (line)
         iwarnu = .false.
      endif 
      call temporary_yield@()
c
c format for error messages
c      
  100 format ('File specified is missing')
  200 format ('File specified does not have a correct extension')
  300 format (
     +'On exit ShellExecute =',i6, ' e.g., No default executable ?') 
      end 
c
c
      subroutine w_startp (progrm, commnd)
c
c action: start a win32 program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c         24/10/2010 added special code for when GS = ghostscript is called in Linux
c         03/10/2013 replaced start_process_and_wait@ by start_process_and_hide 
c                    to suppress the DOS box when Ghostscript is called
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) ::  progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode, x_len200
      character (len = 1024) cval(12)
      character (len = 1024) c_copy, p_copy
      character  line*100, word2*2, word11*11, word60*60, x_trim60*60
      logical    there, x_linux3
      external   w_config, x_putadv, x_trim60, x_linux3, x_lcase1,
     +           x_linux2, x_len200
      C_EXTERNAL start_process_and_hide 'start_process_and_hide' 
     +(string, string, val) : integer
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(8) milliseconds then try to execute
c                             
         mode = -2
         call w_config (mode, nval, 
     +                  cval)
         iwait = nval(8)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         p_copy = progrm
         c_copy = commnd  
         call x_linux2 (p_copy, c_copy)  
         k = start_process_and_hide (p_copy, c_copy, iwait)
         if (k.lt.0) then
c
c abnormal exit from start_process_and_hide (or called in Linux/Wine)
c           
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
c
c output a standard warning
c              
               write (line,100)
               call x_putadv (line)
            elseif (x_linux3(progrm)) then
c
c output a special message if exit from ghostcript in Linux/Wine
c            
               iwait = x_len200(progrm)
               word2 = progrm(iwait - 1:iwait) 
               call x_lcase1 (word2)
               if (iwait.ge.11) then
                  word11 = progrm(iwait - 10:iwait)
                  call x_lcase1 (word11)
               else
                  word11 = ' '
               endif      
               if (word2.eq.'gs' .or. word11.eq.'ghostscript') then 
                  write (line,200) k
                  call x_putadv (line)
               endif  
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,300) word60
         call x_putadv (line)
      endif
  100 format ('Procedure start_process_and_hide failed')
  200 format ('GS probably OK but k from start_process_and_hide =',i4)
  300 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_acrobat (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c         19/02/2020 added call to w_shellx if a pdf reader is not defined
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character (len = 1024) cval(12)
      character (len = 100 ) line
      character (len = 60  ) word60, x_trim60
      logical    there
      logical    noisy, noisy1
      parameter (noisy1 = .false.) 
      external   w_config, x_putadv, x_trim60
      external   w_shellx
c
c does progrm exist
c
      noisy = noisy1
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(1) milliseconds then try to execute
c                                  
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(1)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then  
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      elseif (noisy) then
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      else
         call w_shellx (commnd)
      endif
  100 format (
     +'Cannot run pdf viewer ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_calculator (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(2) milliseconds then try to execute
c     
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(2)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then  
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      endif
  100 format (
     +'Cannot run calculator ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_clipboard (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(3) milliseconds then try to execute
c         
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(3)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         iwait = 0
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      endif
  100 format (
     +'Cannot view clipboard ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_editor (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      logical    noisy, noisy1
      parameter (noisy1 = .false.) 
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      noisy = noisy1
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(4) milliseconds then try to execute
c    
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(4)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      elseif (noisy) then
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      endif
  100 format (
     +'Cannot run editor ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_explorer (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(5) milliseconds then try to execute
c 
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(5)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      endif
  100 format (
     +'Cannot run explorer ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_gsview (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c         11/11/2022 added text_viewer
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    isend
      parameter (isend = 1)
      integer    iwait, k, nval(12)
      integer    mode
      character (len = 1024) cval(12), fname
      character  line*100, word60*60, x_trim60*60
      character (len = 1   ) blank
      parameter (blank = ' ') 
      logical    proceed, view_as_text, view_as_text1
      parameter (proceed = .true., view_as_text = .true.) 
      logical    there
      external   w_config, x_putadv, x_trim60, text_viewer, x_infofl
      view_as_text1 = view_as_text
c
c does the .ps file exist
c
      fname = commnd
      if (fname.ne.blank) then  
         inquire (file = fname, exist = there)
         if (.not.there) then
            call x_infofl (isend,
     +                     fname)             
            return
         endif
      endif
      if (view_as_text1) then
         call text_viewer (commnd,
     +                     proceed)
         return
      endif   
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(6) milliseconds then try to execute
c         
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(6)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      endif
  100 format (
     +'Cannot run PS viewer ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_program (progrm, commnd)
c
c action: start a simfit program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(7) milliseconds then try to execute
c         
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(7)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1  
         k = start_process_and_wait@(progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif    
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
      endif
  100 format ('Procedure start_process_and_wait@ failed')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_win32 (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(8) milliseconds then try to execute
c         
         mode = -2
         call w_config (mode, nval, 
     +                  cval)
         iwait = nval(8)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then 
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
      endif
  100 format ('Procedure start_process_and_wait@ failed')
  200 format ('Cannot find',1x,a)
      end
c
c
      subroutine startp_printer (progrm, commnd)
c
c action: start a program with a command line
c author: w.g.bardsley, university of manchester, uk, 19/10/2001
c         10/11/2003 replaced call and treated as a function
c         16/11/2003 added warning for missing program file
c         14/05/2004 added call to config and start_process_and_wait@
c         25/11/2006 used kval(8) to display/suppress warnings 
c
c         progrm: (input/unchanged) name of executable
c         commnd: (input/unchanged) command line for executable
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: progrm, commnd
c
c locals
c
      integer    iwait, k, nval(12)
      integer    mode
      character  cval(12)*1024
      character  line*100, word60*60, x_trim60*60
      logical    there
      external   w_config, x_putadv, x_trim60
c
c does progrm exist
c
      inquire (file = progrm, exist = there)
      if (there) then
c
c if so get iwait = nval(9) milliseconds then try to execute
c       
         mode = -2
         call w_config (mode, nval,
     +                  cval)
         iwait = nval(9)
         if (iwait.lt.0 .or. iwait.gt.10000) iwait = - 1
         k = start_process_and_wait@ (progrm, commnd, iwait)
         if (k.lt.0) then
            mode = -1  
            call w_config (mode, nval, 
     +                     cval)
            if (nval(8).eq.1) then
               write (line,100)
               call x_putadv (line)
            endif   
         endif
      else
c
c if not inform user
c
         word60 = x_trim60(progrm)
         write (line,200) word60
         call x_putadv (line)
         write (line,100)
         call x_putadv (line)
      endif
  100 format (
     +'Cannot run printer ... Use [Configure], [Check], [Apply]')
  200 format ('Cannot find',1x,a)
      end
c
c
