c
c Collected svg subroutines 
c      
c w_svgchk (ix, iy, iz,
c           fname,
c           allow_blanks, allow_isvg, noisy)
c w_svgdim (ix, iy, 
c           fname,
c           allow_blanks, allow_isvg)
c w_svgdis (fname)
c w_svgedi (fname,
c           allow_blanks, allow_isvg)
c

c
c-------------------------------------------------------------------------------
c     
      subroutine w_svgchk (ix, iy, iz,
     +                     fname,
     +                     allow_blanks, allow_isvg, noisy)
c
c action: check for a genuine Simfit-compatible SVG or ISVG file 
c author: w.g.bardsley, university of manchester, u.k., 22/12/2018
c
c           ix: width if > 0
c           iy: height if > 0
c           iz: svg type as follows
c               -5 ... not a Simfit-consistent svg type
c               -4 ... file name too short < 5 characters
c               -3 ... file has no .svg suffix
c               -2 ... file currently connected
c               -1 ... file not found
c                0 ... filename is blank
c                1 ... ok
c allow_blanks: accepts if .true.
c allow_isvg  : accepts if .true.
c        noisy: if .true. then output error messages
c        fname: svg file 
c
c      
c extern "C" int __get_svg_information(char* file,int& width,int& height,int& svg_type)
c {
c /***************************************************************************************/
c /*                                                                                     */
c /*     Tests an SVG file and extracts certain information. Possible return values:     */
c /*                                                                                     */
c /*     0 - Success                                                                     */
c /*     1 - File not found, or not .SVG suffix                                          */
c /*     2 - Invalid XML/SVG syntax                                                      */
c /*                                                                                     */
c /*     svg_type=0 - Unknown source                                                     */
c /*     svg_type=1 - Generated by ClearWin+                                             */
c /*     svg_type=2 - Generated by dvisvgm                                               */
c /*                                                                                     */
c /*     svg_flags is considered bit significant, so othre bits may be defined later     */
c /*                                                                                     */
c /***************************************************************************************/
    
      implicit none
c
c arguments
c      
      integer,             intent (out) :: ix, iy, iz
      character (len = *), intent (in)  :: fname
      logical,             intent (in)  :: allow_blanks, allow_isvg, 
     +                                     noisy
c
c locals
c
      integer    k  
      character (len = 5) word5
      character (len = 4) word4
      character (len = 1) blank
      parameter (blank = ' ')
      logical    ex, op
      external   x_putadv, x_lcase1
      c_external svgdim '__get_svg_information' (instring,ref,ref,ref)
      if (allow_blanks .and. fname.eq.blank) then
         ix = 0
         iy = 0
         iz = 1
         return
      endif 
      if (allow_isvg) then 
         ix = 0
         iy = 0
         k = len_trim(fname)
         if (k.gt.5) then
            word5 = fname(k - 4:k)
            call x_lcase1 (word5)
            if (word5.eq.'.isvg') then
               iz = 1
               return
            endif   
         endif 
      endif   
      ix = -1
      iy = -1
      iz = 0
      if (fname.eq.blank) then
         if (noisy) call x_putadv (
     +'file name supplied is blank') 
         return
      endif  
      iz = -1 
      inquire (file = fname, exist = ex, opened = op) 
      if (.not.ex) then
         if (noisy) call x_putadv (
     +'File specified cannot be found')
         return
      endif   
      iz = -2
      if (op) then
         if (noisy) call x_putadv (
     +'File specified is currently opened')
         return
      endif 
      iz = -3 
      k = len_trim(fname)
      if (k.lt.5) then
         if (noisy) call x_putadv (
     +'File not a SVG file ... i.e., no svg suffix')
         return
      endif
      iz = -4
      word4 = fname(k - 3:k)
      call x_lcase1 (word4)
      if (word4.ne.'.svg') then
         if (noisy) call x_putadv (
     +'File must have suffix svg ... i.e., *.svg')
         return
      endif   
      iz = 0 
      call svgdim (fname, ix, iy, iz)
      if (noisy .and. iz.ne.1) then
         iz = -5
         call x_putadv (
     +'Not a valid Simfit-type svg file')
      endif
      end
c
c-------------------------------------------------------------------------------
c 
      subroutine w_svgdim (ix, iy, 
     +                     allow_blanks, fname)
c
c action: interface to David Bailey's program get_svg_information 
c author: w.g.bardsley, university of manchester, u.k., 20/12/2018
c
c           ix: width if > 0
c           iy: height if > 0
c           iz: svg type as follows
c               -5 ... not a Simfit-consistent svg type
c               -4 ... file name too short < 5 characters
c               -3 ... file has no .svg suffix
c               -2 ... file currently connected
c               -1 ... file not found
c                0 ... filename is blank
c                1 ... ok
c allow_blanks: accepts blanks if .true. 
c        noisy: if .true. then output error messages
c        fname: svg file 
c
      implicit none
c
c arguments
c      
      integer,             intent (out) :: ix, iy
      character (len = *), intent (in)  :: fname
      logical,             intent (in)  :: allow_blanks 
c
c locals
c
      integer    iz
      logical    allow_isvg, noisy
      parameter (allow_isvg = .false., noisy = .false.)
      external   w_svgchk 
c
c check for a valid Simfit-compatible svg file
c      
      call w_svgchk (ix, iy, iz, 
     +               fname,
     +               allow_blanks, allow_isvg, noisy)
      if (iz.eq.1) then
         return
      else   
         ix = 0
         iy = 0
      endif     
      end  
c
c--------------------------------------------------------------------------
c
c
      subroutine w_svgdis (fname)
c
c action: interface to David Bailey's displaysvg program 
c author: w.g.bardsley, university of manchester, u.k., 20/12/2018
c
c fname: svg file 
c 
      implicit none
c
c arguments
c      
      character (len = *), intent (in) :: fname
c
c locals
c 
      integer    ix, iy, iz
      logical    allow_blanks, allow_isvg, noisy
      parameter (allow_blanks = .false., allow_isvg = .false., 
     +           noisy = .true.)
      external   w_svgchk
      c_external svgdis '__DisplaySVG' (instring)
      call w_svgchk (ix, iy, iz,
     +               fname,
     +               allow_blanks, allow_isvg, noisy) 
      if (iz.eq.1) call svgdis (fname)   
      end
c
c----------------------------------------------------------------------
c 
      subroutine w_svgedi (fname,
     +                     allow_blanks, allow_isvg)
c
c action: interface to David Bailey's program editsvg 
c author: w.g.bardsley, university of manchester, u.k., 21/12/2018
c
      implicit none
c
c arguments
c      
      character (len = *), intent (in) :: fname
      logical,             intent (in) :: allow_isvg, allow_blanks
c
c locals
c
      integer    ix, iy, iz
      logical    noisy
      parameter (noisy = .true.)
      external   w_svgchk
      c_external edit_svg '__EditSVG'(instring)
      call w_svgchk (ix, iy, iz,
     +               fname,
     +               allow_blanks, allow_isvg, noisy)
      if (iz.eq.1) call edit_svg (fname)
      end
c
c------------------------------------------------------------------------------- 
c                 