c
c w_svgini      ... open/close svg
c svg_copy      ... copyfile
c svgpar        ... return svg parameters for use outside the simfit clearwin dll
c svg_margin    ... add a margin to svg files
c corner_dots   ... no longer used but left in just in case
c
      subroutine w_svgini (isend, ix, iy,
     +                     svg_file,
     +                     svg_state) 
      use module_defngks, only : svg
c
c
c action: subroutine to open or close the David Bailey svg procedure
c author: w.g.bardsley, university of manchester, u.k., 24/04/2014
c         12/07/2014 now only isend = 0 initialises and arguments are always returned
c         01/04/2018 improved by David Bailey 
c         28/10/2018 added calls to corner_dots
c         21/12/2018 removed calls to corner_dots with jsend = 3
c         15/06/2019 now calls w_syspar, xres_yres, and svgpar
c         10/09/2019 now calls svg_copy 
c
c    isend: isend = 0 initialise  
c           isend = 1 open  the svg procedure (and return the saved parameters)   
c           isend = 2 close the svg procedure (and return the saved parameters)   
c           otherwise just return the saved parameters        
c       ix: pixels across
c       iy: pixels down 
c svg_file: file to receive the plotting instructions
c
      implicit none
      include <windows.ins>
c
c arguments
c      
      integer,             intent (in)     :: isend 
      integer,             intent (inout)  :: ix, iy
      character (len = *), intent (inout)  :: svg_file
      character (len = *), intent (out)    :: svg_state
c
c locals
c      
      integer    ix_sav, iy_sav, k, l
      integer    graphics_ident
      double precision x_svg, y_svg
      double precision one
      parameter (one = 1.0D+00)
      character (len = 1024) f$simfit_svg, svg_file_sav
      character (len = 6   ) svg_state_sav
      logical    abort, first
      logical    active_svg
      external   svgpar, svg_margin, svg_copy
      external   w_syspar, xres_yres, w_svgdis, w_v7path, x_putadv
      intrinsic  trim
      save ix_sav, iy_sav 
      save svg_file_sav
      save svg_state_sav
      save graphics_ident
      save active_svg
      save f$simfit_svg
      data ix_sav, iy_sav / 1600, 1200 /
      data svg_file_sav / 'NOFILE' /
      data svg_state_sav / 'NOFILE' /
      data first / .true. /
      data f$simfit_svg / 'NOFILE' /
c
c this definition for f$simfit_svg must agree with w_button in the function i_press_25
c
      IF (FIRST) THEN
         FIRST = .FALSE.
         CALL W_V7PATH (L,
     +                  'tmp', F$SIMFIT_SVG)
         IF (F$SIMFIT_SVG(L:L).NE.'\') THEN
            L = L + 1
            F$SIMFIT_SVG(L:L) = '\'
         ENDIF
         F$SIMFIT_SVG(L + 1:L + 12) = 'f$simfit.svg'
      ENDIF      
      if (isend.eq.0) then
c
c isend = 0: initialise
c
          ix_sav = ix
          iy_sav = iy
          svg_file_sav = svg_file
          svg_state = 'SVGINI'
          svg_state_sav = svg_state
       elseif (isend.eq.1) then
c
c isend = 1: open svg and define svg = .true. Note: call to svgpar to set active_svg = .true.
c        
         if (svg_state.eq.'OPENED') then
            return
         else
            CALL W_SYSPAR (IX_SAV, 'x')
            CALL W_SYSPAR (IY_SAV, 'y')
            CALL XRES_YRES (IX_SAV, IY_SAV)
            call svgpar (isend,
     +                   x_svg, y_svg,
     +                   active_svg)
            ix_sav = nint(x_svg*dble(ix_sav))   
            iy_sav = nint(y_svg*dble(iy_sav))
            ix = ix_sav
            iy = iy_sav   
            graphics_ident=42
            k = OPEN_SVG1@ (svg_file_sav,
     +                      ix_sav, iy_sav, graphics_ident) 
            svg_state = 'OPENED'  
            svg = .true.
            k = ix_sav!to silence ftn95
            ix = k
            iy = iy_sav
            svg_file = svg_file_sav
            svg_state_sav = svg_state
                
c***********jsend = 3                       ! not used
c***********call corner_dots (jsend, ix, iy)! not used
         endif   
      elseif (isend.eq.2) then
c
c isend = 2: close svg and set svg = .false. Note call to svgpar to set active_svg = .false. 
c      
         call svgpar (isend,
     +                x_svg, y_svg,
     +                active_svg)  
         ix = ix_sav
         iy = iy_sav
         svg_file = svg_file_sav
         k = close_svg@(graphics_ident)
         svg_state = 'CLOSED'
         svg_state_sav = svg_state
         svg = .false.
         if (svg_file_sav.eq.f$simfit_svg) then
            call w_svgdis (svg_file_sav)
         elseif (x_svg.gt.one .or. y_svg.gt.one) then
            call svg_copy (svg_file_sav, f$simfit_svg, 
     +                     abort)
            if (abort) call x_putadv ('svg_copy failed')  
            call svg_margin (f$simfit_svg, svg_file_sav,
     +                       abort)
         endif
      else
c
c otherwise return the saved parameters
c        
         ix = ix_sav
         iy = iy_sav
         svg_file = svg_file_sav
         svg_state = svg_state_sav
      endif
      end      
c
c
      subroutine svg_copy (fname1, fname2,
     +                     abort)
c
c action: copy fname1 to fname2 over_writing if necessary
c author: w.g.bardsley, university of manchester u.k. 10/09/2019
c         12/05/2020 corrected so that k = 0 => abort = .true.
c                    also introduced l1, and l2 as len of fname1 and fname 2 must be <= 256  
c     
      implicit   none
      include   <windows.ins>
      character (len = *),intent (in)  :: fname1, fname2
      logical,            intent (out) :: abort
      integer    l1, l2
      integer    k, copyfile
      logical    no_overwrite, no_replace
      parameter (no_overwrite = .false.)
      intrinsic  len, min
      abort = .false.
      l1 = min(len(fname1),256)
      l2 = min(len(fname2),256)
      no_replace = no_overwrite
      k = copyfile (fname1(1:l1), fname2(1:l2),
     +              no_replace)
      if (k.eq.0) abort = .true.
      end     
c
c-------------------------------------------------------------------------------
c
      subroutine svgpar (isend, 
     +                   x_svg, y_svg,
     +                   active_svg)
c
c action: set/return SVG parameters
c author: w.g.bardsley, university of manchester, u.k., 15/06/2019
c         21/08/2019 suppressed the steps preventing both x_svg and y_svg being altered               
c  
c isend = 0: return stored parameters
c isend = 1: set active = .true.   
c isend = 2: set active = .false.   
c isend = 3: change x_svg   
c isend = 4: change y_svg
c isend = 5: cancel scaling
C isend = 6: return x_svg = y_svg = one 
c   
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: isend
      double precision, intent (out) :: x_svg, y_svg
      logical,          intent (out) :: active_svg  
c
c locals
c
      double precision  x_sav, y_sav
      double precision  xmax, xmin, ymax, ymin
      parameter        (xmin = 1.0d+00, xmax = 20.0d+00,
     +                  ymin = 1.0d+00, ymax = 20.0d+00)   
      double precision  one
      parameter (one = 1.0d+00)
      logical    active_sav
      external   x_getdm1, x_putwar  
      save x_sav, y_sav
      save active_sav
      data x_sav, y_sav  / one, one /
      data active_sav / .false. /
c
c always check x_sav and y_sav then set output parameters to current stored values
c
      if (x_sav .lt. one) x_sav = one  
      if (y_sav .lt. one) y_sav = one 
c      if (x_sav.gt.one .and. y_sav.gt.one) y_sav = one
      x_svg = x_sav
      y_svg = y_sav
      active_svg = active_sav
c
c subsequent procedures depend on isend
c      
      if (isend.eq.0) then
c
c isend = 0: return stored values
c        
         return
      elseif (isend.eq.1)  then
c
c isend = 1: set active_svg = .true., then RETURN
c        
         active_svg = .true.
         active_sav = .true.
         return
      elseif (isend.eq.2) then
c
c isend = 2: set active_svg = .false. then RETURN
c      
         active_svg = .false.
         active_sav = .false.
         return
      elseif (isend.eq.3) then
c
c isend = 3: just set/store x_scaling factor
c      
         call x_getdm1 (xmin, x_sav, xmax, 'Value of x_scale required')
c         if (x_sav.gt.one .and. y_sav.gt.one) y_sav = one
         x_svg = x_sav 
         y_svg = y_sav
      elseif (isend.eq.4) then
c
c isend = 4: just set/store y_scaling factor
c        
         call x_getdm1 (ymin, y_sav, ymax, 'Value of y_scale required') 
c         if (x_sav.gt.one .and. y_sav.gt.one) x_sav = one
         x_svg = x_sav  
         y_svg = y_sav
      elseif (isend.eq.5) then
c
c isend = 5: restore default scaling factors
c      
         x_svg = one
         y_svg = one 
         x_sav = one
         y_sav = one  
      elseif (isend.eq.6) then   
c
c isend = 6: always return x_svg = y_svg = one but no change to x_sav or y_sav
c  
         x_svg = one
         y_svg = one       
      else
c
c o/w error warning and exit 
c        
         call x_putwar ('ISEND out of range (0,6) in call to SVGPAR')
         return           
      endif
      end 
c
c------------------------------------------------------------------------
c
      subroutine svg_margin (fname_in, fname_out,
     +                       abort)
c
c action: add a margin to compensate for trimming when re-scaling
c author: w.g.bardsley, university of manchester, u.k. 28/07/2019 using code by David Bailey
c
c  fname_in = svg file with arbitrary margins which is returned unchanged
c fname_out = svg file returned but with a small margin
c
c Note that this subroutine takes no action if x_svg and y_svg are =< 1.1
c
c      
      implicit   none  
      include   <windows.ins>
c
c argument
c      
      character (len = *), intent (inout) :: fname_in, fname_out 
      logical,             intent (out)   :: abort
c
c locals
c      
      integer    isend
      parameter (isend = 0) 
      integer    l
      integer    width, height, type1
      integer    i_width, i_height
      double precision factor
      parameter (factor = 1.25d+00)
      double precision x_svg, y_svg
      double precision image_width, image_height, scale
      character (len = 4) ext
      logical    active_svg
      logical    op, read_only, there
      c_external get_svg_information '__get_svg_information' (instring,
     +           ref, ref, ref) : integer 
      c_external import_tex_object '__import_tex_object' (instring,
     +           val, val, val, ref, ref) : integer             
      external   x_attrib, x_putadv, x_lcase1
      external   svgpar
      intrinsic  len_trim
c
c find out if x_svg or y_svg >> 1
c      
      call svgpar (isend,
     +             x_svg, y_svg,
     +             active_svg) 
      if (x_svg.le.factor .and. y_svg.le.factor) return    
c
c set abort = .true. then check that the files exist and are not read_only or connected
c     
      abort = .true.
      call x_attrib (fname_in,
     +               there, read_only) 
      
      if (.not.there) then 
         call x_putadv ('Input file does not exist')
         return
      endif
      call x_attrib (fname_out,
     +               there, read_only) 
      if (read_only) then
         call x_putadv ('Output file is read_only')
         return
      endif  
      inquire(file = fname_out, exist = there, opened = op) 
      if (op) then
         call x_putadv ('Output file is connected')
         return
      endif   
      l = len_trim (fname_in)
      if (l.lt.5) then
         call x_putadv ('Input file name must have >= 5 characters')
         return
      endif
      ext = fname_in(l-3:l)
      call x_lcase1 (ext)
      if (ext.ne.'.svg') then
         call x_putadv ('Input file does not have the extension .svg')
         return
      endif 
      l = len_trim (fname_out)
      if (l.lt.5) then
         call x_putadv ('Output file name must have >= 5 characters')
         return
      endif
      ext = fname_out(l-3:l)
      call x_lcase1 (ext)
      if (ext.ne.'.svg') then
         call x_putadv ('Output file does not have the extension .svg')
         return
      endif             
c
c fortran version of code by David Bailey that adds a margin to offset the effects of trimming
c      
      call get_svg_information (fname_in, width, height, type1)
      if (mod(type1,4).eq.0) then
         call x_putadv ('Input file is not a Clearwin type svg file')
         return
      endif   
      l = open_svg@ (fname_out, width, height)
      scale = 1.0d+00
      call import_tex_object (fname_in, 0.0d+00, 0.0d+00, scale, 
     +                        image_width, image_height)
      i_width = nint(image_width)
      i_height = nint(image_height)
      l = close_svg@ (0)
c
c expand the viewport and add an offset to create a small margin then set abort = .false.
c      
      l = open_svg@ (fname_out, i_width + 100, i_height + 100)
      call import_tex_object (fname_in, 50.0d+00, 50.0d+00, scale,
     +                        image_width,
     +                        image_height)
      l = close_svg@ (0)
      abort = .false.
      end
c
c--------------------------------------------------------------------------- 
c
      subroutine corner_dots (isend, ix, iy) 
c
c action: save/retrieve/plot corner dots for SVG
c author: w.g.bardsley, university of manchester, u.k. 26/10/2018
c         10/12/2018 call to savres$ to initialise corner_dots  
c         21/12/2018 no action when isend = 3 to stop corner dots being drawn 
c                    but code left in just in case for possible future use  
c         23/12/2018 also made sure by setting draw_dots and draw_polyline to .false.   
c
      implicit none
      include <windows.ins>
c
c arguments
c
      integer, intent (in)    :: isend
      integer, intent (inout) :: ix, iy               
c
c locals
c      
      integer  ixsav, iysav
      integer  i, icol, jx(5), jy(5), n
      logical  draw_dots, draw_polyline
      logical  store
      external x_putfat, savres$
      data     ixsav, iysav / -1, -1 /
c
c 21/12/2018: now no action if isend = 3
c 23/12/2018: also added draw_polyline to make absolutely sure
c      
      if (isend.eq.3) return
c
c decide to draw dots or a polyline...23/12/2018 both set to false.
c      
      draw_dots = .false.
      draw_polyline = .false.
c
c make sure ixsav and iysav are sensibly initialised
c      
      if (ixsav.le.0 .or. iysav.le.0) then
         store = .false.
         call savres$(ixsav, iysav,
     +                store)          
      endif
      if (isend.eq.1) then
c
c isend = 1: save the coordinates
c
         if (ix.gt.0 .and. iy.gt.0) then
            ixsav = ix
            iysav = iy            
         endif   
      elseif (isend.eq.2) then  
c
c isend = 2: retrieve the coordinates
c        
         ix = ixsav
         iy = iysav
      elseif (isend.eq.3) then   
c
c isend = 3:  draw dots at all 4 corners or else a picture frame
c
         ixsav = ix
         iysav = iy
         jx(1) = 0
         jx(2) = ix - 1
         jx(3) = ix - 1
         jx(4) = 0
         jx(5) = jx(1)
         jy(1) = 0
         jy(2) = 0
         jy(3) = iy - 1
         jy(4) = iy - 1
         jy(5) = jy(1)
         icol = rgb@(250,250,250)
         if (draw_dots) then
           call draw_line_between@(jx(1), jy(1), jx(1) + 1, jy(1), icol)
           call draw_line_between@(jx(2), jy(2), jx(2) - 1, jy(2), icol)
           call draw_line_between@(jx(3), jy(3), jx(3) - 1, jy(3), icol)
           call draw_line_between@(jx(4), jy(4), jx(4) + 1, jy(4), icol)
            n = 4
            do i = 1, n
               call draw_point@(jx(i), jy(i), icol)
            enddo   
         elseif (draw_polyline) then   
            n = 5
            call draw_polyline@(jx, jy, n, icol)
         endif   
      else
c      
c isend out of range
c        
         call x_putfat ('ISEND out of range in call to DRAW_CORNERS')
      endif    
      end
c
c
     
    