c
c----------------------------------
c start of module to hold variables
c---------------------------------- 
c 
      module     module_symbols
      integer    nmax
      parameter (nmax = 20)
      integer    jcolor_1(nmax), kcolor_1(nmax), l_1(nmax), m_1(nmax)
      integer    jcolor_2(nmax), kcolor_2(nmax), l_2(nmax), m_2(nmax)
      integer    jcolor_3(nmax), kcolor_3(nmax), l_3(nmax), m_3(nmax)
      double precision size_1(nmax), thick_1(nmax)
      double precision size_2(nmax), thick_2(nmax)
      double precision size_3(nmax), thick_3(nmax)
      double precision one
      parameter (one = 1.0d+00)
      logical    cancel_symbol
c
c data statements to initialise variables
c
      data       jcolor_2 /  0,  4,  1,  2,  3,  5,  6,  9, 10, 11, 
     +                      14, 12, 13,  7,  8, 28, 39, 40, 44, 48 /
      data       kcolor_2 /  4,  0,  0,  1,  1, 22, 22, 15,  4,  0,
     +                       0,  0,  0,  0,  0,  0,  0,  0,  0,  0 /
      data            l_2 /  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,
     +                       2,  3,  1,  2,  3,  1,  2,  3,  1,  2  /
      data            m_2 /  5,  8, 11, 14,  34, 6,  9, 12, 15, 35, 
     +                       7, 10, 13, 16, 37, 18, 19,  1,  2,  3  /
      data         size_2 / nmax*one /
      data        thick_2 / nmax*one /
      data       jcolor_3 /  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     +                       0,  0,  0,  0,  0,  0,  0,  0,  0,  0 /
      data       kcolor_3 /  0,  0,  0,  0,  0, 22, 22, 15,  0,  0, 
     +                       0,  0,  0,  0,  0,  0,  0,  0,  0,  0 /
      data       cancel_symbol / .false. /
      end module module_symbols
c
c--------------------------------
c end of module to hold variables
c--------------------------------
c
      subroutine w_symbol (isend, jcolor, kcolor, l, m,
     +                     sizes, thick)
      use module_symbols
c
c action: store colours, symbols and linetypes for re-use in plots
c author: w.g.bardsley, university of manchester, u.k., 12/12/98
c         05/07/2000 introduced store1 to force creation of a default
c         13/02/2002 XP version
c         15/10/2004 added isend and kcolor, and deleted store
c         24/10/2004 made sure l_1(i) and m_1(i) are never both = 0
c         28/10/2004 introduced pcent and ntype
c         12/11/2004 removed restriction on kcolor =< 7, deleted n12 and n15 and
c                    set kcolor(8) = background. Now all arguments are edited
c                    up to nmax so dimension supplied as (*) must be at least nmax.
c                    Also background default (kcolor(8)) is not allowed to be black.
c         17/02/2005 initialised when called with isend = 2 
c         05/02/2007 edited for w_clearwin.dll 
c         10/12/2007 changed red title default and silenced advice when creating w_symbol.cfg 
c         12/12/2007 added scale1 and scale2 to scale font sizes
c         06/11/2008 rename w_simfit.sym to w_symbol.cfg 
c         02/11/2010 added sizes and thick and allowed isend = 4  
c         04/12/2010 corrected error with window_update@ and increased dimension to 15
c         24/04/2011 increased dimension to 20
c         26/12/2012 altered winio call at c***** to agree with the 64-bit version
c         08/01/2016 replaced common blocks by module_symbols and stopped l(1) = 0 and m(1) = 0
c
c         NOTE: dimensions are assumed to be at least nmax for all arrays. Values
c               are stored in w_symbol.cfg which is created if missing.
c               nmax MUST be the same in the routine AND call back function
c               jcolor_2, kcolor_2, l_2, m_2, size_2 and thick_2 are never changed by this
c               subroutine but are used as permanent reference values.
c               jcolor_3 and kcolor_3 are monochrome defaults in call back
c
c         isend: (input/unchanged) as follows:
c                isend = 1, RETRIEVE               ... just return current default values
c                isend = 2, EDIT/STORE/RETRIEVE    ... then write w_symbol.cfg and 
c                                                  ... also return current default values
c                isend = 3, INSTALL DEFAULT VALUES ... then write w_symbol.cfg and 
c                                                  ... also return current default values
c                isend = 4, STORE SUPPLIED VALUES  ... then write w_symbol.cfg
c        jcolor: (input/output) line/symbol colour 0 =< jcolor =< 71
c        kcolor: (input/output) other colours 0 =< kcolor =< 71 as follows:
c                 1, main title    (red = 12 ?)
c                 2, axes
c                 3, labels
c                 4, legends  (blue = 9 ?)
c                 5, panel keys
c                 6, border   (should be specified as grey, i.e. 7)
c                 7, graticule(should be specified as grey, i.e. 7)
c                 8, background (not allowed to be black, i.e. 0)
c                 9, extra title
c             l: (input/output) line type 1 =< l =< 8
c             m: (input/output) symbol type 1 =< m =< 37
c         sizes: (input/output) symbol size between 0.2 and 5
c         thick: (input/output) line thickness between 0.2 and 5
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      integer,          intent (in)    :: isend  
      integer,          intent (inout) :: jcolor(20), kcolor(20), l(20),
     +                                    m(20)
      double precision, intent (inout) :: thick(20), sizes(20)
c
c locals
c
      integer    n0, n1, n2, n3, n4, n8, n19, n24, n37, n71
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n8 = 8, 
     +           n19 = 19, n24 = 24, n37 = 37, n71 = 71)
c
c nmax must be equal to nmax defined in module_symbols
c
      integer    ntype
      parameter (ntype = 4)
      integer    jcolor_sav(nmax), kcolor_sav(nmax), l_sav(nmax),
     +           m_sav(nmax) 
      integer    i, ios, itemp, j, nout
      integer    i_restore_symbol_defaults
      integer    i_tell_about_symbol_defaults
      integer    i_cancel_symbol_editing
      integer    x_len200
      double precision sizes_sav(nmax)
      double precision thick_sav(nmax)
      double precision s_lower, s_upper, t_lower, t_upper
      parameter (s_lower = 0.2d+00, s_upper = 5.0d+00,
     +           t_lower = 0.2d+00, t_upper = 5.0d+00)      
      double precision scale1, scale2, size1, size2
      parameter (scale1 = 0.95d+00, scale2 = 0.95d+00)
      character (len = 1024) fname, x_sim256
      character (len = 100 ) line 
      character (len = 30  ) stype(24)
      character (len = 25  ) ctype(20)
      character (len = 20  ) ltype(8)
      character (len = 15  ) feature(nmax)
      character (len = 12  ) w_simfit_sym
      character (len = 1   ) pcent
      parameter (w_simfit_sym = 'w_symbol.cfg', pcent = '%')
      logical    check_header, exist, first, ok, read_only
      logical    askif, there
      parameter (askif = .false.)
      external   w_syspar, w_getnou, x_putfat, x_attrib, x_sim256,
     +           x_len200, w_deleet
      external   i_restore_symbol_defaults
      external   i_tell_about_symbol_defaults
      external   i_cancel_symbol_editing
      intrinsic  dble, index
      save       check_header, first
      data       check_header, first / .true., .true. /
c
c check isend
c
      if (isend.lt.n1 .or. isend.gt.n4) then
         write (line,100)
         call x_putfat (line)
         return
      endif
      
c      if (isend.eq.4)  call x_putfat ('w_symbol called with isend = 4')
        
c
c check if w_symbol.cfg exists and is read-only
c                                     
      fname = x_sim256(w_simfit_sym)
      call x_attrib (fname,
     +               exist, read_only)
     
      if (check_header .and. exist .and. .not.read_only) then
c
c check the configuration type
c        
         check_header = .false.
         call w_getnou (nout)
         close (unit = nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
         close (unit = nout)
         if (ios.eq.n0) then
            i = index(line,pcent)
            j = x_len200(line)
            read (line(i + 1:j),*,iostat=ios) itemp
            if (ios.eq.n0 .and. itemp.ne.ntype) then
               call w_deleet (fname,
     +                        askif, there)
               exist = .false.            
            endif 
         endif   
      endif   
c
c------------------------------------------------------------------------
c special actions required if w_symbol.cfg is read-only or does not exist
c------------------------------------------------------------------------
c
      if (exist .and. read_only) then
c
c if w_symbol.cfg is read_only then complain but return defaults
c
         do i = n1, nmax
            jcolor(i) = jcolor_2(i)
            kcolor(i) = kcolor_2(i)
            l(i) = l_2(i)
            m(i) = m_2(i)
            sizes(i) = size_2(i)
            thick(i) = thick_2(i)
         enddo
         if (first) then
            write (line,200)
            call x_putfat (line)
         endif
         return
      elseif (.not.exist) then
c
c if w_symbol.cfg does not exist advise user and create a default
c suppressed 10/12/2007
c
c         write (line,300)
c         call x_putadv (line)
         do i = n1, nmax
           
            jcolor_1(i) = jcolor_2(i)
            kcolor_1(i) = kcolor_2(i)
            l_1(i) = l_2(i)
            m_1(i) = m_2(i)
            size_1(i) = size_2(i)
            thick_1(i) = thick_2(i)
            
            jcolor(i) = jcolor_2(i)
            kcolor(i) = kcolor_2(i)
            l(i) = l_2(i)
            m(i) = m_2(i)
            thick(i) = thick_2(i)
            sizes(i) = size_2(i)
         enddo
         call w_getnou (nout)
         close (unit = nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.n0) then
            write (nout,400) pcent, ntype
            do i = n1, nmax
              write (nout,'(3i4,f6.2,i4,f6.2)',iostat=ios)
     +                     kcolor_2(i), jcolor_2(i),
     +                     l_2(i), thick_2(i),
     +                     m_2(i), size_2(i)
               if (ios.ne.0) exit
            enddo
         endif
         write (nout,500)
         close (unit = nout)
      endif
c
c----------------------------------------------------------------
c special action required to set up the defaults first time round
c----------------------------------------------------------------
c
      if (first .and. isend.lt.n3) then
         first = .false.
c
c initialise then open the w_symbol.cfg file and read in values
c
         do i = n1, nmax
            jcolor_1(i) = jcolor_2(i)
            kcolor_1(i) = kcolor_2(i)
            l_1(i) = l_2(i)
            m_1(i) = m_2(i)
            size_1(i) = size_2(i)
            thick_1(i) = thick_2(i)
         enddo
         call w_getnou (nout)
         close (unit = nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.n0) read (nout,'(a)',iostat=ios) line
         if (ios.eq.n0) then
            ok = .true.
            i = index(line, pcent)
            if (i.gt.n0) then
               j = x_len200(line)
               read (line(i + 1:j),*,iostat=ios) itemp
               if (ios.eq.n0) then
                  if (itemp.ne.ntype) ok = .false.
               else
                  ok = .false.
               endif
            else
               ok = .false.
            endif
         else
            ok = .false.
         endif
         if (ok) then
c
c file seems ok so try to read parameters from it
c
            do i = 1, nmax
               read (nout,*,iostat=ios) kcolor_1(i), jcolor_1(i), 
     +                                  l_1(i), thick_1(i), m_1(i), 
     +                                  size_1(i) 
     
               if (jcolor_1(i).lt.n0 .or. jcolor_1(i).gt.n71)
     +             jcolor_1(i) = jcolor_2(i)
               if (kcolor_1(i).lt.n0 .or. kcolor_1(i).gt.n71)
     +             kcolor_1(i) = kcolor_2(i)
               if (l_1(i).lt.n1 .or. l_1(i).gt.n8) l_1(i) = l_2(i)
               if (m_1(i).lt.n1 .or. m_1(i).gt.n37) m_1(i) = m_2(i)
               if (size_1(i).lt.s_lower .or.
     +             size_1(i).gt.s_upper) size_1(i) = size_2(i)
               if (thick_1(i).lt.t_lower .or.
     +             thick_1(i).gt.t_upper) thick_1(i) = thick_2(i)
               
               if (ios.ne.0) exit               
            enddo              
c
c make sure background colour is not black
c
            if (kcolor_1(8).eq.n0) kcolor_1(8) = kcolor_2(8)
         endif
         close (unit = nout)
      endif
c
c--------------------------------
c start of normal routine entries
c--------------------------------
c
      if (isend.eq.n1) then
c
c isend = 1: just return with the current default values
c ==========
c
         if (kcolor_1(8).eq.n0) kcolor_1(8) = kcolor_2(8)
         do i = n1, nmax
           
            if (jcolor_1(i).lt.n0 .or. jcolor_1(i).gt.n71)
     +          jcolor_1(i) = jcolor_2(i)
            if (kcolor_1(i).lt.n0 .or. kcolor_1(i).gt.n71)
     +          kcolor_1(i) = kcolor_2(i)
            if (l_1(i).lt.n1 .or. l_1(i).gt.n8) l_1(i) = l_2(i)
            if (m_1(i).lt.n1 .or. m_1(i).gt.n37) m_1(i) = m_2(i)
            if (size_1(i).lt.s_lower .or.
     +          size_1(i).gt.s_upper) size_1(i) = size_2(i)
            if (thick_1(i).lt.t_lower .or.
     +          thick_1(i).gt.t_upper) thick_1(i) = thick_2(i)
 
            jcolor(i) = jcolor_1(i)
            kcolor(i) = kcolor_1(i)
            l(i) = l_1(i)
            m(i) = m_1(i)
            sizes(i) = size_1(i)
            thick(i) = thick_1(i)
            
         enddo
         return
      elseif (isend.eq.n2) then
c
c isend = 2: set the defaults as for isend = 1, scale the font sizes, use the control,
c ========== then eventually write edited values to w_symbol.cfg
c
                  
         cancel_symbol = .false.  
         if (kcolor_1(8).eq.n0) kcolor_1(8) = kcolor_2(8)
         do i = n1, nmax

            if (jcolor_1(i).lt.n0 .or. jcolor_1(i).gt.n71)
     +          jcolor_1(i) = jcolor_2(i)
            if (kcolor_1(i).lt.n0 .or. kcolor_1(i).gt.n71)
     +          kcolor_1(i) = kcolor_2(i)
            if (l_1(i).lt.n1 .or. l_1(i).gt.n8) l_1(i) = l_2(i)
            if (m_1(i).lt.n1 .or. m_1(i).gt.n37) m_1(i) = m_2(i)
            if (size_1(i).lt.s_lower .or.
     +          size_1(i).gt.s_upper) size_1(i) = size_2(i)
            if (thick_1(i).lt.t_lower .or.
     +          thick_1(i).gt.t_upper) thick_1(i) = thick_2(i)           
            
            jcolor_sav(i) = jcolor_1(i)
            kcolor_sav(i) = kcolor_1(i)
            l_sav(i) = l_1(i)
            m_sav(i) = m_1(i)
            sizes_sav(i) = size_1(i)
            thick_sav(i) = thick_1(i)
         enddo
         write (feature,1000)
         write (ctype,2000)
         write (ltype,3000)
         write (stype,4000)
         call use_windows95_font@()
         call w_syspar (i, 'f')
         size1 = scale1*dble(i)/100.0d+00
         size2 = scale2*dble(i)/100.0d+00
         i = winio@('%`sf%ts&', size1)
         i = winio@('%ca[Simfit: plot colours,lines,symbols]&')
         i = winio@('%sy[no_sysmenu]&')
         i = winio@('%bg[grey]&')

         i = winio@('%ob[named_l,scored][Plot colour]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%il&', n0, n71)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%2rd&', kcolor_1(i))
            j = winio@(feature(i)//'&')
            j = winio@('%cb&')
         enddo
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Data colour]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%il&', n0, n71)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%2rd&', jcolor_1(i))
            j = winio@('%cb&')
         enddo
         i = winio@('%cb&')

         j = winio@('%ob[named_l, scored][Options]&')
         do i = n1, n19
            j = winio@(ctype(i)//'&')
            j = winio@('%nl&')
         enddo
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Lines]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%il&', n1, n8)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%2rd&', l_1(i))
            j = winio@('%cb&')
         enddo
         i = winio@('%cb&')

         j = winio@('%ob[named_l,scored][Options]&')
         do i = n1, n8
            j = winio@(ltype(i)//'&')
            j = winio@('%nl&')
         enddo
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Thickness]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%fl&', t_lower, t_upper)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%4rf&', thick_1(i))
            j = winio@('%cb&')
         enddo
         i = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Symbols]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%il&', n1, n37)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%2rd&', m_1(i))
            j = winio@('%cb&')
         enddo
         i = winio@('%cb&')

         j = winio@('%ob[named_l,scored][Options]&')
         do i = n1, n24
            j = winio@(stype(i)//'&')
            j = winio@('%nl&')
         enddo
         j = winio@('%cb&')

         i = winio@('%ob[named_l,scored][Size]&')
         i = winio@('%1.20ob[invisible]&')
         do i = n1, nmax
            j = winio@('%`bg[white]&')
            j = winio@('%fl&', s_lower, s_upper)
            j = winio@('%co[check_on_focus_loss]&')
            j = winio@('%4rf&', size_1(i))
            j = winio@('%cb&')
         enddo
         i = winio@('%cb&')

         j = winio@('%`sf%ts&', size2)
c         
c         j = winio@('%^6bt[Apply]%nl  %nl%^6bt[Cancel]
c*****+%nl  %nl%^6bt[Help]%nl  %nl%^6bt[Defaults]',
c     +              'EXIT',
c     +              i_cancel_symbol_editing,
c     +              i_tell_about_symbol_defaults,
c     +              i_restore_symbol_defaults)
c
         j=winio@('%^6bt[Apply]&', 'EXIT')
         j=winio@('%nl  %nl%^6bt[Cancel]&', i_cancel_symbol_editing)
         j=winio@('%nl  %nl%^6bt[Help]&', i_tell_about_symbol_defaults)
         j=winio@('%nl  %nl%^6bt[Defaults]', i_restore_symbol_defaults)
         if (cancel_symbol) then
            do i = n1, nmax
               jcolor_1(i) = jcolor_sav(i)
               kcolor_1(i) = kcolor_sav(i) 
               l_1(i) = l_sav(i) 
               m_1(i) = m_sav(i) 
               size_1(i) = sizes_sav(i) 
               thick_1(i) = thick_sav(i) 
            enddo
         endif   
      elseif (isend.eq.n3) then
c
c isend = 3: over-ride current values by built-in defaults then write w_symbol.cfg
c ==========
c
         do i = n1, nmax
            jcolor_1(i) = jcolor_2(i)
            kcolor_1(i) = kcolor_2(i)
            l_1(i) = l_2(i)
            m_1(i) = m_2(i)
            size_1(i) = size_2(i)
            thick_1(i) = thick_2(i)
         enddo
         if (kcolor_1(8).eq.n0) kcolor_1(8) = kcolor_2(8)
         do i = n1, nmax 
            jcolor(i) = jcolor_1(i)
            kcolor(i) = kcolor_1(i)
            l(i) = l_1(i)
            m(i) = m_1(i)
            sizes(i) = size_1(i)
            thick(i) = thick_1(i) 
         enddo   
      elseif (isend.eq.n4) then
c
c isend = 4: over-ride current values by the values supplied then write w_symbol.cfg
c ==========
c      
         do i = 1, nmax
            if (jcolor(i).ge.n0 .and. jcolor(i).le.n71)
     +          jcolor_1(i) = jcolor(i)
            if (kcolor(i).ge.n0 .and. kcolor(i).le.n71)
     +          kcolor_1(i) = kcolor(i)
            if (l(i).ge.n1 .and. l(i).le.n8) l_1(i) = l(i)
            if (m(i).ge.n1 .and. m(i).le.n37)  m_1(i) = m(i)
            if (sizes(i).ge.s_lower .and.
     +          sizes(i).le.s_upper) size_1(i) = sizes(i)
            if (thick(i).ge.t_lower .and.
     +          thick(i).le.t_upper) thick_1(i) = thick(i)
         enddo       
      endif
c
c---------------------------------------------------------
c special action required if w_symbol.cfg is not read-only
c---------------------------------------------------------
c
      if (.not.read_only) then
         if (isend.ne.n1) then
c
c check to make sure all colours, types and sizes are in range
c
            do i = n1, nmax
               if (jcolor_1(i).lt.n0 .or. jcolor_1(i).gt.n71)
     +             jcolor_1(i) = jcolor_2(i)
               if (kcolor_1(i).lt.n0 .or. kcolor_1(i).gt.n71)
     +             kcolor_1(i) = kcolor_2(i)
               if (l_1(i).lt.n1 .or. l_1(i).gt.n8) l_1(i) = l_2(i)
               if (m_1(i).lt.n1 .or. m_1(i).gt.n37) m_1(i) = m_2(i)
               if (size_1(i).lt.s_lower .or. size_1(i).gt.s_upper)
     +             size_1(i) = size_2(i) 
               if (thick_1(i).lt.t_lower .or. thick_1(i).gt.t_upper)
     +             thick_1(i) = thick_2(i)                 
            enddo
c
c make sure black background is not the default
c
            if (kcolor_1(8).eq.n0) kcolor_1(8) = kcolor_2(8)
c
c Create a new w_symbol.cfg file
c
            call w_getnou (nout)
            open (unit = nout, file = fname, iostat = ios)
            if (ios.eq.n0) write (nout,400,iostat=ios) pcent, ntype
            do i = n1, nmax
               write (nout,'(3i4,f6.2,i4,f6.2)',iostat=ios)
     +                       kcolor_1(i), jcolor_1(i),
     +                       l_1(i), thick_1(i),
     +                       m_1(i), size_1(i) 
               if (ios.ne.0) exit      
            enddo
            if (ios.eq.0) write (nout,500,iostat=ios)
            close (unit = nout)
         endif
      endif
      if (isend.eq.n2) then
c
c isend = 2: make sure sensible arguments are returned
c ==========
c
         if (kcolor_1(8).eq.n0) kcolor_1(8) = kcolor_2(8)
         do i = n1, nmax
            jcolor(i) = jcolor_1(i)
            kcolor(i) = kcolor_1(i)
            l(i) = l_1(i)
            m(i) = m_1(i)
            sizes(i) = size_1(i)
            thick(i) = thick_1(i)
         enddo
      endif
c
c format statements
c      
  100 format (
     +'ISEND out of range in call to W_SYMBOL')
  200 format (
     +'w_symbol.cfg is read_only ... use attrib -r w_symbol.cfg')
c  300 format (
c     +'Cannot find w_symbol.cfg ... Simfit will create a default')
  400 format (
     +'Simfit colours/line/thickness/symbol/size file: type',1x,a1,i3)
  500 format (
     + 'Line 1 defines the version number, then'
     +/'Column 1 = colour for features'
     +/'Column 2 = colour for lines and symbols'
     +/'Column 3 = line type'
     +/'Column 4 = line thickness'
     +/'Column 5 = symbol type'
     +/'Column 6 = symbol size')
c
c format statements
c
 1000 format (
     + ' Main Title'
     +/' Plot axes'
     +/' Labels'
     +/' Legends'
     +/' Panel'
     +/' Border'
     +/' Graticule'
     +/' Background'
     +/' Extra title'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved'
     +/' Reserved')
 2000 format (
     + '0 = black'
     +/'1 = blue',
     +/'2 = green'
     +/'3 = cyan'
     +/'4 = red'
     +/'5 = magenta'
     +/'6 = brown'
     +/'7 = light grey'
     +/'8 = grey'
     +/'9 = light blue'
     +/'10 = light green'
     +/'11 = light cyan'
     +/'12 = light red'
     +/'13 = light magenta'
     +/'14 = yellow'
     +/'15 = bright white'
     +/'16 = etc.'
     +/'.........'
     +/'71 = etc.' )
 3000 format (
     + '1 = solid'
     +/'2 = dashed'
     +/'3 = dotted'
     +/'4 = dash-dot'
     +/'5 = vector >>>'
     +/'6 = vector <<<'
     +/'7 = step (pdf)'
     +/'8 = step (survive)')
 4000 format (
     + '1 = dot'
     +/'2 = plus'
     +/'3 = cross'
     +/'4 = asterisk'
     +/'5 = circle'
     +/'6 = half circle'
     +/'7 = full circle'
     +/'8 = triangle'
     +/'9 = half triangle'
     +/'10 = full triangle'
     +/'11 = square'
     +/'12 = half square'
     +/'13 = full square'
     +/'14 = diamond'
     +/'15 = half diamond'
     +/'16 = full diamond'
     +/'17 = minus sign'
     +/'18 = male'
     +/'19 = female'
     +/'...'
     +/'34 = inverted-triangle'
     +/'35 = half inverted triangle'
     +/'36 = full inverted triangle'
     +/'37 = outline inverted triangle')
      end
c
c
      recursive integer function i_restore_symbol_defaults()
      use module_symbols
      implicit   none
      include   <windows.ins>
c
c nmax must equal nmax in module_symbols
c
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 1, numdec = 1,
     +           numopt = 8, nstart = 3, ntext = numopt + 2)
      integer    numpos(numopt), numbld(ntext)
      integer    i
      character  text(ntext)*100
      logical    fixed, full, high
      parameter (fixed = .false., full = .false., high = .true.)
      data       numbld / 1, 0, -100, -100, -200, -200, 0, 0, 0, 0 /
      data       numpos / 1, 0, 1, 0, 1, 1, 1, 1 /
      external   w_rbox01
      save       numpos
      i_restore_symbol_defaults = 1
      write (text,100)
      call w_rbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +               numpos, nstart, ntext,
     +               text,
     +               fixed, full, high)
      do i = 1, nmax
         if (numpos(1).eq.1) then
            kcolor_1(i) = kcolor_2(i)
         elseif (numpos(2).eq.1) then
            kcolor_1(i) = kcolor_3(i)
         endif
         if (numpos(3).eq.1) then
            jcolor_1(i) = jcolor_2(i)
         elseif (numpos(4).eq.1) then
            jcolor_1(i) = jcolor_3(i)
         endif
         if (numpos(5).eq.1) then
            l_1(i) = l_2(i)
         endif
         if (numpos(6).eq.1) then
            m_1(i) = m_2(i)
         endif
         if (numpos(7).eq.1) then
            thick_1(i) = thick_2(i)
         endif
         if (numpos(8).eq.1) then
            size_1(i) = size_2(i)
         endif
      enddo
      if (numpos(1).eq.1 .or. numpos(2).eq.1) then
         call window_update@(kcolor_1)
      endif
      if (numpos(3).eq.1 .or. numpos(4).eq.1) then
         call window_update@(jcolor_1)
      endif
      if (numpos(5).eq.1) then
         call window_update@(l_1)
      endif
      if (numpos(6).eq.1) then
         call window_update@(m_1)
      endif
      if (numpos(7).eq.1) then
         call window_update@(thick_1)
      endif
      if (numpos(8).eq.1) then
         call window_update@(size_1)
      endif
c
c format statement
c      
  100 format (
     + 'Tick to restore defaults required'
     +/'...'
     +/'Features in colour'
     +/'Features in monochrome'
     +/'Lines/symbols in colour'
     +/'Lines/symbols in monochrome'
     +/'Line types'
     +/'Symbol types'
     +/'Line thickness'
     +/'Symbol size')
      end
c
c
      recursive integer function i_tell_about_symbol_defaults()
      implicit   none
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 21)
      integer    numbld(numtxt)
      character  text(numtxt)*100
      logical    border
      parameter (border = .false.)
      external   w_patch1
      data       numbld / numtxt*0 /
      write (text,100)
      numbld(1) = 1
      call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +               text,
     +               border)
      i_tell_about_symbol_defaults = 2
  100 format (
     + 'Colours, line-type/thickness, and symbol-type/size'
     +/
     +/'Each data set plotted has a colour, line-type, line-thickness,'
     +/'symbol-type, and symbol-size. Also, every feature, such as the'
     +/'title, legends, axes, etc. has an associated size and colour.'
     +/
     +/'You can select appropriate colours, line-, and symbol-types as'
     +/'required using the [Data] and [Colours] options interactively'
     +/'from the Simplot main control (when the choices will be saved).'
     +/'However, as this is tedious, there are three other mechanisms'
     +/'that can be used to initialise defaults.'
     +/'1)`This control can be used to set up your own defaults.'
     +/'2)`If you do not know what defaults to use, press the [Default]'
     +/'  `button to restore Simfit defaults in colour or monochrome.'
     +/'3)`Experienced users will use the configuration option from the'
     +/'  `main Simplot menu to store configuration files as templates,'
     +/'  `or read in stored templates to over-ride the defaults.'
     +/
     +/'Note that only values for the first 20 files can be configured'
     +/'from this control, whereas there is no limit to the number'
     +/'that can be configured from a configuration file.')
      end
c
c
      recursive integer function i_cancel_symbol_editing()
      use module_symbols
      implicit none
      i_cancel_symbol_editing = 0
      cancel_symbol = .true.
      end
c
c      

