c
c
      subroutine w_syspar (i,
     +                     c)
c
c action : get win32 system parameters
c author : w.g.bardsley, university of manchester, u.k., 22/02/97
c          22/10/1999 added c = h
c          01/12/2000 added c = w
c          06/02/2002 redefined effect of f or F and added first, pcent
c                     and c = s
c          28/09/2002 introduced method and high/low word technique for h and w 
c          05/02/2007 edited for w_clearwin.dll
c          29/11/2007 altered to always return i = 100 for c = 'f'
c          12/12/2007 restored font size scaling for c = 'f' but with no 1024 correction
c          15/01/2011 added call to x_sim256 
c
c advice : scheme as follows:-
c          ===================
c          first time read kpcent off w_simfit.cfg
c          c = i or I then i = appropriate value for iscale as in
c                              k = winio@('%sp&', iscale*ix, iscale*iy)
c                              8 is empirical and could be font width 9
c          c = x or X then i = screen width in pixels
c          c = y or Y then i = screen height in pixels
c          c = f or F then i = percentage correction for text size so that
c                              users can configure the size of controls
c          c = s or S then i = kpcent stored from i
c          c = h or H then i = text height
c          c = w or W then i = text width
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (inout) :: i 
      character (len = *), intent (in)    :: c 
c
c locals
c      
      integer (kind = 7) ibig 
      integer    i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13
      integer    ios, nout
      integer    iword, jbot, jmid, jtop, kpcent
      parameter (iword = 2**16, jbot = 50, jtop = 200)
      double precision factor, xtemp
      double precision f8, f1024
      parameter (f8 = 8.0d+00, f1024 = 1024.0d+00)
      parameter (factor = f8/f1024)
      character  family*72, word6*6
      character  fname*1024, x_sim256*1024
      logical    first, there
      logical    method(2)
      external   x_putfat, w_getnou, x_sim256
      intrinsic  dble, nint, mod
      save       first, kpcent
      data       kpcent / 100 /
      data       first / .true. /
      data       method / .false., .false. /
c
c initialise pcent from w_simfit.cfg first time round
c
      fname = x_sim256('w_simfit.cfg')
      if (first) then
         first = .false.
         inquire (file = fname, exist = there)
         if (there) then
            call w_getnou (nout)
            open (unit = nout, file = fname, iostat=ios)
            if (ios.eq.0) then
               do i = 1, 11
                  if (ios.eq.0) read (nout,'(a)',iostat=ios) word6
               enddo
            endif
            close (unit = nout)
            if (ios.eq.0) then
               read (word6,'(i6)',iostat=ios) jmid
               if (ios.eq.0) then
                 if (jmid.ge.jbot .and. jmid.le.jtop) kpcent = jmid
               endif
            endif
         endif
      endif

c
c subsequent action depends on c
c
      if (c.eq.'i' .or. c.eq.'I') then
c
c iscale .... 8 pixels in 1024 for use by %sp
c
         i = GetSystemMetrics(SM_CXSCREEN)
         xtemp = dble(i)*factor
         i = nint(xtemp)
      elseif (c.eq.'x' .or. c.eq.'X') then
c
c xres ... screen width in pixels
c
         i = GetSystemMetrics(SM_CXSCREEN)
      elseif (c.eq.'y' .or. c.eq.'Y') then
c
c yres ... screen height in pixels
c
         i = GetSystemMetrics(SM_CYSCREEN)
      elseif (c.eq.'f' .or. c.eq.'F') then
c
c font ... used to correct for screen with respect to 1024 (now returned as font%)
c
         i = kpcent
      elseif (c.eq.'h' .or. c.eq.'H') then
c
c height of system font (lfHeight)
c
          if (method(1)) then
             call get_system_font@(i1, i2, i3, i4, i5, i6, i7, i8, i9,
     +                             i10, i11, i12, i13, family)
             i = i1
          elseif (method(2)) then
             ibig = clearwin_info@('SYSTEM_FONT_HEIGHT')
             i = ibig
          else
             i = GetDialogBaseUnits()/iword
          endif
      elseif (c.eq.'s' .or. c.eq.'S') then
c
c store kpcent
c
          if (i.ge.jbot .and. i.le.jtop) kpcent = i
      elseif (c.eq.'w' .or. c.eq.'W') then
c
c width of system font (lfWidth)
c
         if (method(1)) then
            call get_system_font@(i1, i2, i3, i4, i5, i6, i7, i8, i9,
     +                            i10, i11, i12, i13, family)
            i = i2
c
c SYSTEM_FONT_WIDTH is unknown to clearwin
c         elseif (method(2)) then
c            i = clearwin_info@('SYSTEM_FONT_WIDTH')
         else
            i = mod(GetDialogBaseUnits(),iword)
         endif
      else
         i = 0
         call x_putfat ('Illegal argument in call to w_syspar')
      endif
      end
c
c
