c
c
      subroutine w_system (path, pname_in,
     +                     there)
c
c action: confirm or try to find a path to a named system file
c author: w.g.bardsley, university of manchester, u.k., 23/02/2002
c         30/07/2002 derived from w_pathto by eliminating w_findfl
c         05/02/2007 edited for w_clearwin.dll
c         23/05/2008 added call to curdir@
c         15/01/2009 added tests with explicit c:\
c         04/08/2010 new version calling w_getenv and w_findfl but using rather 
c                    repetitive code for ghostscript, gsview, and Acrobat to
c                    allow for future developments, e.g. 64 bit versions and
c                    possibly new filenames
c         29/09/2010 added undef to redefine path on failure
c         25/01/2011 added calls to w_v7path and allowed for possible 64 bit versions
c         01/05/2011 added calls to w_fpath2
c         10/08/2015 added iostat, added bslash to folder names and calls to w_pathid
c         11/04/2017 added code for Artifex version of gsview  
c         13/05/2017 added code for SumatraPDF including using pname_in to define pname 
c         15/07/2017 used logical function use_gsdll() to check for ghostscript dll  
c         27/07/2017 added check for acrobat.exe after searching from ...\Adobe and
c                    added direct search for acrobat 
c         06/11/2022 added pdfrdr
c         08/11/2022 added epsrdr
c         12/11/2022 use epsrdr for ghostscript     
c
c         path = on entry may be a fully qualified path/filename like
c                c:\windows\notepad.exe and this may or may not exist.
c                The subroutine confirms the path supplied or tries to
c                return an existing fully qualified path/filename
c                On failure returns ***Undefined
c         pname = default filename, e.g. Notepad.exe
c         there : if true then path exists o/w path was not found
c
c programs: Notepad.exe
c           Clipbrd.exe
c           Explorer.exe
c           Calc.exe
c           GSwin32c.exe
c           GSwin64c.exe
c           GSview32.exe
c           GSview64.exe
c           Acrord32.exe 
c           Acrord64.exe 
c           Acrobat.exe
c           SumatraPDF.exe
c
      implicit   none
c
c arguments
c      
      character (len = *), intent (in)    :: pname_in  
      character (len = *), intent (inout) :: path 
      logical,             intent (out)   :: there
c
c locals
c
      integer    ios
      integer    l_pf32, l_pf64, l_s32, l_win
      character (len = 1024) pf32, pf64, s32, win
      character (len = 1024) temp, w_fpath2
      character (len = 20  ) pname
      character (len = 14  ) word14
      character (len = 12  ) word12, undef
      parameter (undef = '***Undefined')
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical    bit_64, first
      external   x_lcase1,  w_v7path, w_fpath2, 
     +           pdfrdr, epsrdr
      intrinsic  index, len_trim
      save       l_pf32, l_pf64, l_s32, l_win
      save       pf32, pf64, s32, win
      save       bit_64, first
      data       bit_64, first / .false., .true. /
      data       l_pf32, l_pf64, l_s32, l_win / 0, 0, 0, 0 /
      data       pf32, pf64, s32, win / blank , blank, blank, blank /
c
c define pname
c      
      pname = blank
      ios = len_trim(pname_in)
      pname(1:ios) = pname_in(1:ios)
c
c try the path supplied and return if it is OK
c
      inquire (file = path, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
         temp = w_fpath2(path)
         path = temp
         return      
      endif 
      inquire (file = pname, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
         temp = w_fpath2(pname)
         path = temp
         return      
      endif     
c
c first time round find the system path and program files path
c     
      if (first) then
         first = .false.
         
         call w_v7path (l_pf32,
     +                  'p32', pf32)
         if (pf32(l_pf32:l_pf32).ne.bslash) then
            l_pf32 = l_pf32 + 1
            pf32(l_pf32:l_pf32) = bslash
         endif
            
         call w_v7path (l_pf64,
     +                  'p64', pf64)
         if (pf64(l_pf64:l_pf64).ne.bslash) then
            l_pf64 = l_pf64 + 1
            pf64(l_pf64:l_pf64) = bslash
         endif
     
         call w_v7path (l_s32,
     +                  's32', s32)
         if (s32(l_s32:l_s32).ne.bslash) then
            l_s32 = l_s32 + 1
            s32(l_s32:l_s32) = bslash
         endif
     
         call w_v7path (l_win,
     +                  'win', win) 
         if (win(l_win:l_win).ne.bslash) then
            l_win = l_win + 1
            win(l_win:l_win) = bslash
         endif 
     
         if (l_pf32.gt.l_pf64) then
            bit_64 = .true.
         else
            bit_64 = .false.
         endif 
              
      endif            
c
c check for system files if appropriate
c
      word12 = pname(1:12)
      call x_lcase1 (word12)
      word14 = pname(1:14)
      call x_lcase1 (word14)
      if (word12.eq.'notepad.exe ' .or. 
     +    word12.eq.'explorer.exe' .or. word12.eq.'calc.exe    ') then
c
c try the windows folder
c           
         path = win(1:l_win)//pname
         inquire (file = path, exist = there, iostat = ios) 
         if (ios.eq.0 .and. there) return     
c
c try the System folder
c
         path = s32(1:l_s32)//pname
         inquire (file = path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) return
c
c try the simfit binaries
c           
         path = pf32(1:l_pf32)//'Simfit\bin\'//pname 
         inquire (file = path, exist = there, iostat = ios) 
         if (ios.eq.0 .and. there) return
         if (bit_64) then
            path = pf64(1:l_pf64)//'Simfit\bin\'//pname 
            inquire (file = path, exist = there, iostat = ios) 
            if (ios.eq.0 .and. there) return
         endif    
c
c try the simdem binaries
c            
         path = pf32(1:l_pf32)//'Simdem\bin\'//pname 
         inquire (file = path, exist = there, iostat = ios) 
         if (ios.eq.0 .and. there) return  
         if (bit_64) then
            path = pf64(1:l_pf64)//'Simdem\bin\'//pname 
            inquire (file = path, exist = there, iostat = ios) 
         endif    
         if (ios.eq.0 .and. there) then
            return
         else   
            path = undef
         endif  
      elseif (word12.eq.'gsview.exe  ') then
c
c gsview  
c     
         call epsrdr (path)
         there = .true.
         return
      elseif (word12.eq.'gsview32.exe' .or.
     +        word12.eq.'gsview64.exe') then
c
c gsview32 and gsview64  
c     
         call epsrdr (path)
         there = .true.
         return
      elseif (word12.eq.'gswin32c.exe' .or.
     +        word12.eq.'gswin64c.exe') then
c
c ghostscript  
c     
         call epsrdr (path)
         there = .true.
         return
      elseif (word12.eq.'acrord32.exe' .or.
     +        word12.eq.'acrord64.exe' .or.
     +        word12.eq.'acrobat.exe ' .or.
     +        word12.eq.'pdfreader   ' .or.
     +        word14.eq.'sumatrapdf.exe') then
              there = .true.
              call pdfrdr (path)
              return
      endif

      end
c
c




