c
c----------------------------------------------------------------------
c
      subroutine w_table1 (icolor,
     +                     line)
c
c action: replacement for w_table1
c author: w.g.bardsley, university of manchester, u.k.
c         12/04/2010 developed from ideas and code kindly supplied by 
c                    Paul Laidler of Silverfrost Software
c         24/06/2010 replaced call to w_config by call to x_getcfg
c         26/04/2016 increased width from 85 to 90 characters
c         31/07/2017 added Stop to menu using the call back i_stop_this_program 
c         27/09/2017 added limit_height  
c         18/02/2021 increased table width n from 90 to 110 (line 130)
c         03/04/2024 introduced x_ucase1, x_triml1 and line_copy 
c
c     icolor: VGA colour for text string
c       line: text string
c     
c     kmax = maximum line width
c     nmax = maximum number of rows
c
      implicit none
      include <clearwin.ins>
c
c arguments
c      
      integer,             intent (in) :: icolor
      character (len = *), intent (in) :: line 
c
c locals
c
      integer    n, m
      integer    i, iscale, it, j, k, kval, nval(12)
      integer    i_close_table1, i_table1_cb
      integer    i_call_x_switch, i_stop_this_program
      integer    ctrl
      integer    icount
      integer   (kind = 7) i0
      parameter (i0 = 0)
      integer    ix, iy, kmax, kmm2, mode, nmax
      parameter (ix = 1, iy = 1, kmax = 1024, kmm2 = kmax - 2, mode = 0,
     +           nmax = 100000)
      integer    back_colour, text_colour(nmax)
      integer    w_vgacol
      double precision height
      parameter (height = 0.8+00)
      double precision correction, percent, size_1, size1
      parameter (percent = 100.0d+00, size_1 = 1.0d+00)
      character  caption*80, c10*1, c13*1, text*(kmax)
      character  cval(12)*1024, line_copy*250, word4*4, word5*5
      character  blank*1
      parameter (blank = ' ')
      logical    first
      external   x_triml1, x_ucase1
      external   i_call_x_switch, i_stop_this_program
      external   i_table1_cb, table1_insert_string
      external   x_getcfg, w_syspar, w_reslib
      external   w_vgacol, i_close_table1
      intrinsic  char, leng, dble, len_trim
      common   / table1_colours / back_colour, text_colour
      common   / table1_control / ctrl
      save       c10, c13
      save       icount
      save       first
      data       icount / -1 /
      data       first  / .true. /
      

c
c if first time called then initialise back_colour, text_colour, c10, and c13
c      
      if (first) then
         first = .false.
         back_colour = w_vgacol(15)
         it = w_vgacol(0)
         do i = 1, nmax
            text_colour(i) = it
         enddo
         c10 = char(10)
         c13 = char(13) 
      endif  
c
c start of over-the-top code to check for 'OPEN' or 'CLOSE' 03/04/2024
c      
      word4 = blank
      word5 = blank 
      line_copy = blank
      j = len_trim(line)
      line_copy(1:j) = line(1:j)
      call x_triml1 (line_copy)
      j = len_trim(line_copy)
      if (j.eq.4) then
         word4 = line_copy(1:4) 
         call x_ucase1(word4)
      elseif (j.eq.5) then   
         word5 = line_copy(1:5)
         call x_ucase1(word5)
      endif   
c
c end checking for 'OPEN' or 'CLOSE'
c      

      
      if (word4.eq.'OPEN') then
c
c -----------------------
c line = 'OPEN' or 'open': first check if a window has already been opened, if not then open the window
c -----------------------
c
         
         if (icount.ge.0) return
c
c open the window and define  back_colour, and icount 
c        
         
         back_colour = w_vgacol(icolor)
         icount = 0
c
c get kval as the the maximum number of lines per display when the table is first opened
c        
         call x_getcfg (mode, nval,
     +                  cval)
         kval = nval(12)
         write (caption,100) kval         
         call w_syspar (i, 'f')
         correction = dble(i)/percent
         size1 = correction*size_1
         call w_syspar (iscale, 'i')  
c
c*********************************************** 
c start of Clearwin+ code to define the window *
c***********************************************
c                  
         i = winio@('%sp&', iscale*ix, iscale*iy)
         i = winio@('%ca@&', caption)
         call w_reslib 
c         
c call use_all_dll_resources@!!!NO causes ambiguity between w_clearwin.dll and x64_clearwin.dll
c
         i = winio@('%mi[icon_1]&')
         i = winio@('%mn[&Edit[&Copy        Ctrl+C,
     +                         &Select All  Ctrl+A]]&', 
     +                         'copy', 'select_all')
         i = winio@('%mn[Stop]&', i_stop_this_program)
         i = winio@('%mn[Speedup]&', i_call_x_switch)
         i = winio@('%ww[thin_border, topmost, no_minbox]&')
         i = winio@('%ac[Ctrl+C]&', 'copy')
         i = winio@('%ac[Ctrl+A]&', 'select_all')
         i = winio@('%cc&', i_close_table1)
         i = winio@('%fn[Courier New]&')
         i = winio@('%ts&', size1)
         i = winio@('%bg&', back_colour)
         n = 110
         m = kval
         i = winio@('%pv%^*.*eb[hscrollbar,
     +vscrollbar, read_only, user_colours, no_border, limit_height]&',
     +n, m, ccore1(i0), 0, height, i_table1_cb)
         i = winio@('%lw', ctrl)
c
c*********************************************
c end of Clearwin+ code to define the window *
c*********************************************
c         
      elseif (word5.eq.'CLOSE') then 
c
c ---------------------------------
c line = 'CLOSE' or line = 'close': first check if the window has already been closed, if not close the window
c ---------------------------------
c      
         if (icount.lt.0) then
            return
         elseif (icount.eq.0) then
            icount = -1
            ctrl = 0
            call window_update@(ctrl)
         else      
c
c close the window as a window has been opened (icount >=0)
c

            call edit_move_tof@(core4(i0))
            
            do while (ctrl.ne.0)
               call temporary_yield@()
            enddo 
            icount = -1  
         endif
      else
c
c ----------------------------------------
c line .ne. 'OPEN'/'open'/'CLOSE'/'close': first check if the window has already been opened, if so add a line
c ----------------------------------------
c        
         if (icount.lt.0) return
c
c write to the widow if a window has been opened (0 =< icount < nmax)
c     
         if (icount.lt.nmax) then
            text = line
            k = leng(text) 
            if (k.lt.kmm2) then
               k = k + 1
               text(k:k) = c13
               k = k + 1
               text(k:k) = c10
               it = w_vgacol(icolor)
               icount = icount + 1 
               call table1_insert_string(icount, it,
     +                                   text(1:k))
            endif
         endif  
      endif
  100 format (
     +'Simfit table: current configuration option =<',i3,' rows')        
      end
c
c----------------------------------------------------------------------
c
      subroutine table1_insert_string (n, textColour, 
     +                                 line)
      implicit none
      include <clearwin.ins>
c
c arguments
c      
      integer,             intent (in) :: n
      integer,             intent (in) :: textColour
      character (len = *), intent (in) :: line
c
c locals
c      
      integer    nmax
      parameter (nmax = 100000)
      integer   (kind = 7) i0
      parameter (i0 = 0)
      integer    back_colour, text_colour(nmax)
      common   / table1_colours / back_colour, text_colour
      call INSERT_EDIT_STRING@(core4(i0), line) 
      text_colour(n) = textColour
      end

      recursive integer function i_table1_cb()
      implicit none
      include <clearwin.ins>
      integer    nmax
      parameter (nmax = 100000)
      integer    back_colour, text_colour(nmax)
      integer    n
      character (len = 256) clearwin_string@!added  by w.g.b. 13/01/2020 
      common   / table1_colours / back_colour, text_colour 
      C_EXTERNAL set_line_colours@ '__set_line_colours'(VAL,VAL)
      C_EXTERNAL set_word_colours@ '__set_word_colours'(VAL,VAL,VAL,VAL)
      C_EXTERNAL edit_info@ '__edit_info'(VAL):INTEGER
      i_table1_cb = 2
      if (clearwin_string@("CALLBACK_REASON") == "COLOURING") then
         if (edit_info@(9) > 0) return
         n = edit_info@(10)
         call set_line_colours@(text_colour(n), back_colour)
      endif  
      end
c
c
      recursive integer function i_close_table1()
      implicit none
      integer  ctrl
      common / table1_control / ctrl
      i_close_table1 = 0
      ctrl = 0
      call window_update@(ctrl)
      end      
c
c
