c
c----------------------------------------------------------------------
c
      subroutine w_table2 (icolor,
     +                     line)
c
c action: replacement for the original w_table2
c author: w.g.bardsley, university of manchester, u.k.
c         12/04/2010 developed from ideas and code kindly supplied by 
c                    Paul Laidler of Silverfrost Software
c         24/06/2010 replaced call to w_config by call to x_getcfg 
c         26/04/2016 increased width from 85 to 90 characters
c         03/08/2017 added i_stop_this_program
c         27/09/2017 added limit_height 
c         18/02/2021 increased table width n from 90 to 110 (line 121)
c         03/04/2024 introduced line_copy, word4, word5, x_ucase1, and and x_triml1
c
c     icolor: VGA colours for text string
c       line: text string
c   
c kmax = maximum line width
c nmax = maximum number of rows
c
c   
      implicit none
      include <clearwin.ins>
c
c arguments
c      
      integer,             intent (in) :: icolor(*)
      character (len = *), intent (in) :: line 
c
c locals
c      
      integer    n, m
      integer    i_stop_this_program
      integer    i, iscale, j, kval, nval(12)
      integer    it 
      integer    icount
      integer    ctrl
      integer    i_call_x_switch, i_close_table2, i_table2_cb
      integer   (kind = 7) i0
      parameter (i0 = 0)
      integer    ix, iy, kmax, kmm2, mode, nmax
      parameter (ix = 1, iy = 1, kmax = 1024, kmm2 = kmax - 2, mode = 0, 
     +           nmax = 5000)
      integer    jcolor(nmax,kmax), k(nmax)
      integer    back_colour, text_colour(nmax)
      integer    w_vgacol
      double precision height
      parameter (height = 0.8d+00)
      double precision correction, percent, size_1, size1
      parameter (percent = 100.0d+00, size_1 = 1.0d+00)      
      character  text*(kmax)
      character  c10*1, c13*1, word4*4, word5*5
      character  caption*80, cval(12)*1024, line_copy*250
      character  blank*1
      parameter (blank = ' ')
      logical    first
      external   x_triml1, x_ucase1 
      external   i_table2_cb, table2_insert_string, i_close_table2
      external   w_vgacol, x_getcfg, w_syspar, w_reslib
      external   i_call_x_switch, i_stop_this_program
      intrinsic  char, dble, leng
      common   / table2_colour1 / back_colour, text_colour
      common   / table2_colour2 / it, jcolor, k
      common   / table2_control / ctrl
      save       icount
      save       first
      save       c10, c13
      data       icount / -1 /
      data       first / .true. /

      if (first) then
         first = .false.
         back_colour = w_vgacol(15)
         it = w_vgacol(0)
         do j = 1, kmax
            do i = 1, nmax
               jcolor(i,j) = it
            enddo   
         enddo
         c10 = char(10)
         c13 = char(13)
      endif
c
c start of over-the-top code to check for 'OPEN' or 'CLOSE' 03/04/2024
c      
      word4 = blank
      word5 = blank 
      line_copy = blank
      j = len_trim(line)
      line_copy(1:j) = line(1:j)
      call x_triml1 (line_copy)
      j = len_trim(line_copy)
      if (j.eq.4) then
         word4 = line_copy(1:4) 
         call x_ucase1(word4)
      elseif (j.eq.5) then   
         word5 = line_copy(1:5)
         call x_ucase1(word5)
      endif   
c
c end checking for 'OPEN' or 'CLOSE'
c      

      
      if (word4.eq.'OPEN') then
c
c check if window is already opened
c        
      if (icount.ge.0) return
c
c open the window
c        
         icount = 0
         back_colour = w_vgacol(icolor(1))
         it = w_vgacol(0)
        
c
c get kval as the the maximum number of lines per display when the table is first opened
c        
         call x_getcfg (mode, nval,
     +                  cval)
         kval = nval(12)
         write (caption,100) kval         
         call w_syspar (i, 'f')
         correction = dble(i)/percent
         size1 = correction*size_1
         call w_syspar (iscale, 'i')           
         i = winio@('%sp&', iscale*ix, iscale*iy)
         i = winio@('%ca@&', caption)
         call w_reslib 
         i = winio@('%mi[icon_1]&')
         i = winio@('%mn[&Edit[&Copy        Ctrl+C,
     +                   &Select All  Ctrl+A]]&', 
     +                   'copy', 'select_all')
         i = winio@('%mn[Stop]&', i_stop_this_program)
         i = winio@('%mn[Speedup]&', i_call_x_switch)
         i = winio@('%ww[thin_border, topmost, no_minbox]&')
         i = winio@('%ac[Ctrl+C]&', 'copy')
         i = winio@('%ac[Ctrl+A]&', 'select_all')
         i = winio@('%cc&', i_close_table2)
         i = winio@('%fn[Courier New]&')
         i = winio@('%ts&', size1)
         i = winio@('%bg&', back_colour)
         n = 110
         m = kval
         i = winio@('%pv%^*.*eb[hscrollbar,
     +vscrollbar, read_only, user_colours, no_border, limit_height]&',
     +n, m, ccore1(i0), 0, height, i_table2_cb)     
         i = winio@('%lw', ctrl)
      elseif (word5.eq.'CLOSE') then 
c
c check that a window is open
c      
         if (icount.lt.0) then
            return
         elseif (icount.eq.0) then
            ctrl = 0
            call window_update@(ctrl)
            icount = -1
         else     
c
c close the window
c

            call edit_move_tof@(core4(i0))
                
            do while (ctrl.ne.0)
               call temporary_yield@()
            enddo  
            icount = -1
         endif   
      else
c
c check that a window is open
c      
         if (icount.lt.0) return        
c
c write to the widow
c     
c
        if (icount.lt.nmax) then
           text = line
           i = leng(text)
           if (i.lt.kmm2) then
              icount = icount + 1 
              k(icount) = i
              i = i + 1
              text(i:i) = c13
              i = i + 1
              text(i:i) = c10
              do i = 1, k(icount)
                 jcolor(icount,i) = w_vgacol(icolor(i))
              enddo
              call table2_insert_string (icount, it,
     +                                   text(1:k(icount) + 2))                      
            endif
         endif    
      endif 
  100 format (
     +'Simfit table: current configuration option =<',i3,' rows')        
      end
c
c----------------------------------------------------------------------
c

      subroutine table2_insert_string (n, textColour,
     +                                 line)
      include <clearwin.ins>
c
c arguments
c      
      integer,             intent (in) :: n
      integer,             intent (in) :: textColour
      character (len = *), intent (in) :: line
c
c locals
c      
      integer    nmax
      parameter (nmax = 5000)
      integer   (kind = 7) i0
      parameter (i0 = 0)
      integer    back_colour, text_colour(nmax)
      common / table2_colour1 / back_colour, text_colour
      call INSERT_EDIT_STRING@(core4(i0), line) 
      text_colour(n) = textColour
      end

      recursive integer function i_table2_cb()
      include <clearwin.ins>
      integer    i
      integer    kmax, nmax, n1
      parameter (kmax = 1024, nmax = 5000, n1 = 1)
      integer    it, jcolor(nmax,kmax), k(nmax)
      integer    back_colour, text_colour(nmax)
      integer    n, pos
      character (len = 256) clearwin_string@!added  by w.g.b. 13/01/2020 
      common / table2_colour1 / back_colour, text_colour
      common / table2_colour2 / it, jcolor, k
      C_EXTERNAL set_line_colours@ '__set_line_colours'(VAL,VAL)
      C_EXTERNAL set_word_colours@ '__set_word_colours'(VAL,VAL,VAL,VAL)
      C_EXTERNAL edit_info@ '__edit_info'(VAL):INTEGER
      i_table2_cb = 2
      if (clearwin_string@("CALLBACK_REASON") == "COLOURING") then
         if (edit_info@(9) > 0) return
         n = edit_info@(10)
         call set_line_colours@(text_colour(n), back_colour)
c
c attempt to colour any characters that differ from the default
c           
         do i = 1, k(n)
            if (jcolor(n,i).ne.it) then
               pos = i
               call set_word_colours@(jcolor(n,i), back_colour, pos, n1)
            endif   
         enddo
      endif  
      end
c
c
      recursive integer function i_close_table2()
      implicit   none
      integer    ctrl
      common   / table2_control / ctrl
      i_close_table2 = 0
      ctrl = 0
      call window_update@(ctrl)
      end
c
c
