c
c
      subroutine w_tbox01 (ixl, iyl, numbld, numdec, numopt, numsta,
     +                     numtxt,
     +                     text_in,
     +                     titles)
c
c action : put out a text plus menu with attributes onto a window
c          this is the main simfit list view selection routine
c          it creates a multicolumn list box based on %lv but differs from
c          w_lview1 only in that numbld is used for colouring
c author : w.g.bardsley, university of manchester, u.k.
c          04/12/2000 developed from w_lbox01 
c          08/02/2007 edited for w_clearwin.dll
c          30/05/2007 added allocatable array and call to w_dbleup
c          01/12/2007 new technique for calculated pixel settings
c
c          ixl    ... x coordinate of top left hand corner
c          iyl    ... y coordinate of top left hand corner
c          numbld ... colour for header and trailer
c          numdec ... number of the initial decision
c          numopt ... number of options available
c          numsta ... number of the line of text where the menu starts
c                     text(nstart - 1) MUST be the title line but this is
c                     only displayed if titles = .true.
c          numtxt ... number of lines of text (ntext >= numopt + 1)
c          text_in... text array (header, titles, menus and trailer)
c          titles ... .true. then use text(nstart - 1) as column headers
c                     .false. use text(nstart - 1) just to set column headers
c
c          text size is set by the parameters size_roman
c          menu size is set by size_msss
c          width of the control is set by the parameter wide
c
      implicit   none
      include   <windows.ins>  
c
c arguments
c      
      integer,             intent (in)    :: ixl, iyl, numopt, numsta,
     +                                       numtxt
      integer,             intent (inout) :: numdec
      integer,             intent (in)    :: numbld(numtxt)
      character (len = *), intent (in)    :: text_in(numtxt) 
      logical,             intent (in)    :: titles 
c
c local allocatable arrays
c
      character (len = 129), allocatable :: text(:)
      character (len = 100), allocatable :: items(:)
c
c locals
c      
      integer    ih, iview, iw, ix, iy, nhigh, nwide, number, nxmax,
     +           nymax
      integer    i, ierr, iscale, j, k, l, nbar1, nbar2, n_cancel
      integer    nstart, ntext 
      integer    x_len200, x_len300
      integer    n0, n1, n2, n3, n4, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n7 = 7)
      integer    nbig, nmax
      parameter (nbig = 35, nmax = 500)
      integer    isel(nmax)
      integer    ixyuse, ixy_use, mwtype, mw_type
      parameter (ixy_use = 1, mw_type = 4)
      integer    ipick, nitems_sel, numdec_sel
      integer    i_press_w_tbox01, i_select_w_tbox01
      double precision size_msss, size_roman
      double precision size_msss_1, size_roman_1
      parameter (size_msss_1 = 1.0d+00, size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabvar, tm_lead,
     +                 tm_space       
      parameter (factor = 1.0d+00, percent = 100.0d+00,
     +           tm_lead = 1.30d+00, tm_space = 0.90d+00)
      double precision three, four
      parameter (three = 3.0d+00, four = 4.0d+00)
      character (len = 129) line, w_dbleup
      character (len = 1  ) bar, grave
      parameter (bar = '|', grave = '`')
      logical    abort, cancel
      external   x_len200, x_len300, w_syspar, x_putfat, w_dbleup
      external   i_press_w_tbox01, i_select_w_tbox01
      intrinsic  len, dble, index, max, min, nint
      common / w_tbox01_variables / ipick, isel, nitems_sel, numdec_sel
c
c check numopt
c        
      if (numopt.gt.nmax) then
         call x_putfat ('NUMOPT too large in call to W_TBOX01')
         return
      endif   
c
c initialise variables in case a closure cross is necessary
c
      mwtype = mw_type
      ipick = n0
      n_cancel = n0
      numdec_sel = numdec
      cancel = .false. 
      nstart = numsta
      ntext = numtxt
c
c check the arguments supplied
c
      if (numopt.eq.n1) then
         numdec = n1
         return
      endif
      if (numopt.lt.n1 .or. numopt + n1.gt.ntext .or.
     +    nstart.lt.n2 .or. nstart + numopt - n1.gt.ntext) then
          call x_putfat (
     +'nstart/numopt/ntext inconsistent in call to w_tbox01')
          return
      endif
      abort = .false.
      nbar1 = n0
      nbar2 = n0
      do i = nstart - n1, nstart + numopt - n1
         if (.not.abort) then
            l = x_len200(text_in(i))
            nbar2 = n0
            do j = n1, l
               if (text_in(i)(j:j).eq.bar) nbar2 = nbar2 + n1
            enddo
            if (nbar2.lt.n1) abort = .true.
            if (.not.abort .and. i.ge.nstart) then
               if (nbar2.ne.nbar1) abort = .true.
            endif
            nbar1 = nbar2
         endif
      enddo
      if (abort) then
         call x_putfat (
     +'Inconsistent no. of column separators in call to w_tbox01')
         return
      endif
c
c set position
c             
      if (numopt.le.nbig .or. ixl.le.0 .or. iyl.le.0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif      
c
c allocate
c         
      ierr = n0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.n0) return  
      if (allocated(items)) deallocate(items, stat = ierr)
      if (ierr.ne.n0) return    
      allocate(text(ntext), stat = ierr)
      if (ierr.ne.n0) return
      allocate(items(ntext), stat = ierr)
      if (ierr.ne.n0) return  
      j = nstart + numopt - n1
      if (titles) then
         k = nstart - n1
      else
         k = nstart
      endif      
      do i = n1, ntext 
         if (i.lt.k .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else
            text(i) = text_in(i)
         endif      
      enddo
      if (numdec.lt.n1) numdec = n1
      if (numdec.gt.numopt) numdec = numopt
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1   
      if (ixyuse.eq.1) then
c
c use ixl, iyl and parameter iscale to position the window
c
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c swap the next lines for a normal window instead of a dialogue window
c ====================================================================
c
      if (mwtype.eq.n1) then
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost, independent]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost, independent]&')
         endif
      elseif (mwtype.eq.n2) then
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, no_sysmenu, 3d_thin]&')
         else
            k = winio@('%sy[thin_border, no_sysmenu, 3d_thin]&')
         endif
      elseif (mwtype.eq.n3) then
         if (ntext.le.numopt + n1) then
            k = winio@('%sy[no_border, 3d_thin]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
         endif
      elseif (mwtype.eq.n4) then
c
c check if 'Cancel' or 'Exit' or 'Quit' is an item and, if so, make it the default
c
         i = nstart - n1
         do while (i.lt.nstart + numopt - n1 .and. .not.cancel)
            i = i + n1
            if (index(text(i),'Cancel').gt.n0 .or.
     +          index(text(i),'Exit').gt.n0 .or.
     +          index(text(i),'Quit').gt.n0 .or.
     +          index(text(i),'Abandonar').gt.n0 .or.
     +          index(text(i),'Salir').gt.n0) then
               cancel = .true.
               n_cancel = i - nstart + n1
            endif
         enddo
         if (cancel) then
            if (ntext.le.numopt + n1) then
               k = winio@('%sy[no_border, 3d_thin]&')
            else
               k = winio@('%sy[thin_border, 3d_thin]&')
            endif
         else
            if (ntext.le.numopt + n1) then
               k = winio@('%sy[no_sysmenu, no_border, 3d_thin]&')
            else
               k = winio@('%sy[no_sysmenu, thin_border, 3d_thin]&')
            endif
         endif
      endif
      k = winio@('%ca[Simfit: options]&')
c
c put out the text strings up to the menu minus header
c
      if (nstart.gt.n2) then
         do i = n1, nstart - n2
            if (i.eq.1 .and. numbld(1).ne.0) then
               k = winio@('%`sf%bf&')
            elseif (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif
            k = winio@('%ts&', size_roman)
c
c set the text color depending on numbld(i)
c
            if (i.eq.1 .and. numbld(1).ne.0) then
               k = winio@('%tc[black]&')
            elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +              numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), grave)
            if (j.ge.n1) then
               l = x_len200(text(i))
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = '%ta'//text(i)(j + n1:l)//'&'
               k = winio@(line(n1:l - j + n4))
            else
               line = text(i)(n1:x_len200(text(i)))//'&'
               k = winio@(line)
            endif
            k = winio@('%nl&')
         enddo
      endif
c
c get the header and items
c
      do i = n1, numopt + n1
         items(i) = text(nstart + i - n2)(1:100)
      enddo
c
c make copies of numdec and numopt then initialise the selection
c
      nitems_sel = min(numopt, nmax)
      numdec_sel = min(numdec, nitems_sel)
      do i = n1, nitems_sel
         isel(i) = n0
      enddo
      isel(numdec_sel) = n1
      iview = n1
c
c get the screen dimensions and set upper limits for the dimensions
c
      call w_syspar (ix, 'x')
      nxmax = nint(three*dble(ix)/four)
      call w_syspar (iy, 'y')
      nymax = nint(three*dble(iy)/four)
c
c calculate nhigh using the font height but extra lines for scroll bars
c
      k = winio@('%`sf%ts&', size_msss)
      call w_syspar (ih, 'h')
      if (titles) then
         number = nitems_sel + n1
      else
         number = nitems_sel
      endif
      if (ix.ge.639 .and. ix.le.641) then
         nhigh = 18 + 14*(number + n1)
      else
c
c allow extra for spaces between lines
c
        ih = nint(correction*tm_lead*dble(ih))
        nhigh = ih*number
      endif
      if (nhigh.gt.nymax) nhigh = nymax
c
c calculate nwide, first the no. of characters
c
      number = n0
      do i = n1, ntext
         j = x_len300(text(i))
         if (j.gt.number) number = j
      enddo
c
c now scale up by the character width and check if within limits
c
      call w_syspar (iw, 'w')
      iw = nint(correction*tm_space*dble(iw))
      nwide = iw*number
      if (nwide.gt.nxmax) nwide = nxmax
c
c place the control centrally
c
      i = winio@('%cn&')
      if (titles) then
         i = winio@('%^lv[single_selection, show_selection_always,
     +              no_border, user_font, full_row_select,
     +              autosize_last_column]&',
     +              nwide, nhigh, items, nitems_sel + 1, isel, iview,
     +              i_select_w_tbox01)
      else
         i = winio@('%^lv[single_selection, show_selection_always,
     +              no_border, no_column_headers, user_font,
     +              full_row_select, autosize_last_column]&',
     +              nwide, nhigh, items, nitems_sel + 1, isel, iview,
     +              i_select_w_tbox01)
      endif
c
c put out the text strings after the end of the menu
c
      if (ntext.gt.nstart + numopt - n1) then
         k = winio@('%ff&')
         k = winio@('%`sf&')
         k = winio@('%ts&', size_roman)
         do i = nstart + numopt, ntext
            if (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif
            k = winio@('%ts&', size_roman)
c
c set the text color depending on numbld(i)
c
            if (i.eq.1 .and. numbld(1).ne.0) then
               k = winio@('%tc[black]&')
            elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +              numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
c
c does the line contain a tabbing character ` grave accent
c
            j = index(text(i), grave)
            if (j.ge.n1) then
               l = x_len200(text(i))
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = '%ta'//text(i)(j + n1:l)//'%nl&'
               k = winio@(line(n1:l - j + n7))
            else
               line = text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line)
            endif
         enddo
         k = winio@(' & ')
      endif
c
c close by button press
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%^`tt[&OK]&', i_press_w_tbox01)
      k = winio@('%nl &')
      k = winio@('%cb')
c
c assign and check numdec depending on cancel
c
      if (cancel) then
         if (ipick.eq.n0) then
c
c window has been close by closure cross so set numdec = n_cancel
c
            numdec = n_cancel
         else
c
c window has been closed by double click or button press
c
            numdec = numdec_sel
         endif
      else
c
c normal closure by button press or double click
c
         numdec = numdec_sel
      endif
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt 
c
c deallocate
c
      deallocate(text, stat = ierr)
      deallocate(items, stat = ierr)
      end
c
c -------------------------------------------------------------------
c call back function for tabbing list box control
c -------------------------------------------------------------------
c
      recursive integer function i_select_w_tbox01()
c
c call back required for %lv
c
      implicit   none
      integer    nmax
      parameter (nmax = 500)
      integer    i
      integer    ipick, isel(nmax), nitems_sel, numdec_sel
      character (len = 256) clearwin_string@!added  by w.g.b. 13/01/2020       
      character (len = 256) line
      common / w_tbox01_variables / ipick, isel, nitems_sel, numdec_sel
      external   clearwin_string@
      i_select_w_tbox01 = 2
      ipick = 0
      line = clearwin_string@('CALL_BACK_REASON')
      if (line.eq.'MOUSE_DOUBLE_CLICK') THEN
         ipick = 1
         do i = 1, nitems_sel
            if (isel(i).eq.1) then
               numdec_sel = i
               i_select_w_tbox01 = 0
               return
            endif
         enddo
      endif
      end
c
c
c -------------------------------------------------------------------
c call back function for button press
c -------------------------------------------------------------------
c
      recursive integer function i_press_w_tbox01()
c
c call back required for button press
c
      implicit   none
      integer    nmax
      parameter (nmax = 500)
      integer    i, ipick, isel(nmax), nitems_sel, numdec_sel
      common / w_tbox01_variables / ipick, isel, nitems_sel, numdec_sel
      ipick = 0
      i_press_w_tbox01 = 2
      do i = 1, nitems_sel
         if (isel(i).eq.1) then
            numdec_sel = i
            i_press_w_tbox01 = 0
            ipick = 2
            return
         endif
      enddo
      end
c
c
