c
c
      subroutine w_title2 (icolor, numbld, numdec, numhdr, numopt,
     +                     numpos,
     +                     header_in, option_in)
c
c action : put out a titles menu onto a window
c          like w_titles but puts the menu at bottom horizontally
c author : w.g.bardsley, university of manchester, u.k., 26/10/98
c          26/10/1998 derived from w_title1
c                     defined my_decision = numopt to set numdec = numopt on
c                     closure by hitting the cross
c          01/11/1998 changed colours, removed box and tidied up
c          13/11/1998 changed factor from 0.8 to 1.0 and removed code
c                     checking for option(1)(1:10) = options :
c          14/11/1998 re-introduced Roman for buttons and %sy if grey
c                     to create a scored box
c          14/04/1999 returned to ms sans serif for buttons and prevented ambiguous
c                     closure from caption cross
c          03/12/1999 restored normal dialogue type of window
c          21/01/2001 numdec now returned as entry value when closed by cross
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window withmno closure cross
c                     mwtype = 3: normal dialogue with close = default
c                     mwtype = 4: depends on Cancel/Exit/Quit
c          13/02/2002 XP version
c          18/12/2002 added %sy[toolwindow] and putfat to report errors
c          20/22/2006 suppressed toolwindow and added intents 
c          06/02/2007 edited for w_clearwin.dll
c          30/05/2007 added allocatables, roman, and calls to w_dbleup and w_dbleam
c          18/04/2011 added numbld(i) = 4 for bold and numbld(i) = 2 for italic font 
c          06/11/2023 numpos has no effect in this version or in x_chkmen
c 
c    icolor: (input/unchanged) colour scheme
c    numbld: (input/unchanged) font style
c    numdec: (input/output) sets choice on input then returned as the decision
c    numhdr: (input/unchanged) no. of header lines
c    numopt: (input/unchanged) no. of options
c    numpos: (input/unchanged) hot key positions
c header_in: (input/unchanged) header text
c option_in: (input/unchanged) menu options
c
c          icolor background   text     highlight-text (in question line)
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          2      green        black    blue
c          3      cyan         black    blue
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          text size is set by the parameter size
c
      implicit   none
      include   <windows.ins>  
c
c arguments
c      
      integer,             intent (in)    :: numhdr, numopt
      integer,             intent (in)    :: icolor, numbld(numhdr), 
     +                                       numpos(numopt) 
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: header_in(numhdr), 
     +                                       option_in(numopt)
c
c local allocatable arrays
c                         
      character (len = 129), allocatable :: header(:), option(:)
c
c locals
c      
      integer    i, ierr, j, k, l, m, my_decision, n_cancel, nstart,
     +           ntext, nwide 
      integer    x_len200
      integer    mwtype
      integer    n0, n1, n2, n3, n4, n5, n6, n7, n9
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6,
     +           n7 = 7, n9 = 9)
      integer    nmax
      parameter (nmax = 15)
      integer    i_simfit_title2_1, i_simfit_title2_2,
     +           i_simfit_title2_3, i_simfit_title2_4,
     +           i_simfit_title2_5
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.15d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  items(nmax)*80, line*129, w_dbleam*129, w_dbleup*129
      character  cipher*9
      character  blank*1
      parameter (blank = ' ')
      character  text(30)*100
      logical    abort, cancel, ok
      logical    check1, check2, fixed    
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200, x_chkmen, x_putfat
      external   i_simfit_title2_1, i_simfit_title2_2,
     +           i_simfit_title2_3, i_simfit_title2_4,
     +           i_simfit_title2_5
      external   w_syspar, w_dbleam, w_dbleup
      intrinsic  len, index, dble
      common / simfit_title2 / my_decision 
c
c define the font type
c      
      roman = roman_1
c
c allocate
c          
      if (numhdr.gt.n0) then
         ierr = n0
         if (allocated(header)) deallocate(header, stat = ierr)
         if (ierr.ne.n0) return
         allocate (header(numhdr), stat = ierr)
         if (ierr.ne.n0) return
         do i = n1, numhdr
            header(i) = w_dbleup(header_in(i))
         enddo
      endif   
      ierr = n0
      if (allocated(option)) deallocate(option, stat = ierr)
      if (ierr.ne.n0) return
      allocate(option(numopt), stat = ierr)
      if (ierr.ne.n0) return
      do i = n1, numopt
         option(i) = w_dbleam(option_in(i))
      enddo  
      
c
c initialise in case Cancel encountered
c
      cancel = .false.
      n_cancel = n0
c
c Scale the font sizes
c
      mwtype = 4
      check1 = .true.
      check2 = .false.
      fixed = .false.
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent 
      size_courier = correction*size_courier_1
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
     
c
c full check if required
c
      if (check1) then
         nstart = numhdr + n1
         ntext = numhdr + numopt
         do i = n1, numhdr
            text(i) = header(i)(1:100)
         enddo
         j = numhdr
         do i = n1, numopt
            j = j + n1
            text(j) = option(i)(1:100)
         enddo
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                  'w_title2', text,
     +                  abort)
         if (abort) then
            deallocate(header, stat = ierr)
            deallocate(option, stat = ierr)
            return 
         endif   
      endif

c
c lesser check if required
c
      if (check2) then
         ok = .true.
         if (numopt.lt.n2 .or. numopt.gt.nmax) ok = .false.
         k = len(line)
         do i = n1, numopt
            j = numpos(i)
            l = x_len200(option(i))
c***********if (j.lt.n1 .or. j.gt.l .or. l.gt.k) ok = .false.
         enddo
         do i = n1, numhdr
            l = len(header(i))
            if (l.gt.k) ok = .false.
         enddo
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_title2')
            deallocate(header, stat = ierr)
            deallocate(option, stat = ierr)
            return
         endif
      endif
c
c the header window ... leave the caption in
c                                      
      i = winio@('%ca[Simfit: choices]&')

c
c
c swap the next lines for a %ww type of window instead of a dialogue type
c ======================================================================
c
      my_decision = numdec
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[no_sysmenu]&')
      elseif (mwtype.eq.n4) then
         i = n0
         do while (i.lt.numopt .and. .not.cancel)
            i = i + n1
            if (index(option(i),'Cancel').gt.n0 .or.
     +          index(option(i),'Quit').gt.n0 .or.
     +          index(option(i),'Exit').gt.n0 .or.
     +          index(option(i),'Abandonar').gt.n0 .or.
     +          index(option(i),'Salir').gt.n0) then
                cancel = .true.
                n_cancel = i
            endif
         enddo
         if (cancel) then
            my_decision = n_cancel
         else
            i = winio@('%sy[no_sysmenu]&')
         endif
      endif
c
c now set the font and background and text colours depending on icolor
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
      else  
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
         else
            i = winio@('%`sf&')
         endif      
      endif
      if (icolor.eq.n0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.n1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.n2) then
         k = winio@('%bg[green]&')
      elseif (icolor.eq.n3) then
         k = winio@('%bg&', rgb@(0,167,167))   
      elseif (icolor.eq.n4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.n9) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%sy[3d_thin]&')
         k = winio@('%bg&', rgb@(240,240,240))
      endif
c
c is there a header ?
c
      if (numhdr.gt.n0) then
         k = winio@('%ob[invisible,bottom_exit]&')
         if (fixed) then
            k = winio@('%ts&', size_courier)
         else
            k = winio@('%ts&', size_roman)
         endif
         line = header(n1)
         do i = n1, numhdr
            k = winio@('%sf&')
            if (numbld(i).eq.n0) then
               if (icolor.eq.n0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n2) then
                  k = winio@('%tc[black]&') 
               elseif (icolor.eq.n3) then
                  k = winio@('%tc[black]&')      
               elseif (icolor.eq.n4) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n9) then
                  k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[black]&')
               endif
            elseif (numbld(i).eq.n2) then
               k = winio@('%it&')  
               if (icolor.eq.n0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n2) then
                  k = winio@('%tc[black]&') 
               elseif (icolor.eq.n3) then
                  k = winio@('%tc[black]&')      
               elseif (icolor.eq.n4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            elseif (numbld(i).eq.n4) then    
               k = winio@('%bf&')
               if (icolor.eq.n0) then
                  k = winio@('%tc[white]&')
               elseif (icolor.eq.n1) then
                  k = winio@('%tc[white]&')
               elseif (icolor.eq.n2) then
                  k = winio@('%tc[black]&')  
               elseif (icolor.eq.n3) then
                  k = winio@('%tc[black]&')      
               elseif (icolor.eq.n4) then
                  k = winio@('%tc[white]&')
               else
                  k = winio@('%tc[black]&')
               endif   
            else
               if (icolor.eq.n0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.n1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.n2) then
                  k = winio@('%tc[blue]&')
               elseif (icolor.eq.n3) then
                  k = winio@('%tc[blue]&')      
               elseif (icolor.eq.n4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.n9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            nwide = index(header(i), '`')
            if (nwide.ge.n1 .and. .not.fixed) then
c
c tab the line at backslahes (indicated by grave accents `)
c
               tab = correction*factor*dble(nwide)
               k = winio@('%`1tl&', tab)
               l = x_len200(header(i))
               line = blank
               line = header(i)(n1:nwide - n1)//'%ta'//
     +header(i)(nwide + n1:l)
               k = l + n3
               if (i.eq.numhdr) then
                  line(k:k) =  '&'
               else
                  line(k:k + n3) = '%nl&'
               endif
               k = winio@(line(n1:x_len200(line)))
            else
               if (i.eq.numhdr) then
                  line = header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line(n1:x_len200(line)))
            endif
         enddo
         k = winio@('%cb&')
         k = winio@('%ff%nl&')
      endif
c
c create the menu items
c
      j = n0
      do i = n1, numopt
         j = j + n1
         l = x_len200(option(j))
         line = option(j)(n1:l)
         k = numpos(i)
         k = n1
         l = x_len200(line)
         if (k.eq.n1 .and. l.ge.n1) then
           items(i) = '[&'//line(n1:l)//']'
         elseif (k.gt.n1 .and. l.ge.k) then
            items(i) = '['//line(n1:k - n1)//'&'//line(k:l)//']'
         else
            items(i) = '[**********]'
         endif
      enddo
c
c call winio@ (with & except for the last time)
c
      k = winio@('%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%`sf&')
      k = winio@('%ts&', size_courier)
         nwide = n0
         do i = n1, numopt
            l = x_len200(items(i))
            if (l.gt.nwide) nwide = l
         enddo
         nwide = nwide - n3
         j = n0
         do i = n1, numopt
            j = j + n1
            l = x_len200(items(i))
            if (j.eq.n1) then
               m = n5
               cipher = '%^*bt'
            elseif (j.eq.numdec) then
               m = n7
               cipher = ' %`^*bt'
            else
               m = n6
               cipher = ' %^*bt'
            endif
            if (j.eq.1) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                    nwide, i_simfit_title2_1)
            elseif (j.eq.2) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                    nwide, i_simfit_title2_2)
            elseif (j.eq.3) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                    nwide, i_simfit_title2_3)
            elseif (j.eq.4) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                    nwide, i_simfit_title2_4)
            elseif (j.eq.5) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                    nwide, i_simfit_title2_5)
            endif
         enddo
      k = winio@('%cb')
c
c set numdec then check before returning
c
      numdec = my_decision
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt
      deallocate(header, stat = ierr)
c
c deallocate
c      
      deallocate(option, stat = ierr)      
      end
c
c
      recursive integer function i_simfit_title2_1()
      implicit none
      integer  my_decision
      common / simfit_title2 / my_decision
      my_decision = 1
      i_simfit_title2_1 = 0
      end
c
c
      recursive integer function i_simfit_title2_2()
      implicit none
      integer  my_decision
      common / simfit_title2 / my_decision
      my_decision = 2
      i_simfit_title2_2 = 0
      end
c
c
      recursive integer function i_simfit_title2_3()
      implicit none
      integer  my_decision
      common / simfit_title2 / my_decision
      my_decision = 3
      i_simfit_title2_3 = 0
      end
c
c
      recursive integer function i_simfit_title2_4()
      implicit none
      integer  my_decision
      common / simfit_title2 / my_decision
      my_decision = 4
      i_simfit_title2_4 = 0
      end
c
c
      recursive integer function i_simfit_title2_5()
      implicit none
      integer  my_decision
      common / simfit_title2 / my_decision
      my_decision = 5
      i_simfit_title2_5 = 0
      end
c
c
