c
c
      subroutine w_titles (icolor, numbld, numdec, numhdr, numopt,
     +                     numpos,
     +                     header_in, option_in)
c
c action : put out a titles menu onto a window
c author : w.g.bardsley, university of manchester, u.k., 26/12/96
c
c          this version uses: len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c          fixed gives Courier o/w roman
c
c          03/02/1997 increased nmax to 15 and introduced x_shift, y_shift
c          04/02/1997 added scope for finer button control using nwide
c          10/02/1997 added tabbing code
c          04/04/1997 added call to w_syspar to adjust font size
c          09/09/1998 supressed raised box as it does not tab properly and
c                     removed topmost
c                      also suppressed %ww and pre-defined my_decision to
c                     exit with numdec = numopt if closed from cross
c          01/11/1998 changed colours, removed box and tidied up
c          13/11/1998 changed factor from 0.8 to 1.0 and removed code
c                     for checking for option(1)(1:10) = option :
c          14/11/1998 re-introduced Roman for buttons
c          14/04/1999 returned to ms sans serif for buttons and removed
c                     possibility of ambiguous closing from caption cross
c          03/12/1999 returned to dialogue type of window
c          21/01/2001 now returns numdec = entry value on closure by cross
c          02/03/2001 introduced %sy[no_sysmenu], mwtype, and cancel mechanism
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     mwtype = 3: normal dialogue window, closure = default
c                     mwtype = 4: depends on Cancel/Quit/Exit
c          13/02/2002 XP version
c          20/11/2006 suppressed toolwindow and added intents
c          06/02/2007 edited for w_clearwin.dll
c          30/05/2007 added allocatables, roman, and calls to w_dbleup and w_dbleam
c          06/11/2023 numpos has no effect in this version or in x_chkmen
c
c    icolor: (input/unchanged) colour scheme
c    numbld: (input/unchanged) font style
c    numdec: (input/output) sets choice on input then returned as the decision
c    numhdr: (input/unchanged) no. of header lines
c    numopt: (input/unchanged) no. of options
c    numpos: (input/unchanged) hot key positions
c header_in: (input/unchanged) header text
c option_in: (input/unchanged) menu options
c
c          icolor background   text     highlight-text (in question line)
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          text size is set by the parameters size_roman and size_courier
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: numhdr, numopt
      integer,             intent (in)    :: icolor, numbld(numhdr),
     +                                       numpos(numopt) 
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: header_in(numhdr), 
     +                                       option_in(numopt)
c
c local allocatable arrays
c                         
      character (len = 129), allocatable :: header(:), option(:)     
c
c locals
c       
      integer    i, ierr, j, k, l, m, my_decision, n_cancel, nstart,
     +           ntext, nwide 
      integer    x_len200
      integer    mwtype
      integer    n0, n1, n2, n3, n4, n7, n8, n9
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n7 = 7, n8 = 8,
     +           n9 = 9)
      integer    nmax
      parameter (nmax = 15)
      integer    i_simfit_titles_1, i_simfit_titles_2,
     +           i_simfit_titles_3, i_simfit_titles_4,
     +           i_simfit_titles_5, i_simfit_titles_6,
     +           i_simfit_titles_7, i_simfit_titles_8,
     +           i_simfit_titles_9, i_simfit_titles_10,
     +          i_simfit_titles_11, i_simfit_titles_12,
     +          i_simfit_titles_13, i_simfit_titles_14,
     +          i_simfit_titles_15
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.15d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      double precision x_shift, y_shift, z_shift
      parameter (x_shift = 0.0d+00, y_shift = 0.25d+00,
     +           z_shift = 2.0d+00)
      character  items(nmax)*80, line*129, w_dbleam*129, w_dbleup*129 
      character  cipher*9
      character  blank*1
      parameter (blank = ' ')
      character  text(30)*80
      logical    abort, cancel, ok
      logical    check1, check2, fixed  
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200, x_chkmen, x_putfat
      external   i_simfit_titles_1, i_simfit_titles_2,
     +           i_simfit_titles_3, i_simfit_titles_4,
     +           i_simfit_titles_5, i_simfit_titles_6,
     +           i_simfit_titles_7, i_simfit_titles_8,
     +           i_simfit_titles_9, i_simfit_titles_10,
     +          i_simfit_titles_11, i_simfit_titles_12,
     +          i_simfit_titles_13, i_simfit_titles_14,
     +          i_simfit_titles_15
      external   w_syspar, w_dbleam, w_dbleup
      intrinsic  len, index, dble
      common / simfit_titles / my_decision 
c
c define the font type
c       
      roman = roman_1
c
c allocate
c          
      if (numhdr.gt.n0) then
         ierr = n0
         if (allocated(header)) deallocate(header, stat = ierr)
         if (ierr.ne.n0) return
         allocate (header(numhdr), stat = ierr)
         if (ierr.ne.n0) return
         do i = n1, numhdr
            header(i) = w_dbleup(header_in(i))
         enddo
      endif   
      ierr = n0
      if (allocated(option)) deallocate(option, stat = ierr)
      if (ierr.ne.n0) return
      allocate(option(numopt), stat = ierr)
      if (ierr.ne.n0) return
      do i = n1, numopt
         option(i) = w_dbleam(option_in(i))
      enddo  
c
c initialise in case cancel is encountered
c
      cancel = .false.
      n_cancel = n0
c
c Scale the font sizes
c
      mwtype = 4
      check1 = .true.
      check2 = .false.
      fixed = .false.
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1 
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
c
c full check if required
c
      if (check1) then
         nstart = numhdr + n1
         ntext = numhdr + numopt
         do i = n1, numhdr
            text(i) = header(i)(1:80)
         enddo
         j = numhdr
         do i = n1, numopt
            j = j + n1
            text(j) = option(i)(1:80)
         enddo
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                  'w_titles', text,
     +                  abort)
          if (abort) then
            deallocate(header, stat = ierr)
            deallocate(option, stat = ierr)
            return 
         endif   
      endif

c
c lesser check if required
c
      if (check2) then
         ok = .true.
         if (numopt.lt.n2 .or. numopt.gt.nmax) ok = .false.
         k = len(line)
         do i = n1, numhdr
            l = len(header(i))
            if (l.gt.k) ok = .false.
         enddo
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_titles')
            deallocate(header, stat = ierr)
            deallocate(option, stat = ierr)
            return
         endif
      endif                            
      i = winio@('%ca[Simfit: choices]&')

c
c swap these lines for a %ww window instead of a dialogue window
c =================================================================
c
      my_decision = numdec
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[no_sysmenu]&')
      elseif (mwtype.eq.n4) then
         i = n0
         do while (i.lt.numopt .and. .not.cancel)
            i = i + n1
            if (index(option(i),'Cancel').gt.n0 .or.
     +          index(option(i),'Quit').gt.n0 .or.
     +          index(option(i),'Exit').gt.n0 .or.
     +          index(option(i),'Abandonar').gt.n0 .or.
     +          index(option(i),'Salir').gt.n0) then
                cancel = .true.
                n_cancel = i
            endif
         enddo
         if (cancel) then 
            my_decision = n_cancel
         else   
            i = winio@('%sy[no_sysmenu]&')
         endif   
      endif

c
c now set the font and background and text colours depending on icolor
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
      else  
         if (roman) then
            i = winio@('%fn[Times New Roman]&') 
         else
            i = winio@('%`sf&')   
         endif   
      endif
      if (icolor.eq.n0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.n1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.n4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.n9) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg&', rgb@(240,240,240))
      endif
c
c is there a header ?
c
      if (numhdr.gt.n0) then
         if (fixed) then
            k = winio@('%ts&', size_courier)
         else
            k = winio@('%ts&', size_roman)
         endif
         line = header(n1)
         do i = n1, numhdr
            if (numbld(i).eq.n0) then
               if (icolor.eq.n0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.n4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.n0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.n1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.n4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.n9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            nwide = index(header(i), '`')
            if (nwide.ge.n1 .and. .not.fixed) then
c
c tab the line at backslashes (as indicated by grave accent `)
c
               tab = correction*factor*dble(nwide)
               k = winio@('%`1tl&', tab)
               l = x_len200(header(i))
               line = blank
               line = header(i)(n1:nwide - n1)//'%ta'//
     +header(i)(nwide + n1:l)
               k = l + n3
               if (i.eq.numhdr) then
                  line(k:k) =  '&'
               else
                  line(k:k + n3) = '%nl&'
               endif
               k = winio@(line(n1:x_len200(line)))
            else
               if (i.eq.numhdr) then
                  line = header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line(n1:x_len200(line)))
            endif
         enddo
         k = winio@('%ff%nl&')
      endif
c
c create the menu items
c
      j = n0
      do i = n1, numopt
         j = j + n1
         l = x_len200(option(j))
         line = option(j)(n1:l)
         k = n1
         l = x_len200(line)
         if (k.eq.n1 .and. l.ge.n1) then
           items(i) = '['//line(n1:l)//']'
         else
            items(i) = '[**********]'
         endif
      enddo
c
c call winio@ (with & except for the last time)
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_courier)
      if (numopt.lt.n7) then
c
c if numopt < 7 use %bt and nwide
c
         nwide = n0
         do i = n1, numopt
            l = x_len200(items(i))
            if (l.gt.nwide) nwide = l
         enddo
         nwide = nwide - n3
         j = n0
         do i = n1, numopt
            j = j + n1
            l = x_len200(items(i))
            if (j.eq.numdec) then
               m = n9
               cipher = '%cn%`^*bt'
            else
               m = n8
               cipher = '%cn%^*bt'
            endif
            if (j.eq.1) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_titles_1)
            elseif (j.eq.2) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_titles_2)
            elseif (j.eq.3) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_titles_3)
            elseif (j.eq.4) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_titles_4)
            elseif (j.eq.5) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_titles_5)
            elseif (j.eq.6) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_titles_6)
            endif
            if (i.lt.numopt) then
               k = winio@('%`rp&', x_shift*z_shift, y_shift*z_shift)
            else
               k = winio@('%nl')
            endif
         enddo
      else
c
c if numopt >= 7 use %tt
c
         j = n0
         do i = n1, numopt
            j = j + n1
            l = x_len200(items(i))
            if (j.eq.numdec) then
               m = n8
               cipher = '%cn%`^tt'
            else
               m = n7
               cipher = '%cn%^tt'
            endif
            if (j.eq.1) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_1)
            elseif (j.eq.2) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_2)
            elseif (j.eq.3) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_3)
            elseif (j.eq.4) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 i_simfit_titles_4)
            elseif (j.eq.5) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_5)
            elseif (j.eq.6) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_6)
            elseif (j.eq.7) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_7)
            elseif (j.eq.8) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_8)
            elseif (j.eq.9) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_9)
            elseif (j.eq.10) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_10)
            elseif (j.eq.11) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_11)
            elseif (j.eq.12) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_12)
            elseif (j.eq.13) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_13)
            elseif (j.eq.14) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_14)
            elseif (j.eq.15) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_titles_15)
            endif
            if (i.lt.numopt) then
               k = winio@('%`rp&', x_shift, y_shift)
            else
               k = winio@('%nl')
            endif
         enddo
      endif
c
c set numdec then check before returning
c
      numdec = my_decision
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt
c
c deallocate
c      
      deallocate(header, stat = ierr)
      deallocate(option, stat = ierr)
      end
c
c
      recursive integer function i_simfit_titles_1()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 1
      i_simfit_titles_1 = 0
      end
c
c
      recursive integer function i_simfit_titles_2()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 2
      i_simfit_titles_2 = 0
      end
c
c
      recursive integer function i_simfit_titles_3()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 3
      i_simfit_titles_3 = 0
      end
c
c
      recursive integer function i_simfit_titles_4()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 4
      i_simfit_titles_4 = 0
      end
c
c
      recursive integer function i_simfit_titles_5()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 5
      i_simfit_titles_5 = 0
      end
c
c
      recursive integer function i_simfit_titles_6()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 6
      i_simfit_titles_6 = 0
      end
c
c
      recursive integer function i_simfit_titles_7()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 7
      i_simfit_titles_7 = 0
      end
c
c
      recursive integer function i_simfit_titles_8()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 8
      i_simfit_titles_8 = 0
      end
c
c
      recursive integer function i_simfit_titles_9()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 9
      i_simfit_titles_9 = 0
      end
c
c
      recursive integer function i_simfit_titles_10()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 10
      i_simfit_titles_10 = 0
      end
c
c
      recursive integer function i_simfit_titles_11()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 11
      i_simfit_titles_11 = 0
      end
c
c
      recursive integer function i_simfit_titles_12()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 12
      i_simfit_titles_12 = 0
      end
c
c
      recursive integer function i_simfit_titles_13()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 13
      i_simfit_titles_13 = 0
      end
c
c
      recursive integer function i_simfit_titles_14()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 14
      i_simfit_titles_14 = 0
      end
c
c
      recursive integer function i_simfit_titles_15()
      implicit none
      integer  my_decision
      common / simfit_titles / my_decision
      my_decision = 15
      i_simfit_titles_15 = 0
      end
c
c
