c
c
      subroutine w_tutor1 (icolor, inext, ipage, ipmax, numbld, numhdr,
     +                     header_in, 
     +                     fixed)
c
c action : put out a tutors text with attributes onto a window
c author : w.g.bardsley, university of manchester, u.k., 12/12/98
c
c          derived from w_tutors
c          this routine must be called from a driver like tutor1 to take
c          care of the backwards/forwards/cancel/operations
c
c          12/04/1999 set n_button_pressed = 3 on entry so that closing by the
c                     caption cross causes an exit not a selection of the
C                     highlighted button
c          03/09/1999 removed the closure cross using %ww[no_sysmenu]
c          03/12/1999 restored topmost
c          22/01/2001 supressed topmost and linked cross-closure to the default button
c          02/03/2001 introduced %sy[no_sysmenu], mwtype, and restored closure
c                     by cross when mwtype = 3
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure
c                     o/w normal dialogue window closing by cross
c          13/02/2002 XP version
c          18/12/2002 added %sy[toolwindow]
c          20/11/2006 removed toolwindow and added intents 
c          06/02/2007 edited for w_clearwin.dll 
c          30/05/2007 added allocatable array, roman, and w_dbleup
c          04/04/2010 added copy as menu item for extra text appended to header_in
c                     this must now be called from tutor1 with the following scheme
c                     %start-of-text-to-copy%
c                       ...
c                     %end-of-text-to-copy%'      
c  
c    icolor: (input/unchanged) colour scheme
c     inext: (input/output) page counter
c     ipage: (input/unchanged) current page number 
c     ipmax: (input/unchanged) total number of pages to be displayed
c    numbld: (input/unchanged) font scheme
c    numhdr: (input/unchanged) no. of text lines in current page
c header_in: (input/unchanged) current page 
c     fixed: (input/unchanged) fixe/proportionally-spaced font
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          numbld(i)  font  (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times
c          2, 3       Times Italic
c          4, 5       Times Bold
c          6, 7       Times Bold Italic
c
c          text size is set by the parameters size_roman, size_courier
c
      implicit   none
      include   <windows.ins>    
c
c arguments
c      
      integer,             intent (in)    :: icolor, ipage, ipmax,
     +                                       numhdr
      integer,             intent (inout) :: inext
      integer,             intent (in)    :: numbld(numhdr)
      character (len = *), intent (in)    :: header_in(*) 
      logical,             intent (in)    :: fixed  
c
c local allocatable array
c                        
      character (len = 129), allocatable :: header(:) 
c
c locals
c      
      integer    i, ierr, ios, j, k, l, nout 
      integer    x_len200
      integer    ictrl1, ictrl2
      integer    n_button_pressed
      integer    i_copy_tutor1, i_tutor1_1, i_tutor1_2, i_tutor1_3
      integer    mwtype, mw_type
      parameter (mw_type = 3)
      integer    n0, n1, n2, n4, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n7 = 7)
      double precision size_roman, size_courier, size_msss
      double precision size_roman_1, size_courier_1, size_msss_1
      parameter (size_roman_1 = 1.15d+00, size_courier_1 = 1.0d+00,
     +           size_msss_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  line*129, title*40, w_dbleup*129
      character  blank*1, space*4
      parameter (blank = ' ', space = '    ')  
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      intrinsic  dble, index
      external   w_syspar, w_dbleup, w_getnou, w_reslib
      external   x_len200
      external   i_copy_tutor1, i_tutor1_1, i_tutor1_2, i_tutor1_3
      common / simfit_tutor1 / n_button_pressed
      common / copy_tutor1 / nout
      mwtype = mw_type 
      roman = roman_1
c
c allocate
c          
      if (numhdr.gt.n0) then
         ierr = n0
         if (allocated(header)) deallocate(header, stat = ierr)
         if (ierr.ne.n0) return
         allocate (header(numhdr), stat = ierr)
         if (ierr.ne.n0) return
         do i = n1, numhdr
            header(i) = w_dbleup(header_in(i))
         enddo
      else
         return   
      endif         
c
c
      if (mwtype.eq.3) then
         n_button_pressed = 3
      elseif (ipage.eq.ipmax) then
         n_button_pressed = 1
      else
         n_button_pressed = 2
      endif
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
     
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1 
      if (roman) then
          size_roman = correction*size_roman_1
      else
          size_roman = size_courier
      endif        
c
c open the window
c
      write (title,100) ipage, ipmax

c
c swap the next line for a normal window instead of a dialogue window
c ===================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[no_sysmenu]&')
      endif
c

      i = winio@('%ca@&', title)
      i = winio@('%mn[Copy]&', i_copy_tutor1)
      call w_reslib
      i = winio@('%mi[icon_1]&')
c
c create the text for copying
c      
      call w_getnou (nout)
      open (unit = nout, status = 'SCRATCH', iostat = ios)
      i = numhdr
      do while (ios.eq.0 .and. i.ge.numhdr)
         i = i + 1
         line = header_in(i)
         if (line.eq.'%start-of-text-to-copy%') then
            do while (ios.eq.0 .and. i.ge.numhdr)
               i = i + 1 
               line = header_in(i)
               if (line.eq.'%end-of-text-to-copy%') then
                  ios = -1
                  i = -1
                  exit
               else   
                  write (nout,'(a)',iostat=ios) line 
               endif   
            enddo
         endif      
      enddo  
c
c now set the background colour depending on icolor
c
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg[grey]&')
      endif
      do i = n1, numhdr

c
c now set the text font depending on numbld(i) and fixed
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (i.eq.numhdr) then
               line = '%ts'//header(i)(n1:x_len200(header(i)))//'&'
            else
               line = '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
            endif
            k = winio@(line, size_courier)
         else 
            if (roman) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Times New Roman]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Times New Roman]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Times New Roman]%bf&')
               else
                  k = winio@('%fn[Times New Roman]%bf%it&')
               endif 
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&') 
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif 
            endif      
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
c
c check for tabs (i.e. grave accent `) and act if required
c
            j = index(header(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               tab = correction*factor*dble(j)
               k = winio@('%`1tl&', tab)
               l = x_len200(header(i))
               line = blank
               line = header(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               line = blank
               if (i.eq.numhdr) then
                  line = '%ta'//header(i)(j + n1:l)//'&'
                  k = winio@(line(n1:l - j + n4))
               else
                  line = '%ta'//header(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               endif
            else
               if (i.eq.numhdr) then
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = 
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line, size_roman)
            endif
         endif
         k = winio@('%sf&')
      enddo
      k = winio@('%ff&')
      if (fixed) then
         k = winio@('%fn[Courier New]&')
      else
         k = winio@('%`sf&')
      endif
      k = winio@('%ts&', size_msss)
      if (ipage.eq.n1) then
         ictrl1 = 0
         ictrl2 = 1
      elseif (ipage.eq.ipmax) then
         ictrl1 = 1
         ictrl2 = 0
      else
         ictrl1 = 1
         ictrl2 = 1
      endif
      line = '%nl%cn%~^tt[&<<]'//space//'%~`^tt[&>>]'//space//
     +'%^tt[&Cancel]&'
      k = winio@(line, ictrl1, i_tutor1_1, ictrl2, i_tutor1_2,
     +           i_tutor1_3)
      k = winio@(' ')
      if (n_button_pressed.eq.1) then
         inext = ipage - n1
      elseif (n_button_pressed.eq.2) then
         if (ipage.eq.ipmax) then
            inext = 0
         else
            inext = ipage + n1
         endif
      elseif (n_button_pressed.eq.3) then
         inext = 0
      endif    
c
c deallocate
c           
      deallocate(header, stat = ierr)
      close (unit = nout)
  100 format ('Simfit: tutorial  ( Page',i3,' of',i3,' )')
      end
c
c
      recursive integer function i_copy_tutor1()
      implicit none
      integer  nout
      external w_revpro
      common / copy_tutor1 / nout
      i_copy_tutor1 = 1
      call w_revpro (nout)
      end      
c
c
      recursive integer function i_tutor1_1()
      implicit none
      integer  n_button_pressed
      common / simfit_tutor1 / n_button_pressed
      n_button_pressed = 1
      i_tutor1_1 = 0
      end
c
c
      recursive integer function i_tutor1_2()
      implicit none
      integer  n_button_pressed
      common / simfit_tutor1 / n_button_pressed
      n_button_pressed = 2
      i_tutor1_2 = 0
      end
c
c
      recursive integer function i_tutor1_3()
      implicit none
      integer  n_button_pressed
      common / simfit_tutor1 / n_button_pressed
      n_button_pressed = 3
      i_tutor1_3 = 0
      end
c
c
