c
c
      subroutine w_tutors (icolor, numbld, numhdr, 
     +                     header_in,
     +                     fixed, next, updown)
c
c action : put out a tutors text with attributes onto a window
c author : w.g.bardsley, university of manchester, u.k., 19/12/96
c          10/02/1997 added tabbing
c          04/04/1997 added call to w_syspar to adjust font size
c          28/09/1998 removed %ww and initialised next to allow window
c                     closure from close button (cross)
c          14/11/1998 re-introduced Roman/Courier for buttons
c          03/09/1999 re-introduced ms sans serif for buttons and %ww[no_sysmenu]
c          03/12/1999 restored topmost
c          22/01/2001 suppressed topmost and returns next = .true. on cross-closure
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype. w_tutors should now
c                     only be called for 1 page tutorials with mwtype = 3
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     o/w normal dialogue type
c          13/02/2002 XP version
c          18/12/2002 added %sy[toolwindow]
c          20/11/2006 removed toolwindow and added intents 
c          06/02/2007 edited for w_clearwin.dll 
c          30/05/2007 added allocatable array, roman, and calls to w_dbleup
c          04/04/2010 added copy as a menu item 
c
c          this version uses: len200 = leng@ = len_trim, lcase1 = lcase@
c          to be compatible with ftn77 and ftn90
c
c          This routine should normally be called from tutors which uses a call
c          to w_dbleup to filter out problem character strings before calling
c          cw+. Users calling w_tutors directly should filter out character
c          strings and provide a front end like tutor1 to control the backwards
c          and forward actions.
c
c          updown = .true.  : supply option for backwards/forwards, i.e. so
c                             that next can be returned as .false. or .true.
c                             This option allows sequential calls
c          updown = .false. : just one closure button and next is always .true.
c                             on return.
c                             This option is for one-off tutorials.
c
c    icolor: (input/unchanged) colour scheme
c    numbld: (input/unchanged) font scheme
c    numhdr: (input/unchanged) no. of lines in current page 
c header_in: (input/unchanged) current page 
c     fixed: (input/unchanged) fixed or proportionally-spaced font
c      next: (output) .true. if next page has been requested
c    updown: (input/unchanged) backwards/forwards
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          numbld(i)  font  (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times
c          2, 3       Times Italic
c          4, 5       Times Bold
c          6, 7       Times Bold Italic
c
c          text size is set by the parameters size_roman, size_courier
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)  :: icolor, numhdr
      integer,             intent (in)  :: numbld(numhdr)
      character (len = *), intent (in)  :: header_in(numhdr)
      logical,             intent (in)  :: fixed, updown
      logical,             intent (out) :: next 
c
c local allocatable array
c                        
      character (len = 129), allocatable :: header(:)
c
c locals
c      
      integer    i, ierr, ios, j, k, l, nout
      integer    x_len200
      integer    i_copy_tutors, i_previous_tutors, i_next_tutors
      integer    mwtype
      integer    n1, n2, n4, n7
      parameter (n1 = 1, n2 = 2, n4 = 4, n7 = 7)
      double precision size_roman, size_courier, size_msss
      double precision size_roman_1, size_courier_1, size_msss_1
      parameter (size_roman_1 = 1.15d+00, size_courier_1 = 1.0d+00,
     +           size_msss_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  line*129, w_dbleup*129
      character  blank*1, space*3
      parameter (blank = ' ', space = '   ')
      logical    next_simfit_tutors 
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      intrinsic  dble, index
      external   w_syspar, w_dbleup, w_getnou, w_reslib
      external   x_len200
      external   i_copy_tutors, i_previous_tutors, i_next_tutors
      common / simfit_tutors / next_simfit_tutors 
      common / copy_tutors / nout
c
c define the font
c      
      roman = roman_1
c
c allocate
c          
      if (numhdr.gt.0) then
         ierr = 0
         if (allocated(header)) deallocate(header, stat = ierr)
         if (ierr.ne.0) return
         allocate (header(numhdr), stat = ierr)
         if (ierr.ne.0) return
         do i = n1, numhdr
            header(i) = w_dbleup(header_in(i))
         enddo  
      else
         return   
      endif         
c
c
      next = .true.
      next_simfit_tutors = next
c
c Scale the font sizes
c
      mwtype = 3
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      if (roman) then  
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
c
c open the window
c

c
c swap the next lines for a normal window instead of a dialogue window
c ====================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[no_sysmenu]&')
      endif

      i = winio@('%ca[Simfit: tutorial]&')
      i = winio@('%mn[Copy]&', i_copy_tutors)
      call w_reslib
      i = winio@('%mi[icon_1]&')
      call w_getnou (nout)
      open (unit = nout, status = 'SCRATCH', iostat = ios)
      do i = 1, numhdr
         line = header_in(i)
         j = index(line,'`')
         do while (j.gt.0)
            line(j:j) = blank
            j = index(line,'`')
        enddo
        write (nout,'(a)',iostat=ios) line
      enddo      
c
c now set the background colour depending on icolor
c
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg[grey]&')
      endif
      do i = n1, numhdr

c
c now set the text font depending on numbld(i) and fixed
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif 
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (i.eq.numhdr) then
               line = '%ts'//header(i)(n1:x_len200(header(i)))//'&'
            else
               line = '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
            endif
            k = winio@(line, size_courier)
         else 
            if (roman) then 
               if (numbld(i).le.1) then
                  k = winio@('%fn[Times New Roman]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Times New Roman]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Times New Roman]%bf&')
               else
                  k = winio@('%fn[Times New Roman]%bf%it&')
               endif
            else 
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
            
            endif      
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
c
c check for tabs (i.e. grave accent `) and act if required
c
            j = index(header(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               tab = correction*factor*dble(j)
               k = winio@('%`1tl&', tab)
               l = x_len200(header(i))
               line = blank
               line = header(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               line = blank
               if (i.eq.numhdr) then
                  line = '%ta'//header(i)(j + n1:l)//'&'
                  k = winio@(line(n1:l - j + n4))
               else
                  line = '%ta'//header(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               endif
            else
               if (i.eq.numhdr) then
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = 
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line, size_roman)
            endif
         endif
         k = winio@('%sf&')
      enddo
      k = winio@('%ff&')
      if (fixed) then
         k = winio@('%fn[Courier New]&')
      else
         k = winio@('%`sf&')
      endif
      k = winio@('%ts&', size_msss)
      if (updown) then
         line = '%nl%cn%^tt[< &Back]'//space//'%`^tt[&Next >]'
         k = winio@(line, i_previous_tutors, i_next_tutors)
         next = next_simfit_tutors
      else
         next = .true.
         line = '%nl%cn%`^tt[OK]'
         k = winio@(line, 'exit')
      endif
c
c deallocate
c           
      deallocate(header, stat = ierr)
      close (unit = nout)
      end
c
c
      recursive integer function i_copy_tutors()
      implicit none
      integer  nout
      external w_revpro
      common / copy_tutors / nout 
      i_copy_tutors = 1
      call w_revpro (nout)
      end   
c
c
      recursive integer function i_previous_tutors()
      implicit none
      logical  next_simfit_tutors
      common / simfit_tutors / next_simfit_tutors
      next_simfit_tutors = .false.
      i_previous_tutors = 0
      end
c
c
      recursive integer function i_next_tutors()
      implicit none
      logical  next_simfit_tutors
      common / simfit_tutors / next_simfit_tutors
      next_simfit_tutors = .true.
      i_next_tutors = 0
      end
c
c
