c
c
      subroutine w_v7path (k, 
     +                     arg, path)
c
c action: return Version 7 paths to results, user, configuration and temporary files
c author: w.g.bardsley, university of manchester, u.k., 13/01/2011
C         25/01/2011 replaced C_EXTERNAL by STDCALL 
C         10/11/2011 corrected k64 = n - 5 to k64 = n - 6 on line 160 
C         03/05/2015 corrected code for p64
C         05/08/2015 re-corrected code for p64 at lines 163 and 164 which was again as at 10/11/2011 
C         10/08/2015 added call to w_pathid
c         25/08/2016 added app, dat, and roa
c         10/09/2019 added username and changed main folder to c:\ProgramData\Simfit\User
c         21/09/2019 username had a trailing blank from getusername so used len_trim to calculate k_usr 
c
c Notes: this subroutine was developed with valuable help from David Bailey.
c        If the paths do not exist, the folders are created on the fly.
c        The code is verbose to allow for possible future developments using
c        additional or alternative folders.
c        There is a reason why the folders are made in a two step process i.e.
c        first C:\ProgramData\
c        then  C:\ProgramData\Simfit 
c        then  C:\ProgramData\Simfit\user
c        then  C:\ProgramData\Simfit\user\res
c        etc., as follows:
c        mkdir@ just returns error_code = 183 if the folder exists but, if you try
c        to make the ...folder\subfolder in one pass it fails with error_code = 3. 
c
c    k: effective length of path
c  arg: path required as follows ...
c       cfg: Simfit configuration folder
c       res: Simfit results folder
c       p32: %PROGRAMFILES% Program Files or Program Files (x86)
c       p64: %PROGRAMFILESW6432%?? Program Files 
c       tmp: %TEMP%
c       usr: Simfit user folder
c       win: Windows folder
c       s32: System32 folder 
c       app: AppData/Local 
c       dat: ProgramData
c       roa: AppData/roaming     
c path: path returned
c 
      implicit   none
      include <windows.ins>
c
c arguments
c      
      integer,             intent (out) :: k  
      character (len = *), intent (in)  :: arg 
      character (len = *), intent (out) :: path 
c
c locals
c      
      integer   (SELECTED_INT_KIND(4)) error_code
      integer    k_name
      integer    k_app, k_cfg, k_dat, k_res, k_roa, k_tmp, k_usr, n
      integer    k32, k64
      integer    k_win, k_s32
      integer    csidl
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\')
      character (len = 3) arg_copy
      character (len = 3) app, cfg, dat, res, roa, tmp, usr
      parameter (app = 'app', cfg = 'cfg', dat = 'dat', res = 'res',
     +           roa = 'roa', tmp = 'tmp', usr = 'usr')
      character (len = 3) p32, p64
      parameter (p32 = 'p32', p64 = 'p64')
      character (len = 3) win, s32
      parameter (win = 'win', s32 = 's32')
      character (len = 1024) app_path, cfg_path, dat_path, res_path,
     +                       roa_path, tmp_path, usr_path
      character (len = 1024) csidl_path, pdata, simfit
      character (len = 1024) pfiles32, pfiles64
      character (len = 1024) win_path, sys32_path
      character (len = 1024) username
      logical    first, ok, ok32, ok64, w_pathid
      external   w_pathid, x_putwar
      external   lcase@, mkdir@
      STDCALL cspath 'SHGetSpecialFolderPathA' (VAL, OUTSTRING(1024),
     +VAL, VAL): LOGICAL 
      STDCALL temppath 'GetTempPathA' (VAL, OUTSTRING(1024)): INTEGER
      intrinsic  leng, len_trim
      save       first
      save       k_name
      save       username
      save       k_app, k_cfg, k_dat, k_res, k_roa, k_tmp, k_usr
      save       k32, k64
      save       app_path, cfg_path, dat_path, res_path, roa_path, 
     +           tmp_path, usr_path 
      save       pfiles32, pfiles64
      save       win_path, sys32_path             
      data       first  / .true. /
      data       k_name / 0 / 
      data       username / ' ' / 
      data       app_path, cfg_path, dat_path, res_path, roa_path, 
     +           tmp_path, usr_path 
     +          / blank, blank, blank, blank, blank, blank, blank /
      data       k_app, k_cfg, k_res, k_roa, k_tmp, k_usr 
     +          / 0, 0, 0, 0, 0, 0 /
      data       pfiles32, pfiles64 / blank, blank /
      data       k32, k64 / 0, 0 /
      data       win_path, sys32_path / blank, blank /
      data       k_win, k_s32 / 0, 0 /
c
c initialise
c      
      k = 0
      path = blank
c
c if first time create the folders if they are not there already
c
      if (first) then
         first = .false.
c
c get the username
c         
         k_name = 1024 
         ok = getusername (username, k_name)
         if (.not.ok) call x_putwar ('w_v7path cannot get username')
         k_name = len_trim(username)!k_name may (will) have a trailing blank  
c
c get the path to ProgramData
c         
         csidl = 35
         csidl_path = blank
         call cspath (0, csidl_path, csidl, 0)
         n = leng(csidl_path)
         if (n.gt.0) then
            if (csidl_path(n:n).eq.bslash) then
               csidl_path(n:n) = blank
               n = n - 1
            endif   
         endif   
         if (n.eq.0) then
            n = 2
            csidl_path = 'C:'   
         endif 
         pdata(1:n) = csidl_path(1:n) 
         call mkdir@(pdata(1:n), error_code)
c
c get the path to Simfit
c
         simfit = pdata(1:n)//'\Simfit'
         n = n + 7
         call mkdir@(simfit(1:n), error_code)
c
c add the user to simfit         
         
         n = n + 1
         simfit(n:n) = '\'
         simfit(n + 1: n + k_name) = username(1:k_name)
         n = n + k_name
         call mkdir@(simfit(1:n), error_code)
          
         cfg_path = simfit(1:n)//'\cfg'
         k_cfg = n + 4
         call mkdir@(cfg_path(1:k_cfg), error_code)
         
         res_path = simfit(1:n)//'\res'
         k_res = n + 4 
         call mkdir@(res_path(1:k_res), error_code)
         
         usr_path = simfit(1:n)//'\usr'
         k_usr = n + 4 
         call mkdir@(usr_path(1:k_usr), error_code)
         
c
c get the path to TEMP
c         
         n = 1024
         tmp_path = blank
         call temppath (n, tmp_path)
         k_tmp = leng(tmp_path)
         if (k_tmp.gt.0) then
            if (tmp_path(k_tmp:k_tmp).eq.bslash) then
               tmp_path(k_tmp:k_tmp) = blank
               k_tmp = k_tmp - 1
            endif
         endif   
         if (k_tmp.eq.0) then
            k_tmp = 7 
            tmp_path = 'C:\Temp'     
         endif   
c
c get the paths to program files
c
         csidl = 38
         csidl_path = blank
         call cspath (0, csidl_path, csidl, 0)
         n = leng(csidl_path)
         if (n.gt.0) then
            if (csidl_path(n:n).eq.bslash) then
               csidl_path(n:n) = blank
               n = n - 1
            endif
            pfiles32 = csidl_path
            if (csidl_path(n - 2:n).eq.'86)') then
               k32 = n
               pfiles32 = csidl_path
               k64 = n - 6
               csidl_path(n - 5:n) = '    '
               pfiles64 = csidl_path
            else
               k64 = n
               pfiles64 = csidl_path
               k32 = n + 6
               pfiles32 = pfiles64(1:n)//' (x86)'
            endif
         else
            k32 = 0
            k64 = 0
            pfiles32 = blank
            pfiles64 = blank            
         endif
c
c check to re-define for 32-bit OS
c         
         ok32 = w_pathid(pfiles32)
         ok64 = w_pathid(pfiles64)
         if (ok64 .and. .not.ok32) then
            k32 = k64
            pfiles32 = pfiles64
         endif    
c
c get the windows and system32 folders
c     
          csidl = 36
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             win_path = csidl_path
             k_win = n
          endif
                   
          csidl = 37
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             sys32_path = csidl_path
             k_s32 = n
          endif           

c
c get the path to Apps and ProgramData
c
          csidl = 26 
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             roa_path = csidl_path
             k_roa = n
          endif  
          
          csidl = 28 
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             app_path = csidl_path
             k_app = n
          endif  

          csidl = 35 
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             dat_path = csidl_path
             k_dat = n
          endif  

      endif
c
c decide which folder is required
c      
      arg_copy = arg
      call lcase@(arg_copy)
c
c return the stored values 
c      
      if (arg_copy.eq.app) then
         k = k_app
         path = app_path
      elseif (arg_copy.eq.cfg) then
         k = k_cfg
         path = cfg_path
      elseif (arg_copy.eq.dat) then
         k = k_dat
         path = dat_path   
      elseif (arg_copy.eq.res) then
         k = k_res
         path = res_path
      elseif (arg_copy.eq.roa) then
         k = k_roa
         path = roa_path   
      elseif (arg_copy.eq.tmp) then   
         k = k_tmp
         path = tmp_path                    
      elseif (arg_copy.eq.usr) then   
         k = k_usr
         path = usr_path
      elseif (arg_copy.eq.p32) then
         k = k32
         path = pfiles32
      elseif (arg_copy.eq.p64) then
         k = k64
         path = pfiles64   
      elseif (arg_copy.eq.win) then  
         k = k_win
         path = win_path
      elseif (arg_copy.eq.s32) then
         k = k_s32
         path = sys32_path
      endif
      end
c
c            

c
c
      subroutine w_v7path_old (k, 
     +                         arg, path)
c
c action: return Version 7 paths to results, user, configuration and temporary files
c author: w.g.bardsley, university of manchester, u.k., 13/01/2011
C         25/01/2011 replaced C_EXTERNAL by STDCALL 
C         10/11/2011 corrected k64 = n - 5 to k64 = n - 6 on line 160 
C         03/05/2015 corrected code for p64
C         05/08/2015 re-corrected code for p64 at lines 163 and 164 which was again as at 10/11/2011 
C         10/08/2015 added call to w_pathid
c         25/08/2016 added app, dat, and roa
c
c Notes: this subroutine was developed with valuable help from David Bailey.
c        If the paths do not exist, the folders are created on the fly.
c        The code is verbose to allow for possible future developments using
c        additional or alternative folders.
c        There is a reason why the folders are made in a two step process i.e.
c        first ...\User\Documents\Simfit 
c        then  ...\user\Documents\Simfit\res
c        etc., as follows:
c        mkdir@ just returns error_code = 183 if the folder exists but, if you try
c        to make the ...folder\subfolder in one pass it fails with error_code = 3. 
c        Note, the folder name is now (26/09/2019) ProgramData but this may mot display in the
c        the Disk Explorer control as it is a hidden folder.  
c
c    k: effective length of path
c  arg: path required as follows ...
c       cfg: Simfit configuration folder
c       res: Simfit results folder
c       p32: %PROGRAMFILES% Program Files or Program Files (x86)
c       p64: %PROGRAMFILESW6432%?? Program Files 
c       tmp: %TEMP%
c       usr: Simfit user folder
c       win: Windows folder
c       s32: System32 folder 
c       app: AppData/Local 
c       dat: ProgramData
c       roa: AppData/roaming     
c path: path returned
c 
      implicit   none
c
c arguments
c      
      integer,             intent (out) :: k  
      character (len = *), intent (in)  :: arg 
      character (len = *), intent (out) :: path 
c
c locals
c      
      integer    error_code*2
      integer    k_app, k_cfg, k_dat, k_res, k_roa, k_tmp, k_usr, n
      integer    k32, k64
      integer    k_win, k_s32
      integer    csidl
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\')
      character (len = 3) arg_copy
      character (len = 3) app, cfg, dat, res, roa, tmp, usr
      parameter (app = 'app', cfg = 'cfg', dat = 'dat', res = 'res',
     +           roa = 'roa', tmp = 'tmp', usr = 'usr')
      character (len = 3) p32, p64
      parameter (p32 = 'p32', p64 = 'p64')
      character (len = 3) win, s32
      parameter (win = 'win', s32 = 's32')
      character (len = 1024) app_path, cfg_path, dat_path, res_path,
     +                       roa_path, tmp_path, usr_path
      character (len = 1024) csidl_path, simfit
      character (len = 1024) pfiles32, pfiles64
      character (len = 1024) win_path, sys32_path
      logical    first, ok32, ok64, w_pathid
      external   w_pathid
      external   lcase@, mkdir@
      STDCALL cspath 'SHGetSpecialFolderPathA' (VAL, OUTSTRING(1024),
     +VAL, VAL): LOGICAL 
      STDCALL temppath 'GetTempPathA' (VAL, OUTSTRING(1024)): INTEGER
      intrinsic  leng
      save       first
      save       k_app, k_cfg, k_dat, k_res, k_roa, k_tmp, k_usr
      save       k32, k64
      save       app_path, cfg_path, dat_path, res_path, roa_path, 
     +           tmp_path, usr_path 
      save       pfiles32, pfiles64
      save       win_path, sys32_path             
      data       first  / .true. /
      data       app_path, cfg_path, dat_path, res_path, roa_path, 
     +           tmp_path, usr_path 
     +          / blank, blank, blank, blank, blank, blank, blank /
      data       k_app, k_cfg, k_res, k_roa, k_tmp, k_usr 
     +          / 0, 0, 0, 0, 0, 0 /
      data       pfiles32, pfiles64 / blank, blank /
      data       k32, k64 / 0, 0 /
      data       win_path, sys32_path / blank, blank /
      data       k_win, k_s32 / 0, 0 /
c
c initialise
c      
      k = 0
      path = blank
c
c if first time create the folders if they are not there already
c
      if (first) then
         first = .false.
c
c get the path to My Documents
c         
         csidl = 5
         csidl_path = blank
         call cspath (0, csidl_path, csidl, 0)
         n = leng(csidl_path)
         if (n.gt.0) then
            if (csidl_path(n:n).eq.bslash) then
               csidl_path(n:n) = blank
               n = n - 1
            endif   
         endif   
         if (n.eq.0) then
            n = 2
            csidl_path = 'C:'   
         endif   

         simfit = csidl_path(1:n)//'\Simfit'
         n = n + 7
         call mkdir@(simfit, error_code)
          
         cfg_path = simfit(1:n)//'\cfg'
         k_cfg = n + 4
         call mkdir@(cfg_path, error_code)
         
         res_path = simfit(1:n)//'\res'
         k_res = n + 4 
         call mkdir@(res_path, error_code)
         
         usr_path = simfit(1:n)//'\usr'
         k_usr = n + 4 
         call mkdir@(usr_path, error_code)
c
c get the path to TEMP
c         
         n = 1024
         tmp_path = blank
         call temppath (n, tmp_path)
         k_tmp = leng(tmp_path)
         if (k_tmp.gt.0) then
            if (tmp_path(k_tmp:k_tmp).eq.bslash) then
               tmp_path(k_tmp:k_tmp) = blank
               k_tmp = k_tmp - 1
            endif
         endif   
         if (k_tmp.eq.0) then
            k_tmp = 7 
            tmp_path = 'C:\Temp'     
         endif   
c
c get the paths to program files
c
         csidl = 38
         csidl_path = blank
         call cspath (0, csidl_path, csidl, 0)
         n = leng(csidl_path)
         if (n.gt.0) then
            if (csidl_path(n:n).eq.bslash) then
               csidl_path(n:n) = blank
               n = n - 1
            endif
            pfiles32 = csidl_path
            if (csidl_path(n - 2:n).eq.'86)') then
               k32 = n
               pfiles32 = csidl_path
               k64 = n - 6
               csidl_path(n - 5:n) = '    '
               pfiles64 = csidl_path
            else
               k64 = n
               pfiles64 = csidl_path
               k32 = n + 6
               pfiles32 = pfiles64(1:n)//' (x86)'
            endif
         else
            k32 = 0
            k64 = 0
            pfiles32 = blank
            pfiles64 = blank            
         endif
c
c check to re-define for 32-bit OS
c         
         ok32 = w_pathid(pfiles32)
         ok64 = w_pathid(pfiles64)
         if (ok64 .and. .not.ok32) then
            k32 = k64
            pfiles32 = pfiles64
         endif    
c
c get the windows and system32 folders
c     
          csidl = 36
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             win_path = csidl_path
             k_win = n
          endif
                   
          csidl = 37
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             sys32_path = csidl_path
             k_s32 = n
          endif           

c
c get the path to Apps and ProgramData
c
          csidl = 26 
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             roa_path = csidl_path
             k_roa = n
          endif  
          
          csidl = 28 
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             app_path = csidl_path
             k_app = n
          endif  

          csidl = 35 
          csidl_path = blank
          call cspath (0, csidl_path, csidl, 0)
          n = leng(csidl_path) 
          if (n.gt.0) then
             dat_path = csidl_path
             k_dat = n
          endif  

      endif
c
c decide which folder is required
c      
      arg_copy = arg
      call lcase@(arg_copy)
c
c return the stored values 
c      
      if (arg_copy.eq.app) then
         k = k_app
         path = app_path
      elseif (arg_copy.eq.cfg) then
         k = k_cfg
         path = cfg_path
      elseif (arg_copy.eq.dat) then
         k = k_dat
         path = dat_path   
      elseif (arg_copy.eq.res) then
         k = k_res
         path = res_path
      elseif (arg_copy.eq.roa) then
         k = k_roa
         path = roa_path   
      elseif (arg_copy.eq.tmp) then   
         k = k_tmp
         path = tmp_path                    
      elseif (arg_copy.eq.usr) then   
         k = k_usr
         path = usr_path
      elseif (arg_copy.eq.p32) then
         k = k32
         path = pfiles32
      elseif (arg_copy.eq.p64) then
         k = k64
         path = pfiles64   
      elseif (arg_copy.eq.win) then  
         k = k_win
         path = win_path
      elseif (arg_copy.eq.s32) then
         k = k_s32
         path = sys32_path
      endif
      end
c
c


