c
c
      subroutine w_vbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text,
     +                     fixed, full, high)
c
c action : put out a vbox type of menu onto a window
c author : w.g.bardsley, university of manchester, u.k., 03/02/97 
c          06/02/1997 developed from w_bbox01
c          10/02/1997 added tabbing
c          04/04/1997 added call to w_syspar to adjust font size
c          28/10/1998 removed topmost, changed button font and
c                     initialised my_decision
c          01/11/1998 changed colour and tidied up
c          14/11/1998 re-introduced Roman/Courier for buttons and %sy
c                     if grey to create a scored box
c          14/04/1999 suppressed closure via caption cross to avoid ambiguity
c                     and restored ms sans serif for button font
c          04/12/1999 restored topmost
c          22/01/2001 suppressed topmost and allowd cross-closure = default
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     o/w normal dialogue window
c          13/02/2002 XP version     
c          18/12/2002 added %sy[toolwindow] and used putdat to report errors 
c          20/11/2006 removed toolwindow and added intents 
c          06/02/2007 edited for w_clearwin.dll
c          30/05/2007 added position, roman, w_dbleam, and w_dbleup
c          18/08/2017 added call to add_stop_option
c          26/11/2017 added closure cross linked to the default o/w any option containing Cancel, Stop, Quit, Exit
c          06/11/2023 numpos has no effect in this version or in x_chkmen
c                                                      
c    icolor: (input/unchanged) colour scheme (not used in this version)
c       ixl: (input/unchanged) x coordinate of top left hand corner
c       iyl: (input/unchanged) y coordinate of top left hand corner
c    lshade: (input/unchanged) shading (not used in this version)
c    numbld: (input/unchanged) font scheme line by line
c    numdec: (input/output) sets default on input then returns users choice
c    numopt: (input/unchanged) number of options available
c    numpos: (input/unchanged) position of hot key (not used in this version)
c    numsta: (input/unchanged) number of line of text where menu starts
c    numtxt: (input/unchanged) number of lines of text ntext >= numopt
c      text: (input/unchanged) text array (text plus menus)
c     fixed: (input/unchanged) mono spaced font (Courier New)
c      full: (input/unchanged) not used in this version
c      high: (input/unchanged) not used in this version
c          this version uses: len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c          fixed gives Courier o/w roman
c          this version does not use full or high and lshade not used but
c          it is passed on to w_bbox01
c
c          icolor background   text     highlight-text (in question line)
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          text size is set by the parameter size
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: numopt, numtxt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numbld(numtxt), 
     +                                       numpos(numopt), numsta    
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: text(numtxt)
      logical,             intent (in)    :: fixed, full, high  
c
c locals
c      
      integer    i, j, k, l, m, my_decision, numhdr, nwide,
     +           nstart, ntext  
      integer    x_len200
      integer    n0, n1, n2, n3, n4, n5, n6, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6,
     +           n7 = 7)
      integer    iscale, nmax
      integer    ixyuse, ixy_use, mwtype, mw_type
      parameter (ixy_use = 2, mw_type = 2)
      parameter (nmax = 12)
      integer    i_simfit_vbox01_1, i_simfit_vbox01_2,
     +           i_simfit_vbox01_3, i_simfit_vbox01_4,
     +           i_simfit_vbox01_5, i_simfit_vbox01_6,
     +           i_simfit_vbox01_7, i_simfit_vbox01_8,
     +           i_simfit_vbox01_9, i_simfit_vbox01_10,
     +          i_simfit_vbox01_11, i_simfit_vbox01_12
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.15d+00)
      double precision x_shift, y_shift, z_shift
      parameter (x_shift = 0.0d+00, y_shift = 0.25d+00,
     +           z_shift = 2.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  header(30)*129, option(nmax)*129
      character  items(nmax)*80, line*129, w_dbleam*129, w_dbleup*129
      character  cipher*9
      character  blank*1
      parameter (blank = ' ')
      logical    abort, box, ok
      logical    check1, check2 
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   w_bbox01, x_chkmen, x_putfat
      external   x_len200
      external   w_syspar, w_dbleam, w_dbleup
      external   i_simfit_vbox01_1, i_simfit_vbox01_2,
     +           i_simfit_vbox01_3, i_simfit_vbox01_4,
     +           i_simfit_vbox01_5, i_simfit_vbox01_6,
     +           i_simfit_vbox01_7, i_simfit_vbox01_8,
     +           i_simfit_vbox01_9, i_simfit_vbox01_10,
     +          i_simfit_vbox01_11, i_simfit_vbox01_12
      external   add_stop_option
      intrinsic  len, dble, index
      common / simfit_vbox01 / my_decision  
c
c transfer to w_bbox01 if numopt > nmax
c          
      nstart = numsta
      ntext = numtxt 
      if (numopt.gt.nmax .or. numopt.eq.ntext) then
         call w_bbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                  numopt, numpos, nstart, ntext,
     +                  text,
     +                  fixed, full, high)
         return
      endif         
c
c initialise
c                            
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif       
      roman = roman_1
      my_decision = numdec   

c
c check if 'Cancel', 'Stop', 'Quit', or 'Exit' is a menu item
c      
      i = numsta - n1
      j = n0
      do while (i.lt.numsta + numopt - 1)
         i = i + n1
         j = j + n1
         line = text(i)
         if (index(line,'Cancel').gt.n0 .or. 
     +       index(line,'Stop')  .gt.n0 .or.
     +       index(line,'Quit')  .gt.n0 .or.  
     +       index(line,'Exit')  .gt.n0) then  
            my_decision = j
            i = numsta + numopt + 1
         endif  
      enddo        
      
      mwtype = mw_type
      check1 = .true.
      check2 = .false.
c
c full check if required
c
      if (check1) then
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                  'w_vbox01', text, 
     +                  abort)
         if (abort) return
      endif 
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      if (roman) then
         size_roman = correction*size_roman_1      
      else
         size_roman = size_courier
      endif      
c
c create the new text arrays
c
      ok = full
      ok = high
      numhdr = n0
      j = nstart + numopt - n1
      k = n0
      do i = n1, ntext
         if (i.lt.nstart .or. i.gt.j) then
            numhdr = numhdr + n1
            header(numhdr) = w_dbleup(text(i))
         else
            k = k + n1
            option(k) = w_dbleam(text(i))
         endif
      enddo
c
c lesser check if required
c
      if (check2) then
         ok = .true.
         if (numopt.lt.n2 .or. numopt.gt.nmax) ok = .false.
         k = len(line)
         do i = n1, numopt
            j = numpos(i)
            l = x_len200(option(i))
c***********if (j.lt.n1 .or. j.gt.l .or. l.gt.k) ok = .false.
         enddo
         do i = n1, numhdr
            l = len(header(i))
            if (l.gt.k) ok = .false.
         enddo
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_vbox01')
            return
         endif
      endif
c
c the header window ... leave the caption in
c                          
      if (ixyuse.eq.n1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', ixl*iscale, iyl*iscale)
      endif   
      i = winio@('%ca[Simfit: options]&')

c
c swap the next line for a normal window instead of a dialogue window
c ===================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
c
c restore the next section to suppress the closure cross
c         
c      elseif (mwtype.eq.n2) then
c         i = winio@('%sy[no_sysmenu]&')
      endif
      if (numtxt.gt.n1) call add_stop_option (n1)
c
c now set the font and background and text colours depending on icolor
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
      else  
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
         else
            i = winio@('%`sf&')  
         endif      
      endif
      box = .false.
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
      else
         box = .true.
         k = winio@('%bg&', rgb@(240,240,240))
      endif
      if (numhdr.gt.n0) then
         if (box) then
            k = winio@('%ob[scored]&')
         else
            k = winio@('%ob[invisible]&')
         endif
         do i = n1, numhdr
            if (numbld(i).eq.n0) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (fixed) then
               if (i.eq.numhdr) then
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = 
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line, size_courier)
            else
               j = index(header(i), '`')
               k = winio@('%ts&', size_roman)
               l = x_len200(header(i))
               line = blank
               if (j.ge.n1) then
                  line = header(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  line = blank
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  if (i.eq.numhdr) then
                     line = '%ta'//header(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//header(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.numhdr) then
                     line = header(i)(n1:l)//'&'
                     k = winio@(line(n1:l + n1))
                  else
                     line = header(i)(n1:l)//'%nl&'
                     k = winio@(line(n1:l + n4))
                  endif
               endif
            endif
         enddo
         k = winio@('%cb&')
      endif
c
c create the menu items
c
      j = n0
      do i = n1, numopt
         j = j + n1
         l = x_len200(option(j))
         line = option(j)(n1:l)
         k = numpos(i)
         k = n1
         l = x_len200(line)
         if (k.eq.n1 .and. l.ge.n1) then
           items(i) = '[&'//line(n1:l)//']'
         elseif (k.gt.n1 .and. l.ge.k) then
            items(i) = '['//line(n1:k - n1)//'&'//line(k:l)//']'
         else
            items(i) = '[**********]'
         endif
      enddo
c
c call winio@ with &
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_courier)
      nwide = n0
      do i = n1, numopt
         l = x_len200(items(i))
         if (l.gt.nwide) nwide = l
      enddo
      nwide = nwide - n3
      j = n0
c
c move over before creating the menu box if not grey
c
      if (.not.box) i = winio@('    &')
      k = winio@('%ob[invisible]&')
      do i = n1, numopt
         j = j + n1
         l = x_len200(items(i))
         if (j.eq.numdec) then
            m = n6
            cipher = '%`^*bt'
         else
            m = n5
            cipher = '%^*bt'
         endif
         if (j.eq.1) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_1)
         elseif (j.eq.2) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_2)
         elseif (j.eq.3) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_3)
         elseif (j.eq.4) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_4)
         elseif (j.eq.5) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_5)
         elseif (j.eq.6) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_6)
         elseif (j.eq.7) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_7)
         elseif (j.eq.8) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_8)
         elseif (j.eq.9) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_9)
         elseif (j.eq.10) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_10)
         elseif (j.eq.11) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_11)
         elseif (j.eq.12) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                 nwide, i_simfit_vbox01_12)
         endif
         if (i.lt.numopt) k = winio@('%`rp&', x_shift*z_shift,
     +                                        y_shift*z_shift)
      enddo
      k = winio@('%cb')
c
c check
c
      numdec = my_decision
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt
      end
c
c
      recursive integer function i_simfit_vbox01_1()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 1
      i_simfit_vbox01_1 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_2()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 2
      i_simfit_vbox01_2 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_3()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 3
      i_simfit_vbox01_3 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_4()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 4
      i_simfit_vbox01_4 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_5()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 5
      i_simfit_vbox01_5 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_6()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 6
      i_simfit_vbox01_6 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_7()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 7
      i_simfit_vbox01_7 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_8()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 8
      i_simfit_vbox01_8 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_9()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 9
      i_simfit_vbox01_9 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_10()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 10
      i_simfit_vbox01_10 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_11()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 11
      i_simfit_vbox01_11 = 0
      end
c
c
      recursive integer function i_simfit_vbox01_12()
      implicit none
      integer  my_decision
      common / simfit_vbox01 / my_decision
      my_decision = 12
      i_simfit_vbox01_12 = 0
      end
c
c









