c
c
      subroutine w_viewer (isend,
     +                     fname, path, pattern)
c
c contains: 
c viewer_clearwin ... comprehensive text viewer with options
c text_viewer     ... simple cut-down version of viewer clearwin
c
c action : view/print/save a file
c author : w.g.bardsley, university of manchester, u.k., 28/6/97
c
c          29/03/1998 Increased number of filters
c          28/09/1998 removed topmost and added Copy-to-Clipboard
c          03/12/1999 restored topmost and added icon
c          22/01/2001 suppressed topmost and introduced repeet
c          17/01/2002 added no_minbox to %ww
c          13/02/2002 XP version
c          10/09/2003 added print facility
c          28/10/2004 extra checking for opened and forbidden files
c          27/05/2005 adding file saving to menu options
c          16/01/2007 edited for Linux 
c          18/02/2007 edited for w_clearwin.dll
c          17/12/2007 restored %ww[topmost,no_minbox] and added Select All = Ctrl+A 
c          07/08/2008 disabled the direct calls to the editor
c          08/08/2010 added call to x_chkext
c          13/10/2010 added calls to run_acrobat and run_gsview
c          15/09/2011 added filters for ps, eps, and pdf
c          23/12/2011 removed copying to a temporary file
c          12/10/2016 introduced w_reslib for loading the correct dll
c          03/08/2017 added i_stop_this_program
c          22/12/2018 added filter for svg
c          04/05/2020 experimented with fname as inout when isend = 2 but left in original state
c          09/07/2020 moved clearwin code into viewer_clearwin to allow a loop depending on refresh_eb
c                     and also calls eb_settings to inititialise eb_editor, eb_viewer, and refresh_eb
c
c          Note: arguments 1, 3, and 4 supplied to this routine are never changed
c          isend: (input/unchanged) as follows:
c                  isend = 1: view file = fname just once then return
c                             fname is provided
c                             path and pattern are not referenced
c                  isend = 2: use search pattern repeatedly until user quits
c                             fname is not returned if selected
c                             path and pattern must be supplied
c          fname: (input/unchanged) 
c           path: (input/unchanged) copied internally depending on isend
c        pattern: (input/unchanged) copied internally depending on isend
c
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: path, pattern
      character (len = *), intent (in) :: fname
c
c locals
c
      integer    i, ios, jsend, l
      integer    x_len200
      integer    n1, nfilters
      parameter (n1 = 1, nfilters = 16)  
      integer    mustexist
      character (len = 1024) fname1, path1
      character (len = 20  ) filterspecs(nfilters), pattern1
      character (len = 40  ) filternames(nfilters)*40, title
      character (len = 5   ) word5
      character (len = 4   ) word4
      character (len = 3   ) word3
      character (len = 1   ) blank
      parameter (blank = ' ')
      parameter (title = 'Simfit: viewer (no editing)')
      logical    ok, op, repeet, there
      logical    try_eps, try_pdf, try_svg
      logical    refresh
      logical    noisy
      parameter (noisy = .true.)
      external   x_len200, x_lcase1, x_infofl, w_getffs,
     +           x_chkext
      external   run_acrobat, run_gsview, w_svgdis
      external   viewer_clearwin
      external   eb_settings
      intrinsic  dble, len_trim
c
c check isend
c
      if (isend.lt.1 .or. isend.gt.2) return
c
c initialise eb_editor, eb_viewer, and refresh_eb
c    
      jsend = 2! sets eb_editor = .false., eb_viewer = .true., and refresh_eb = .false.
      call eb_settings (jsend,
     +                  refresh)                            
      call use_windows95_font@()
c
c Define the filters
c
      filterspecs(2) = '*.*'
      filternames(2) = 'All files'
      filterspecs(3) = '*.tf?'
      filternames(3) = 'Test files'
      filterspecs(4) = '*.TFL'
      filternames(4) = 'Library files'
      filterspecs(5) = '*.mod'
      filternames(5) = 'Model files'
      filterspecs(6) = '*.cfg'
      filternames(6) = 'Configuration files'
      filterspecs(7) = '*.txt'
      filternames(7) = 'Text files'
      filterspecs(8) = '*.dat'
      filternames(8) = 'Data files'
      filterspecs(9) = '*.res'
      filternames(9) = 'Results files'
      filterspecs(10) = '*.eps'
      filternames(10) = 'Encapsulated PostScript'
      filterspecs(11) = '*.pdf'
      filternames(11) = 'Portable Document Format'
      filterspecs(12) = '*.svg'
      filternames(12) = 'Scalable vector graphics'
      filterspecs(13) = '*.log'
      filternames(13) = 'Log files'
      filterspecs(14) = '*.tmp'
      filternames(14) = 'Temporary files'
      filterspecs(15) = '*.old'
      filternames(15) = 'Old files'
      filterspecs(16) = '*.new'
      filternames(16) = 'New files'
     
      
      
c
c branch point for repeats (if isend = 2)
c
      repeet = .true.
      do while (repeet)
c
c action depends on isend
c
         if (isend.eq.1) then
            fname1 = fname
         elseif (isend.eq.2) then
            mustexist = 1
            fname1 = blank
            path1 = blank
            l = len_trim(path)
            if (l.gt.0) path1(1:l) = path(1:l)
            pattern1 = blank
            l = len_trim(pattern)  
            if (l.gt.0) pattern1(1:l) = pattern(1:l)
            filterspecs(1) = pattern1(1:20)
            filternames(1) = 'Selected files'
            call w_getffs (title, fname1, path1, filternames,
     +                     filterspecs, nfilters, mustexist)
            if (fname1.eq.blank) return
         endif
c
c does the file exist ?
c
         inquire (file = fname1, exist = there, opened = op,
     +            iostat = ios)
         ok = .true.
         if (.not.there .or. op .or. ios.ne.0) then
            ok = .false.       
            call x_infofl (n1,
     +                     fname1)            
            if (isend.eq.1) return
         endif
c
c check for the special cases of ps, eps, pdf, and svg
c         
         if (ok) then
            try_eps = .false.
            try_pdf = .false.
            try_svg = .false.
            i = x_len200(fname1)
            if (i.gt.5) then
               word5 = fname1(i - 4:i)
               call x_lcase1 (word5)
               word4 = fname1(i - 3:i)
               call x_lcase1 (word4)
               word3 = word4(2:4)
            elseif (i.gt.4) then
               word5 = blank
               word4 = fname1(i - 3:i)
               call x_lcase1 (word4)
               word3 = word4(2:4)
            else
               word3 = blank
               word4 = blank
               word5 = blank
            endif
            if (word3.eq.'.ps' .or. word4.eq.'.eps' .or.
     +          word5.eq.'.epsf') then
               try_eps = .true.
            elseif (word4.eq.'.pdf') then
               try_pdf =.true.
            elseif (word4.eq.'.svg') then
               try_svg = .true.    
            endif 
            if (try_eps) then
               ok = .false.
               call run_gsview (fname1)
               if (isend.eq.1) return
            elseif (try_pdf) then
               ok = .false.
               call run_acrobat (fname1)
               if (isend.eq.1) return
            elseif (try_svg) then
               ok = .false.
               call w_svgdis (fname1)
               if (isend.eq.1) return    
            endif        
         endif 
         if (ok) then 
c
c check for forbidden file extensions
c
            call x_chkext (fname1,
     +                     noisy, ok)  
            if (.not.ok .and. isend.eq.1) return
         endif
         if (ok) then
c
c view the selected file checking for refresh possibly caused by the format callback
c Note: it is not clear why or if the calls to temporary_yield@ are really needed
c           
            refresh = .true.
            do while (refresh)
               call temporary_yield@()
               call viewer_clearwin (fname1,
     +                               ok)
               call temporary_yield@()
               jsend = 3! returns refresh = refresh_eb
               call eb_settings (jsend,
     +                           refresh)    
               call temporary_yield@()
            enddo
         endif
         if (isend.eq.1) then
            repeet = .false.
         else
            repeet = .true.
         endif
      enddo
      end
c
c------------------------------------------------------------
c
      recursive integer function i_view_edit_file()
c
c now only views the help section in format 100
c
      implicit   none
      integer    numtxt
      parameter (numtxt = 25)
      integer    numbld(numtxt) 
      character (len = 100) text(numtxt)
      external   x_patch2
      data       numbld / numtxt*0 /
      write (text,100)
      numbld(1) = 1
      call x_patch2 (numbld, numtxt,
     +               text) 
      i_view_edit_file = 2 
  100 format (
     + 'Printing, Editing, and Saving text files.'
     +/
     +/'The current control is displaying a text file in the Simfit'
     +/'text editor. However, the Simfit editor is now in read_only'
     +/'mode, so you cannot do anything with the text directly.' 
     +/
     +/'If you want to print, edit, save, or copy-paste into a word'
     +/'processor, or spreadsheet program, take the following steps.'
     +/      
     +/'1.`Select all the file using Ctrl+A, or else a chosen subset'
     +/'  `of the text by highlighting with the mouse.'
     +/
     +/'2.`Copy the selected text to the clipboard, e.g. using Ctrl+C.' 
     +/
     +/'3.`Open your text editor, e.g. Notepad.'
     +/
     +/'4.`Paste in text from the clipboard, e.g. using Ctrl+V.'
     +/
     +/'5.`The text in your text editor will then be independent of'
     +/'  `Simfit so you can safely Print, Edit, or Save As ...'
     +/
     +/'6.`Matrices can be copied and pasted but it is best to use the'
     +/'  `[Results] then [Extract table] options from the main Simfit'
     +/'  `menu to obtain tab-separated text, html, xml, or LaTeX to'
     +/'  `import into documents.') 
      end
c
c----------------------------------------------------------------------------
c
      subroutine viewer_clearwin (fname1,
     +                            ok)
      include   <windows.ins>
      
      character (len = *), intent (in) :: fname1
      logical,             intent (in) :: ok   
      
      integer i, nfsize, nxwide, nyhigh
      integer i_call_x_switch, i_stop_this_program, i_configure_editt1,
     +        i_view_edit_file
      integer ios
      parameter (ios = 0)
      double precision sizes
      double precision ten
      parameter (ten = 10.0d+00)
      character (len = 14) font
      logical store
      parameter (store = .false.)
      external i_call_x_switch, i_stop_this_program, i_configure_editt1,
     +         i_view_edit_file
      external x_txtcfg, w_reslib
      intrinsic dble
      if (ok) then
         call x_txtcfg (nfsize, nxwide, nyhigh,
     +                  font,
     +                  store)  
         sizes = dble(nfsize)/ten           
         call use_windows95_font@()
         i = winio@('%mn[File[Print/Edit/Save As...,|]]&',
     +              i_view_edit_file)
         i = winio@('%mn[[Exit]]&', 'exit')
         i = winio@('%mn[&Edit[&Copy        Ctrl+C,
     +                         &Select All  Ctrl+A]]&', 
     +                         'copy', 'select_all')
         i = winio@('%mn[Format]&', i_configure_editt1)
         i = winio@('%mn[Stop]&', i_stop_this_program)
         i = winio@('%mn[Speedup]&', i_call_x_switch)
         call w_reslib
         i = winio@('%mi[icon_1]&')
         i = winio@('%fn@&', font)
         i = winio@('%ts&', sizes)
         i = winio@('%bg[white]%tc[black]&')
         i = winio@('%ac[Ctrl+C]&', 'copy')
         i = winio@('%ac[Ctrl+A]&', 'select_all')
         i = winio@('%ww[topmost,no_minbox]&')
         i = winio@('%pv%*.*eb[hscrollbar, vscrollbar, alt_edit,
     +              read_only]&', nxwide, nyhigh, '*', ios)           
         i = winio@('%ca[Simfit: view/copy/print/Save As]&')
         i = winio@('%sc', 'edit_file', fname1)  
      endif        
      end
c
c      
      subroutine text_viewer (fname1,
     +                        ok)
c
c simple version of viewer_clearwin for simple text viewing with no editing
c     
      include   <windows.ins>
      
      character (len = *), intent (in) :: fname1
      logical,             intent (in) :: ok   
      
      integer i, nfsize, nxwide, nyhigh
      integer i_configure_editt1, i_view_edit_file
      integer ios
      parameter (ios = 0)
      double precision sizes
      double precision ten
      parameter (ten = 10.0d+00)
      character (len = 14) font
      logical store
      parameter (store = .false.)
      external  i_configure_editt1, i_view_edit_file
      external x_txtcfg, w_reslib
      intrinsic dble
      if (ok) then
         call x_txtcfg (nfsize, nxwide, nyhigh,
     +                  font,
     +                  store)  
         sizes = dble(nfsize)/ten           
         call use_windows95_font@()
         i = winio@('%mn[File[Print/Edit/Save As...,|]]&',
     +              i_view_edit_file)
         i = winio@('%mn[&Edit[&Copy        Ctrl+C,
     +                         &Select All  Ctrl+A]]&', 
     +                         'copy', 'select_all')
         i = winio@('%mn[Format]&', i_configure_editt1)
         call w_reslib
         i = winio@('%mi[icon_1]&')
         i = winio@('%fn@&', font)
         i = winio@('%ts&', sizes)
         i = winio@('%bg[white]%tc[black]&')
         i = winio@('%ac[Ctrl+C]&', 'copy')
         i = winio@('%ac[Ctrl+A]&', 'select_all')
         i = winio@('%ww[topmost,no_minbox]&')
         i = winio@('%pv%*.*eb[hscrollbar, vscrollbar, alt_edit,
     +              read_only]&', nxwide, nyhigh, '*', ios)           
         i = winio@('%ca[Simfit: text viewer]&' )
         i = winio@('%sc', 'edit_file', fname1)  
      endif        
      end
c
c      
