c
c
      subroutine w_vuop01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt, 
     +                     text_in,
     +                     fixed, full, high, view)
c
c action : version of w_lbox01 but with two buttons for view or open
c author : w.g.bardsley, university of manchester, u.k., 17/02/97
c          developed from w_lbox01 14/01/2005
c          05/02/1997 padded menu with blanks and added button press
c          10/02/1997 added tabbing at the grave ` character
c          04/04/1997 added call to w_syspar to adjust font size
c          08/08/1997 extensive revision to limit colours in order to
c                     use %sy to set the windows95 list box style
c          12/11/1997 added facility to tab menu items into an extra %lb
c                     replaced Times by ms sans serif and used scored %ob
c          21/02/1998 made the second list box greyed out
c          09/09/1998 supressed features and made into standard windows
c                     dialogue control with no scoring or shading and introduced
c                     ndeep = max. depth, nmax = max. items. Also removed extra
c                     spaces either side of menu items.
c          01/11/1998 changed colour scheme and tidied up
c          12/04/1999 used %ww[no_sysmenu] to avoid ambiguities
c                     when closing from the closure cross and force exit
c                     by menu-choice
c          24/10/1999 added nblank and nblank2 to diminish the effect of
c                     multiple blanks used for padding to achieve tabbing
c          03/12/1999 restored topmost
c          10/01/2001 suppressed %ww, dimensioned the assumed size arrays,
c                     redefined factor depending on list box type and introduced
c                     tabber to control tab spacing when tabvar is defined
c          02/03/2001 added %sy[no_sysmenu] and mwtype and now treats menus
c                     with Cancel as a special case as follows:-
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     mwtype = 3: normal dialogue window
c                     mwtype = 4: treat 'Cancel' as a special case by
c                                 setting closure cross = 'Cancel'
c          21/10/2001 used msss font for list box when fixed = .true.
c          13/02/2002 XP version
c          22/02/2002 moved %tc so that it is not cancelled by %`sf
c          18/12/2002 added %sy[toolwindow]
c          07/04/2003 suppressed [toolwindow] as it causes problems with GSview
c          27/04/2004 altered factor and iwide if header/trailer present
c          14/01/2005 now has two buttons for view or open
c          20/11/2006 added intents           
c          06/02/2007 edited for w_clearwin.dll
c          29/11/2007 added [limit_height]
c          11/12/2007 replaced x_len200 by x_len300
c          21/05/2008 introduced allocatable arrays and corrected where x_len300
c                     was used incorrectly instead of x_len200
c
c  icolor: (input/unchanged) colour scheme (not used in this version)
c     ixl: (input/unchanged) x coordinate of top left hand corner
c     iyl: (input/unchanged0 y coordinate of top left hand corner
c  lshade: (input/unchanged) 0 = no shade o/w shade for all other values
c  numbld: (input/unchanged) font scheme line by line
c  numdec: (input/output)... number of the decision
c  numopt: (input/unchanged) number of options available
c  numpos: (input/unchanged) position of hot key (not used in this version)
c  numsta: (input/unchanged) number of line of text where menu starts
c  numtxt: (input/unchanged) number of lines of text ntext >= numopt
c text_in: (input/unchanged) text array (text plus menus)
c   fixed: (input/unchanged) mono spaced font (Courier New)
c    full: (input/unchanged) not used in this version
c    high: (input/unchanged) not used in this version
c    view: (input/output) open file for reading or viewing only
c
c          this version creates the menu as a list box so it does not use
c          selection by special key and some parameters are disabled, e.g.
c          icolor ... is not used in this version
c          lshade ... is not used in this version
c          numpos ... is not used in this version
c          full   ... is not used in this version
c          high   ... is not used in this version
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times .............. Now replaced by ms sans serif
c          2, 3       Times Italic                   "
c          4, 5       Times Bold                     "
c          6, 7       Times Bold Italic              "
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: numtxt, numopt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numsta
      integer,             intent (inout) :: numdec
      integer,             intent (in)    :: numbld(numtxt), 
     +                                       numpos(numopt)
      character (len = *), intent (in)    :: text_in(numtxt)
      logical,             intent (in)    :: fixed, full, high
      logical,             intent (inout) :: view
c
c allocatable
c      
      character (len = 80), allocatable :: items(:), items2(:), text(:)
c
c locals
c      
      integer    i, ierr, j, k, l, m, nblank, nblank2, nstart, ntext 
      integer    x_len200, x_len300
      integer    i_check_vuopen, ideep, ipick, iwide, iwide2
      integer    i_button_view, i_button_open, i_tell_which
      integer    iscale, n_cancel
      integer    mwtype
      integer    ndeep, nmax
      parameter (ndeep = 35)
      integer    n0, n1, n2, n3, n4, n7, n20
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n7 = 7,
     +           n20 = 20)
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00,
     +           size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabber, tabvar
      parameter (percent = 100.0d+00, tabber = 1.00d+00)
      double precision height
      parameter (height = 0.60d+00)
      character  line*129, line1*80, x_trim80*80
      character  blank*1
      parameter (blank = ' ')
      logical    abort, cancel, extra, ok
      logical    check1, check2
      logical    viewit
      external   x_len200, x_len300, x_chkmen
      external   w_syspar, x_putfat, x_trim80
      external   i_check_vuopen, i_button_view, i_button_open
      intrinsic  len, dble, index, max, min, nint
      common    / vu_open_tell / i_tell_which
      common    / vu_open_info / viewit
c
c Initialise parameters used if 'Cancel' is a list box item
c
      i_tell_which = n0
      n_cancel = n0
      cancel = .false.
      viewit = view  
      nstart = numsta
      ntext = numtxt
c
c Scale the font sizes
c
      mwtype = 4
      check1 = .false.
      check2 = .true.
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
c
c full check if required (not generally required for list boxes)
c
      if (check1) then
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                 'w_vuop01', text_in,
     +                  abort)
         if (abort) return
      endif
c
c lesser check if required (generally required for list boxes)
c
      if (check2) then
         if (numopt.le.n1) then
            numdec = n1
            return
         endif
         ok = .true.
         if (ntext.lt.n2 .or. ntext.lt.numopt .or. nstart.lt.n1 .or.
     +       nstart + numopt - n1.gt.ntext) ok = .false.
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_vuop01')
            return
         endif
      endif
c
c allocate
c      
      ierr = 0
      if (allocated(items)) deallocate(items, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(items2)) deallocate(items2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return 
      nmax = ntext
      allocate (items(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate (items2(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate (text(nmax), stat = ierr)
      if (ierr.ne.0) return  
c
c copy text_in into text
c        
      do i = n1, nmax
         text(i) = x_trim80(text_in(i))
      enddo   
c
c use up dummy argument to stop ftn90 complaining
c leave them in the argument list for future developments
c
      i = icolor
      i = numpos(n1)
      i = lshade
      ok = full
      ok = high
c
c use ixl, iyl and parameter iscale to position the window
c
      call w_syspar (iscale, 'i')
      i = winio@('%sp&', iscale*ixl, iscale*iyl)
c
c the next lines select the window type
c =====================================
c
      if (mwtype.eq.n1) then
c
c ww-type
c
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
            k = winio@('%ww[no_sysmenu, topmost]&')
            i = winio@('%ca[Simfit: options]&')
         endif
      elseif (mwtype.eq.n2) then
c
c dialogue type with no closure cross
c
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_sysmenu, no_border, 3d_thin]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[no_sysmenu, thin_border, 3d_thin]&')
            i = winio@('%ca[Simfit: options]&')
         endif
      elseif (mwtype.eq.n3) then
c
c dialogue type with closure cross
c
         if (ntext.eq.numopt) then
            k = winio@('%sy[no_border, 3d_thin]&')
            i = winio@('%ca[Options]&')
         else
            k = winio@('%sy[thin_border, 3d_thin]&')
            i = winio@('%ca[Simfit: options]&')
         endif
      elseif (mwtype.eq.n4) then
c
c check if 'Cancel' or 'Exit' or 'Quit' is an item and, if so, make it
c the default. Here are Spanish equivalents.
c
c Apply = Aplicar
c Accept = Acceptar
c Done = Hecho
c OK = OK
c Exit = Salir
c Cancel = Abandonar
c
         i = nstart - n1
         do while (i.lt.nstart + numopt - n1 .and. .not.cancel)
            i = i + n1
            if (index(text(i),'Cancel').gt.n0 .or.
     +          index(text(i),'Exit').gt.n0 .or.
     +          index(text(i),'Quit').gt.n0 .or.
     +          index(text(i),'Abandonar').gt.n0 .or.
     +          index(text(i),'Salir').gt.n0) then
               cancel = .true.
               n_cancel = i - nstart + n1
            endif
         enddo
         if (cancel) then
            if (ntext.eq.numopt) then
               k = winio@('%sy[no_border, 3d_thin]&')
               i = winio@('%ca[Options]&')
            else
               k = winio@('%sy[thin_border, 3d_thin]&')
               i = winio@('%ca[Simfit: options]&')
            endif
         else
            if (ntext.eq.numopt) then
               k = winio@('%sy[no_sysmenu, no_border, 3d_thin]&')
               i = winio@('%ca[Options]&')
            else
               k = winio@('%sy[no_sysmenu, thin_border, 3d_thin]&')
               i = winio@('%ca[Simfit: options]&')
            endif
         endif
      endif

c
c set the background colour
c
      k = winio@('%bg[grey]&')
c
c put out the text strings up to the menu
c
      do i = n1, nstart - n1

c
c now set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
c
c set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
            k = winio@(line, size_courier)
         else
            if (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif
c
c set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//'&'
               k = winio@(line(n1:j))
               tabvar = correction*tabber*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//'&'
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               k = winio@(line, size_roman)
            endif
         endif
c
c the next line causes a line feed
c
         k = winio@('%nl&')
      enddo
c
c create the menu items
c
      extra = .false.
      iwide = n1
      if (nstart.gt.n1) then
c
c increase iwide according to header text
c
         do i = n1, nstart - n1
            l = x_len300(text(i))
            if (l.gt.iwide) iwide = l
         enddo
      endif
      if (ntext.gt.nstart + numopt - n1) then
c
c increase iwide according to trailer text
c
         do i = nstart + numopt - n1, ntext
            l = x_len300(text(i))
            if (l.gt.iwide) iwide = l
         enddo
      endif
c
c initialise factor depending on header/trailer
c
      if (iwide.gt.n1) then
         factor = 0.95d+00
         iwide = nint(factor*dble(iwide))
      else
         factor = 0.85d+00
      endif
      iwide2 = n1
      j = nstart - n1
      do i = n1, numopt
         j = j + n1
         l = x_len200(text(j))
         line1 = text(j)(n1:l)
c
c does the item contain a grave ` tabbing character ?
c
         nblank = n0
         nblank2 = n0
         k = index(line1, '`')
         if (k.ge.n1) then
            extra = .true.
            if (k.gt.n2) then
               do m = n2, k - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank = nblank + n1
               enddo
            endif
            if (l - k.gt.n2) then
               do m = k + n2, l - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank2 = nblank2 + n1
               enddo
            endif
            items(i) = line1(n1:k - n1)
            items2(i) = line1(k + n1:l)
            if (k - n1 - nblank.gt.iwide) iwide = k - n1 - nblank
            if (l - k - nblank2.gt.iwide2) iwide2 = l - k - nblank2
         else
            if (l.gt.n4) then
               do m = n2, l - n1
                  if (line1(m:m).eq.blank .and.
     +                line1(m - n1:m - n1).eq.blank)
     +                nblank = nblank + n1
               enddo
            endif
            items(i) = line1(n1:l)
            items2(i) = blank
            l = x_len300(items(i))
            if (l - nblank.gt.iwide) iwide = l - nblank
         endif
      enddo
c
c define ideep and ipick
c
      ideep = min(ndeep,numopt)
      if (numdec.lt.n1) then
         ipick = n1
      elseif (numdec.gt.numopt) then
         ipick = numopt
      else
         ipick = numdec
      endif
c
c set up font then show list box (ms sans serif seems best here)
c
      if (fixed) then
c********k = winio@('%fn[Courier New]&')
         k = winio@('%`sf&')
         line = '%ts&'
c********k = winio@(line, size_courier)
         k = winio@(line, size_msss)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif
      k = winio@('%cn&')
      k = winio@('%`bg[white]%tc[black]&')
c
c adjust the list box width if necessary
c
      if (.not.fixed) then
         iwide = max(n20, nint(factor*dble(iwide)))
         if (extra) iwide2 = max(n1, nint(factor*dble(iwide2)))
      endif
      if (nstart + numopt - n1.eq.ntext) then
c
c code when there is no more text
c
         k = winio@('%*.*^ls[limit_height]&', iwide, ideep, items, 
     +              numopt, ipick, height, i_check_vuopen)
         if (extra) then
            i = n0
            j = n0
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%~*.*^ls[limit_height]&', iwide2, ideep,
     +                 items2, numopt, i, j, height, i_check_vuopen)
         endif
      else
c
c code when there is more text
c
         k = winio@('%*.*^ls&', iwide, ideep, items, numopt, ipick,
     +              i_check_vuopen)
         if (extra) then
            i = n0
            j = n0
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%~*.*^ls[limit_height]&', iwide2, ideep, items2,
     +                 numopt, i, j, height, i_check_vuopen)
         endif
         k = winio@('%ff&')
c
c put out the text strings after the end of the menu
c
         do i = nstart + numopt, ntext
c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif
c
c set the text color depending on numbld(i)
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[blue]&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
c
c set the text color depending on numbld(i)
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  k = winio@('%tc[blue]&')
               endif
c
c does the line contain a tabbing character ` grave accent
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  tabvar = correction*tabber*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
         enddo
         k = winio@(' &')
      endif
c
c close by button press
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%^`tt[&View]&', i_button_view)
      k = winio@('  %^tt[&Open]&', i_button_open)
      k = winio@('%nl &')
      k = winio@('%cb')
c
c set numdec then check before returning
c
      if (cancel) then
         if (i_tell_which.eq.n0) then
c
c window closed from closure cross so return numdec = n_cancel
c
           numdec = n_cancel
         else
c
c window closed by button press or double clicking on a list box item
c
            numdec = ipick
         endif
      else
c
c window closed by button or double click
c
         numdec = ipick
      endif
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt
      view = viewit
c
c deallocate
c      
      deallocate(items, stat = ierr)
      deallocate(items2, stat = ierr)
      deallocate(text, stat = ierr)
      end
c
c --------------------------------------------------------------------
c call back function for call back from list box
c --------------------------------------------------------------------
c
      recursive integer function i_check_vuopen()
      implicit none
      include <windows.ins>
      integer (kind = 7) ibig
      integer  i, i_tell_which
      common / vu_open_tell / i_tell_which
      ibig = clearwin_info@('LISTBOX_ITEM_SELECTED')
      i = ibig
      if (i.eq.1) then
c
c the list box item has been double clicked
c
         i_check_vuopen = 0
         i_tell_which = 1
      else
c
c the list box item has been single clicked
c
         i_check_vuopen = 1
         i_tell_which = 0
      endif
      end
c
c --------------------------------------------------------------------
c call back functions for call back from button presses
c --------------------------------------------------------------------
c
      recursive integer function i_button_view()
c
c the View button has been pressed
c
      implicit none
      integer  i_tell_which
      logical  viewit
      common / vu_open_tell / i_tell_which
      common / vu_open_info / viewit
      i_button_view = 0
      i_tell_which = 2
      viewit = .true.
      end
c
c
c
      recursive integer function i_button_open()
c
c the open button has been pressed
c
      implicit none
      integer  i_tell_which
      logical  viewit
      common / vu_open_tell / i_tell_which
      common / vu_open_info / viewit
      i_button_open = 0
      i_tell_which = 2
      viewit = .false.
      end
c
c
