c
c NOTE: uncomment the icon line for use of w_window in the menus dll
c =====
c
      subroutine w_window (close_unit_4,
     +                     title,
     +                     action)
c
c action: open/close a background window 
c author: w.g.bardsley, university of manchester, u.k., 01/09/99

c
c         uncomment the icon line to include the main program icon in the window
c
c         22/10/1999 added code to open/close f$simfit.tmp if title is the
c                    name of a simfit main program as in
c                    'Simfit: program '//PNAME
c         03/12/1999 added i_close_simfit call back
c         13/12/2001 checked ios for create permission
c         28/02/2002 introduced invisible text and just used no_minbox
c                    also heavily re-wrote to only deal with 1 window so
c                    that isend is now redundant.
c         08/03/2002 added call to w_waiter
c         18/12/2002 %sy[toolwindow], caption allocation, dot, nlines and
c                    other improvements
c         31/02/2003 closed units 3 and 4 on exit to save results files, etc.
c         16/05/2004 added mode and call to w_config to switch off background
c                    window if kval(6) = 0
c         13/12/2004 used colour_value, red, green, blue, rgb@ for background
c         22/09/2006 made sure title1 is always defined
c         16/11/2006 moved all the simfit specific code to the front end routine
c                    ... window.for and edited to remove toolwindow
c         04/04/2014 added call to c_window
c         10/04/2014 deleted test for existence of simfitbar.exe 
c         20/04/2014 added subroutine close_unit_4 which MUST be in w_menus.dll for cross-compiler compatibility
c         19/05/2014 restored test for existence of simfitbar.exe 
c         19/06/2017 no action if linux_os = .true. 
c
c         title: (input/unchanged) caption for window
c        action: (input/unchanged) switch on/off 
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: title
      logical,             intent (in) :: action
c
c locals
c
      integer    ictrl_window 
      integer    i_action, i_close_simfit
      integer    ios, k, nlines
      parameter (nlines = 25)
      integer    colour_value, red, green, blue
      parameter (red = 127, green = 153, blue = 153) 
      character (len = 80) temp
      character (len = 17) bar_64
      parameter (bar_64 = 'x64_simfitbar.exe')
      character (len = 13) bar_32
      parameter (bar_32 = 'simfitbar.exe')
      character (len = 5) dot
      parameter (dot = '.%nl&')
      character (len = 1) star
      parameter (star = '*')
      logical    action_copy, there
      logical    linux_os, x_linux3
      external   i_close_simfit
      external   close_unit_4 
      external   w_reslib, x_linux3
      c_external c_window 'c_window'(instring,val,ref): integer
      save       action_copy
      save       ictrl_window
      common    /close_simfit / ictrl_window
      data       action_copy / .false. /
c
c Part 0: check to prevent mutiple windows
c
      if (action      .and. action_copy .or.
     +    .not.action .and. .not.action_copy) return
      action_copy = action
      call temporary_yield@()
c
c Part 1: define i_action then call c_window if simfitbar.exe has been located
c
      linux_os = x_linux3 (star) 
      if (linux_os) then
         return
      else
         inquire (file = bar_32, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            if (action) then
               i_action = 1
            else
               i_action = 0
            endif    
            k = c_window (title,
     +                    i_action,
     +                    close_unit_4)
            return
         else  
            inquire (file = bar_64, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               if (action) then
                  i_action = 1
               else
                  i_action = 0
               endif    
               k = c_window (title,
     +                       i_action,
     +                       close_unit_4)
               return
            endif    
         endif      
      endif
c
c Part 2: the next code will only be executed if c_window cannot find and start simfitbar.exe
c      
      if (action) then
c
c specify the call back function
c                                 
         k = winio@('%cc&', i_close_simfit)
c
c calculate the background colour
c
         colour_value = rgb@(red, green, blue)          
c
c the text colour must be the same as the background colour
c
         k = winio@('%bg&', colour_value)
c
c include the icon then create the window
c                           
         call w_reslib
         k = winio@('%mi[icon_1]&')
         temp = 'Program '//title
         k = winio@('%ca@&', temp)
         k = winio@('%ww[maximise, inactive, no_minbox]&')
         k = winio@('%`sf&')
c
c the text colour must be the same as the background colour
c
         k = winio@('%tc&', colour_value)
c
c dummy lines of text to prevent minimising leading to a strip
c
         do ios = 1, nlines
            k = winio@(dot)
         enddo
         k = winio@('%lw', ictrl_window)
      else
         ictrl_window = 0
         call window_update@(ictrl_window)
      endif
      end
c                                            
c
      recursive integer function i_close_simfit()
      implicit   none
      include   <windows.ins>
      integer    ictrl_window
      integer    k
      integer    i_close_simfit_no, i_close_simfit_yes
      logical    yesno
      logical    action
      parameter (action = .false.)
      external   w_waiter
      external   i_close_simfit_no, i_close_simfit_yes
      external   abort@
      common    /close_simfit/ ictrl_window
     +          /close_yes_no/ yesno
c
c initialise then return if appropriate
c     
      i_close_simfit = 0
      if (ictrl_window.eq.0) return    
c
c initialise yesno (to allow closure cross) then create the window
c           
      yesno = .true.
      k = winio@('%sy[no_sysmenu,topmost]&')
      k = winio@('%ca[Simfit: Continue/Exit]&')
      k = winio@('%`sf%bg[blue]%tc[white]&')
      k = winio@('%si?You can resume or stop and exit this program&')
      k = winio@('%ff%nl%cn%`^8bt[Resume]   %^8bt[Stop]',
     +            i_close_simfit_no, i_close_simfit_yes)
      if (yesno) then
c
c closure has been requested
c      
         call w_waiter (action)
         ictrl_window = 0
         call window_update@(ictrl_window)
         call abort@
       else                 
c
c the user selected to continue
c       
         i_close_simfit = 2
      endif
      end
c
c
      recursive integer function i_close_simfit_no()
      implicit none
      logical  yesno
      common  /close_yes_no / yesno
      yesno = .false.
      i_close_simfit_no = 0
      end
c
c
      recursive integer function i_close_simfit_yes()
      implicit none
      integer  nout
      logical  yesno
      common  /close_yes_no / yesno
      do nout = 3, 4
         close (unit = nout)
      enddo
      yesno = .true.
      i_close_simfit_yes = 0
      end


