c
c
      subroutine w_wparam (x)
c
c action: store x for re-use as in editmt
c author: w.g.bardsley, university of manchester, u.k., 08/11/98
c         20/11/2006 removed [toolwindow] and introduced getnou 
c         06/02/2007 edited for w_clearwin.dll
c         12/12/2007 added scale1 and scale2 to scale fonts
c         06/11/2008 renamed w_simfit.par as w_params.cfg 
c         26/06/2010 added call to x_infofl
c
c         opens 'w_params.cfg' to store/retrieve parameters
c         make sure nmax is even and nmax2 is consistent
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c                   
      double precision, intent (inout) :: x 
c
c locals
c      
      integer    i, ios, j, nout, nsav, ntemp
      integer    ictrl, nmax, nmax2, n6
      parameter (ictrl = 0, nmax = 24, nmax2 = nmax/2, n6 = 6)
      integer    isav(nmax)
      double precision size1, size2, xsav(nmax), xtemp(nmax2)
      double precision scale1, scale2, xmax, xmin
      parameter (scale1 = 1.0d+00, scale2 = 0.95d+00, xmax = 1.0d+75,
     +           xmin = - xmax)
      character  line*100, text(nmax)*25
      character  fname*1024, x_sim256*1024
      character  w_simfit_par*12 
      parameter (w_simfit_par = 'w_params.cfg')
      logical    first, there, read_only
      external   w_syspar, w_getnou, x_attrib, x_infofl 
      external   x_sim256
      intrinsic  dble
      save       first, isav, nsav, xsav, text
      data       first / .true. /
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      size1 = scale1*dble(i)/100.0d+00
      size2 = scale2*dble(i)/100.0d+00
c
c Set up the defaults first time round
c
      if (first) then
         first = .false.
         nsav = 1
         xsav(1) = 1.0d+00
         xsav(2) = 2.0d+00
         xsav(3) = 3.0d+00
         xsav(4) = 4.0d+00
         xsav(5) = 5.0d+00
         xsav(6) = 6.0d+00
         xsav(7) = 7.0d+00
         xsav(8) = 8.0d+00
         xsav(9) = 9.0d+00
         xsav(10) = 10.0d+00
         xsav(11) = 0.0d+00      !zero
         xsav(12) = 1.4142136d+00!root(2)
         xsav(13) = 3.1415927d+00!pi
         xsav(14) = 2.7182818d+00!e
         xsav(15) = 0.4342944d+00!log10(e)
         xsav(16) = 2.3025851d+00!loge(10)
         xsav(17) = 6.022d+23    !Avogadro
         xsav(18) = 1.381d+00    !Boltzmann
         xsav(19) = 8.314        !Molar gas constant
         xsav(20) = 9.649d+04    !Faraday
         xsav(21) = 6.626d-34    !Planck
         xsav(22) = 9.81d+00     !g
         xsav(23) = 6.672d-11    !G
         xsav(24) = 2.998d+08    !c
         do i = 1, nmax
            isav(i) = 0
         enddo
         isav(nsav) = 1
         text(1) = '  value 1'
         text(2) = '  value 2'
         text(3) = '  value 3'
         text(4) = '  value 4'
         text(5) = '  value 5'
         text(6) = '  value 6'
         text(7) = '  value 7'
         text(8) = '  value 8'
         text(9) = '  value 9'
         text(10) = '  value 10'
         text(11) = '  value 11'
         text(12) = '  value 12'
         text(13) = '  pi'
         text(14) = '  e'
         text(15) = '  log10(e)'
         text(16) = '  loge(10)'
         text(17) = '  A mol^-1'
         text(18) = '  k JK^-1'
         text(19) = '  R JK^-1'
         text(20) = '  F C'
         text(21) = '  h Js'
         text(22) = '  g ms^-2'
         text(23) = '  G N m^-2kg^-2'
         text(24) = '  c ms^-1'
      endif
c
c Find an unopened unit
c                     
      call w_getnou (nout)
c
c Open the parameter file and read in ntemp and xtemp
c                                
      fname = x_sim256(w_simfit_par)
      inquire (file = fname, exist = there, iostat = ios)
      if (ios.eq.0 .and. there) then
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.0) read (nout,'(a)',iostat=ios) line
         ntemp = -1
         if (ios.eq.0) read (nout,*,iostat=ios) ntemp
         if (ntemp.lt.1 .or. ntemp.gt.nmax) ios = -1
         i = 1
         do while (i.le.nmax2 .and. ios.eq.0)
            read (nout,*,iostat=ios) xtemp(i)
            i = i + 1
         enddo
         if (i.eq.nmax2 + 1) then
            nsav = ntemp
            do i = 1, nmax
               isav(i) = 0
            enddo
            isav(nsav) = 1
            do i = 1, nmax2
               xsav(i) = xtemp(i)
            enddo
         endif
         close (unit = nout)
      endif
c
c Now the radio box control
c
      i = winio@('%`sf%ts&', size1)
      i = winio@('%sy[3d_thin, no_sysmenu]&')
      i = winio@('%ca[Simfit: parameters]&')
      i = winio@('%ob[named_l][Your values]&')
      do i = 1, nmax2
         j = winio@('%fl&', xmin, xmax)
         j = winio@('%co[check_on_focus_loss]&')
         j = winio@('%12rf&', xsav(i))
         j = winio@('   &')
         j = winio@('%`rb@&', text(i), isav(i))
         j = winio@('%nl&')
      enddo
      i = winio@('%cb&')
      i = winio@('%ob[named_l][Fixed constants]&')
      do i = nmax2 + 1, nmax
         j = winio@('%~12rf&', xsav(i), ictrl)
         j = winio@('   &')
         j = winio@('%`rb@&', text(i), isav(i))
         j = winio@('%nl&')
      enddo
      i = winio@('%cb&')
      j = winio@('%24`ga&',  isav(1),   isav(2),  isav(3),  isav(4),
     +             isav(5),  isav(6),   isav(7),  isav(8),  isav(9),
     +             isav(10), isav(11), isav(12), isav(13), isav(14),
     +             isav(15), isav(16), isav(17), isav(18), isav(19),
     +             isav(20), isav(21), isav(22), isav(23), isav(24))
      j = winio@('%`sf%ts&', size2)
      j = winio@('%ff%nl%cn%^tt[OK]', 'EXIT')
c
c Find out which check box has been selected
c
      i = 0
      nsav = 0
      do while(i.lt.nmax .and. nsav.eq.0)
         i = i + 1
         if (isav(i).eq.1) then
            nsav = i
            x = xsav(nsav)
         endif
      enddo
c
c check
c      
      call x_attrib (fname,
     +               there, read_only)      
      if (there .and. read_only) then
         call x_infofl (n6,
     +                  fname)
         return
      endif            
c
c Create a new 'w_params.cfg' file
c
      if (nout.ge.11 .and. nout.le.100) then
          open (unit = nout, file = fname, iostat = ios)
          if (ios.eq.0) write (nout,'(a)',iostat=ios)
     +'SIMFIT store/retrieve parameter file %  1'
          if (ios.eq.0) write (nout,'(i3)',iostat=ios) nsav
          do i = 1, nmax2
             if (ios.eq.0) write (nout,'(1p,e12.4)',iostat=ios) xsav(i)
          enddo
         if (ios.eq.0) write (nout,'(a)',iostat=ios)
     +'line 1 = title, line 2 = item selected, lines 3-14 = parameters'
          close (unit = nout, iostat = ios)
      endif
      end
c
c
